/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io.encoding;

import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.encoding.Base64;
import kotlin.io.encoding.Base64Kt;
import kotlin.io.encoding.ExperimentalEncodingApi;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u000f\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tH\u0002J(\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\tH\u0002J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\tH\u0002J\b\u0010\u001d\u001a\u00020\tH\u0016J \u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tH\u0016J\b\u0010 \u001a\u00020\tH\u0002J\b\u0010!\u001a\u00020\u0014H\u0002J\b\u0010\"\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lkotlin/io/encoding/DecodeInputStream;", "Ljava/io/InputStream;", "input", "base64", "Lkotlin/io/encoding/Base64;", "(Ljava/io/InputStream;Lkotlin/io/encoding/Base64;)V", "byteBuffer", "", "byteBufferEndIndex", "", "byteBufferLength", "getByteBufferLength", "()I", "byteBufferStartIndex", "isClosed", "", "isEOF", "singleByteBuffer", "symbolBuffer", "close", "", "copyByteBufferInto", "dst", "dstOffset", "length", "decodeSymbolBufferInto", "dstEndIndex", "symbolBufferLength", "handlePaddingSymbol", "read", "destination", "offset", "readNextSymbol", "resetByteBufferIfEmpty", "shiftByteBufferToStartIfNeeded", "kotlin-stdlib"})
@ExperimentalEncodingApi
final class DecodeInputStream
extends InputStream {
    private final InputStream input;
    private final Base64 base64;
    private boolean isClosed;
    private boolean isEOF;
    private final byte[] singleByteBuffer;
    private final byte[] symbolBuffer;
    private final byte[] byteBuffer;
    private int byteBufferStartIndex;
    private int byteBufferEndIndex;

    /*
     * WARNING - void declaration
     */
    public DecodeInputStream(InputStream input, Base64 base64) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(input, "input");
        Intrinsics.checkNotNullParameter(base64, "base64");
        this.input = var1_1;
        this.base64 = var2_2;
        this.singleByteBuffer = new byte[1];
        this.symbolBuffer = new byte[1024];
        this.byteBuffer = new byte[1024];
    }

    private final int getByteBufferLength() {
        return this.byteBufferEndIndex - this.byteBufferStartIndex;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int read() {
        if (this.byteBufferStartIndex < this.byteBufferEndIndex) {
            void var1_1;
            int n = this.byteBuffer[this.byteBufferStartIndex] & 0xFF;
            ++this.byteBufferStartIndex;
            this.resetByteBufferIfEmpty();
            return (int)var1_1;
        }
        DecodeInputStream decodeInputStream = this;
        switch (decodeInputStream.read(decodeInputStream.singleByteBuffer, 0, 1)) {
            case -1: {
                return -1;
            }
            case 1: {
                return this.singleByteBuffer[0] & 0xFF;
            }
        }
        throw new IllegalStateException("Unreachable".toString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int read(byte[] destination, int offset, int length) {
        void var2_2;
        Intrinsics.checkNotNullParameter(destination, "destination");
        if (offset < 0 || length < 0 || offset + length > ((byte[])destination).length) {
            throw new IndexOutOfBoundsException("offset: " + offset + ", length: " + length + ", buffer size: " + ((byte[])destination).length);
        }
        if (this.isClosed) {
            throw new IOException("The input stream is closed.");
        }
        if (this.isEOF) {
            return -1;
        }
        if (length == 0) {
            return 0;
        }
        if (this.getByteBufferLength() >= length) {
            this.copyByteBufferInto((byte[])destination, offset, length);
            return length;
        }
        int n = length - this.getByteBufferLength();
        n = (n + 3 - 1) / 3;
        int symbolsNeeded = n << 2;
        int dstOffset = offset;
        while (!this.isEOF && symbolsNeeded > 0) {
            int symbolBufferLength = 0;
            int symbolsToRead = Math.min(this.symbolBuffer.length, symbolsNeeded);
            block5: while (!this.isEOF && symbolBufferLength < symbolsToRead) {
                int symbol = this.readNextSymbol();
                switch (symbol) {
                    case -1: {
                        this.isEOF = true;
                        continue block5;
                    }
                    case 61: {
                        symbolBufferLength = this.handlePaddingSymbol(symbolBufferLength);
                        this.isEOF = true;
                        continue block5;
                    }
                }
                this.symbolBuffer[symbolBufferLength] = (byte)symbol;
                ++symbolBufferLength;
            }
            boolean bl = this.isEOF || symbolBufferLength == symbolsToRead;
            if (!bl) {
                destination = "Check failed.";
                throw new IllegalStateException(destination.toString());
            }
            symbolsNeeded -= symbolBufferLength;
            dstOffset += this.decodeSymbolBufferInto((byte[])destination, dstOffset, length + offset, symbolBufferLength);
        }
        if (dstOffset == offset && this.isEOF) {
            return -1;
        }
        return dstOffset - var2_2;
    }

    @Override
    public final void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            this.input.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int decodeSymbolBufferInto(byte[] dst, int dstOffset, int dstEndIndex, int symbolBufferLength) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.byteBufferEndIndex += this.base64.decodeIntoByteArray(this.symbolBuffer, this.byteBuffer, this.byteBufferEndIndex, 0, symbolBufferLength);
        int bytesToCopy = Math.min(this.getByteBufferLength(), dstEndIndex - dstOffset);
        this.copyByteBufferInto((byte[])var1_1, (int)var2_2, bytesToCopy);
        this.shiftByteBufferToStartIfNeeded();
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private final void copyByteBufferInto(byte[] dst, int dstOffset, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        ArraysKt.copyInto(this.byteBuffer, (byte[])var1_1, (int)var2_2, this.byteBufferStartIndex, this.byteBufferStartIndex + length);
        this.byteBufferStartIndex += var3_3;
        this.resetByteBufferIfEmpty();
    }

    private final void resetByteBufferIfEmpty() {
        if (this.byteBufferStartIndex == this.byteBufferEndIndex) {
            this.byteBufferStartIndex = 0;
            this.byteBufferEndIndex = 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void shiftByteBufferToStartIfNeeded() {
        void var1_1;
        int byteBufferCapacity = this.byteBuffer.length - this.byteBufferEndIndex;
        int n = this.symbolBuffer.length / 4 * 3;
        if (n > var1_1) {
            ArraysKt.copyInto(this.byteBuffer, this.byteBuffer, 0, this.byteBufferStartIndex, this.byteBufferEndIndex);
            this.byteBufferEndIndex -= this.byteBufferStartIndex;
            this.byteBufferStartIndex = 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int handlePaddingSymbol(int symbolBufferLength) {
        void var1_1;
        this.symbolBuffer[symbolBufferLength] = 61;
        if ((symbolBufferLength & 3) == 2) {
            int secondPad = this.readNextSymbol();
            if (secondPad >= 0) {
                void var2_2;
                this.symbolBuffer[symbolBufferLength + 1] = (byte)var2_2;
            }
            return symbolBufferLength + 2;
        }
        return (int)(var1_1 + true);
    }

    /*
     * WARNING - void declaration
     */
    private final int readNextSymbol() {
        void var1_1;
        int read;
        if (!this.base64.isMimeScheme$kotlin_stdlib()) {
            return this.input.read();
        }
        while ((read = this.input.read()) != -1 && !Base64Kt.isInMimeAlphabet(read)) {
        }
        return (int)var1_1;
    }
}

