/*
 * Decompiled with CFR 0.152.
 */
package kotlin.jvm.internal;

import java.util.Arrays;
import kotlin.KotlinNullPointerException;
import kotlin.SinceKotlin;
import kotlin.UninitializedPropertyAccessException;

public class Intrinsics {
    private Intrinsics() {
    }

    /*
     * WARNING - void declaration
     */
    public static String stringPlus(String self, Object other) {
        void var1_1;
        String string;
        return string + var1_1;
    }

    public static void checkNotNull(Object object) {
        if (object == null) {
            Intrinsics.throwJavaNpe();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkNotNull(Object object, String message) {
        if (object == null) {
            void var1_1;
            Intrinsics.throwJavaNpe((String)var1_1);
        }
    }

    public static void throwNpe() {
        throw Intrinsics.sanitizeStackTrace(new KotlinNullPointerException());
    }

    public static void throwNpe(String message) {
        String string;
        throw Intrinsics.sanitizeStackTrace(new KotlinNullPointerException(string));
    }

    @SinceKotlin(version="1.4")
    public static void throwJavaNpe() {
        throw Intrinsics.sanitizeStackTrace(new NullPointerException());
    }

    @SinceKotlin(version="1.4")
    public static void throwJavaNpe(String message) {
        String string;
        throw Intrinsics.sanitizeStackTrace(new NullPointerException(string));
    }

    public static void throwUninitializedProperty(String message) {
        String string;
        throw Intrinsics.sanitizeStackTrace(new UninitializedPropertyAccessException(string));
    }

    public static void throwUninitializedPropertyAccessException(String propertyName) {
        String string;
        Intrinsics.throwUninitializedProperty("lateinit property " + string + " has not been initialized");
    }

    public static void throwAssert() {
        throw Intrinsics.sanitizeStackTrace(new AssertionError());
    }

    public static void throwAssert(String message) {
        String string;
        throw Intrinsics.sanitizeStackTrace(new AssertionError((Object)string));
    }

    public static void throwIllegalArgument() {
        throw Intrinsics.sanitizeStackTrace(new IllegalArgumentException());
    }

    public static void throwIllegalArgument(String message) {
        String string;
        throw Intrinsics.sanitizeStackTrace(new IllegalArgumentException(string));
    }

    public static void throwIllegalState() {
        throw Intrinsics.sanitizeStackTrace(new IllegalStateException());
    }

    public static void throwIllegalState(String message) {
        String string;
        throw Intrinsics.sanitizeStackTrace(new IllegalStateException(string));
    }

    /*
     * WARNING - void declaration
     */
    public static void checkExpressionValueIsNotNull(Object value, String expression) {
        if (value == null) {
            void var1_1;
            throw Intrinsics.sanitizeStackTrace(new IllegalStateException((String)var1_1 + " must not be null"));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkNotNullExpressionValue(Object value, String expression) {
        if (value == null) {
            void var1_1;
            throw Intrinsics.sanitizeStackTrace(new NullPointerException((String)var1_1 + " must not be null"));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkReturnedValueIsNotNull(Object value, String className, String methodName) {
        if (value == null) {
            void var2_2;
            void var1_1;
            throw Intrinsics.sanitizeStackTrace(new IllegalStateException("Method specified as non-null returned null: " + (String)var1_1 + "." + (String)var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkReturnedValueIsNotNull(Object value, String message) {
        if (value == null) {
            void var1_1;
            throw Intrinsics.sanitizeStackTrace(new IllegalStateException((String)var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkFieldIsNotNull(Object value, String className, String fieldName) {
        if (value == null) {
            void var2_2;
            void var1_1;
            throw Intrinsics.sanitizeStackTrace(new IllegalStateException("Field specified as non-null is null: " + (String)var1_1 + "." + (String)var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkFieldIsNotNull(Object value, String message) {
        if (value == null) {
            void var1_1;
            throw Intrinsics.sanitizeStackTrace(new IllegalStateException((String)var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkParameterIsNotNull(Object value, String paramName) {
        if (value == null) {
            void var1_1;
            Intrinsics.throwParameterIsNullIAE((String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkNotNullParameter(Object value, String paramName) {
        if (value == null) {
            void var1_1;
            Intrinsics.throwParameterIsNullNPE((String)var1_1);
        }
    }

    private static void throwParameterIsNullIAE(String paramName) {
        String string;
        throw Intrinsics.sanitizeStackTrace(new IllegalArgumentException(Intrinsics.createParameterIsNullExceptionMessage(string)));
    }

    private static void throwParameterIsNullNPE(String paramName) {
        String string;
        throw Intrinsics.sanitizeStackTrace(new NullPointerException(Intrinsics.createParameterIsNullExceptionMessage(string)));
    }

    /*
     * WARNING - void declaration
     */
    private static String createParameterIsNullExceptionMessage(String paramName) {
        String string;
        void var1_1;
        void var2_2;
        void var3_3;
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        String thisClassName = Intrinsics.class.getName();
        int i = 0;
        while (!stackTraceElements[i].getClassName().equals(thisClassName)) {
            ++i;
        }
        while (stackTraceElements[i].getClassName().equals(thisClassName)) {
            ++i;
        }
        StackTraceElement caller = stackTraceElements[var3_3];
        String className = caller.getClassName();
        String methodName = caller.getMethodName();
        return "Parameter specified as non-null is null: method " + (String)var2_2 + "." + (String)var1_1 + ", parameter " + string;
    }

    /*
     * WARNING - void declaration
     */
    public static int compare(long thisVal, long anotherVal) {
        void var2_1;
        long l;
        if (thisVal < anotherVal) {
            return -1;
        }
        if (l == var2_1) {
            return 0;
        }
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    public static int compare(int thisVal, int anotherVal) {
        void var1_1;
        int n;
        if (thisVal < anotherVal) {
            return -1;
        }
        if (n == var1_1) {
            return 0;
        }
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean areEqual(Object first, Object second) {
        void var1_1;
        Object object;
        if (first == null) {
            return second == null;
        }
        return object.equals(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.1")
    public static boolean areEqual(Double first, Double second) {
        void var1_1;
        Double d;
        if (first == null) {
            return second == null;
        }
        return second != null && d.doubleValue() == var1_1.doubleValue();
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.1")
    public static boolean areEqual(Double first, double second) {
        void var1_1;
        Double d;
        return first != null && d.doubleValue() == var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.1")
    public static boolean areEqual(double first, Double second) {
        void var2_1;
        double d;
        return second != null && d == var2_1.doubleValue();
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.1")
    public static boolean areEqual(Float first, Float second) {
        void var1_1;
        Float f;
        if (first == null) {
            return second == null;
        }
        return second != null && f.floatValue() == var1_1.floatValue();
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.1")
    public static boolean areEqual(Float first, float second) {
        void var1_1;
        Float f;
        return first != null && f.floatValue() == var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.1")
    public static boolean areEqual(float first, Float second) {
        void var1_1;
        float f;
        return second != null && f == var1_1.floatValue();
    }

    public static void throwUndefinedForReified() {
        Intrinsics.throwUndefinedForReified("This function has a reified type parameter and thus can only be inlined at compilation time, not called directly.");
    }

    public static void throwUndefinedForReified(String message) {
        String string;
        throw new UnsupportedOperationException(string);
    }

    public static void reifiedOperationMarker(int id, String typeParameterIdentifier) {
        Intrinsics.throwUndefinedForReified();
    }

    public static void reifiedOperationMarker(int id, String typeParameterIdentifier, String message) {
        Intrinsics.throwUndefinedForReified(message);
    }

    public static void needClassReification() {
        Intrinsics.throwUndefinedForReified();
    }

    public static void needClassReification(String message) {
        Intrinsics.throwUndefinedForReified(message);
    }

    /*
     * WARNING - void declaration
     */
    public static void checkHasClass(String internalName) throws ClassNotFoundException {
        String fqName = internalName.replace('/', '.');
        try {
            Class.forName(fqName);
            return;
        }
        catch (ClassNotFoundException e) {
            void var1_1;
            String string;
            throw Intrinsics.sanitizeStackTrace(new ClassNotFoundException("Class " + string + " is not found. Please update the Kotlin runtime to the latest version", (Throwable)var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkHasClass(String internalName, String requiredVersion) throws ClassNotFoundException {
        String fqName = internalName.replace('/', '.');
        try {
            Class.forName(fqName);
            return;
        }
        catch (ClassNotFoundException e) {
            void var2_2;
            void var1_1;
            String string;
            throw Intrinsics.sanitizeStackTrace(new ClassNotFoundException("Class " + string + " is not found: this code requires the Kotlin runtime of version at least " + (String)var1_1, (Throwable)var2_2));
        }
    }

    private static <T extends Throwable> T sanitizeStackTrace(T throwable) {
        return Intrinsics.sanitizeStackTrace(throwable, Intrinsics.class.getName());
    }

    /*
     * WARNING - void declaration
     */
    static <T extends Throwable> T sanitizeStackTrace(T throwable, String classNameToDrop) {
        T t;
        void var3_3;
        void var2_2;
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        int size = stackTrace.length;
        int lastIntrinsic = -1;
        for (int i = 0; i < size; ++i) {
            if (!classNameToDrop.equals(stackTrace[i].getClassName())) continue;
            lastIntrinsic = i;
        }
        StackTraceElement[] newStackTrace = (StackTraceElement[])Arrays.copyOfRange(var2_2, lastIntrinsic + 1, (int)var3_3);
        throwable.setStackTrace(newStackTrace);
        return t;
    }

    @SinceKotlin(version="1.4")
    public static class Kotlin {
        private Kotlin() {
        }
    }
}

