/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import androidx.compose.foundation.gestures.DraggableKt;
import com.ibm.icu.text.UnicodeSet;

public final class BMPSet {
    private boolean[] latin1Contains;
    private int[] table7FF;
    private int[] bmpBlockBits;
    private int[] list4kStarts;
    private final int[] list;
    private final int listLength;

    /*
     * WARNING - void declaration
     */
    public BMPSet(int[] parentList, int parentListLength) {
        void var2_3;
        this.list = parentList;
        this.listLength = var2_3;
        this.latin1Contains = new boolean[256];
        this.table7FF = new int[64];
        this.bmpBlockBits = new int[64];
        this.list4kStarts = new int[18];
        this.list4kStarts[0] = this.findCodePoint(2048, 0, this.listLength - 1);
        for (int i = 1; i <= 16; ++i) {
            this.list4kStarts[i] = this.findCodePoint(i << 12, this.list4kStarts[i - 1], this.listLength - 1);
        }
        this.list4kStarts[17] = this.listLength - 1;
        this.initBits();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean contains(int c) {
        if (c <= 255) {
            return this.latin1Contains[c];
        }
        if (c <= 2047) {
            return (this.table7FF[c & 0x3F] & 1 << (c >> 6)) != 0;
        }
        if (c < 55296 || c >= 57344 && c <= 65535) {
            void var2_2;
            int lead = c >> 12;
            int twoBits = this.bmpBlockBits[c >> 6 & 0x3F] >> lead & 0x10001;
            if (twoBits <= 1) {
                void var3_3;
                return var3_3 != false;
            }
            return this.containsSlow(c, this.list4kStarts[lead], this.list4kStarts[var2_2 + true]);
        }
        if (c <= 0x10FFFF) {
            void var1_1;
            return this.containsSlow((int)var1_1, this.list4kStarts[13], this.list4kStarts[17]);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final int span$3279c9dc(CharSequence s, int start, UnicodeSet.SpanCondition spanCondition, DraggableKt outCount) {
        int supplementary;
        int lead;
        char c2;
        int i;
        int limit = s.length();
        int numSupplementary = 0;
        if (UnicodeSet.SpanCondition.NOT_CONTAINED != spanCondition) {
            for (i = start; i < limit; ++i) {
                char c = s.charAt(i);
                if (c <= '\u00ff') {
                    if (this.latin1Contains[c]) continue;
                } else if (c <= '\u07ff') {
                    if ((this.table7FF[c & 0x3F] & 1 << (c >> 6)) != 0) continue;
                } else if (c < '\ud800' || c >= '\udc00' || i + 1 == limit || (c2 = s.charAt(i + 1)) < '\udc00' || c2 >= '\ue000') {
                    lead = c >> 12;
                    int twoBits = this.bmpBlockBits[c >> 6 & 0x3F] >> lead & 0x10001;
                    if (twoBits <= 1) {
                        if (twoBits != 0) continue;
                    } else if (this.containsSlow(c, this.list4kStarts[lead], this.list4kStarts[lead + 1])) {
                        continue;
                    }
                } else {
                    supplementary = Character.toCodePoint(c, c2);
                    if (this.containsSlow(supplementary, this.list4kStarts[16], this.list4kStarts[17])) {
                        ++numSupplementary;
                        ++i;
                        continue;
                    }
                }
                break;
            }
        } else {
            while (i < limit) {
                char c = s.charAt(i);
                if (c <= '\u00ff') {
                    if (this.latin1Contains[c]) {
                        break;
                    }
                } else if (c <= '\u07ff') {
                    if ((this.table7FF[c & 0x3F] & 1 << (c >> 6)) != 0) {
                        break;
                    }
                } else if (c < '\ud800' || c >= '\udc00' || i + 1 == limit || (c2 = s.charAt(i + 1)) < '\udc00' || c2 >= '\ue000') {
                    lead = c >> 12;
                    int twoBits = this.bmpBlockBits[c >> 6 & 0x3F] >> lead & 0x10001;
                    if (twoBits <= 1) {
                        if (twoBits != 0) {
                            break;
                        }
                    } else if (this.containsSlow(c, this.list4kStarts[lead], this.list4kStarts[lead + 1])) break;
                } else {
                    void var3_5;
                    supplementary = Character.toCodePoint((char)var3_5, c2);
                    if (this.containsSlow(supplementary, this.list4kStarts[16], this.list4kStarts[17])) break;
                    ++numSupplementary;
                    ++i;
                }
                ++i;
            }
        }
        if (outCount != null) {
            void var2_2;
            int spanLength = i - var2_2;
            DraggableKt draggableKt = outCount;
            int n = spanLength - numSupplementary;
            throw null;
        }
        return i;
    }

    /*
     * WARNING - void declaration
     */
    public final int spanBack(CharSequence s, int limit, UnicodeSet.SpanCondition spanCondition) {
        void var2_2;
        block17: {
            if (UnicodeSet.SpanCondition.NOT_CONTAINED != spanCondition) {
                do {
                    char c2;
                    char c;
                    if ((c = s.charAt(--limit)) <= '\u00ff') {
                        if (this.latin1Contains[c]) continue;
                        break block17;
                    }
                    if (c <= '\u07ff') {
                        if ((this.table7FF[c & 0x3F] & 1 << (c >> 6)) != 0) continue;
                        break block17;
                    }
                    if (c < '\ud800' || c < '\udc00' || limit == 0 || (c2 = s.charAt(limit - 1)) < '\ud800' || c2 >= '\udc00') {
                        int lead = c >> 12;
                        int twoBits = this.bmpBlockBits[c >> 6 & 0x3F] >> lead & 0x10001;
                        if (twoBits <= 1) {
                            if (twoBits != 0) continue;
                        } else if (this.containsSlow(c, this.list4kStarts[lead], this.list4kStarts[lead + 1])) {
                            continue;
                        }
                        break block17;
                    }
                    int supplementary = Character.toCodePoint(c2, c);
                    if (!this.containsSlow(supplementary, this.list4kStarts[16], this.list4kStarts[17])) break block17;
                    --limit;
                } while (limit != 0);
                return 0;
            }
            do {
                void var3_5;
                char c2;
                char c;
                if ((c = s.charAt(--limit)) <= '\u00ff') {
                    if (!this.latin1Contains[c]) continue;
                    break block17;
                }
                if (c <= '\u07ff') {
                    if ((this.table7FF[c & 0x3F] & 1 << (c >> 6)) == 0) continue;
                    break block17;
                }
                if (c < '\ud800' || c < '\udc00' || limit == 0 || (c2 = s.charAt(limit - 1)) < '\ud800' || c2 >= '\udc00') {
                    int lead = c >> 12;
                    int twoBits = this.bmpBlockBits[c >> 6 & 0x3F] >> lead & 0x10001;
                    if (twoBits <= 1) {
                        if (twoBits == 0) continue;
                    } else if (!this.containsSlow(c, this.list4kStarts[lead], this.list4kStarts[lead + 1])) {
                        continue;
                    }
                    break block17;
                }
                int supplementary = Character.toCodePoint(c2, (char)var3_5);
                if (this.containsSlow(supplementary, this.list4kStarts[16], this.list4kStarts[17])) break block17;
                --limit;
            } while (limit != 0);
            return 0;
        }
        return (int)(var2_2 + true);
    }

    /*
     * WARNING - void declaration
     */
    private static void set32x64Bits(int[] table, int start, int limit) {
        assert (64 == table.length);
        int lead = start >> 6;
        int trail = start & 0x3F;
        int bits = 1 << lead;
        if (start + 1 == limit) {
            int n = trail;
            table[n] = table[n] | bits;
            return;
        }
        int limitLead = limit >> 6;
        int limitTrail = limit & 0x3F;
        if (lead == limitLead) {
            while (trail < limitTrail) {
                int n = trail++;
                table[n] = table[n] | bits;
            }
        } else {
            void var1_1;
            if (trail > 0) {
                do {
                    int n = trail++;
                    table[n] = table[n] | bits;
                } while (trail < 64);
                ++lead;
            }
            if (lead < limitLead) {
                void var3_3;
                bits = ~((1 << var3_3) - 1);
                if (limitLead < 32) {
                    bits &= (1 << limitLead) - 1;
                }
                trail = 0;
                while (trail < 64) {
                    int n = trail++;
                    table[n] = table[n] | bits;
                }
            }
            bits = 1 << var1_1;
            trail = 0;
            while (trail < limitTrail) {
                int n = trail++;
                table[n] = table[n] | bits;
            }
        }
    }

    private void initBits() {
        int start;
        int limit;
        int listIndex = 0;
        do {
            start = this.list[listIndex++];
            limit = listIndex < this.listLength ? this.list[listIndex++] : 0x110000;
            if (start >= 256) break;
            do {
                this.latin1Contains[start++] = true;
            } while (start < limit && start < 256);
        } while (limit <= 256);
        while (start < 2048) {
            BMPSet.set32x64Bits(this.table7FF, start, limit <= 2048 ? limit : 2048);
            if (limit > 2048) {
                start = 2048;
                break;
            }
            start = this.list[listIndex++];
            if (listIndex < this.listLength) {
                limit = this.list[listIndex++];
                continue;
            }
            limit = 0x110000;
        }
        int minStart = 2048;
        while (start < 65536) {
            if (limit > 65536) {
                limit = 65536;
            }
            if (start < minStart) {
                start = minStart;
            }
            if (start < limit) {
                if (0 != (start & 0x3F)) {
                    int n = (start >>= 6) & 0x3F;
                    this.bmpBlockBits[n] = this.bmpBlockBits[n] | 65537 << (start >> 6);
                    minStart = start = start + 1 << 6;
                }
                if (start < limit) {
                    if (start < (limit & 0xFFFFFFC0)) {
                        BMPSet.set32x64Bits(this.bmpBlockBits, start >> 6, limit >> 6);
                    }
                    if (0 != (limit & 0x3F)) {
                        int n = (limit >>= 6) & 0x3F;
                        this.bmpBlockBits[n] = this.bmpBlockBits[n] | 65537 << (limit >> 6);
                        minStart = limit = limit + 1 << 6;
                    }
                }
            }
            if (limit == 65536) break;
            start = this.list[listIndex++];
            if (listIndex < this.listLength) {
                limit = this.list[listIndex++];
                continue;
            }
            limit = 0x110000;
        }
    }

    /*
     * WARNING - void declaration
     */
    private int findCodePoint(int c, int lo, int hi) {
        void var3_3;
        int i;
        if (c < this.list[lo]) {
            return lo;
        }
        if (lo >= hi || c >= this.list[hi - 1]) {
            return hi;
        }
        while ((i = lo + hi >>> 1) != lo) {
            if (c < this.list[i]) {
                hi = i;
                continue;
            }
            lo = i;
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean containsSlow(int c, int lo, int hi) {
        void var3_3;
        void var2_2;
        void var1_1;
        return 0 != (this.findCodePoint((int)var1_1, (int)var2_2, (int)var3_3) & 1);
    }
}

