/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.util.ICUException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;

public abstract class CacheValue<V> {
    private static volatile Strength strength = Strength.SOFT;
    private static final CacheValue NULL_VALUE = new NullValue(0);

    public static boolean futureInstancesWillBeStrong() {
        return strength == Strength.STRONG;
    }

    public static <V> CacheValue<V> getInstance(V value) {
        V v;
        if (value == null) {
            return NULL_VALUE;
        }
        if (strength == Strength.STRONG) {
            return new StrongValue<V>(value);
        }
        return new SoftValue<V>(v);
    }

    public boolean isNull() {
        return false;
    }

    public abstract V get();

    public abstract V resetIfCleared(V var1);

    static final class SoftValue<V>
    extends CacheValue<V> {
        private volatile Reference<V> ref;

        /*
         * WARNING - void declaration
         */
        SoftValue(V value) {
            void var1_1;
            this.ref = new SoftReference<void>(var1_1);
        }

        @Override
        public final V get() {
            return this.ref.get();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final synchronized V resetIfCleared(V value) {
            void var2_2;
            V oldValue = this.ref.get();
            if (oldValue == null) {
                void var1_1;
                this.ref = new SoftReference<V>(value);
                return var1_1;
            }
            return var2_2;
        }
    }

    static final class StrongValue<V>
    extends CacheValue<V> {
        private V value;

        /*
         * WARNING - void declaration
         */
        StrongValue(V value) {
            void var1_1;
            this.value = var1_1;
        }

        @Override
        public final V get() {
            return this.value;
        }

        @Override
        public final V resetIfCleared(V value) {
            return this.value;
        }
    }

    static final class NullValue<V>
    extends CacheValue<V> {
        private NullValue() {
        }

        @Override
        public final boolean isNull() {
            return true;
        }

        @Override
        public final V get() {
            return null;
        }

        @Override
        public final V resetIfCleared(V value) {
            if (value != null) {
                throw new ICUException("resetting a null value to a non-null value");
            }
            return null;
        }

        /* synthetic */ NullValue(byte by) {
            this();
        }
    }

    public static final class Strength
    extends Enum<Strength> {
        public static final /* enum */ Strength STRONG = new Strength();
        public static final /* enum */ Strength SOFT = new Strength();

        static {
            Strength[] strengthArray = new Strength[]{STRONG, SOFT};
        }
    }
}

