/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.Trie2_16;
import com.ibm.icu.impl.UCaseProps;
import com.ibm.icu.impl.UCharacterProperty;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.Edits;
import com.ibm.icu.util.ICUUncheckedIOException;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.text.CharacterIterator;

public final class CaseMapImpl {
    private static final Trie2_16 CASE_TRIE = UCaseProps.getTrie();

    /*
     * WARNING - void declaration
     */
    public static BreakIterator getTitleBreakIterator(ULocale locale, int options, BreakIterator iter) {
        void var2_2;
        if ((options &= 0xE0) != 0 && iter != null) {
            throw new IllegalArgumentException("titlecasing iterator option together with an explicit iterator");
        }
        if (iter == null) {
            void var1_1;
            switch (var1_1) {
                case 0: {
                    iter = BreakIterator.getWordInstance(locale);
                    break;
                }
                case 32: {
                    iter = new WholeStringBreakIterator(0);
                    break;
                }
                case 64: {
                    ULocale uLocale;
                    iter = BreakIterator.getSentenceInstance(uLocale);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown titlecasing iterator option");
                }
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static int appendCodePoint(Appendable a, int c) throws IOException {
        void var1_1;
        Appendable appendable;
        if (c <= 65535) {
            a.append((char)c);
            return 1;
        }
        a.append((char)(55232 + (c >> 10)));
        appendable.append((char)(56320 + (var1_1 & 0x3FF)));
        return 2;
    }

    /*
     * WARNING - void declaration
     */
    private static void appendResult(int result, Appendable dest, int cpLength, int options, Edits edits) throws IOException {
        if (result < 0) {
            void var3_3;
            if (edits != null) {
                edits.addUnchanged(cpLength);
            }
            if ((var3_3 & 0x4000) != 0) {
                return;
            }
            CaseMapImpl.appendCodePoint(dest, ~result);
            return;
        }
        if (result <= 31) {
            if (edits != null) {
                edits.addReplace(cpLength, result);
                return;
            }
        } else {
            void var1_1;
            int length = CaseMapImpl.appendCodePoint((Appendable)var1_1, result);
            if (edits != null) {
                int n;
                void var2_2;
                edits.addReplace((int)var2_2, n);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void appendUnchanged(CharSequence src, int start, int length, Appendable dest, int options, Edits edits) throws IOException {
        if (length > 0) {
            void var2_2;
            CharSequence charSequence;
            void var3_3;
            void var1_1;
            if (edits != null) {
                edits.addUnchanged(length);
            }
            if ((options & 0x4000) != 0) {
                return;
            }
            void v0 = var1_1;
            var3_3.append(charSequence, (int)v0, (int)(v0 + var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String applyEdits(CharSequence src, StringBuilder replacementChars, Edits edits) {
        void var3_3;
        if (!edits.hasChanges()) {
            return src.toString();
        }
        StringBuilder result = new StringBuilder(src.length() + edits.lengthDelta());
        Edits.Iterator ei = edits.getCoarseIterator();
        while (ei.next()) {
            int i;
            if (ei.hasChange()) {
                int n = i = ei.replacementIndex();
                result.append(replacementChars, n, n + ei.newLength());
                continue;
            }
            int n = i = ei.sourceIndex();
            result.append(src, n, n + ei.oldLength());
        }
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static void internalToLower(int caseLocale, int options, CharSequence src, int srcStart, int srcLimit, StringContextIterator iter, Appendable dest, Edits edits) throws IOException {
        void var1_1;
        void var3_3;
        void var2_2;
        void srcIndex;
        byte[] latinToLower = caseLocale == 1 || (caseLocale >= 0 ? caseLocale != 2 && caseLocale != 3 : (options & 7) == 0) ? UCaseProps.LatinCase.TO_LOWER_NORMAL : UCaseProps.LatinCase.TO_LOWER_TR_LT;
        int prev = srcStart;
        while (srcIndex < srcLimit) {
            int c;
            char trail;
            char lead;
            block9: {
                int delta;
                block10: {
                    int props;
                    block8: {
                        lead = src.charAt((int)srcIndex);
                        if (lead >= '\u017f') break block8;
                        int d = latinToLower[lead];
                        if (d == -128) break block9;
                        ++srcIndex;
                        if (d == 0) continue;
                        delta = d;
                        break block10;
                    }
                    if (lead < '\ud800' && !UCaseProps.propsHasException(props = CASE_TRIE.getFromU16SingleLead(lead))) {
                        ++srcIndex;
                        if (!UCaseProps.isUpperOrTitleFromProps(props) || (delta = UCaseProps.getDelta(props)) == 0) continue;
                    }
                    break block9;
                }
                lead = (char)(lead + delta);
                CaseMapImpl.appendUnchanged(src, prev, (int)(srcIndex - true - prev), dest, options, edits);
                dest.append(lead);
                if (edits != null) {
                    edits.addReplace(1, 1);
                }
                prev = srcIndex;
                continue;
            }
            void cpStart = srcIndex++;
            if (Character.isHighSurrogate(lead) && srcIndex < srcLimit && Character.isLowSurrogate(trail = src.charAt((int)srcIndex))) {
                c = Character.toCodePoint(lead, trail);
                ++srcIndex;
            }
            CaseMapImpl.appendUnchanged(src, prev, (int)(cpStart - prev), dest, options, edits);
            prev = cpStart;
            if (caseLocale >= 0) {
                if (iter == null) {
                    iter = new StringContextIterator(src, (int)cpStart, (int)srcIndex);
                } else {
                    iter.setCPStartAndLimit((int)cpStart, (int)srcIndex);
                }
                c = UCaseProps.INSTANCE.toFullLower(c, iter, dest, caseLocale);
            } else {
                c = UCaseProps.INSTANCE.toFullFolding(c, dest, options);
            }
            if (c < 0) continue;
            CaseMapImpl.appendResult(c, dest, (int)(srcIndex - cpStart), options, edits);
            prev = srcIndex;
        }
        CaseMapImpl.appendUnchanged((CharSequence)var2_2, prev, (int)(var3_3 - prev), dest, (int)var1_1, edits);
    }

    /*
     * WARNING - void declaration
     */
    public static String toLower(int caseLocale, int options, CharSequence src) {
        void var2_4;
        int n;
        if (src.length() <= 100) {
            void var1_3;
            void var0_1;
            if (src.length() == 0) {
                return src.toString();
            }
            Edits edits = new Edits();
            StringBuilder replacementChars = CaseMapImpl.toLower(caseLocale, 16384, src, new StringBuilder(), edits);
            return CaseMapImpl.applyEdits(src, (StringBuilder)var0_1, (Edits)var1_3);
        }
        return CaseMapImpl.toLower(n, 0, src, new StringBuilder(var2_4.length()), null).toString();
    }

    /*
     * WARNING - void declaration
     */
    private static <A extends Appendable> A toLower(int caseLocale, int options, CharSequence src, A dest, Edits edits) {
        try {
            void var3_4;
            void var2_3;
            void var1_2;
            if (edits != null) {
                edits.reset();
            }
            CaseMapImpl.internalToLower(caseLocale, (int)var1_2, src, 0, var2_3.length(), null, dest, edits);
            return var3_4;
        }
        catch (IOException e) {
            void var0_1;
            throw new ICUUncheckedIOException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String toUpper(int caseLocale, int options, CharSequence src) {
        void var2_4;
        int n;
        if (src.length() <= 100) {
            void var1_3;
            void var0_1;
            if (src.length() == 0) {
                return src.toString();
            }
            Edits edits = new Edits();
            StringBuilder replacementChars = CaseMapImpl.toUpper(caseLocale, 16384, src, new StringBuilder(), edits);
            return CaseMapImpl.applyEdits(src, (StringBuilder)var0_1, (Edits)var1_3);
        }
        return CaseMapImpl.toUpper(n, 0, src, new StringBuilder(var2_4.length()), null).toString();
    }

    /*
     * WARNING - void declaration
     */
    private static <A extends Appendable> A toUpper(int caseLocale, int options, CharSequence src, A dest, Edits edits) {
        try {
            void var3_4;
            void var1_2;
            void var2_3;
            if (edits != null) {
                edits.reset();
            }
            if (caseLocale == 4) {
                return (A)GreekUpper.access$100(options, src, dest, edits);
            }
            Edits edits2 = edits;
            A a = dest;
            StringContextIterator stringContextIterator = null;
            byte[] byArray = caseLocale == 2 ? UCaseProps.LatinCase.TO_UPPER_TR : UCaseProps.LatinCase.TO_UPPER_NORMAL;
            int n = 0;
            int n2 = 0;
            int n3 = var2_3.length();
            while (n2 < n3) {
                int n4;
                char c;
                int n5;
                block12: {
                    block13: {
                        block11: {
                            n5 = var2_3.charAt(n2);
                            if (n5 >= 383) break block11;
                            c = byArray[n5];
                            if (c == '\uffffff80') break block12;
                            ++n2;
                            if (c == '\u0000') continue;
                            n4 = c;
                            break block13;
                        }
                        if (n5 < 55296 && !UCaseProps.propsHasException(c = CASE_TRIE.getFromU16SingleLead((char)n5))) {
                            ++n2;
                            if (UCaseProps.getTypeFromProps(c) != 1 || (n4 = UCaseProps.getDelta(c)) == 0) continue;
                        }
                        break block12;
                    }
                    n5 = (char)(n5 + n4);
                    CaseMapImpl.appendUnchanged((CharSequence)var2_3, n, n2 - 1 - n, a, (int)var1_2, edits2);
                    a.append((char)n5);
                    if (edits2 != null) {
                        edits2.addReplace(1, 1);
                    }
                    n = n2;
                    continue;
                }
                n4 = n2++;
                if (Character.isHighSurrogate((char)n5) && n2 < n3) {
                    char c2 = var2_3.charAt(n2);
                    c = c2;
                    if (Character.isLowSurrogate(c2)) {
                        n5 = Character.toCodePoint((char)n5, c);
                        ++n2;
                    }
                }
                if (stringContextIterator == null) {
                    stringContextIterator = new StringContextIterator((CharSequence)var2_3, n4, n2);
                } else {
                    stringContextIterator.setCPStartAndLimit(n4, n2);
                }
                CaseMapImpl.appendUnchanged((CharSequence)var2_3, n, n4 - n, a, (int)var1_2, edits2);
                n = n4;
                if ((n5 = UCaseProps.INSTANCE.toFullUpper(n5, stringContextIterator, a, caseLocale)) < 0) continue;
                CaseMapImpl.appendResult(n5, a, n2 - n4, (int)var1_2, edits2);
                n = n2;
            }
            CaseMapImpl.appendUnchanged((CharSequence)var2_3, n, n2 - n, a, (int)var1_2, edits2);
            return var3_4;
        }
        catch (IOException e) {
            void var0_1;
            throw new ICUUncheckedIOException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String toTitle(int caseLocale, int options, BreakIterator iter, CharSequence src) {
        void var3_4;
        void var2_3;
        void var1_2;
        int n;
        if (src.length() <= 100 && (options & 0x4000) == 0) {
            void var0_1;
            if (src.length() == 0) {
                return src.toString();
            }
            Edits edits = new Edits();
            StringBuilder replacementChars = CaseMapImpl.toTitle(caseLocale, options | 0x4000, iter, src, new StringBuilder(), edits);
            return CaseMapImpl.applyEdits(src, (StringBuilder)var0_1, edits);
        }
        return CaseMapImpl.toTitle(n, (int)var1_2, (BreakIterator)var2_3, src, new StringBuilder(var3_4.length()), null).toString();
    }

    /*
     * Unable to fully structure code
     */
    private static <A extends Appendable> A toTitle(int caseLocale, int options, BreakIterator titleIter, CharSequence src, A dest, Edits edits) {
        try {
            if (edits != null) {
                edits.reset();
            }
            iter = new StringContextIterator(src);
            srcLength = src.length();
            prev = 0;
            isFirstIndex = true;
            while (prev < srcLength) {
                block22: {
                    block34: {
                        block23: {
                            block24: {
                                block28: {
                                    block32: {
                                        block33: {
                                            block30: {
                                                block31: {
                                                    block29: {
                                                        block26: {
                                                            block25: {
                                                                block27: {
                                                                    if (isFirstIndex) {
                                                                        isFirstIndex = false;
                                                                        index = titleIter.first();
                                                                    } else {
                                                                        index = titleIter.next();
                                                                    }
                                                                    if (index == -1 || index > srcLength) {
                                                                        index = srcLength;
                                                                    }
                                                                    if (prev >= index) break block22;
                                                                    titleStart = prev;
                                                                    iter.setLimit(index);
                                                                    c = iter.nextCaseMapCP();
                                                                    if ((options & 512) == 0) {
                                                                        v0 = toCased = (options & 1024) != 0 ? 1 : 0;
                                                                        while ((toCased != 0 ? 0 == UCaseProps.INSTANCE.getType(c) : ((1 << (var14_17 = UCharacterProperty.INSTANCE.getType(var13_15 = c)) & 251792942) != 0 || var14_17 == 4 && UCaseProps.INSTANCE.getType(var13_15) != 0) == false) && (c = iter.nextCaseMapCP()) >= 0) {
                                                                        }
                                                                        toCased = iter.getCPStart();
                                                                        if (prev < toCased) {
                                                                            CaseMapImpl.appendUnchanged(src, prev, toCased - prev, dest, options, edits);
                                                                        }
                                                                    }
                                                                    if (toCased >= index) break block22;
                                                                    c = UCaseProps.INSTANCE.toFullTitle(c, iter, dest, caseLocale);
                                                                    CaseMapImpl.appendResult(c, dest, iter.getCPLength(), options, edits);
                                                                    if (toCased + 1 >= index || caseLocale != 5) break block23;
                                                                    if (c < 0) {
                                                                        c ^= -1;
                                                                    }
                                                                    if (c != 73 && c != 205) break block24;
                                                                    v1 = toCased + 1;
                                                                    var16_19 = edits;
                                                                    var15_18 = options;
                                                                    var12_14 = dest;
                                                                    toCased = index;
                                                                    prev = v1;
                                                                    var14_17 = c;
                                                                    var13_16 = src;
                                                                    if (!CaseMapImpl.$assertionsDisabled && prev >= toCased) {
                                                                        throw new AssertionError();
                                                                    }
                                                                    var17_20 = prev;
                                                                    var18_21 = false;
                                                                    var19_22 = 0;
                                                                    var20_23 = false;
                                                                    var21_24 = 0;
                                                                    var22_25 = var13_16.charAt(var17_20++);
                                                                    if (var14_17 != 73) break block25;
                                                                    if (var22_25 != '\u0301') break block26;
                                                                    var18_21 = true;
                                                                    var19_22 = 1;
                                                                    if (var17_20 != toCased) break block27;
                                                                    v2 = prev;
                                                                    break block28;
                                                                }
                                                                var22_25 = var13_16.charAt(var17_20++);
                                                                break block26;
                                                            }
                                                            var18_21 = true;
                                                        }
                                                        if (var22_25 != 'j') break block29;
                                                        var20_23 = true;
                                                        break block30;
                                                    }
                                                    if (var22_25 == 'J') break block31;
                                                    v2 = prev;
                                                    break block28;
                                                }
                                                ++var19_22;
                                            }
                                            if (!var18_21) break block32;
                                            if (var17_20 != toCased && var13_16.charAt(var17_20++) == '\u0301') break block33;
                                            v2 = prev;
                                            break block28;
                                        }
                                        if (var20_23) {
                                            var21_24 = 1;
                                        } else {
                                            ++var19_22;
                                        }
                                    }
                                    if (var17_20 >= toCased) ** GOTO lbl-1000
                                    toCased = Character.codePointAt(var13_16, var17_20);
                                    if (((toCased = 1 << UCharacterProperty.INSTANCE.getType(toCased)) & 448) != 0) {
                                        v2 = prev;
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        CaseMapImpl.appendUnchanged(var13_16, prev, var19_22, var12_14, var15_18, var16_19);
                                        prev += var19_22;
                                        if (var20_23) {
                                            var12_14.append('J');
                                            if (var16_19 != null) {
                                                var16_19.addReplace(1, 1);
                                            }
                                            ++prev;
                                        }
                                        CaseMapImpl.appendUnchanged(var13_16, prev, var21_24, var12_14, var15_18, var16_19);
                                        if (!CaseMapImpl.$assertionsDisabled && prev + var21_24 != var17_20) {
                                            throw new AssertionError();
                                        }
                                        v2 = var17_20;
                                    }
                                }
                                titleLimit = v2;
                                iter.moveTo(titleLimit);
                                break block34;
                            }
                            titleLimit = iter.getCPLimit();
                            break block34;
                        }
                        titleLimit = iter.getCPLimit();
                    }
                    if (titleLimit < index) {
                        if ((options & 256) == 0) {
                            CaseMapImpl.internalToLower(caseLocale, options, src, titleLimit, index, iter, dest, edits);
                        } else {
                            CaseMapImpl.appendUnchanged(src, titleLimit, index - titleLimit, dest, options, edits);
                        }
                        iter.moveToLimit();
                    }
                }
                prev = index;
            }
            return dest;
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String fold(int options, CharSequence src) {
        void var1_2;
        int n;
        if (src.length() <= 100 && (options & 0x4000) == 0) {
            void var2_3;
            void var0_1;
            if (src.length() == 0) {
                return src.toString();
            }
            Edits edits = new Edits();
            StringBuilder replacementChars = CaseMapImpl.fold(options | 0x4000, src, new StringBuilder(), edits);
            return CaseMapImpl.applyEdits(src, (StringBuilder)var0_1, (Edits)var2_3);
        }
        return CaseMapImpl.fold(n, src, new StringBuilder(var1_2.length()), null).toString();
    }

    /*
     * WARNING - void declaration
     */
    private static <A extends Appendable> A fold(int options, CharSequence src, A dest, Edits edits) {
        try {
            void var2_3;
            void var3_4;
            void var1_2;
            if (edits != null) {
                edits.reset();
            }
            CaseMapImpl.internalToLower(-1, options, src, 0, var1_2.length(), null, dest, (Edits)var3_4);
            return var2_3;
        }
        catch (IOException e) {
            void var0_1;
            throw new ICUUncheckedIOException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(int x0, Appendable x1, int x2, int x3, Edits x4) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        CaseMapImpl.appendResult(x0, (Appendable)var1_1, (int)var2_2, (int)var3_3, x4);
    }

    static final class GreekUpper {
        private static final char[] data0370 = new char[]{'\u0370', '\u0370', '\u0372', '\u0372', '\u0000', '\u0000', '\u0376', '\u0376', '\u0000', '\u0000', '\u037a', '\u03fd', '\u03fe', '\u03ff', '\u0000', '\u037f', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u5391', '\u0000', '\u5395', '\u5397', '\u5399', '\u0000', '\u539f', '\u0000', '\u53a5', '\u53a9', '\ud399', '\u1391', '\u0392', '\u0393', '\u0394', '\u1395', '\u0396', '\u1397', '\u0398', '\u1399', '\u039a', '\u039b', '\u039c', '\u039d', '\u039e', '\u139f', '\u03a0', '\u03a1', '\u0000', '\u03a3', '\u03a4', '\u13a5', '\u03a6', '\u03a7', '\u03a8', '\u13a9', '\u9399', '\u93a5', '\u5391', '\u5395', '\u5397', '\u5399', '\ud3a5', '\u1391', '\u0392', '\u0393', '\u0394', '\u1395', '\u0396', '\u1397', '\u0398', '\u1399', '\u039a', '\u039b', '\u039c', '\u039d', '\u039e', '\u139f', '\u03a0', '\u03a1', '\u03a3', '\u03a3', '\u03a4', '\u13a5', '\u03a6', '\u03a7', '\u03a8', '\u13a9', '\u9399', '\u93a5', '\u539f', '\u53a5', '\u53a9', '\u03cf', '\u0392', '\u0398', '\u03d2', '\u43d2', '\u83d2', '\u03a6', '\u03a0', '\u03cf', '\u03d8', '\u03d8', '\u03da', '\u03da', '\u03dc', '\u03dc', '\u03de', '\u03de', '\u03e0', '\u03e0', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u039a', '\u03a1', '\u03f9', '\u037f', '\u03f4', '\u1395', '\u0000', '\u03f7', '\u03f7', '\u03f9', '\u03fa', '\u03fa', '\u03fc', '\u03fd', '\u03fe', '\u03ff'};
        private static final char[] data1F00 = new char[]{'\u1391', '\u1391', '\u5391', '\u5391', '\u5391', '\u5391', '\u5391', '\u5391', '\u1391', '\u1391', '\u5391', '\u5391', '\u5391', '\u5391', '\u5391', '\u5391', '\u1395', '\u1395', '\u5395', '\u5395', '\u5395', '\u5395', '\u0000', '\u0000', '\u1395', '\u1395', '\u5395', '\u5395', '\u5395', '\u5395', '\u0000', '\u0000', '\u1397', '\u1397', '\u5397', '\u5397', '\u5397', '\u5397', '\u5397', '\u5397', '\u1397', '\u1397', '\u5397', '\u5397', '\u5397', '\u5397', '\u5397', '\u5397', '\u1399', '\u1399', '\u5399', '\u5399', '\u5399', '\u5399', '\u5399', '\u5399', '\u1399', '\u1399', '\u5399', '\u5399', '\u5399', '\u5399', '\u5399', '\u5399', '\u139f', '\u139f', '\u539f', '\u539f', '\u539f', '\u539f', '\u0000', '\u0000', '\u139f', '\u139f', '\u539f', '\u539f', '\u539f', '\u539f', '\u0000', '\u0000', '\u13a5', '\u13a5', '\u53a5', '\u53a5', '\u53a5', '\u53a5', '\u53a5', '\u53a5', '\u0000', '\u13a5', '\u0000', '\u53a5', '\u0000', '\u53a5', '\u0000', '\u53a5', '\u13a9', '\u13a9', '\u53a9', '\u53a9', '\u53a9', '\u53a9', '\u53a9', '\u53a9', '\u13a9', '\u13a9', '\u53a9', '\u53a9', '\u53a9', '\u53a9', '\u53a9', '\u53a9', '\u5391', '\u5391', '\u5395', '\u5395', '\u5397', '\u5397', '\u5399', '\u5399', '\u539f', '\u539f', '\u53a5', '\u53a5', '\u53a9', '\u53a9', '\u0000', '\u0000', '\u3391', '\u3391', '\u7391', '\u7391', '\u7391', '\u7391', '\u7391', '\u7391', '\u3391', '\u3391', '\u7391', '\u7391', '\u7391', '\u7391', '\u7391', '\u7391', '\u3397', '\u3397', '\u7397', '\u7397', '\u7397', '\u7397', '\u7397', '\u7397', '\u3397', '\u3397', '\u7397', '\u7397', '\u7397', '\u7397', '\u7397', '\u7397', '\u33a9', '\u33a9', '\u73a9', '\u73a9', '\u73a9', '\u73a9', '\u73a9', '\u73a9', '\u33a9', '\u33a9', '\u73a9', '\u73a9', '\u73a9', '\u73a9', '\u73a9', '\u73a9', '\u1391', '\u1391', '\u7391', '\u3391', '\u7391', '\u0000', '\u5391', '\u7391', '\u1391', '\u1391', '\u5391', '\u5391', '\u3391', '\u0000', '\u1399', '\u0000', '\u0000', '\u0000', '\u7397', '\u3397', '\u7397', '\u0000', '\u5397', '\u7397', '\u5395', '\u5395', '\u5397', '\u5397', '\u3397', '\u0000', '\u0000', '\u0000', '\u1399', '\u1399', '\ud399', '\ud399', '\u0000', '\u0000', '\u5399', '\ud399', '\u1399', '\u1399', '\u5399', '\u5399', '\u0000', '\u0000', '\u0000', '\u0000', '\u13a5', '\u13a5', '\ud3a5', '\ud3a5', '\u03a1', '\u03a1', '\u53a5', '\ud3a5', '\u13a5', '\u13a5', '\u53a5', '\u53a5', '\u03a1', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u73a9', '\u33a9', '\u73a9', '\u0000', '\u53a9', '\u73a9', '\u539f', '\u539f', '\u53a9', '\u53a9', '\u33a9', '\u0000', '\u0000', '\u0000'};

        /*
         * Unable to fully structure code
         */
        static /* synthetic */ Appendable access$100(int x0, CharSequence x1, Appendable x2, Edits x3) throws IOException {
            var0 = x0;
            var4_4 = 0;
            var5_5 = 0;
            while (var5_5 < var1_1.length()) {
                block40: {
                    block39: {
                        block38: {
                            var6_6 = Character.codePointAt((CharSequence)var1_1, var5_5);
                            var7_7 = var5_5 + Character.charCount(var6_6);
                            var8_8 = 0;
                            var9_9 = UCaseProps.INSTANCE.getTypeOrIgnorable(var6_6);
                            if ((var9_9 & 4) != 0) {
                                var8_8 = 0 | var4_4 & true;
                            } else if (var9_9 != 0) {
                                var8_8 = 1;
                            }
                            var12_12 = var6_6;
                            if ((var12_12 < 880 || 8486 < var12_12 || 1023 < var12_12 && var12_12 < 7936 ? 0 : (var12_12 <= 1023 ? GreekUpper.data0370[var12_12 - 880] : (var12_12 <= 8191 ? GreekUpper.data1F00[var12_12 - 7936] : (var9_9 = var12_12 == 8486 ? 5033 : 0)))) <= 0) break block39;
                            var6_6 = var9_9 & 1023;
                            if ((var9_9 & 4096) != 0 && (var4_4 & 2) != 0 && (var6_6 == 921 || var6_6 == 933)) {
                                var9_9 |= 32768;
                            }
                            var10_10 = 0;
                            if ((var9_9 & 8192) != 0) {
                                var10_10 = 1;
                            }
                            while (var7_7 < var1_1.length()) {
                                v0 = var1_1.charAt(var7_7);
                                var12_12 = v0;
                                switch (v0) {
                                    case '\u0300': 
                                    case '\u0301': 
                                    case '\u0302': 
                                    case '\u0303': 
                                    case '\u0311': 
                                    case '\u0342': {
                                        v1 = 16384;
                                        break;
                                    }
                                    case '\u0308': {
                                        v1 = 65536;
                                        break;
                                    }
                                    case '\u0344': {
                                        v1 = 81920;
                                        break;
                                    }
                                    case '\u0345': {
                                        v1 = 8192;
                                        break;
                                    }
                                    case '\u0304': 
                                    case '\u0306': 
                                    case '\u0313': 
                                    case '\u0314': 
                                    case '\u0343': {
                                        v1 = 131072;
                                        break;
                                    }
                                    default: {
                                        v1 = var11_11 = 0;
                                    }
                                }
                                if (v1 == 0) break;
                                var9_9 |= var11_11;
                                if ((var11_11 & 8192) != 0) {
                                    ++var10_10;
                                }
                                ++var7_7;
                            }
                            if ((var9_9 & 53248) == 20480) {
                                var8_8 |= 2;
                            }
                            var11_11 = 0;
                            if (var6_6 != 919 || (var9_9 & 16384) == 0 || var10_10 != 0 || (var4_4 & 1) != 0) ** GOTO lbl-1000
                            var12_13 = var1_1;
                            for (var4_4 = var7_7; var4_4 < var12_13.length(); var4_4 += Character.charCount(var13_15)) {
                                var13_15 = Character.codePointAt((CharSequence)var12_13, var4_4);
                                var14_16 = UCaseProps.INSTANCE.getTypeOrIgnorable(var13_15);
                                if ((var14_16 & 4) != 0) {
                                    continue;
                                }
                                v2 = var14_16 != 0;
                                break block38;
                            }
                            v2 = false;
                        }
                        if (!v2) {
                            if (var5_5 == var7_7) {
                                var6_6 = 905;
                            } else {
                                var11_11 = 1;
                            }
                        } else if ((var9_9 & 32768) != 0) {
                            if (var6_6 == 921) {
                                var6_6 = 938;
                                var9_9 &= -98305;
                            } else if (var6_6 == 933) {
                                var6_6 = 939;
                                var9_9 &= -98305;
                            }
                        }
                        if (var3_3 == null && (var0 & 16384) == 0) {
                            v3 = 1;
                        } else {
                            var4_4 = var1_1.charAt(var5_5) != var6_6 || var10_10 > 0 ? 1 : 0;
                            var12_14 = var5_5 + 1;
                            if ((var9_9 & 98304) != 0) {
                                var4_4 |= var12_14 >= var7_7 || var1_1.charAt(var12_14) != '\u0308' ? 1 : 0;
                                ++var12_14;
                            }
                            if (var11_11 != 0) {
                                var4_4 |= var12_14 >= var7_7 || var1_1.charAt(var12_14) != '\u0301' ? 1 : 0;
                                ++var12_14;
                            }
                            if ((var4_4 |= (var13_15 = var7_7 - var5_5) != (var5_5 = var12_14 - var5_5 + var10_10) ? 1 : 0) != 0) {
                                if (var3_3 != null) {
                                    var3_3.addReplace(var13_15, var5_5);
                                }
                            } else {
                                if (var3_3 != null) {
                                    var3_3.addUnchanged(var13_15);
                                }
                                v3 = var4_4 = (var0 & 16384) == 0 ? 1 : 0;
                            }
                        }
                        if (var4_4 != 0) {
                            var2_2.append((char)var6_6);
                            if ((var9_9 & 98304) != 0) {
                                var2_2.append('\u0308');
                            }
                            if (var11_11 != 0) {
                                var2_2.append('\u0301');
                            }
                            while (var10_10 > 0) {
                                var2_2.append('\u0399');
                                --var10_10;
                            }
                        }
                        break block40;
                    }
                    var6_6 = UCaseProps.INSTANCE.toFullUpper(var6_6, null, (Appendable)var2_2, 4);
                    CaseMapImpl.access$200(var6_6, (Appendable)var2_2, var7_7 - var5_5, var0, (Edits)var3_3);
                }
                var5_5 = var7_7;
                var4_4 = var8_8;
            }
            return var2_2;
        }
    }

    static final class WholeStringBreakIterator
    extends BreakIterator {
        private int length;

        private WholeStringBreakIterator() {
        }

        private static void notImplemented() {
            throw new UnsupportedOperationException("should not occur");
        }

        @Override
        public final int first() {
            return 0;
        }

        @Override
        public final int next(int n) {
            WholeStringBreakIterator.notImplemented();
            return 0;
        }

        @Override
        public final int next() {
            return this.length;
        }

        @Override
        public final CharacterIterator getText() {
            WholeStringBreakIterator.notImplemented();
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setText(CharacterIterator newText) {
            void var1_1;
            this.length = var1_1.getEndIndex();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setText(String newText) {
            void var1_1;
            this.length = var1_1.length();
        }

        /* synthetic */ WholeStringBreakIterator(byte by) {
            this();
        }
    }

    public static final class StringContextIterator
    implements UCaseProps.ContextIterator {
        private CharSequence s;
        private int index;
        private int limit;
        private int cpStart;
        private int cpLimit;
        private int dir;

        /*
         * WARNING - void declaration
         */
        public StringContextIterator(CharSequence src) {
            void var1_1;
            this.s = src;
            this.limit = var1_1.length();
            StringContextIterator stringContextIterator = this;
            this.index = 0;
            stringContextIterator.cpLimit = 0;
            stringContextIterator.cpStart = 0;
            this.dir = 0;
        }

        /*
         * WARNING - void declaration
         */
        public StringContextIterator(CharSequence src, int cpStart, int cpLimit) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.s = src;
            this.index = 0;
            this.limit = var1_1.length();
            this.cpStart = var2_2;
            this.cpLimit = var3_3;
            this.dir = 0;
        }

        /*
         * WARNING - void declaration
         */
        public final void setLimit(int lim) {
            if (lim >= 0 && lim <= this.s.length()) {
                void var1_1;
                this.limit = var1_1;
                return;
            }
            this.limit = this.s.length();
        }

        public final void moveToLimit() {
            StringContextIterator stringContextIterator = this;
            stringContextIterator.cpStart = stringContextIterator.cpLimit = this.limit;
        }

        /*
         * WARNING - void declaration
         */
        public final void moveTo(int i) {
            void var1_1;
            StringContextIterator stringContextIterator = this;
            stringContextIterator.cpStart = stringContextIterator.cpLimit = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final int nextCaseMapCP() {
            this.cpStart = this.cpLimit;
            if (this.cpLimit < this.limit) {
                void var1_1;
                int c = Character.codePointAt(this.s, this.cpLimit);
                this.cpLimit += Character.charCount(c);
                return (int)var1_1;
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        public final void setCPStartAndLimit(int s, int l) {
            void var2_2;
            void var1_1;
            this.cpStart = var1_1;
            this.cpLimit = var2_2;
            this.dir = 0;
        }

        public final int getCPStart() {
            return this.cpStart;
        }

        public final int getCPLimit() {
            return this.cpLimit;
        }

        public final int getCPLength() {
            return this.cpLimit - this.cpStart;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void reset(int direction) {
            void var1_1;
            if (direction > 0) {
                this.dir = 1;
                this.index = this.cpLimit;
                return;
            }
            if (var1_1 < 0) {
                this.dir = -1;
                this.index = this.cpStart;
                return;
            }
            this.dir = 0;
            this.index = 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int next() {
            if (this.dir > 0 && this.index < this.s.length()) {
                int c = Character.codePointAt(this.s, this.index);
                this.index += Character.charCount(c);
                return c;
            }
            if (this.dir < 0 && this.index > 0) {
                void var1_2;
                int c = Character.codePointBefore(this.s, this.index);
                this.index -= Character.charCount(c);
                return (int)var1_2;
            }
            return -1;
        }
    }
}

