/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ICUBinary;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.CharsTrie;
import com.ibm.icu.util.CodePointMap;
import com.ibm.icu.util.CodePointTrie;
import com.ibm.icu.util.ICUUncheckedIOException;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class EmojiProps {
    private static final IsAcceptable IS_ACCEPTABLE = new IsAcceptable(0);
    public static final EmojiProps INSTANCE = new EmojiProps();
    private CodePointTrie.Fast8 cpTrie = null;
    private String[] stringTries = new String[6];
    private static final byte[] bitFlags = new byte[]{0, 1, 2, 3, 4, -1, -1, 5, 6, -1, -1, -1, -1, -1, 6};

    /*
     * WARNING - void declaration
     */
    private EmojiProps() {
        ByteBuffer bytes = ICUBinary.getRequiredData("uemoji.icu");
        try {
            int i;
            ICUBinary.readHeaderAndDataVersion(bytes, 1164799850, IS_ACCEPTABLE);
            int startPos = bytes.position();
            int cpTrieOffset = bytes.getInt();
            int indexesLength = cpTrieOffset / 4;
            if (indexesLength <= 9) {
                throw new ICUUncheckedIOException("Emoji properties data: not enough indexes");
            }
            int[] nArray = new int[indexesLength];
            int[] inIndexes = nArray;
            nArray[0] = cpTrieOffset;
            for (i = 1; i < indexesLength; ++i) {
                inIndexes[i] = bytes.getInt();
            }
            int nextOffset = inIndexes[1];
            this.cpTrie = CodePointTrie.Fast8.fromBinary(bytes);
            int pos = bytes.position() - startPos;
            assert (nextOffset >= pos);
            ICUBinary.skipBytes(bytes, nextOffset - pos);
            int offset = nextOffset;
            nextOffset = inIndexes[4];
            ICUBinary.skipBytes(bytes, nextOffset - offset);
            for (i = 4; i <= 9; ++i) {
                nextOffset = inIndexes[i + 1];
                offset = inIndexes[i];
                if (nextOffset <= offset) continue;
                int n = i;
                this.stringTries[n - 4] = ICUBinary.getString(bytes, (nextOffset - offset) / 2, 0);
            }
            return;
        }
        catch (IOException e) {
            void var2_3;
            throw new ICUUncheckedIOException((Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final UnicodeSet addPropertyStarts(UnicodeSet set) {
        void var1_1;
        CodePointMap.Range range = new CodePointMap.Range();
        int start = 0;
        while (this.cpTrie.getRange(start, null, range)) {
            set.add(start);
            start = range.getEnd() + 1;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean hasBinaryProperty(int c, int which) {
        void var2_2;
        int n;
        if (which < 57 || 71 < which) {
            return false;
        }
        byte bit = bitFlags[which - 57];
        if (bit < 0) {
            return false;
        }
        return ((n = this.cpTrie.get(n)) >> var2_2 & 1) != 0;
    }

    public final void addStrings(int which, UnicodeSet set) {
        if (which < 65 || 71 < which) {
            return;
        }
        int firstProp = which;
        int lastProp = which;
        if (which == 71) {
            firstProp = 65;
            lastProp = 70;
        }
        for (int prop = firstProp; prop <= lastProp; ++prop) {
            Object object;
            String trieUChars = this.stringTries[prop - 65];
            if (trieUChars == null) continue;
            object = new CharsTrie((CharSequence)object, 0);
            object = ((CharsTrie)object).iterator();
            while (object.hasNext()) {
                CharsTrie.Entry entry = (CharsTrie.Entry)object.next();
                set.add(entry.chars);
            }
        }
    }

    static final class IsAcceptable
    implements ICUBinary.Authenticate {
        private IsAcceptable() {
        }

        @Override
        public final boolean isDataVersionAcceptable(byte[] version) {
            return version[0] == 1;
        }

        /* synthetic */ IsAcceptable(byte by) {
            this();
        }
    }
}

