/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ClassLoaderUtil;
import com.ibm.icu.impl.ICUConfig;
import com.ibm.icu.impl.ICUData;
import com.ibm.icu.util.ICUUncheckedIOException;
import com.ibm.icu.util.VersionInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public final class ICUBinary {
    private static final List<DataFile> icuDataFiles = new ArrayList<DataFile>();

    /*
     * WARNING - void declaration
     */
    private static void addDataFilesFromPath$1b7460f0(String dataPath) {
        int pathStart = 0;
        while (pathStart < dataPath.length()) {
            void var2_3;
            void var3_4;
            int sepIndex = dataPath.indexOf(File.pathSeparatorChar, pathStart);
            int pathLimit = sepIndex >= 0 ? sepIndex : dataPath.length();
            String path = dataPath.substring(pathStart, (int)var3_4).trim();
            if (path.endsWith(File.separator)) {
                path = path.substring(0, path.length() - 1);
            }
            if (path.length() != 0) {
                void var1_2;
                ICUBinary.addDataFilesFromFolder(new File((String)var1_2), new StringBuilder(), icuDataFiles);
            }
            if (sepIndex < 0) break;
            void var1_1 = var2_3 + true;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void addDataFilesFromFolder(File folder, StringBuilder itemPath, List<DataFile> dataFiles) {
        File[] fileArray;
        File[] files = folder.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        int folderPathLength = itemPath.length();
        if (folderPathLength > 0) {
            itemPath.append('/');
            ++folderPathLength;
        }
        for (File file : fileArray) {
            String fileName = file.getName();
            if (fileName.endsWith(".txt")) continue;
            itemPath.append(fileName);
            if (file.isDirectory()) {
                ICUBinary.addDataFilesFromFolder(file, itemPath, dataFiles);
            } else if (fileName.endsWith(".dat")) {
                ByteBuffer pkgBytes = ICUBinary.mapFile(file);
                if (pkgBytes != null && DatPackageReader.validate(pkgBytes)) {
                    dataFiles.add(new PackageDataFile(itemPath.toString(), pkgBytes));
                }
            } else {
                void var6_6;
                dataFiles.add(new SingleDataFile(itemPath.toString(), (File)var6_6));
            }
            itemPath.setLength(folderPathLength);
        }
    }

    static int compareKeys(CharSequence key, ByteBuffer bytes, int offset) {
        int i = 0;
        while (true) {
            byte c2;
            if ((c2 = bytes.get(offset)) == 0) {
                if (i == key.length()) {
                    return 0;
                }
                return 1;
            }
            if (i == key.length()) {
                return -1;
            }
            int diff = key.charAt(i) - c2;
            if (diff != 0) {
                return diff;
            }
            ++i;
            ++offset;
        }
    }

    static int compareKeys(CharSequence key, byte[] bytes, int offset) {
        int i = 0;
        while (true) {
            byte c2;
            if ((c2 = bytes[offset]) == 0) {
                if (i == key.length()) {
                    return 0;
                }
                return 1;
            }
            if (i == key.length()) {
                return -1;
            }
            int diff = key.charAt(i) - c2;
            if (diff != 0) {
                return diff;
            }
            ++i;
            ++offset;
        }
    }

    public static ByteBuffer getData(String itemPath) {
        String string;
        return ICUBinary.getData(null, null, string, false);
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuffer getData(ClassLoader loader, String resourceName, String itemPath) {
        void var2_2;
        void var1_1;
        return ICUBinary.getData(loader, (String)var1_1, (String)var2_2, false);
    }

    public static ByteBuffer getRequiredData(String itemPath) {
        String string;
        return ICUBinary.getData(null, null, string, true);
    }

    /*
     * WARNING - void declaration
     */
    private static ByteBuffer getData(ClassLoader loader, String resourceName, String itemPath, boolean required) {
        ByteBuffer byteBuffer;
        ByteBuffer bytes;
        ByteBuffer byteBuffer2;
        block7: {
            String string = itemPath;
            for (DataFile dataFile : icuDataFiles) {
                ByteBuffer object2 = dataFile.getData(string);
                if (object2 == null) continue;
                byteBuffer2 = object2;
                break block7;
            }
            byteBuffer2 = bytes = null;
        }
        if (byteBuffer2 != null) {
            return bytes;
        }
        if (loader == null) {
            loader = ClassLoaderUtil.getClassLoader(ICUData.class);
        }
        if (resourceName == null) {
            void var2_3;
            resourceName = "com/ibm/icu/impl/data/icudt73b/" + (String)var2_3;
        }
        try {
            void var3_4;
            void var1_2;
            ByteBuffer is = ICUData.getStream(loader, (String)var1_2, (boolean)var3_4);
            if (is == null) {
                return null;
            }
            ByteBuffer buffer = ICUBinary.getByteBufferFromInputStreamAndCloseStream((InputStream)((Object)is));
        }
        catch (IOException e) {
            void var0_1;
            throw new ICUUncheckedIOException((Throwable)var0_1);
        }
        return byteBuffer;
    }

    /*
     * WARNING - void declaration
     */
    private static ByteBuffer mapFile(File path) {
        try {
            FileInputStream file = new FileInputStream(path);
            FileChannel channel = file.getChannel();
            try {
                MappedByteBuffer bytes = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
            }
            catch (Throwable bytes) {
                FileInputStream fileInputStream;
                fileInputStream.close();
                throw bytes;
            }
            file.close();
            return bytes;
        }
        catch (FileNotFoundException ignored) {
            System.err.println(ignored);
        }
        catch (IOException ignored) {
            void var1_4;
            System.err.println(var1_4);
        }
        return null;
    }

    public static void addBaseNamesInFileFolder(String folder, String suffix, Set<String> names) {
        for (DataFile dataFile : icuDataFiles) {
            dataFile.addBaseNamesInFolder(folder, suffix, names);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static VersionInfo readHeaderAndDataVersion(ByteBuffer bytes, int dataFormat, Authenticate authenticate) throws IOException {
        void var2_3;
        void var1_2;
        int n = ICUBinary.readHeader(bytes, (int)var1_2, (Authenticate)var2_3);
        return VersionInfo.getInstance(n >>> 24, n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
    }

    /*
     * WARNING - void declaration
     */
    public static int readHeader(ByteBuffer bytes, int dataFormat, Authenticate authenticate) throws IOException {
        ByteBuffer byteBuffer;
        void var3_3;
        void var2_2;
        void var1_1;
        assert (bytes != null && bytes.position() == 0);
        byte magic1 = bytes.get(2);
        byte magic2 = bytes.get(3);
        if (magic1 != -38 || magic2 != 39) {
            throw new IOException("ICU data file error: Not an ICU data file");
        }
        byte isBigEndian = bytes.get(8);
        byte charsetFamily = bytes.get(9);
        byte sizeofUChar = bytes.get(10);
        if (isBigEndian < 0 || 1 < isBigEndian || charsetFamily != 0 || sizeofUChar != 2) {
            throw new IOException("ICU data file error: Header authentication failed, please check if you have a valid ICU data file");
        }
        bytes.order(isBigEndian != 0 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        char headerSize = bytes.getChar(0);
        char sizeofUDataInfo = bytes.getChar(4);
        if (sizeofUDataInfo < '\u0014' || headerSize < sizeofUDataInfo + 4) {
            throw new IOException("Internal Error: Header size error");
        }
        byte[] formatVersion = new byte[]{bytes.get(16), bytes.get(17), bytes.get(18), bytes.get(19)};
        if (bytes.get(12) != (byte)(dataFormat >> 24) || bytes.get(13) != (byte)(dataFormat >> 16) || bytes.get(14) != (byte)(dataFormat >> 8) || bytes.get(15) != (byte)var1_1 || authenticate != null && !var2_2.isDataVersionAcceptable(formatVersion)) {
            throw new IOException("ICU data file error: Header authentication failed, please check if you have a valid ICU data file" + String.format("; data format %02x%02x%02x%02x, format version %d.%d.%d.%d", bytes.get(12), bytes.get(13), bytes.get(14), bytes.get(15), formatVersion[0] & 0xFF, formatVersion[1] & 0xFF, formatVersion[2] & 0xFF, formatVersion[3] & 0xFF));
        }
        bytes.position((int)var3_3);
        return bytes.get(20) << 24 | (bytes.get(21) & 0xFF) << 16 | (bytes.get(22) & 0xFF) << 8 | byteBuffer.get(23) & 0xFF;
    }

    /*
     * WARNING - void declaration
     */
    public static void skipBytes(ByteBuffer bytes, int skipLength) {
        if (skipLength > 0) {
            void var1_1;
            ByteBuffer byteBuffer;
            ByteBuffer byteBuffer2 = byteBuffer;
            byteBuffer2.position(byteBuffer2.position() + var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] getBytes(ByteBuffer bytes, int length, int additionalSkipLength) {
        void var1_2;
        ByteBuffer byteBuffer;
        byte[] dest = new byte[length];
        byteBuffer.get(dest);
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public static String getString(ByteBuffer bytes, int length, int additionalSkipLength) {
        void var2_2;
        void var1_1;
        ByteBuffer byteBuffer;
        CharBuffer charBuffer = bytes.asCharBuffer();
        String s = charBuffer.subSequence(0, length).toString();
        ICUBinary.skipBytes(byteBuffer, (int)((var1_1 << 1) + var2_2));
        return charBuffer;
    }

    /*
     * WARNING - void declaration
     */
    public static char[] getChars(ByteBuffer bytes, int length, int additionalSkipLength) {
        void var3_3;
        void var2_2;
        void var1_1;
        ByteBuffer byteBuffer;
        char[] dest = new char[length];
        bytes.asCharBuffer().get(dest);
        ICUBinary.skipBytes(byteBuffer, (int)((var1_1 << 1) + var2_2));
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static int[] getInts(ByteBuffer bytes, int length, int additionalSkipLength) {
        void var3_3;
        void var2_2;
        void var1_1;
        ByteBuffer byteBuffer;
        int[] dest = new int[length];
        bytes.asIntBuffer().get(dest);
        ICUBinary.skipBytes(byteBuffer, (int)((var1_1 << 2) + var2_2));
        return var3_3;
    }

    public static ByteBuffer sliceWithOrder(ByteBuffer bytes) {
        ByteBuffer byteBuffer;
        ByteBuffer byteBuffer2 = bytes.slice();
        return byteBuffer2.order(byteBuffer.order());
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuffer getByteBufferFromInputStreamAndCloseStream(InputStream is) throws IOException {
        ByteBuffer byteBuffer;
        try {
            void var2_4;
            void var1_2;
            int avail = is.available();
            byte[] bytes = avail > 32 ? new byte[avail] : new byte[128];
            int length = 0;
            while (true) {
                void var3_5;
                if (length < bytes.length) {
                    int numRead = is.read(bytes, length, bytes.length - length);
                    if (numRead < 0) break;
                    length += numRead;
                    continue;
                }
                int nextByte = is.read();
                if (nextByte < 0) break;
                int capacity = 2 * bytes.length;
                if (capacity < 128) {
                    capacity = 128;
                } else if (capacity < 16384) {
                    capacity <<= 1;
                }
                byte[] byArray = Arrays.copyOf(bytes, capacity);
                bytes = byArray;
                byArray[length++] = (byte)var3_5;
            }
            byteBuffer = ByteBuffer.wrap((byte[])var1_2, 0, (int)var2_4);
        }
        catch (Throwable throwable) {
            InputStream inputStream;
            inputStream.close();
            throw throwable;
        }
        is.close();
        return byteBuffer;
    }

    /*
     * WARNING - void declaration
     */
    static {
        String dataPath = ICUConfig.get(ICUBinary.class.getName() + ".dataPath");
        if (dataPath != null) {
            void var0;
            ICUBinary.addDataFilesFromPath$1b7460f0((String)var0);
        }
    }

    public static interface Authenticate {
        public boolean isDataVersionAcceptable(byte[] var1);
    }

    static final class PackageDataFile
    extends DataFile {
        private final ByteBuffer pkgBytes;

        /*
         * WARNING - void declaration
         */
        PackageDataFile(String item, ByteBuffer bytes) {
            super((String)var1_1);
            void var2_2;
            void var1_1;
            this.pkgBytes = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final ByteBuffer getData(String requestedPath) {
            void var1_1;
            return DatPackageReader.getData(this.pkgBytes, (CharSequence)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void addBaseNamesInFolder(String folder, String suffix, Set<String> names) {
            void var3_3;
            void var2_2;
            void var1_1;
            DatPackageReader.addBaseNamesInFolder(this.pkgBytes, (String)var1_1, (String)var2_2, (Set<String>)var3_3);
        }
    }

    static final class SingleDataFile
    extends DataFile {
        private final File path;

        /*
         * WARNING - void declaration
         */
        SingleDataFile(String item, File path) {
            super((String)var1_1);
            void var2_2;
            void var1_1;
            this.path = var2_2;
        }

        @Override
        public final String toString() {
            return this.path.toString();
        }

        @Override
        final ByteBuffer getData(String requestedPath) {
            if (requestedPath.equals(this.itemPath)) {
                return ICUBinary.mapFile(this.path);
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void addBaseNamesInFolder(String folder, String suffix, Set<String> names) {
            if (this.itemPath.length() > folder.length() + suffix.length() && this.itemPath.startsWith(folder) && this.itemPath.endsWith(suffix) && this.itemPath.charAt(folder.length()) == '/' && this.itemPath.indexOf(47, folder.length() + 1) < 0) {
                void var2_2;
                void var1_1;
                void var3_3;
                var3_3.add(this.itemPath.substring(var1_1.length() + 1, this.itemPath.length() - var2_2.length()));
            }
        }
    }

    static abstract class DataFile {
        protected final String itemPath;

        /*
         * WARNING - void declaration
         */
        DataFile(String item) {
            void var1_1;
            this.itemPath = var1_1;
        }

        public String toString() {
            return this.itemPath;
        }

        abstract ByteBuffer getData(String var1);

        abstract void addBaseNamesInFolder(String var1, String var2, Set<String> var3);
    }

    static final class DatPackageReader {
        private static final IsAcceptable IS_ACCEPTABLE = new IsAcceptable(0);

        /*
         * WARNING - void declaration
         */
        static boolean validate(ByteBuffer bytes) {
            block8: {
                block7: {
                    void var1_1;
                    ByteBuffer byteBuffer;
                    try {
                        ICUBinary.readHeader(bytes, 1131245124, IS_ACCEPTABLE);
                    }
                    catch (IOException iOException) {
                        return false;
                    }
                    ByteBuffer byteBuffer2 = bytes;
                    int count = byteBuffer2.getInt(byteBuffer2.position());
                    if (count <= 0) {
                        return false;
                    }
                    if (bytes.position() + 4 + count * 24 > bytes.capacity()) {
                        return false;
                    }
                    ByteBuffer byteBuffer3 = bytes;
                    if (!DatPackageReader.startsWithPackageName(byteBuffer3, DatPackageReader.getNameOffset(byteBuffer3, 0))) break block7;
                    ByteBuffer byteBuffer4 = byteBuffer;
                    if (DatPackageReader.startsWithPackageName(byteBuffer4, DatPackageReader.getNameOffset(byteBuffer4, (int)(var1_1 - true)))) break block8;
                }
                return false;
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private static boolean startsWithPackageName(ByteBuffer bytes, int start) {
            void var2_2;
            void var1_1;
            ByteBuffer byteBuffer;
            void var3_3;
            byte c;
            int length = 8 - 1;
            for (int i = 0; i < length; ++i) {
                if (bytes.get(start + i) == "icudt73b".charAt(i)) continue;
                return false;
            }
            return ((c = bytes.get(start + length++)) == 98 || var3_3 == 108) && byteBuffer.get((int)(var1_1 + var2_2)) == 47;
        }

        /*
         * WARNING - void declaration
         */
        static ByteBuffer getData(ByteBuffer bytes, CharSequence key) {
            int index = DatPackageReader.binarySearch(bytes, key);
            if (index >= 0) {
                void var2_3;
                void var1_2;
                ByteBuffer byteBuffer;
                ByteBuffer data = bytes.duplicate();
                data.position(DatPackageReader.getDataOffset(bytes, index));
                data.limit(DatPackageReader.getDataOffset(byteBuffer, (int)(var1_2 + true)));
                return ICUBinary.sliceWithOrder((ByteBuffer)var2_3);
            }
            return null;
        }

        static void addBaseNamesInFolder(ByteBuffer bytes, String folder, String suffix, Set<String> names) {
            int index = DatPackageReader.binarySearch(bytes, folder);
            if (index < 0) {
                index ^= 0xFFFFFFFF;
            }
            int base = bytes.position();
            int count = bytes.getInt(base);
            StringBuilder sb = new StringBuilder();
            while (index < count && DatPackageReader.addBaseName(bytes, index, folder, suffix, sb, names)) {
                ++index;
            }
        }

        /*
         * WARNING - void declaration
         */
        private static int binarySearch(ByteBuffer bytes, CharSequence key) {
            void var3_3;
            int limit;
            int base = bytes.position();
            int count = bytes.getInt(base);
            int start = 0;
            while (start < limit) {
                int mid = start + limit >>> 1;
                int n = DatPackageReader.getNameOffset(bytes, mid);
                int nameOffset = n + (8 + 1);
                int result = ICUBinary.compareKeys(key, bytes, nameOffset);
                if (result < 0) {
                    limit = mid;
                    continue;
                }
                if (result > 0) {
                    start = mid + 1;
                    continue;
                }
                return mid;
            }
            return (int)(~var3_3);
        }

        /*
         * WARNING - void declaration
         */
        private static int getNameOffset(ByteBuffer bytes, int index) {
            void var1_1;
            void var2_2;
            ByteBuffer byteBuffer;
            int base = bytes.position();
            assert (index >= 0 && index < bytes.getInt(base));
            return base + byteBuffer.getInt((int)(var2_2 + 4 + (var1_1 << 3)));
        }

        /*
         * WARNING - void declaration
         */
        private static int getDataOffset(ByteBuffer bytes, int index) {
            void var1_1;
            void var2_2;
            ByteBuffer byteBuffer;
            void var3_3;
            int base = bytes.position();
            int count = bytes.getInt(base);
            if (index == count) {
                return bytes.capacity();
            }
            assert (index >= 0 && index < var3_3);
            return base + byteBuffer.getInt((int)(var2_2 + 4 + 4 + (var1_1 << 3)));
        }

        /*
         * WARNING - void declaration
         */
        private static boolean addBaseName(ByteBuffer bytes, int index, String folder, String suffix, StringBuilder sb, Set<String> names) {
            void var3_5;
            byte b;
            index = DatPackageReader.getNameOffset(bytes, index);
            int offset = index + (8 + 1);
            if (folder.length() != 0) {
                int i = 0;
                while (i < folder.length()) {
                    if (bytes.get(offset) != folder.charAt(i)) {
                        return false;
                    }
                    ++i;
                    ++offset;
                }
                if (bytes.get(offset++) != 47) {
                    return false;
                }
            }
            sb.setLength(0);
            while ((b = bytes.get(offset++)) != 0) {
                char c = (char)b;
                if (c == '/') {
                    return true;
                }
                sb.append(c);
            }
            int nameLimit = sb.length() - suffix.length();
            if (sb.lastIndexOf((String)var3_5, nameLimit) >= 0) {
                void var2_4;
                names.add(sb.substring(0, (int)var2_4));
            }
            return true;
        }

        static final class IsAcceptable
        implements Authenticate {
            private IsAcceptable() {
            }

            @Override
            public final boolean isDataVersionAcceptable(byte[] version) {
                return version[0] == 1;
            }

            /* synthetic */ IsAcceptable(byte by) {
                this();
            }
        }
    }
}

