/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ClassLoaderUtil;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.ICUService;
import com.ibm.icu.util.ULocale;
import java.util.Collections;
import java.util.Set;

public class ICULocaleService
extends ICUService {
    private ULocale fallbackLocale;
    private String fallbackLocaleName;

    /*
     * WARNING - void declaration
     */
    public ICULocaleService(String name) {
        super((String)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String validateFallbackLocale() {
        ULocale loc = ULocale.getDefault();
        if (loc != this.fallbackLocale) {
            ICULocaleService iCULocaleService = this;
            synchronized (iCULocaleService) {
                if (loc != this.fallbackLocale) {
                    void var1_1;
                    this.fallbackLocaleName = loc.getBaseName();
                    this.clearServiceCache();
                    this.fallbackLocale = var1_1;
                }
            }
        }
        return this.fallbackLocaleName;
    }

    public static class ICUResourceBundleFactory
    extends LocaleKeyFactory {
        private String bundleName;

        public ICUResourceBundleFactory() {
            this("com/ibm/icu/impl/data/icudt73b");
        }

        /*
         * WARNING - void declaration
         */
        private ICUResourceBundleFactory(String bundleName) {
            super(true);
            void var1_1;
            this.bundleName = var1_1;
        }

        @Override
        protected final Set<String> getSupportedIDs() {
            ICUResourceBundleFactory iCUResourceBundleFactory = this;
            return ICUResourceBundle.getFullLocaleNameSet(this.bundleName, ClassLoaderUtil.getClassLoader(iCUResourceBundleFactory.getClass()));
        }

        @Override
        protected Object handleCreate$6df53f5b(ULocale loc, int kind) {
            ICUResourceBundleFactory iCUResourceBundleFactory;
            void v0 = iCUResourceBundleFactory;
            iCUResourceBundleFactory = this;
            return ICUResourceBundle.getBundleInstance(this.bundleName, (ULocale)v0, ClassLoaderUtil.getClassLoader(iCUResourceBundleFactory.getClass()));
        }

        @Override
        public String toString() {
            return super.toString() + ", bundle: " + this.bundleName;
        }
    }

    public static abstract class LocaleKeyFactory
    implements ICUService.Factory {
        private String name = null;
        private boolean visible = true;

        protected LocaleKeyFactory(boolean visible) {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Object create(ICUService.Key key, ICUService service) {
            boolean bl;
            Object object = key;
            service = this;
            if (object != null) {
                object = ((ICUService.Key)object).currentID();
                service = ((LocaleKeyFactory)((Object)service)).getSupportedIDs();
                bl = service.contains(object);
            } else {
                bl = false;
            }
            if (bl) {
                void var2_3;
                void var1_1;
                LocaleKey lkey = (LocaleKey)key;
                int kind = lkey.kind();
                ULocale uloc = lkey.currentLocale();
                return this.handleCreate$6df53f5b((ULocale)var1_1, (int)var2_3);
            }
            return null;
        }

        protected Object handleCreate$6df53f5b(ULocale loc, int kind) {
            return null;
        }

        protected Set<String> getSupportedIDs() {
            return Collections.emptySet();
        }

        /*
         * WARNING - void declaration
         */
        public String toString() {
            void var1_1;
            StringBuilder buf = new StringBuilder(super.toString());
            if (this.name != null) {
                buf.append(", name: ");
                buf.append(this.name);
            }
            buf.append(", visible: ");
            buf.append(this.visible);
            return var1_1.toString();
        }
    }

    public static final class LocaleKey
    extends ICUService.Key {
        private int kind;
        private int varstart;
        private String primaryID;
        private String fallbackID;
        private String currentID;

        /*
         * WARNING - void declaration
         */
        public static LocaleKey createWithCanonical(ULocale locale, String canonicalFallbackID, int kind) {
            void var2_2;
            void var1_1;
            String string;
            if (locale == null) {
                return null;
            }
            String canonicalPrimaryID = locale.getName();
            Object object = string;
            return new LocaleKey((String)object, (String)object, (String)var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private LocaleKey(String primaryID, String canonicalPrimaryID, String canonicalFallbackID, int kind) {
            super(primaryID);
            this.kind = kind;
            if (canonicalPrimaryID == null || canonicalPrimaryID.equalsIgnoreCase("root")) {
                this.primaryID = "";
                this.fallbackID = null;
            } else {
                int idx = canonicalPrimaryID.indexOf(64);
                if (idx == 4 && canonicalPrimaryID.regionMatches(true, 0, "root", 0, 4)) {
                    this.primaryID = canonicalPrimaryID.substring(4);
                    this.varstart = 0;
                    this.fallbackID = null;
                } else {
                    void var3_4;
                    void var1_2;
                    void var2_3;
                    this.primaryID = var2_3;
                    this.varstart = var1_2;
                    this.fallbackID = canonicalFallbackID == null || this.primaryID.equals(canonicalFallbackID) ? "" : var3_4;
                }
            }
            this.currentID = this.varstart == -1 ? this.primaryID : this.primaryID.substring(0, this.varstart);
        }

        public final int kind() {
            return this.kind;
        }

        @Override
        public final String canonicalID() {
            return this.primaryID;
        }

        @Override
        public final String currentID() {
            return this.currentID;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String currentDescriptor() {
            void var1_2;
            LocaleKey localeKey = this;
            String result = localeKey.currentID;
            if (result != null) {
                void var2_3;
                StringBuilder buf = new StringBuilder();
                if (this.kind != -1) {
                    localeKey = this;
                    buf.append(localeKey.kind == -1 ? null : Integer.toString(localeKey.kind));
                }
                buf.append('/');
                buf.append(result);
                if (this.varstart != -1) {
                    buf.append(this.primaryID.substring(this.varstart, this.primaryID.length()));
                }
                result = var2_3.toString();
            }
            return var1_2;
        }

        public final ULocale currentLocale() {
            if (this.varstart == -1) {
                return new ULocale(this.currentID);
            }
            return new ULocale(this.currentID + this.primaryID.substring(this.varstart));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean fallback() {
            int x = this.currentID.lastIndexOf(95);
            if (x != -1) {
                void var1_1;
                while (--x >= 0 && this.currentID.charAt(x) == '_') {
                }
                this.currentID = this.currentID.substring(0, (int)(var1_1 + true));
                return true;
            }
            if (this.fallbackID != null) {
                this.currentID = this.fallbackID;
                this.fallbackID = this.fallbackID.length() == 0 ? null : "";
                return true;
            }
            this.currentID = null;
            return false;
        }
    }
}

