/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.CacheValue;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.ICUResourceBundleReader;
import com.ibm.icu.util.UResourceBundle;
import com.ibm.icu.util.UResourceTypeMismatchException;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;

class ICUResourceBundleImpl
extends ICUResourceBundle {
    protected int resource;

    /*
     * WARNING - void declaration
     */
    protected ICUResourceBundleImpl(ICUResourceBundleImpl container, String key, int resource) {
        super((ICUResourceBundle)var1_1, (String)var2_2);
        void var3_3;
        void var2_2;
        void var1_1;
        this.resource = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    ICUResourceBundleImpl(ICUResourceBundle.WholeBundle wholeBundle) {
        super(wholeBundle);
        void var1_1;
        this.resource = var1_1.reader.getRootResource();
    }

    public final int getResource() {
        return this.resource;
    }

    /*
     * WARNING - void declaration
     */
    protected final ICUResourceBundle createBundleObject(String _key, int _resource, HashMap<String, String> aliasesVisited, UResourceBundle requested) {
        switch (ICUResourceBundleReader.RES_GET_TYPE(_resource)) {
            case 0: 
            case 6: {
                return new ResourceString(this, _key, _resource);
            }
            case 1: {
                return new ResourceBinary(this, _key, _resource);
            }
            case 3: {
                void var3_3;
                return ICUResourceBundleImpl.getAliasedResource(this, null, 0, _key, _resource, (HashMap<String, String>)var3_3, requested);
            }
            case 7: {
                return new ResourceInt(this, _key, _resource);
            }
            case 14: {
                return new ResourceIntVector(this, _key, _resource);
            }
            case 8: 
            case 9: {
                return new ResourceArray(this, _key, _resource);
            }
            case 2: 
            case 4: 
            case 5: {
                void var2_2;
                void var1_1;
                return new ResourceTable(this, (String)var1_1, (int)var2_2);
            }
        }
        throw new IllegalStateException("The resource type is unknown");
    }

    static final class ResourceTable
    extends ResourceContainer {
        @Override
        public final int getType() {
            return 2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final Set<String> handleKeySet() {
            void var2_2;
            ICUResourceBundleReader reader = this.wholeBundle.reader;
            TreeSet<String> keySet = new TreeSet<String>();
            ICUResourceBundleReader.Table table = (ICUResourceBundleReader.Table)this.value;
            for (int i = 0; i < table.getSize(); ++i) {
                keySet.add(table.getKey(reader, i));
            }
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final UResourceBundle handleGet(String resKey, HashMap<String, String> aliasesVisited, UResourceBundle requested) {
            void var3_3;
            void var2_2;
            void var1_1;
            int i = ((ICUResourceBundleReader.Table)this.value).findTableItem(this.wholeBundle.reader, resKey);
            if (i < 0) {
                return null;
            }
            return this.createBundleObject((String)var1_1, this.getContainerResource(i), (HashMap<String, String>)var2_2, (UResourceBundle)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final UResourceBundle handleGet(int index, HashMap<String, String> aliasesVisited, UResourceBundle requested) {
            void var3_3;
            void var2_2;
            void var1_1;
            String itemKey = ((ICUResourceBundleReader.Table)this.value).getKey(this.wholeBundle.reader, index);
            if (itemKey == null) {
                throw new IndexOutOfBoundsException();
            }
            return this.createBundleObject(itemKey, this.getContainerResource((int)var1_1), (HashMap<String, String>)var2_2, (UResourceBundle)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final Object handleGetObject(String key) {
            void var1_1;
            ICUResourceBundleReader reader = this.wholeBundle.reader;
            int index = ((ICUResourceBundleReader.Table)this.value).findTableItem(reader, key);
            if (index >= 0) {
                int res = this.value.getContainerResource(reader, index);
                String s = reader.getString(res);
                if (s != null) {
                    return s;
                }
                ICUResourceBundleReader.Array array = reader.getArray(res);
                if (array != null) {
                    int length = array.getSize();
                    String[] strings = new String[length];
                    int j = 0;
                    while (true) {
                        if (j == length) {
                            return strings;
                        }
                        s = reader.getString(array.getContainerResource(reader, j));
                        if (s == null) break;
                        strings[j] = s;
                        ++j;
                    }
                }
            }
            return super.handleGetObject((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        final String findString(String key) {
            void var1_2;
            void var2_3;
            ICUResourceBundleReader reader = this.wholeBundle.reader;
            int index = ((ICUResourceBundleReader.Table)this.value).findTableItem(reader, key);
            if (index < 0) {
                return null;
            }
            return reader.getString(this.value.getContainerResource((ICUResourceBundleReader)var2_3, (int)var1_2));
        }

        /*
         * WARNING - void declaration
         */
        ResourceTable(ICUResourceBundleImpl container, String key, int resource) {
            super((ICUResourceBundleImpl)var1_1, (String)var2_2, resource);
            void var3_3;
            void var2_2;
            void var1_1;
            this.value = this.wholeBundle.reader.getTable((int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        ResourceTable(ICUResourceBundle.WholeBundle wholeBundle, int rootRes) {
            super(wholeBundle);
            void var2_2;
            void var1_1;
            this.value = var1_1.reader.getTable((int)var2_2);
        }
    }

    static final class ResourceArray
    extends ResourceContainer {
        @Override
        public final int getType() {
            return 8;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final String[] handleGetStringArray() {
            void var3_3;
            ICUResourceBundleReader reader = this.wholeBundle.reader;
            int length = this.value.getSize();
            String[] strings = new String[length];
            for (int i = 0; i < length; ++i) {
                String s = reader.getString(this.value.getContainerResource(reader, i));
                if (s == null) {
                    throw new UResourceTypeMismatchException("");
                }
                strings[i] = s;
            }
            return var3_3;
        }

        @Override
        public final String[] getStringArray() {
            return this.handleGetStringArray();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final UResourceBundle handleGet(String indexStr, HashMap<String, String> aliasesVisited, UResourceBundle requested) {
            void var3_3;
            void var2_2;
            void var1_1;
            int i = Integer.parseInt(indexStr);
            return this.createBundleObject(i, (String)var1_1, (HashMap<String, String>)var2_2, (UResourceBundle)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final UResourceBundle handleGet(int index, HashMap<String, String> aliasesVisited, UResourceBundle requested) {
            void var3_3;
            void var2_2;
            void var1_1;
            void v0 = var1_1;
            return this.createBundleObject((int)v0, Integer.toString((int)v0), (HashMap<String, String>)var2_2, (UResourceBundle)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        ResourceArray(ICUResourceBundleImpl container, String key, int resource) {
            super((ICUResourceBundleImpl)var1_1, (String)var2_2, resource);
            void var3_3;
            void var2_2;
            void var1_1;
            this.value = this.wholeBundle.reader.getArray((int)var3_3);
        }
    }

    static abstract class ResourceContainer
    extends ICUResourceBundleImpl {
        protected ICUResourceBundleReader.Container value;

        @Override
        public final int getSize() {
            return this.value.getSize();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String getString(int index) {
            void var1_1;
            int res = this.value.getContainerResource(this.wholeBundle.reader, index);
            if (res == -1) {
                throw new IndexOutOfBoundsException();
            }
            String s = this.wholeBundle.reader.getString(res);
            if (s != null) {
                void var2_3;
                return var2_3;
            }
            return super.getString((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        protected final int getContainerResource(int index) {
            void var1_1;
            return this.value.getContainerResource(this.wholeBundle.reader, (int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        protected final UResourceBundle createBundleObject(int index, String resKey, HashMap<String, String> aliasesVisited, UResourceBundle requested) {
            void var3_3;
            void var1_1;
            void var2_2;
            int item = this.getContainerResource(index);
            if (item == -1) {
                throw new IndexOutOfBoundsException();
            }
            return this.createBundleObject((String)var2_2, (int)var1_1, (HashMap<String, String>)var3_3, requested);
        }

        /*
         * WARNING - void declaration
         */
        ResourceContainer(ICUResourceBundleImpl container, String key, int resource) {
            super((ICUResourceBundleImpl)var1_1, (String)var2_2, (int)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        ResourceContainer(ICUResourceBundle.WholeBundle wholeBundle) {
            super((ICUResourceBundle.WholeBundle)var1_1);
            void var1_1;
        }
    }

    static final class ResourceIntVector
    extends ICUResourceBundleImpl {
        @Override
        public final int getType() {
            return 14;
        }

        @Override
        public final int[] getIntVector() {
            return this.wholeBundle.reader.getIntVector(this.resource);
        }

        /*
         * WARNING - void declaration
         */
        ResourceIntVector(ICUResourceBundleImpl container, String key, int resource) {
            super((ICUResourceBundleImpl)var1_1, (String)var2_2, (int)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }
    }

    static final class ResourceString
    extends ICUResourceBundleImpl {
        private String value;

        @Override
        public final int getType() {
            return 0;
        }

        @Override
        public final String getString() {
            if (this.value != null) {
                return this.value;
            }
            return this.wholeBundle.reader.getString(this.resource);
        }

        /*
         * WARNING - void declaration
         */
        ResourceString(ICUResourceBundleImpl container, String key, int resource) {
            super(container, (String)var2_2, resource);
            void var3_3;
            void var2_2;
            String s = this.wholeBundle.reader.getString((int)var3_3);
            if (s.length() < 12 || CacheValue.futureInstancesWillBeStrong()) {
                void var1_1;
                this.value = var1_1;
            }
        }
    }

    static final class ResourceInt
    extends ICUResourceBundleImpl {
        @Override
        public final int getType() {
            return 7;
        }

        @Override
        public final int getInt() {
            return ICUResourceBundleReader.RES_GET_INT(this.resource);
        }

        /*
         * WARNING - void declaration
         */
        ResourceInt(ICUResourceBundleImpl container, String key, int resource) {
            super((ICUResourceBundleImpl)var1_1, (String)var2_2, (int)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }
    }

    static final class ResourceBinary
    extends ICUResourceBundleImpl {
        @Override
        public final int getType() {
            return 1;
        }

        /*
         * WARNING - void declaration
         */
        ResourceBinary(ICUResourceBundleImpl container, String key, int resource) {
            super((ICUResourceBundleImpl)var1_1, (String)var2_2, (int)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }
    }
}

