/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.CacheValue;
import com.ibm.icu.impl.ICUBinary;
import com.ibm.icu.impl.ICUData;
import com.ibm.icu.impl.SoftCache;
import com.ibm.icu.impl.UResource;
import com.ibm.icu.util.ICUException;
import com.ibm.icu.util.ICUUncheckedIOException;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceTypeMismatchException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;

public final class ICUResourceBundleReader {
    private static final IsAcceptable IS_ACCEPTABLE = new IsAcceptable(0);
    private static final CharBuffer EMPTY_16_BIT_UNITS = CharBuffer.wrap("\u0000");
    private ByteBuffer bytes;
    private byte[] keyBytes;
    private CharBuffer b16BitUnits;
    private ICUResourceBundleReader poolBundleReader;
    private int rootRes;
    private int localKeyLimit;
    private int poolStringIndexLimit;
    private int poolStringIndex16Limit;
    private boolean noFallback;
    private boolean isPoolBundle;
    private boolean usesPoolBundle;
    private int poolCheckSum;
    private ResourceCache resourceCache;
    private static ReaderCache CACHE = new ReaderCache(0);
    private static final ICUResourceBundleReader NULL_READER = new ICUResourceBundleReader();
    private static final char[] emptyChars;
    private static final int[] emptyInts;
    private static final Array EMPTY_ARRAY;
    private static final Table EMPTY_TABLE;
    private static int[] PUBLIC_TYPES;

    private ICUResourceBundleReader() {
    }

    /*
     * WARNING - void declaration
     */
    private ICUResourceBundleReader(ByteBuffer inBytes, String baseName, ClassLoader loader) throws IOException {
        ICUResourceBundleReader iCUResourceBundleReader;
        void var4_4 = iCUResourceBundleReader;
        iCUResourceBundleReader = this;
        ICUBinary.readHeader((ByteBuffer)var4_4, 1382380354, IS_ACCEPTABLE);
        int n = var4_4.get(16);
        iCUResourceBundleReader.bytes = ICUBinary.sliceWithOrder((ByteBuffer)var4_4);
        int n2 = iCUResourceBundleReader.bytes.remaining();
        iCUResourceBundleReader.rootRes = iCUResourceBundleReader.bytes.getInt(0);
        int n3 = iCUResourceBundleReader.getIndexesInt(0);
        int n4 = n3 & 0xFF;
        if (n4 <= 4) {
            throw new ICUException("not enough indexes");
        }
        if (n2 < n4 + 1 << 2 || n2 < (n2 = iCUResourceBundleReader.getIndexesInt(3)) << 2) {
            throw new ICUException("not enough bytes");
        }
        --n2;
        if (n >= 3) {
            iCUResourceBundleReader.poolStringIndexLimit = n3 >>> 8;
        }
        if (n4 > 5) {
            n = iCUResourceBundleReader.getIndexesInt(5);
            iCUResourceBundleReader.noFallback = (n & 1) != 0;
            iCUResourceBundleReader.isPoolBundle = (n & 2) != 0;
            iCUResourceBundleReader.usesPoolBundle = (n & 4) != 0;
            iCUResourceBundleReader.poolStringIndexLimit |= (n & 0xF000) << 12;
            iCUResourceBundleReader.poolStringIndex16Limit = n >>> 16;
        }
        n = n4 + 1;
        n3 = iCUResourceBundleReader.getIndexesInt(1);
        if (n3 > n) {
            if (iCUResourceBundleReader.isPoolBundle) {
                iCUResourceBundleReader.keyBytes = new byte[n3 - n << 2];
                iCUResourceBundleReader.bytes.position(n << 2);
            } else {
                iCUResourceBundleReader.localKeyLimit = n3 << 2;
                iCUResourceBundleReader.keyBytes = new byte[iCUResourceBundleReader.localKeyLimit];
            }
            iCUResourceBundleReader.bytes.get(iCUResourceBundleReader.keyBytes);
        }
        if (n4 > 6) {
            n = iCUResourceBundleReader.getIndexesInt(6);
            if (n > n3) {
                n = n - n3 << 1;
                iCUResourceBundleReader.bytes.position(n3 << 2);
                iCUResourceBundleReader.b16BitUnits = iCUResourceBundleReader.bytes.asCharBuffer();
                iCUResourceBundleReader.b16BitUnits.limit(n);
                n2 |= n - 1;
            } else {
                iCUResourceBundleReader.b16BitUnits = EMPTY_16_BIT_UNITS;
            }
        } else {
            iCUResourceBundleReader.b16BitUnits = EMPTY_16_BIT_UNITS;
        }
        if (n4 > 7) {
            iCUResourceBundleReader.poolCheckSum = iCUResourceBundleReader.getIndexesInt(7);
        }
        if (!iCUResourceBundleReader.isPoolBundle || iCUResourceBundleReader.b16BitUnits.length() > 1) {
            iCUResourceBundleReader.resourceCache = new ResourceCache(n2);
        }
        iCUResourceBundleReader.bytes.position(0);
        if (this.usesPoolBundle) {
            void var3_3;
            void var2_2;
            this.poolBundleReader = ICUResourceBundleReader.getReader((String)var2_2, "pool", (ClassLoader)var3_3);
            if (this.poolBundleReader == null || !this.poolBundleReader.isPoolBundle) {
                throw new IllegalStateException("pool.res is not a pool bundle");
            }
            if (this.poolBundleReader.poolCheckSum != this.poolCheckSum) {
                throw new IllegalStateException("pool.res has a different checksum than this bundle");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    static ICUResourceBundleReader getReader(String baseName, String localeID, ClassLoader root) {
        ICUResourceBundleReader iCUResourceBundleReader;
        void var2_2;
        void var1_1;
        ICUResourceBundleReader info = new ReaderCacheKey(baseName, (String)var1_1);
        ICUResourceBundleReader reader = (ICUResourceBundleReader)CACHE.getInstance(info, var2_2);
        if (reader == NULL_READER) {
            return null;
        }
        return iCUResourceBundleReader;
    }

    /*
     * WARNING - void declaration
     */
    private int getIndexesInt(int i) {
        void var1_1;
        return this.bytes.getInt((int)(var1_1 + true << 2));
    }

    final int getRootResource() {
        return this.rootRes;
    }

    final boolean getNoFallback() {
        return this.noFallback;
    }

    static int RES_GET_TYPE(int res) {
        return res >>> 28;
    }

    static int RES_GET_INT(int res) {
        return res << 4 >> 4;
    }

    static boolean URES_IS_ARRAY(int type) {
        int n;
        return type == 8 || n == 9;
    }

    static boolean URES_IS_TABLE(int type) {
        int n;
        return type == 2 || type == 5 || n == 4;
    }

    /*
     * WARNING - void declaration
     */
    private int getInt(int offset) {
        void var1_1;
        return this.bytes.getInt((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private int[] getInts(int offset, int count) {
        void var3_3;
        int[] ints = new int[count];
        if (count <= 16) {
            for (int i = 0; i < count; ++i) {
                ints[i] = this.bytes.getInt(offset);
                offset += 4;
            }
        } else {
            void var1_1;
            IntBuffer temp = this.bytes.asIntBuffer();
            temp.position((int)(var1_1 / 4));
            temp.get(ints);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static String makeKeyStringFromBytes(byte[] keyBytes, int keyOffset) {
        void var2_2;
        byte b;
        StringBuilder sb = new StringBuilder();
        while ((b = keyBytes[keyOffset]) != 0) {
            void var3_3;
            ++keyOffset;
            sb.append((char)var3_3);
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    private String getStringV2(int res) {
        void var1_1;
        void var2_3;
        String s2;
        void var3_5;
        int n;
        assert ((n = res) >>> 28 == 6);
        n = res;
        int offset = n & 0xFFFFFFF;
        assert (offset != 0);
        Object value = this.resourceCache.get(res);
        if (value != null) {
            return (String)value;
        }
        char first = this.b16BitUnits.charAt(offset);
        if ((first & 0xFFFFFC00) != 56320) {
            char c;
            if (first == '\u0000') {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            sb.append(first);
            while ((c = this.b16BitUnits.charAt(++offset)) != '\u0000') {
                sb.append((char)var3_5);
            }
            s2 = sb.toString();
        } else {
            void s;
            int length;
            if (var3_5 < 57327) {
                length = var3_5 & 0x3FF;
            } else if (var3_5 < 57343) {
                length = var3_5 - 57327 << 16 | this.b16BitUnits.charAt((int)(s + true));
                s += 2;
            } else {
                length = this.b16BitUnits.charAt((int)(s + true)) << 16 | this.b16BitUnits.charAt((int)(s + 2));
                s += 3;
            }
            void v0 = ++s;
            s2 = this.b16BitUnits.subSequence((int)v0, (int)(v0 + length)).toString();
        }
        void v1 = var2_3;
        return (String)this.resourceCache.putIfAbsent((int)var1_1, v1, v1.length() << 1);
    }

    /*
     * WARNING - void declaration
     */
    private String makeStringFromBytes(int offset, int length) {
        void var2_2;
        void var3_4;
        void var1_1;
        if (length <= 16) {
            StringBuilder sb = new StringBuilder(length);
            for (int i = 0; i < length; ++i) {
                sb.append(this.bytes.getChar(offset));
                offset += 2;
            }
            return sb.toString();
        }
        CharBuffer cs = this.bytes.asCharBuffer();
        offset /= 2;
        void v0 = var1_1;
        return var3_4.subSequence((int)v0, (int)(v0 + var2_2)).toString();
    }

    /*
     * WARNING - void declaration
     */
    final String getString(int res) {
        void var1_1;
        void var2_6;
        void var3_4;
        int n = res;
        int offset = n & 0xFFFFFFF;
        if (res != offset && (n = res) >>> 28 != 6) {
            return null;
        }
        if (offset == 0) {
            return "";
        }
        if (res != offset) {
            if (offset < this.poolStringIndexLimit) {
                return this.poolBundleReader.getStringV2(res);
            }
            return this.getStringV2(res - this.poolStringIndexLimit);
        }
        Object value22 = this.resourceCache.get(res);
        if (value22 != null) {
            return (String)value22;
        }
        int value22 = offset;
        offset = value22 << 2;
        int length = this.getInt(offset);
        String s = this.makeStringFromBytes(offset + 4, (int)var3_4);
        void v0 = var2_6;
        return (String)this.resourceCache.putIfAbsent((int)var1_1, v0, v0.length() << 1);
    }

    /*
     * WARNING - void declaration
     */
    final String getAlias(int res) {
        int n = res;
        int offset = n & 0xFFFFFFF;
        n = res;
        if (n >>> 28 == 3) {
            void var3_4;
            void var2_6;
            void var1_1;
            if (offset == 0) {
                return "";
            }
            Object value22 = this.resourceCache.get(res);
            if (value22 != null) {
                return (String)value22;
            }
            int value22 = offset;
            offset = value22 << 2;
            int length = this.getInt(offset);
            String s = this.makeStringFromBytes(offset + 4, length);
            return (String)this.resourceCache.putIfAbsent((int)var1_1, var2_6, (int)(var3_4 << 1));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    final int[] getIntVector(int res) {
        int n = res;
        int offset = n & 0xFFFFFFF;
        n = res;
        if (n >>> 28 == 14) {
            void var1_1;
            void var2_3;
            if (offset == 0) {
                return emptyInts;
            }
            n = offset;
            offset = n << 2;
            int length = this.getInt(offset);
            return this.getInts((int)(var2_3 + 4), (int)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    final Array getArray(int res) {
        void var2_4;
        void var1_1;
        int n = res;
        int type = n >>> 28;
        if (!ICUResourceBundleReader.URES_IS_ARRAY(type)) {
            return null;
        }
        n = res;
        int offset = n & 0xFFFFFFF;
        if (offset == 0) {
            return EMPTY_ARRAY;
        }
        Object value = this.resourceCache.get(res);
        if (value != null) {
            return (Array)value;
        }
        Array array = type == 8 ? new Array32(this, offset) : new Array16(this, n);
        return (Array)this.resourceCache.putIfAbsent((int)var1_1, var2_4, 0);
    }

    /*
     * WARNING - void declaration
     */
    final Table getTable(int res) {
        void var2_4;
        void var1_1;
        void table2;
        int size;
        Table table2;
        int n = res;
        int type = n >>> 28;
        if (!ICUResourceBundleReader.URES_IS_TABLE(type)) {
            return null;
        }
        n = res;
        int offset = n & 0xFFFFFFF;
        if (offset == 0) {
            return EMPTY_TABLE;
        }
        Object value = this.resourceCache.get(res);
        if (value != null) {
            return (Table)value;
        }
        if (type == 2) {
            table2 = new Table1632(this, offset);
            size = table2.getSize() << 1;
        } else if (table2 == 5) {
            table2 = new Table16(this, size);
            size = table2.getSize() << 1;
        } else {
            table2 = new Table32(this, size);
            size = table2.getSize() << 2;
        }
        return (Table)this.resourceCache.putIfAbsent((int)var1_1, var2_4, n);
    }

    /*
     * WARNING - void declaration
     */
    public static String getFullName(String baseName, String localeName) {
        void var1_1;
        String string;
        if (baseName == null || baseName.length() == 0) {
            if (localeName.length() == 0) {
                return ULocale.getDefault().toString();
            }
            return localeName + ".res";
        }
        if (baseName.indexOf(46) == -1) {
            String string2 = baseName;
            if (string2.charAt(string2.length() - 1) != '/') {
                return baseName + "/" + localeName + ".res";
            }
            return baseName + localeName + ".res";
        }
        baseName = baseName.replace('.', '/');
        if (localeName.length() == 0) {
            return baseName + ".res";
        }
        return string + "_" + (String)var1_1 + ".res";
    }

    /*
     * WARNING - void declaration
     */
    /* synthetic */ ICUResourceBundleReader(ByteBuffer x0, String x1, String x2, ClassLoader x3) throws IOException {
        this((ByteBuffer)var1_1, (String)var2_2, x3);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$900(ICUResourceBundleReader x0, int x1) {
        void var1_1;
        return x0.getInt((int)var1_1);
    }

    static /* synthetic */ int access$1000(ICUResourceBundleReader x0, int x1) {
        int n = x1;
        return n << 2;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$1100(ICUResourceBundleReader x0, int x1) {
        void var1_1;
        ICUResourceBundleReader iCUResourceBundleReader = x0;
        if (var1_1 < iCUResourceBundleReader.localKeyLimit) {
            return ICUResourceBundleReader.makeKeyStringFromBytes(iCUResourceBundleReader.keyBytes, (int)var1_1);
        }
        return ICUResourceBundleReader.makeKeyStringFromBytes(iCUResourceBundleReader.poolBundleReader.keyBytes, (int)(var1_1 - iCUResourceBundleReader.localKeyLimit));
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$1200(ICUResourceBundleReader x0, int x1) {
        void var1_1;
        ICUResourceBundleReader iCUResourceBundleReader = x0;
        if (var1_1 >= 0) {
            return ICUResourceBundleReader.makeKeyStringFromBytes(iCUResourceBundleReader.keyBytes, (int)var1_1);
        }
        return ICUResourceBundleReader.makeKeyStringFromBytes(iCUResourceBundleReader.poolBundleReader.keyBytes, var1_1 & Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$1300(ICUResourceBundleReader x0, CharSequence x1, char x2) {
        void var1_1;
        void var2_2;
        ICUResourceBundleReader iCUResourceBundleReader = x0;
        if (var2_2 < iCUResourceBundleReader.localKeyLimit) {
            return ICUBinary.compareKeys((CharSequence)var1_1, iCUResourceBundleReader.keyBytes, (int)var2_2);
        }
        return ICUBinary.compareKeys((CharSequence)var1_1, iCUResourceBundleReader.poolBundleReader.keyBytes, (int)(var2_2 - iCUResourceBundleReader.localKeyLimit));
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$1400(ICUResourceBundleReader x0, CharSequence x1, int x2) {
        void var1_1;
        void var2_2;
        ICUResourceBundleReader iCUResourceBundleReader = x0;
        if (var2_2 >= 0) {
            return ICUBinary.compareKeys((CharSequence)var1_1, iCUResourceBundleReader.keyBytes, (int)var2_2);
        }
        return ICUBinary.compareKeys((CharSequence)var1_1, iCUResourceBundleReader.poolBundleReader.keyBytes, var2_2 & Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1500(ICUResourceBundleReader x0, int x1, UResource.Key x2) {
        void var2_2;
        void var1_1;
        ICUResourceBundleReader iCUResourceBundleReader = x0;
        if (var1_1 < iCUResourceBundleReader.localKeyLimit) {
            var2_2.setBytes(iCUResourceBundleReader.keyBytes, (int)var1_1);
            return;
        }
        var2_2.setBytes(iCUResourceBundleReader.poolBundleReader.keyBytes, (int)(var1_1 - iCUResourceBundleReader.localKeyLimit));
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1600(ICUResourceBundleReader x0, int x1, UResource.Key x2) {
        void var2_2;
        void var1_1;
        ICUResourceBundleReader iCUResourceBundleReader = x0;
        if (var1_1 >= 0) {
            var2_2.setBytes(iCUResourceBundleReader.keyBytes, (int)var1_1);
            return;
        }
        var2_2.setBytes(iCUResourceBundleReader.poolBundleReader.keyBytes, (int)(var1_1 & Integer.MAX_VALUE));
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ char[] access$1700(ICUResourceBundleReader x0, int x1) {
        void var1_1;
        ICUResourceBundleReader iCUResourceBundleReader = x0;
        int n = iCUResourceBundleReader.bytes.getChar((int)var1_1);
        if (n > 0) {
            var1_1 += 2;
            char[] cArray = new char[n];
            if (n <= 16) {
                for (int i = 0; i < n; ++i) {
                    cArray[i] = iCUResourceBundleReader.bytes.getChar((int)var1_1);
                    var1_1 += 2;
                }
            } else {
                CharBuffer charBuffer = iCUResourceBundleReader.bytes.asCharBuffer();
                charBuffer.position((int)(var1_1 / 2));
                charBuffer.get(cArray);
            }
            return cArray;
        }
        return emptyChars;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ char[] access$1800(ICUResourceBundleReader x0, int x1) {
        void var1_1;
        int n;
        ICUResourceBundleReader iCUResourceBundleReader = x0;
        if ((n = iCUResourceBundleReader.b16BitUnits.charAt((int)var1_1++)) > 0) {
            char[] cArray = new char[n];
            if (n <= 16) {
                for (int i = 0; i < n; ++i) {
                    cArray[i] = iCUResourceBundleReader.b16BitUnits.charAt((int)var1_1++);
                }
            } else {
                CharBuffer charBuffer = iCUResourceBundleReader.b16BitUnits.duplicate();
                charBuffer.position((int)var1_1);
                charBuffer.get(cArray);
            }
            return cArray;
        }
        return emptyChars;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int[] access$1900(ICUResourceBundleReader x0, int x1) {
        void var1_1;
        ICUResourceBundleReader iCUResourceBundleReader = x0;
        int n = iCUResourceBundleReader.getInt((int)var1_1);
        if (n > 0) {
            return iCUResourceBundleReader.getInts((int)(var1_1 + 4), n);
        }
        return emptyInts;
    }

    static /* synthetic */ int access$2200(int x0) {
        int n = x0;
        return n & 0xFFFFFFF;
    }

    static {
        ByteBuffer.allocate(0).asReadOnlyBuffer();
        emptyChars = new char[0];
        emptyInts = new int[0];
        EMPTY_ARRAY = new Array();
        EMPTY_TABLE = new Table();
        PUBLIC_TYPES = new int[]{0, 1, 2, 3, 2, 2, 0, 7, 8, 8, -1, -1, -1, -1, 14, -1};
    }

    static final class ResourceCache {
        private int[] keys = new int[32];
        private Object[] values = new Object[32];
        private int length;
        private int maxOffsetBits;
        private int levelBitsList;
        private Level rootLevel;

        private static boolean storeDirectly(int size) {
            return size < 24 || CacheValue.futureInstancesWillBeStrong();
        }

        /*
         * WARNING - void declaration
         */
        private static final Object putIfCleared(Object[] values, int index, Object item, int size) {
            void var2_2;
            void var3_3;
            Object value = values[index];
            if (!(value instanceof SoftReference)) {
                return value;
            }
            assert (var3_3 >= 24);
            if ((value = ((SoftReference)value).get()) != null) {
                return value;
            }
            var0[var1_1] = CacheValue.futureInstancesWillBeStrong() ? item : new SoftReference<Object>(item);
            return var2_2;
        }

        ResourceCache(int maxOffset) {
            assert (maxOffset != 0);
            this.maxOffsetBits = 28;
            while (maxOffset <= 0x7FFFFFF) {
                maxOffset <<= 1;
                --this.maxOffsetBits;
            }
            int keyBits = this.maxOffsetBits + 2;
            if (keyBits <= 7) {
                this.levelBitsList = keyBits;
                return;
            }
            if (keyBits < 10) {
                this.levelBitsList = 0x30 | keyBits - 3;
                return;
            }
            this.levelBitsList = 7;
            keyBits -= 7;
            int shift = 4;
            while (true) {
                if (keyBits <= 6) {
                    this.levelBitsList |= keyBits << shift;
                    return;
                }
                if (keyBits < 9) {
                    this.levelBitsList |= (0x30 | keyBits - 3) << shift;
                    return;
                }
                this.levelBitsList |= 6 << shift;
                keyBits -= 6;
                shift += 4;
            }
        }

        /*
         * WARNING - void declaration
         */
        private int makeKey(int res) {
            void var2_2;
            void var1_1;
            int type = ICUResourceBundleReader.RES_GET_TYPE(res);
            int miniType = type == 6 ? 1 : (type == 5 ? 3 : (type == 9 ? 2 : 0));
            return ICUResourceBundleReader.access$2200((int)var1_1) | var2_2 << this.maxOffsetBits;
        }

        /*
         * WARNING - void declaration
         */
        private int findSimple(int key) {
            void var1_1;
            return Arrays.binarySearch(this.keys, 0, this.length, (int)var1_1);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        final synchronized Object get(int res) {
            void var1_2;
            Object value2;
            assert (ICUResourceBundleReader.access$2200(res) != 0);
            if (this.length >= 0) {
                int index = this.findSimple(res);
                if (index < 0) return null;
                value2 = this.values[index];
            } else {
                void value;
                value2 = this.rootLevel.get(this.makeKey((int)value));
                if (value2 == null) {
                    return null;
                }
            }
            if (!(value2 instanceof SoftReference)) return var1_2;
            value2 = ((SoftReference)value2).get();
            return var1_2;
        }

        /*
         * WARNING - void declaration
         */
        final synchronized Object putIfAbsent(int res, Object item, int size) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (this.length >= 0) {
                int index = this.findSimple(res);
                if (index >= 0) {
                    return ResourceCache.putIfCleared(this.values, index, item, size);
                }
                if (this.length < 32) {
                    if ((index ^= 0xFFFFFFFF) < this.length) {
                        System.arraycopy(this.keys, index, this.keys, index + 1, this.length - index);
                        System.arraycopy(this.values, index, this.values, index + 1, this.length - index);
                    }
                    ++this.length;
                    this.keys[index] = res;
                    this.values[index] = ResourceCache.storeDirectly(size) ? item : new SoftReference<Object>(item);
                    return item;
                }
                this.rootLevel = new Level(this.levelBitsList, 0);
                for (int i = 0; i < 32; ++i) {
                    ResourceCache resourceCache = this;
                    this.rootLevel.putIfAbsent(resourceCache.makeKey(resourceCache.keys[i]), this.values[i], 0);
                }
                this.keys = null;
                this.values = null;
                this.length = -1;
            }
            return this.rootLevel.putIfAbsent(this.makeKey((int)var1_1), var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ Object access$2000(Object[] x0, int x1, Object x2, int x3) {
            void var3_3;
            void var2_2;
            void var1_1;
            return ResourceCache.putIfCleared(x0, (int)var1_1, var2_2, (int)var3_3);
        }

        static final class Level {
            private int levelBitsList;
            private int shift;
            private int mask;
            private int[] keys;
            private Object[] values;

            /*
             * WARNING - void declaration
             */
            Level(int levelBitsList, int shift) {
                void var1_1;
                void var2_2;
                this.levelBitsList = levelBitsList;
                this.shift = var2_2;
                int bits = levelBitsList & 0xF;
                assert (bits != 0);
                int length = 1 << bits;
                this.mask = length - 1;
                this.keys = new int[length];
                this.values = new Object[var1_1];
            }

            /*
             * WARNING - void declaration
             */
            final Object get(int key) {
                while (true) {
                    void var2_2;
                    Level level;
                    void var3_4;
                    int index;
                    int k;
                    if ((k = this_.keys[index = key >> this_.shift & this_.mask]) == key) {
                        return this_.values[index];
                    }
                    if (var3_4 != false || (level = (Level)this_.values[index]) == null) break;
                    Level this_ = var2_2;
                }
                return null;
            }

            final Object putIfAbsent(int key, Object item, int size) {
                int index;
                int k;
                while ((k = this_.keys[index = key >> this_.shift & this_.mask]) != key) {
                    Level this_;
                    Level level;
                    if (k == 0) {
                        level = (Level)this_.values[index];
                        if (level != null) {
                            this_ = level;
                            continue;
                        }
                        this_.keys[index] = key;
                        this_.values[index] = ResourceCache.storeDirectly(size) ? item : new SoftReference<Object>(item);
                        return item;
                    }
                    level = new Level(this_.levelBitsList >> 4, this_.shift + (this_.levelBitsList & 0xF));
                    int i = k >> level.shift & level.mask;
                    level.keys[i] = k;
                    level.values[i] = this_.values[index];
                    this_.keys[index] = 0;
                    this_.values[index] = level;
                    this_ = level;
                }
                return ResourceCache.access$2000(this_.values, index, item, size);
            }
        }
    }

    static final class Table32
    extends Table {
        /*
         * WARNING - void declaration
         */
        @Override
        final int getContainerResource(ICUResourceBundleReader reader, int index) {
            void var2_2;
            void var1_1;
            return this.getContainer32Resource((ICUResourceBundleReader)var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        Table32(ICUResourceBundleReader reader, int offset) {
            void var2_2;
            void var1_1;
            offset = ICUResourceBundleReader.access$1000(reader, offset);
            this.key32Offsets = ICUResourceBundleReader.access$1900((ICUResourceBundleReader)var1_1, offset);
            this.size = this.key32Offsets.length;
            this.itemsOffset = var2_2 + 4 * (1 + this.size);
        }
    }

    static final class Table16
    extends Table {
        /*
         * WARNING - void declaration
         */
        @Override
        final int getContainerResource(ICUResourceBundleReader reader, int index) {
            void var2_2;
            void var1_1;
            return this.getContainer16Resource((ICUResourceBundleReader)var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        Table16(ICUResourceBundleReader reader, int offset) {
            void var2_2;
            void var1_1;
            this.keyOffsets = ICUResourceBundleReader.access$1800((ICUResourceBundleReader)var1_1, offset);
            this.size = this.keyOffsets.length;
            this.itemsOffset = var2_2 + true + this.size;
        }
    }

    static final class Table1632
    extends Table {
        /*
         * WARNING - void declaration
         */
        @Override
        final int getContainerResource(ICUResourceBundleReader reader, int index) {
            void var2_2;
            void var1_1;
            return this.getContainer32Resource((ICUResourceBundleReader)var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        Table1632(ICUResourceBundleReader reader, int offset) {
            void var2_2;
            void var1_1;
            offset = ICUResourceBundleReader.access$1000(reader, offset);
            this.keyOffsets = ICUResourceBundleReader.access$1700((ICUResourceBundleReader)var1_1, offset);
            this.size = this.keyOffsets.length;
            this.itemsOffset = var2_2 + 2 * (this.size + 2 & 0xFFFFFFFE);
        }
    }

    static class Table
    extends Container
    implements UResource.Table {
        protected char[] keyOffsets;
        protected int[] key32Offsets;

        Table() {
        }

        /*
         * WARNING - void declaration
         */
        final String getKey(ICUResourceBundleReader reader, int index) {
            void var2_2;
            void var1_1;
            if (index < 0 || this.size <= index) {
                return null;
            }
            if (this.keyOffsets != null) {
                return ICUResourceBundleReader.access$1100(reader, this.keyOffsets[index]);
            }
            return ICUResourceBundleReader.access$1200((ICUResourceBundleReader)var1_1, this.key32Offsets[var2_2]);
        }

        /*
         * WARNING - void declaration
         */
        final int findTableItem(ICUResourceBundleReader reader, CharSequence key) {
            int start = 0;
            int limit = this.size;
            while (start < limit) {
                void var3_5;
                int mid = start + limit >>> 1;
                int result = this.keyOffsets != null ? ICUResourceBundleReader.access$1300(reader, key, this.keyOffsets[mid]) : ICUResourceBundleReader.access$1400(reader, key, this.key32Offsets[mid]);
                if (result < 0) {
                    limit = mid;
                    continue;
                }
                if (result > 0) {
                    start = mid + 1;
                    continue;
                }
                return (int)var3_5;
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final int getResource(ICUResourceBundleReader reader, String resKey) {
            void var2_2;
            void var1_1;
            return this.getContainerResource(reader, this.findTableItem((ICUResourceBundleReader)var1_1, (CharSequence)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean getKeyAndValue(int i, UResource.Key key, UResource.Value value) {
            if (i >= 0 && i < this.size) {
                void var1_1;
                void var3_3;
                ReaderValue readerValue = (ReaderValue)value;
                if (this.keyOffsets != null) {
                    ICUResourceBundleReader.access$1500(readerValue.reader, this.keyOffsets[i], key);
                } else {
                    void var2_2;
                    ICUResourceBundleReader.access$1600(readerValue.reader, this.key32Offsets[i], (UResource.Key)var2_2);
                }
                readerValue.res = this.getContainerResource(var3_3.reader, (int)var1_1);
                return true;
            }
            return false;
        }
    }

    static final class Array16
    extends Array {
        /*
         * WARNING - void declaration
         */
        @Override
        final int getContainerResource(ICUResourceBundleReader reader, int index) {
            void var2_2;
            void var1_1;
            return this.getContainer16Resource((ICUResourceBundleReader)var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        Array16(ICUResourceBundleReader reader, int offset) {
            void var2_2;
            void var1_1;
            this.size = ((ICUResourceBundleReader)var1_1).b16BitUnits.charAt(offset);
            this.itemsOffset = var2_2 + true;
        }
    }

    static final class Array32
    extends Array {
        /*
         * WARNING - void declaration
         */
        @Override
        final int getContainerResource(ICUResourceBundleReader reader, int index) {
            void var2_2;
            void var1_1;
            return this.getContainer32Resource((ICUResourceBundleReader)var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        Array32(ICUResourceBundleReader reader, int offset) {
            void var2_2;
            void var1_1;
            offset = ICUResourceBundleReader.access$1000(reader, offset);
            this.size = ICUResourceBundleReader.access$900((ICUResourceBundleReader)var1_1, offset);
            this.itemsOffset = var2_2 + 4;
        }
    }

    static class Array
    extends Container
    implements UResource.Array {
        Array() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean getValue(int i, UResource.Value value) {
            if (i >= 0 && i < this.size) {
                void var1_1;
                void var2_2;
                ReaderValue readerValue = (ReaderValue)value;
                ((ReaderValue)value).res = this.getContainerResource(var2_2.reader, (int)var1_1);
                return true;
            }
            return false;
        }
    }

    static class Container {
        protected int size;
        protected int itemsOffset;

        public final int getSize() {
            return this.size;
        }

        int getContainerResource(ICUResourceBundleReader reader, int index) {
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        protected final int getContainer16Resource(ICUResourceBundleReader reader, int index) {
            void var2_2;
            if (index < 0 || this.size <= index) {
                return -1;
            }
            int res16 = reader.b16BitUnits.charAt(this.itemsOffset + index);
            if (res16 >= reader.poolStringIndex16Limit) {
                void var1_1;
                res16 = res16 - reader.poolStringIndex16Limit + ((ICUResourceBundleReader)var1_1).poolStringIndexLimit;
            }
            return 0x60000000 | var2_2;
        }

        /*
         * WARNING - void declaration
         */
        protected final int getContainer32Resource(ICUResourceBundleReader reader, int index) {
            void var2_2;
            void var1_1;
            if (index < 0 || this.size <= index) {
                return -1;
            }
            return ICUResourceBundleReader.access$900((ICUResourceBundleReader)var1_1, this.itemsOffset + 4 * var2_2);
        }

        /*
         * WARNING - void declaration
         */
        int getResource(ICUResourceBundleReader reader, String resKey) {
            void var2_2;
            void var1_1;
            return this.getContainerResource((ICUResourceBundleReader)var1_1, Integer.parseInt((String)var2_2));
        }

        Container() {
        }
    }

    static final class ReaderValue
    extends UResource.Value {
        ICUResourceBundleReader reader;
        int res;

        ReaderValue() {
        }

        @Override
        public final int getType() {
            return PUBLIC_TYPES[ICUResourceBundleReader.RES_GET_TYPE(this.res)];
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String getString() {
            void var1_1;
            String s = this.reader.getString(this.res);
            if (s == null) {
                throw new UResourceTypeMismatchException("");
            }
            return var1_1;
        }

        @Override
        public final int getInt() {
            if (ICUResourceBundleReader.RES_GET_TYPE(this.res) != 7) {
                throw new UResourceTypeMismatchException("");
            }
            return ICUResourceBundleReader.RES_GET_INT(this.res);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int[] getIntVector() {
            void var1_1;
            int[] iv = this.reader.getIntVector(this.res);
            if (iv == null) {
                throw new UResourceTypeMismatchException("");
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final UResource.Array getArray() {
            void var1_1;
            Array array = this.reader.getArray(this.res);
            if (array == null) {
                throw new UResourceTypeMismatchException("");
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final UResource.Table getTable() {
            void var1_1;
            Table table = this.reader.getTable(this.res);
            if (table == null) {
                throw new UResourceTypeMismatchException("");
            }
            return var1_1;
        }
    }

    static final class ReaderCache
    extends SoftCache<ReaderCacheKey, ICUResourceBundleReader, ClassLoader> {
        private ReaderCache() {
        }

        /*
         * WARNING - void declaration
         */
        private static ICUResourceBundleReader createInstance(ReaderCacheKey key, ClassLoader loader) {
            String fullName = ICUResourceBundleReader.getFullName(key.baseName, key.localeID);
            try {
                void var1_1;
                ReaderCacheKey readerCacheKey;
                ByteBuffer inBytes;
                if (key.baseName != null && key.baseName.startsWith("com/ibm/icu/impl/data/icudt73b")) {
                    String itemPath = fullName.substring(30 + 1);
                    inBytes = ICUBinary.getData(loader, fullName, itemPath);
                    if (inBytes == null) {
                        return NULL_READER;
                    }
                } else {
                    InputStream stream = ICUData.getStream(loader, fullName);
                    if (stream == null) {
                        return NULL_READER;
                    }
                    inBytes = ICUBinary.getByteBufferFromInputStreamAndCloseStream(stream);
                }
                return new ICUResourceBundleReader(inBytes, key.baseName, readerCacheKey.localeID, (ClassLoader)var1_1);
            }
            catch (IOException ex) {
                void var3_4;
                void var2_2;
                throw new ICUUncheckedIOException("Data file " + (String)var2_2 + " is corrupt - " + ex.getMessage(), (Throwable)var3_4);
            }
        }

        /* synthetic */ ReaderCache(byte by) {
            this();
        }
    }

    static final class ReaderCacheKey {
        final String baseName;
        final String localeID;

        /*
         * WARNING - void declaration
         */
        ReaderCacheKey(String baseName, String localeID) {
            void var2_2;
            void var1_1;
            this.baseName = baseName == null ? "" : var1_1;
            this.localeID = localeID == null ? "" : var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object obj) {
            void var1_1;
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ReaderCacheKey)) {
                return false;
            }
            ReaderCacheKey info = (ReaderCacheKey)obj;
            return this.baseName.equals(info.baseName) && this.localeID.equals(var1_1.localeID);
        }

        public final int hashCode() {
            return this.baseName.hashCode() ^ this.localeID.hashCode();
        }
    }

    static final class IsAcceptable
    implements ICUBinary.Authenticate {
        private IsAcceptable() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean isDataVersionAcceptable(byte[] formatVersion) {
            void var1_1;
            return formatVersion[0] == 1 && (formatVersion[1] & 0xFF) > 0 || 2 <= formatVersion[0] && var1_1[0] <= 3;
        }

        /* synthetic */ IsAcceptable(byte by) {
            this();
        }
    }
}

