/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ICUDebug;
import com.ibm.icu.impl.ICUNotifier;
import com.ibm.icu.impl.ICURWLock;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ICUService
extends ICUNotifier {
    private String name;
    private static final boolean DEBUG = ICUDebug.enabled("service");
    private final ICURWLock factoryLock = new ICURWLock();
    private final List<Factory> factories = new ArrayList<Factory>();
    private int defaultSize = 0;
    private Map<String, CacheEntry> cache;

    /*
     * WARNING - void declaration
     */
    public ICUService(String name) {
        void var1_1;
        this.name = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final Object getKey(Key key, String[] actualReturn, Factory factory) {
        if (this.factories.size() == 0) {
            return null;
        }
        if (DEBUG) {
            System.out.println("Service: " + this.name + " key: " + key.canonicalID());
        }
        if (key != null) {
            try {
                CacheEntry result;
                this.factoryLock.acquireRead();
                Map<String, CacheEntry> cache = this.cache;
                if (cache == null) {
                    if (DEBUG) {
                        System.out.println("Service " + this.name + " cache was empty");
                    }
                    cache = new ConcurrentHashMap<String, CacheEntry>();
                }
                ArrayList<String> cacheDescriptorList = null;
                boolean putInCache = false;
                int NDebug = 0;
                int startIndex = 0;
                int limit = this.factories.size();
                boolean cacheResult = true;
                if (factory != null) {
                    for (int i = 0; i < limit; ++i) {
                        if (factory != this.factories.get(i)) continue;
                        startIndex = i + 1;
                        break;
                    }
                    if (startIndex == 0) {
                        throw new IllegalStateException("Factory " + factory + "not registered with service: " + this);
                    }
                    cacheResult = false;
                }
                block4: do {
                    String currentDescriptor = key.currentDescriptor();
                    if (DEBUG) {
                        System.out.println(this.name + "[" + NDebug++ + "] looking for: " + currentDescriptor);
                    }
                    if ((result = cache.get(currentDescriptor)) != null) {
                        if (!DEBUG) break;
                        System.out.println(this.name + " found with descriptor: " + currentDescriptor);
                        break;
                    }
                    if (DEBUG) {
                        System.out.println("did not find: " + currentDescriptor + " in cache");
                    }
                    putInCache = cacheResult;
                    int index = startIndex;
                    while (index < limit) {
                        Object service;
                        Factory f = this.factories.get(index++);
                        if (DEBUG) {
                            System.out.println("trying factory[" + (index - 1) + "] " + f.toString());
                        }
                        if ((service = f.create(key, this)) != null) {
                            result = new CacheEntry(currentDescriptor, service);
                            if (!DEBUG) break block4;
                            System.out.println(this.name + " factory supported: " + currentDescriptor + ", caching");
                            break block4;
                        }
                        if (!DEBUG) continue;
                        System.out.println("factory did not support: " + currentDescriptor);
                    }
                    if (cacheDescriptorList == null) {
                        cacheDescriptorList = new ArrayList<String>(5);
                    }
                    cacheDescriptorList.add(currentDescriptor);
                } while (key.fallback());
                if (result != null) {
                    void var3_4;
                    if (putInCache) {
                        if (DEBUG) {
                            System.out.println("caching '" + result.actualDescriptor + "'");
                        }
                        cache.put(result.actualDescriptor, result);
                        if (cacheDescriptorList != null) {
                            for (String desc : cacheDescriptorList) {
                                if (DEBUG) {
                                    System.out.println(this.name + " adding descriptor: '" + desc + "' for actual: '" + result.actualDescriptor + "'");
                                }
                                cache.put(desc, result);
                            }
                        }
                        this.cache = cache;
                    }
                    if (actualReturn != null) {
                        if (result.actualDescriptor.indexOf("/") == 0) {
                            actualReturn[0] = result.actualDescriptor.substring(1);
                        } else {
                            var2_3[0] = result.actualDescriptor;
                        }
                    }
                    if (DEBUG) {
                        System.out.println("found in service: " + this.name);
                    }
                    Object object = var3_4.service;
                    return object;
                }
            }
            finally {
                this.factoryLock.releaseRead();
            }
        }
        if (DEBUG) {
            System.out.println("not found in service: " + this.name);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final Factory registerFactory(Factory factory) {
        void var1_1;
        try {
            this.factoryLock.acquireWrite();
            this.factories.add(0, factory);
            ICUService iCUService = this;
            this.cache = null;
        }
        finally {
            this.factoryLock.releaseWrite();
        }
        this.notifyChanged();
        return var1_1;
    }

    public final boolean isDefault() {
        return this.factories.size() == this.defaultSize;
    }

    protected final void markDefault() {
        this.defaultSize = this.factories.size();
    }

    protected final void clearServiceCache() {
        this.cache = null;
    }

    public String toString() {
        return super.toString() + "{" + this.name + "}";
    }

    static final class CacheEntry {
        final String actualDescriptor;
        final Object service;

        /*
         * WARNING - void declaration
         */
        CacheEntry(String actualDescriptor, Object service) {
            void var2_2;
            void var1_1;
            this.actualDescriptor = var1_1;
            this.service = var2_2;
        }
    }

    public static interface Factory {
        public Object create(Key var1, ICUService var2);
    }

    public static class Key {
        private final String id;

        /*
         * WARNING - void declaration
         */
        public Key(String id) {
            void var1_1;
            this.id = var1_1;
        }

        public String canonicalID() {
            return this.id;
        }

        public String currentID() {
            return this.canonicalID();
        }

        public String currentDescriptor() {
            return "/" + this.currentID();
        }

        public boolean fallback() {
            return false;
        }
    }
}

