/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.LocaleIDs;
import com.ibm.icu.impl.locale.AsciiUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public final class LocaleIDParser {
    private char[] id;
    private int index;
    private StringBuilder buffer;
    private boolean canonicalize;
    private boolean hadCountry;
    private Map<String, String> keywords;
    private String baseName;

    /*
     * WARNING - void declaration
     */
    public LocaleIDParser(String localeID) {
        this((String)var1_1, false);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LocaleIDParser(String localeID, boolean canonicalize) {
        void var2_2;
        void var1_1;
        this.id = var1_1.toCharArray();
        this.index = 0;
        this.buffer = new StringBuilder(this.id.length + 5);
        this.canonicalize = var2_2;
    }

    private void reset() {
        this.index = 0;
        this.buffer = new StringBuilder(this.id.length + 5);
    }

    /*
     * WARNING - void declaration
     */
    private void append(char c) {
        void var1_1;
        this.buffer.append((char)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private String getString(int start) {
        void var1_1;
        return this.buffer.substring((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void set(int pos, String s) {
        void var2_2;
        void var1_1;
        StringBuilder stringBuilder = this.buffer;
        stringBuilder.delete(pos, stringBuilder.length());
        this.buffer.insert((int)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void append(String s) {
        void var1_1;
        this.buffer.append((String)var1_1);
    }

    private char next() {
        if (this.index == this.id.length) {
            ++this.index;
            return '\uffff';
        }
        return this.id[this.index++];
    }

    private void skipUntilTerminatorOrIDSeparator() {
        LocaleIDParser localeIDParser;
        do {
            localeIDParser = this;
        } while (!localeIDParser.isTerminatorOrIDSeparator(localeIDParser.next()));
        --this.index;
    }

    private boolean atTerminator() {
        return this.index >= this.id.length || LocaleIDParser.isTerminator(this.id[this.index]);
    }

    private static boolean isTerminator(char c) {
        char c2;
        return c == '@' || c == '\uffff' || c2 == '.';
    }

    /*
     * WARNING - void declaration
     */
    private boolean isTerminatorOrIDSeparator(char c) {
        void var1_1;
        return c == '_' || c == '-' || LocaleIDParser.isTerminator((char)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private boolean haveExperimentalLanguagePrefix() {
        char c;
        if (this.id.length > 2 && ((c = this.id[1]) == '-' || c == '_')) {
            void var1_1;
            c = this.id[0];
            return c == 'x' || c == 'X' || c == 'i' || var1_1 == 73;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private int parseLanguage() {
        String lang;
        int startLength = this.buffer.length();
        if (this.haveExperimentalLanguagePrefix()) {
            LocaleIDParser localeIDParser = this;
            localeIDParser.append(AsciiUtil.toLower(localeIDParser.id[0]));
            this.append('-');
            this.index = 2;
        }
        while (true) {
            void var2_3;
            LocaleIDParser localeIDParser = this;
            char c = localeIDParser.next();
            if (localeIDParser.isTerminatorOrIDSeparator(c)) break;
            this.append(AsciiUtil.toLower((char)var2_3));
        }
        --this.index;
        if (this.buffer.length() - startLength == 3 && (lang = LocaleIDs.threeToTwoLetterLanguage(this.getString(0))) != null) {
            void var1_2;
            this.set(0, (String)var1_2);
        }
        return 0;
    }

    private void skipLanguage() {
        if (this.haveExperimentalLanguagePrefix()) {
            this.index = 2;
        }
        this.skipUntilTerminatorOrIDSeparator();
    }

    /*
     * WARNING - void declaration
     */
    private int parseScript() {
        if (!this.atTerminator()) {
            void var2_2;
            int oldIndex = this.index++;
            int oldBlen = this.buffer.length();
            boolean firstPass22 = true;
            while (true) {
                void var3_5;
                LocaleIDParser localeIDParser = this;
                char c = localeIDParser.next();
                if (localeIDParser.isTerminatorOrIDSeparator(c) || !AsciiUtil.isAlpha(c)) break;
                if (firstPass22) {
                    LocaleIDParser firstPass22 = this;
                    firstPass22.append('_');
                    this.append(AsciiUtil.toUpper(c));
                    firstPass22 = false;
                    continue;
                }
                this.append(AsciiUtil.toLower((char)var3_5));
            }
            --this.index;
            if (this.index - oldIndex != 5) {
                void var1_1;
                this.index = var1_1;
                StringBuilder stringBuilder = this.buffer;
                stringBuilder.delete(oldBlen, stringBuilder.length());
            } else {
                ++oldBlen;
            }
            return (int)var2_2;
        }
        return this.buffer.length();
    }

    /*
     * WARNING - void declaration
     */
    private void skipScript() {
        if (!this.atTerminator()) {
            void var2_2;
            char c;
            LocaleIDParser localeIDParser;
            int oldIndex = this.index++;
            do {
                localeIDParser = this;
            } while (!localeIDParser.isTerminatorOrIDSeparator(c = localeIDParser.next()) && AsciiUtil.isAlpha((char)var2_2));
            --this.index;
            if (this.index - oldIndex != 5) {
                void var1_1;
                this.index = var1_1;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private int parseCountry() {
        if (!this.atTerminator()) {
            void var2_3;
            int oldIndex = this.index++;
            int oldBlen = this.buffer.length();
            boolean firstPass22 = true;
            while (true) {
                LocaleIDParser localeIDParser = this;
                char c = localeIDParser.next();
                if (localeIDParser.isTerminatorOrIDSeparator(c)) break;
                if (firstPass22) {
                    this.hadCountry = true;
                    LocaleIDParser firstPass22 = this;
                    firstPass22.append('_');
                    ++oldBlen;
                    firstPass22 = false;
                }
                this.append(AsciiUtil.toUpper(c));
            }
            --this.index;
            int charsAppended = this.buffer.length() - oldBlen;
            if (charsAppended != 0) {
                String region;
                void var3_6;
                if (charsAppended < 2 || charsAppended > 3) {
                    this.index = oldIndex;
                    StringBuilder stringBuilder = this.buffer;
                    stringBuilder.delete(--oldBlen, stringBuilder.length());
                    this.hadCountry = false;
                } else if (var3_6 == 3 && (region = LocaleIDs.threeToTwoLetterRegion(this.getString(oldBlen))) != null) {
                    void var1_2;
                    this.set(oldBlen, (String)var1_2);
                }
            }
            return (int)var2_3;
        }
        return this.buffer.length();
    }

    /*
     * WARNING - void declaration
     */
    private int parseVariant() {
        void var1_1;
        char c;
        int oldBlen = this.buffer.length();
        boolean start2 = true;
        int needSeparator = 1;
        boolean skipping = false;
        boolean firstPass = true;
        while ((c = this.next()) != '\uffff') {
            if (c == '.') {
                start2 = false;
                skipping = true;
                continue;
            }
            if (c == '@') {
                boolean bl;
                block9: {
                    LocaleIDParser start2 = this;
                    for (needSeparator = start2.index; needSeparator < start2.id.length; ++needSeparator) {
                        if (start2.id[needSeparator] != '=') continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
                if (bl) break;
                skipping = false;
                start2 = false;
                needSeparator = 1;
                continue;
            }
            if (start2) {
                start2 = false;
                if (c == '_' || c == '-') continue;
                --this.index;
                continue;
            }
            if (skipping) continue;
            if (needSeparator != 0) {
                LocaleIDParser localeIDParser;
                needSeparator = 0;
                if (firstPass && !this.hadCountry) {
                    localeIDParser = this;
                    localeIDParser.append('_');
                    ++oldBlen;
                }
                localeIDParser = this;
                localeIDParser.append('_');
                if (firstPass) {
                    ++oldBlen;
                    firstPass = false;
                }
            }
            if ((c = AsciiUtil.toUpper(c)) == '-' || c == ',') {
                c = '_';
            }
            this.append(c);
        }
        --this.index;
        return (int)var1_1;
    }

    public final String getLanguage() {
        this.reset();
        LocaleIDParser localeIDParser = this;
        return localeIDParser.getString(localeIDParser.parseLanguage());
    }

    public final String getScript() {
        this.reset();
        this.skipLanguage();
        LocaleIDParser localeIDParser = this;
        return localeIDParser.getString(localeIDParser.parseScript());
    }

    public final String getCountry() {
        this.reset();
        this.skipLanguage();
        this.skipScript();
        LocaleIDParser localeIDParser = this;
        return localeIDParser.getString(localeIDParser.parseCountry());
    }

    public final String getVariant() {
        this.reset();
        this.skipLanguage();
        this.skipScript();
        LocaleIDParser localeIDParser = this;
        if (!localeIDParser.atTerminator()) {
            if (localeIDParser.id[localeIDParser.index] == '_' || localeIDParser.id[localeIDParser.index] == '-') {
                ++localeIDParser.index;
            }
            int n = localeIDParser.index;
            localeIDParser.skipUntilTerminatorOrIDSeparator();
            int n2 = localeIDParser.index - n;
            if (n2 < 2 || n2 > 3) {
                localeIDParser.index = n;
            }
        }
        LocaleIDParser localeIDParser2 = this;
        return localeIDParser2.getString(localeIDParser2.parseVariant());
    }

    /*
     * WARNING - void declaration
     */
    public final void setBaseName(String baseName) {
        void var1_1;
        this.baseName = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void parseBaseName() {
        if (this.baseName != null) {
            this.set(0, this.baseName);
            return;
        }
        this.reset();
        this.parseLanguage();
        this.parseScript();
        this.parseCountry();
        this.parseVariant();
        int len = this.buffer.length();
        if (len > 0 && this.buffer.charAt(len - 1) == '_') {
            void var1_1;
            this.buffer.deleteCharAt((int)(var1_1 - true));
        }
    }

    public final String getBaseName() {
        if (this.baseName != null) {
            return this.baseName;
        }
        this.parseBaseName();
        return this.getString(0);
    }

    public final String getName() {
        this.parseBaseName();
        LocaleIDParser localeIDParser = this;
        int n = localeIDParser.buffer.length();
        Map<String, String> map = localeIDParser.getKeywordMap();
        if (!map.isEmpty()) {
            boolean bl = true;
            for (Map.Entry entry : map.entrySet()) {
                localeIDParser.append(bl ? (char)'@' : ';');
                bl = false;
                localeIDParser.append((String)entry.getKey());
                localeIDParser.append('=');
                localeIDParser.append((String)entry.getValue());
            }
            if (!bl) {
                ++n;
            }
        }
        return this.getString(0);
    }

    private boolean setToKeywordStart() {
        for (int i = this.index; i < this.id.length; ++i) {
            if (this.id[i] != '@') continue;
            if (this.canonicalize) {
                for (int j = ++i; j < this.id.length; ++j) {
                    if (this.id[j] != '=') continue;
                    this.index = i;
                    return true;
                }
                break;
            }
            if (++i >= this.id.length) break;
            this.index = i;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private String getKeyword() {
        void var1_1;
        char c;
        int start = this.index;
        while (!((c = this.next()) == '\uffff' || c == '=')) {
        }
        --this.index;
        return AsciiUtil.toLowerString(new String(this.id, start, this.index - var1_1).trim());
    }

    /*
     * WARNING - void declaration
     */
    private String getValue() {
        void var1_1;
        char c;
        int start = this.index;
        while (!((c = this.next()) == '\uffff' || c == ';')) {
        }
        --this.index;
        return new String(this.id, start, this.index - var1_1).trim();
    }

    private Comparator<String> getKeyComparator() {
        Comparator<String> comparator = new Comparator<String>(this){};
        return comparator;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, String> getKeywordMap() {
        block6: {
            void var1_1;
            TreeMap<String, void> m;
            block7: {
                String key;
                if (this.keywords != null) break block6;
                m = null;
                if (!this.setToKeywordStart()) break block7;
                while ((key = this.getKeyword()).length() != 0) {
                    block9: {
                        void var3_4;
                        void var2_2;
                        block11: {
                            block10: {
                                block8: {
                                    char c = this.next();
                                    if (c == '=') break block8;
                                    if (c == '\uffff') {
                                        break;
                                    }
                                    break block9;
                                }
                                String value = this.getValue();
                                if (value.length() == 0) break block9;
                                if (m != null) break block10;
                                m = new TreeMap<String, void>(this.getKeyComparator());
                                break block11;
                            }
                            if (m.containsKey(key)) break block9;
                        }
                        m.put((String)var2_2, var3_4);
                    }
                    if (this.next() == ';') continue;
                }
            }
            this.keywords = m != null ? var1_1 : Collections.emptyMap();
        }
        return this.keywords;
    }

    /*
     * WARNING - void declaration
     */
    public final Iterator<String> getKeywords() {
        void var1_1;
        Map<String, String> m = this.getKeywordMap();
        if (m.isEmpty()) {
            return null;
        }
        return var1_1.keySet().iterator();
    }

    /*
     * WARNING - void declaration
     */
    public final String getKeywordValue(String keywordName) {
        void var1_1;
        void var2_2;
        Map<String, String> m = this.getKeywordMap();
        if (m.isEmpty()) {
            return null;
        }
        return (String)var2_2.get(AsciiUtil.toLowerString(var1_1.trim()));
    }

    /*
     * WARNING - void declaration
     */
    public final void setKeywordValue(String keywordName, String value) {
        void var1_1;
        String string;
        boolean bl = true;
        String string2 = string;
        string = var1_1;
        LocaleIDParser localeIDParser = this;
        if (string == null) {
            localeIDParser.keywords = Collections.emptyMap();
            return;
        }
        if ((string = AsciiUtil.toLowerString(string.trim())).length() == 0) {
            throw new IllegalArgumentException("keyword must not be empty");
        }
        if (string2 != null && (string2 = string2.trim()).length() == 0) {
            throw new IllegalArgumentException("value must not be empty");
        }
        Map<String, String> map = localeIDParser.getKeywordMap();
        if (map.isEmpty()) {
            if (string2 != null) {
                localeIDParser.keywords = new TreeMap<String, String>(localeIDParser.getKeyComparator());
                localeIDParser.keywords.put(string, string2.trim());
                return;
            }
        } else {
            if (string2 != null) {
                map.put(string, string2);
                return;
            }
            map.remove(string);
            if (map.isEmpty()) {
                localeIDParser.keywords = Collections.emptyMap();
            }
        }
    }
}

