/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.Normalizer2Impl;
import com.ibm.icu.impl.SoftCache;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.Normalizer2;
import java.nio.ByteBuffer;

public final class Norm2AllModes {
    public final Normalizer2Impl impl;
    public final ComposeNormalizer2 comp;
    public final DecomposeNormalizer2 decomp;
    private FCDNormalizer2 fcd;
    public static final NoopNormalizer2 NOOP_NORMALIZER2;

    /*
     * WARNING - void declaration
     */
    private Norm2AllModes(Normalizer2Impl ni) {
        void var1_1;
        this.impl = ni;
        this.comp = new ComposeNormalizer2(ni, false);
        this.decomp = new DecomposeNormalizer2(ni);
        this.fcd = new FCDNormalizer2(ni);
        new ComposeNormalizer2((Normalizer2Impl)var1_1, true);
    }

    private static Norm2AllModes getInstanceFromSingleton(Norm2AllModesSingleton singleton) {
        Norm2AllModesSingleton norm2AllModesSingleton;
        if (singleton.exception != null) {
            throw singleton.exception;
        }
        return norm2AllModesSingleton.allModes;
    }

    public static Norm2AllModes getNFCInstance() {
        return Norm2AllModes.getInstanceFromSingleton(NFCSingleton.INSTANCE);
    }

    public static Norm2AllModes getNFKCInstance() {
        return Norm2AllModes.getInstanceFromSingleton(NFKCSingleton.INSTANCE);
    }

    public static Norm2AllModes getNFKC_CFInstance() {
        return Norm2AllModes.getInstanceFromSingleton(NFKC_CFSingleton.INSTANCE);
    }

    public static Normalizer2WithImpl getN2WithImpl(int index) {
        switch (index) {
            case 0: {
                return Norm2AllModes.getInstanceFromSingleton((Norm2AllModesSingleton)NFCSingleton.INSTANCE).decomp;
            }
            case 1: {
                return Norm2AllModes.getInstanceFromSingleton((Norm2AllModesSingleton)NFKCSingleton.INSTANCE).decomp;
            }
            case 2: {
                return Norm2AllModes.getInstanceFromSingleton((Norm2AllModesSingleton)NFCSingleton.INSTANCE).comp;
            }
            case 3: {
                return Norm2AllModes.getInstanceFromSingleton((Norm2AllModesSingleton)NFKCSingleton.INSTANCE).comp;
            }
        }
        return null;
    }

    public static Normalizer2 getFCDNormalizer2() {
        return Norm2AllModes.getInstanceFromSingleton((Norm2AllModesSingleton)NFCSingleton.INSTANCE).fcd;
    }

    /*
     * WARNING - void declaration
     */
    /* synthetic */ Norm2AllModes(Normalizer2Impl x0, byte by) {
        this((Normalizer2Impl)var1_1);
        void var1_1;
    }

    static {
        new SoftCache<String, Norm2AllModes, ByteBuffer>(){};
        NOOP_NORMALIZER2 = new NoopNormalizer2();
    }

    static final class NFKC_CFSingleton {
        private static final Norm2AllModesSingleton INSTANCE = new Norm2AllModesSingleton("nfkc_cf", 0);
    }

    static final class NFKCSingleton {
        private static final Norm2AllModesSingleton INSTANCE = new Norm2AllModesSingleton("nfkc", 0);
    }

    static final class NFCSingleton {
        private static final Norm2AllModesSingleton INSTANCE = new Norm2AllModesSingleton("nfc", 0);
    }

    static final class Norm2AllModesSingleton {
        private Norm2AllModes allModes;
        private RuntimeException exception;

        /*
         * WARNING - void declaration
         */
        private Norm2AllModesSingleton(String name) {
            try {
                Normalizer2Impl impl = new Normalizer2Impl().load(name + ".nrm");
                this.allModes = new Norm2AllModes(impl, 0);
                return;
            }
            catch (RuntimeException e) {
                void var1_2;
                this.exception = var1_2;
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ Norm2AllModesSingleton(String x0, byte by) {
            this((String)var1_1);
            void var1_1;
        }
    }

    public static final class FCDNormalizer2
    extends Normalizer2WithImpl {
        /*
         * WARNING - void declaration
         */
        public FCDNormalizer2(Normalizer2Impl ni) {
            super((Normalizer2Impl)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void normalize(CharSequence src, Normalizer2Impl.ReorderingBuffer buffer) {
            void var2_2;
            void var1_1;
            this.impl.makeFCD(src, 0, var1_1.length(), (Normalizer2Impl.ReorderingBuffer)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void normalizeAndAppend(CharSequence src, boolean doNormalize, Normalizer2Impl.ReorderingBuffer buffer) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.impl.makeFCDAndAppend((CharSequence)var1_1, (boolean)var2_2, (Normalizer2Impl.ReorderingBuffer)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int spanQuickCheckYes(CharSequence s) {
            void var1_1;
            return this.impl.makeFCD(s, 0, var1_1.length(), null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int getQuickCheck(int c) {
            void var1_1;
            if (this.impl.isDecompYes(this.impl.getNorm16((int)var1_1))) {
                return 1;
            }
            return 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean hasBoundaryBefore(int c) {
            void var1_1;
            void var2_3 = var1_1;
            Normalizer2Impl normalizer2Impl = this.impl;
            return normalizer2Impl.hasDecompBoundaryBefore((int)var2_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean isInert(int c) {
            void var1_1;
            Normalizer2Impl normalizer2Impl = this.impl;
            void var2_3 = var1_1;
            return normalizer2Impl.getFCD16((int)var2_3) <= 1;
        }
    }

    public static final class ComposeNormalizer2
    extends Normalizer2WithImpl {
        private final boolean onlyContiguous;

        /*
         * WARNING - void declaration
         */
        public ComposeNormalizer2(Normalizer2Impl ni, boolean fcc) {
            super((Normalizer2Impl)var1_1);
            void var2_2;
            void var1_1;
            this.onlyContiguous = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void normalize(CharSequence src, Normalizer2Impl.ReorderingBuffer buffer) {
            void var2_2;
            void var1_1;
            this.impl.compose(src, 0, var1_1.length(), this.onlyContiguous, true, (Normalizer2Impl.ReorderingBuffer)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void normalizeAndAppend(CharSequence src, boolean doNormalize, Normalizer2Impl.ReorderingBuffer buffer) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.impl.composeAndAppend((CharSequence)var1_1, (boolean)var2_2, this.onlyContiguous, (Normalizer2Impl.ReorderingBuffer)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean isNormalized(CharSequence s) {
            void var1_1;
            return this.impl.compose(s, 0, var1_1.length(), this.onlyContiguous, false, new Normalizer2Impl.ReorderingBuffer(this.impl, new StringBuilder(), 5));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Normalizer.QuickCheckResult quickCheck(CharSequence s) {
            void var1_1;
            void var2_2;
            int spanLengthAndMaybe = this.impl.composeQuickCheck(s, 0, s.length(), this.onlyContiguous, false);
            if ((spanLengthAndMaybe & 1) != 0) {
                return Normalizer.MAYBE;
            }
            if (var2_2 >>> 1 == var1_1.length()) {
                return Normalizer.YES;
            }
            return Normalizer.NO;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int spanQuickCheckYes(CharSequence s) {
            void var1_1;
            return this.impl.composeQuickCheck(s, 0, var1_1.length(), this.onlyContiguous, true) >>> 1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int getQuickCheck(int c) {
            void var1_1;
            return this.impl.getCompQuickCheck(this.impl.getNorm16((int)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean hasBoundaryBefore(int c) {
            void var1_1;
            return this.impl.hasCompBoundaryBefore((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean isInert(int c) {
            void var1_1;
            return this.impl.isCompInert((int)var1_1, this.onlyContiguous);
        }
    }

    public static final class DecomposeNormalizer2
    extends Normalizer2WithImpl {
        /*
         * WARNING - void declaration
         */
        public DecomposeNormalizer2(Normalizer2Impl ni) {
            super((Normalizer2Impl)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void normalize(CharSequence src, Normalizer2Impl.ReorderingBuffer buffer) {
            void var2_2;
            void var1_1;
            this.impl.decompose(src, 0, var1_1.length(), (Normalizer2Impl.ReorderingBuffer)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void normalizeAndAppend(CharSequence src, boolean doNormalize, Normalizer2Impl.ReorderingBuffer buffer) {
            Normalizer2Impl normalizer2Impl;
            void var2_2;
            void var3_4;
            void var4_6 = var3_4;
            int n = var2_2;
            void var2_3 = normalizer2Impl;
            normalizer2Impl = this.impl;
            int n2 = var2_3.length();
            if (n2 != 0) {
                int n3;
                if (n != 0) {
                    normalizer2Impl.decompose((CharSequence)var2_3, 0, n2, (Normalizer2Impl.ReorderingBuffer)var4_6);
                    return;
                }
                n = Character.codePointAt((CharSequence)var2_3, 0);
                int n4 = 0;
                Normalizer2Impl normalizer2Impl2 = normalizer2Impl;
                int n5 = n3 = normalizer2Impl2.getCC(normalizer2Impl2.getNorm16(n));
                int n6 = n3;
                while (n3 != 0) {
                    n5 = n3;
                    if ((n4 += Character.charCount(n)) >= n2) break;
                    n = Character.codePointAt((CharSequence)var2_3, n4);
                    Normalizer2Impl normalizer2Impl3 = normalizer2Impl;
                    n3 = normalizer2Impl3.getCC(normalizer2Impl3.getNorm16(n));
                }
                var4_6.append((CharSequence)var2_3, 0, n4, false, n6, n5);
                var4_6.append((CharSequence)var2_3, n4, n2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int spanQuickCheckYes(CharSequence s) {
            void var1_1;
            return this.impl.decompose(s, 0, var1_1.length(), null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int getQuickCheck(int c) {
            void var1_1;
            if (this.impl.isDecompYes(this.impl.getNorm16((int)var1_1))) {
                return 1;
            }
            return 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean hasBoundaryBefore(int c) {
            void var1_1;
            return this.impl.hasDecompBoundaryBefore((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean isInert(int c) {
            void var1_1;
            return this.impl.isDecompInert((int)var1_1);
        }
    }

    public static abstract class Normalizer2WithImpl
    extends Normalizer2 {
        public final Normalizer2Impl impl;

        /*
         * WARNING - void declaration
         */
        public Normalizer2WithImpl(Normalizer2Impl ni) {
            void var1_1;
            this.impl = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final StringBuilder normalize(CharSequence src, StringBuilder dest) {
            void var2_2;
            void var1_1;
            if (dest == src) {
                throw new IllegalArgumentException();
            }
            dest.setLength(0);
            this.normalize(src, new Normalizer2Impl.ReorderingBuffer(this.impl, dest, var1_1.length()));
            return var2_2;
        }

        protected abstract void normalize(CharSequence var1, Normalizer2Impl.ReorderingBuffer var2);

        /*
         * WARNING - void declaration
         */
        @Override
        public final StringBuilder normalizeSecondAndAppend(StringBuilder first, CharSequence second) {
            void var2_2;
            void var1_1;
            return this.normalizeSecondAndAppend((StringBuilder)var1_1, (CharSequence)var2_2, true);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final StringBuilder append(StringBuilder first, CharSequence second) {
            void var2_2;
            void var1_1;
            return this.normalizeSecondAndAppend((StringBuilder)var1_1, (CharSequence)var2_2, false);
        }

        /*
         * WARNING - void declaration
         */
        private StringBuilder normalizeSecondAndAppend(StringBuilder first, CharSequence second, boolean doNormalize) {
            void var1_1;
            void var2_2;
            void var3_3;
            if (first == second) {
                throw new IllegalArgumentException();
            }
            StringBuilder stringBuilder = first;
            this.normalizeAndAppend(second, (boolean)var3_3, new Normalizer2Impl.ReorderingBuffer(this.impl, stringBuilder, stringBuilder.length() + var2_2.length()));
            return var1_1;
        }

        protected abstract void normalizeAndAppend(CharSequence var1, boolean var2, Normalizer2Impl.ReorderingBuffer var3);

        /*
         * WARNING - void declaration
         */
        @Override
        public final int getCombiningClass(int c) {
            void var1_1;
            return this.impl.getCC(this.impl.getNorm16((int)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean isNormalized(CharSequence s) {
            void var1_1;
            return s.length() == this.spanQuickCheckYes((CharSequence)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Normalizer.QuickCheckResult quickCheck(CharSequence s) {
            void var1_1;
            if (this.isNormalized((CharSequence)var1_1)) {
                return Normalizer.YES;
            }
            return Normalizer.NO;
        }

        public abstract int getQuickCheck(int var1);
    }

    public static final class NoopNormalizer2
    extends Normalizer2 {
        /*
         * WARNING - void declaration
         */
        @Override
        public final StringBuilder normalize(CharSequence src, StringBuilder dest) {
            if (dest != src) {
                void var1_1;
                void var2_2;
                dest.setLength(0);
                return var2_2.append((CharSequence)var1_1);
            }
            throw new IllegalArgumentException();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final StringBuilder normalizeSecondAndAppend(StringBuilder first, CharSequence second) {
            if (first != second) {
                void var2_2;
                void var1_1;
                return var1_1.append((CharSequence)var2_2);
            }
            throw new IllegalArgumentException();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final StringBuilder append(StringBuilder first, CharSequence second) {
            if (first != second) {
                void var2_2;
                void var1_1;
                return var1_1.append((CharSequence)var2_2);
            }
            throw new IllegalArgumentException();
        }

        @Override
        public final boolean isNormalized(CharSequence s) {
            return true;
        }

        @Override
        public final Normalizer.QuickCheckResult quickCheck(CharSequence s) {
            return Normalizer.YES;
        }

        @Override
        public final int spanQuickCheckYes(CharSequence s) {
            return s.length();
        }

        @Override
        public final boolean hasBoundaryBefore(int c) {
            return true;
        }

        @Override
        public final boolean isInert(int c) {
            return true;
        }
    }
}

