/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import androidx.compose.animation.core.AnimationSpecKt;
import com.ibm.icu.impl.ICUBinary;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.CodePointMap;
import com.ibm.icu.util.CodePointTrie;
import com.ibm.icu.util.ICUUncheckedIOException;
import com.ibm.icu.util.MutableCodePointTrie;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public final class Normalizer2Impl {
    private static final IsAcceptable IS_ACCEPTABLE = new IsAcceptable(0);
    private static final CodePointMap.ValueFilter segmentStarterMapper = new CodePointMap.ValueFilter(){

        @Override
        public final int apply(int value) {
            return value & Integer.MIN_VALUE;
        }
    };
    private int minDecompNoCP;
    private int minCompNoMaybeCP;
    private int minLcccCP;
    private int minYesNo;
    private int minYesNoMappingsOnly;
    private int minNoNo;
    private int minNoNoCompBoundaryBefore;
    private int minNoNoCompNoMaybeCC;
    private int minNoNoEmpty;
    private int limitNoNo;
    private int centerNoNoDelta;
    private int minMaybeYes;
    private CodePointTrie.Fast16 normTrie;
    private String maybeYesCompositions;
    private String extraData;
    private byte[] smallFCD;
    private CodePointTrie canonIterData;
    private ArrayList<UnicodeSet> canonStartSets;

    /*
     * WARNING - void declaration
     */
    public final Normalizer2Impl load(ByteBuffer bytes) {
        try {
            void var1_1;
            void var3_4;
            ICUBinary.readHeaderAndDataVersion(bytes, 1316121906, IS_ACCEPTABLE);
            int indexesLength = bytes.getInt() / 4;
            if (indexesLength <= 18) {
                throw new ICUUncheckedIOException("Normalizer2 data: not enough indexes");
            }
            int[] nArray = new int[indexesLength];
            int[] inIndexes = nArray;
            nArray[0] = indexesLength << 2;
            for (int i = 1; i < indexesLength; ++i) {
                inIndexes[i] = bytes.getInt();
            }
            this.minDecompNoCP = inIndexes[8];
            this.minCompNoMaybeCP = inIndexes[9];
            this.minLcccCP = inIndexes[18];
            this.minYesNo = inIndexes[10];
            this.minYesNoMappingsOnly = inIndexes[14];
            this.minNoNo = inIndexes[11];
            this.minNoNoCompBoundaryBefore = inIndexes[15];
            this.minNoNoCompNoMaybeCC = inIndexes[16];
            this.minNoNoEmpty = inIndexes[17];
            this.limitNoNo = inIndexes[12];
            this.minMaybeYes = inIndexes[13];
            assert ((this.minMaybeYes & 7) == 0);
            this.centerNoNoDelta = (this.minMaybeYes >> 3) - 64 - 1;
            int offset = inIndexes[0];
            int nextOffset = inIndexes[1];
            int triePosition = bytes.position();
            this.normTrie = CodePointTrie.Fast16.fromBinary(bytes);
            int trieLength = bytes.position() - triePosition;
            if (trieLength > nextOffset - offset) {
                throw new ICUUncheckedIOException("Normalizer2 data: not enough bytes for normTrie");
            }
            ICUBinary.skipBytes(bytes, nextOffset - offset - trieLength);
            offset = nextOffset;
            nextOffset = var3_4[2];
            void numChars = (nextOffset - offset) / 2;
            if (numChars != false) {
                this.maybeYesCompositions = ICUBinary.getString(bytes, (int)numChars, 0);
                this.extraData = this.maybeYesCompositions.substring(64512 - this.minMaybeYes >> 1);
            }
            this.smallFCD = new byte[256];
            var1_1.get(this.smallFCD);
            return this;
        }
        catch (IOException e) {
            void var2_3;
            throw new ICUUncheckedIOException((Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final Normalizer2Impl load(String name) {
        void var1_1;
        return this.load(ICUBinary.getRequiredData((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final void addPropertyStarts(UnicodeSet set) {
        void var1_1;
        int start = 0;
        CodePointMap.Range range = new CodePointMap.Range();
        while (this.normTrie.getRange(start, CodePointMap.RangeOption.FIXED_LEAD_SURROGATES, 1, null, range)) {
            int end = range.getEnd();
            int value = range.getValue();
            set.add(start);
            if (start != end && this.isAlgorithmicNoNo(value) && (value & 6) > 2) {
                int prevFCD16 = this.getFCD16(start);
                while (++start <= end) {
                    int fcd16 = this.getFCD16(start);
                    if (fcd16 == prevFCD16) continue;
                    set.add(start);
                    prevFCD16 = fcd16;
                }
            }
            start = end + 1;
        }
        for (int c = 44032; c < 55204; c += 28) {
            set.add(c);
            set.add(c + 1);
        }
        var1_1.add(55204);
    }

    public final void addCanonIterPropertyStarts(UnicodeSet set) {
        this.ensureCanonIterData();
        int start = 0;
        CodePointMap.Range range = new CodePointMap.Range();
        while (this.canonIterData.getRange(start, segmentStarterMapper, range)) {
            set.add(start);
            start = range.getEnd() + 1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized Normalizer2Impl ensureCanonIterData() {
        if (this.canonIterData == null) {
            void var1_1;
            MutableCodePointTrie mutableTrie = new MutableCodePointTrie(0, 0);
            this.canonStartSets = new ArrayList();
            int start = 0;
            CodePointMap.Range range = new CodePointMap.Range();
            while (this.normTrie.getRange(start, CodePointMap.RangeOption.FIXED_LEAD_SURROGATES, 1, null, range)) {
                void c;
                int end = range.getEnd();
                int norm16 = range.getValue();
                if (Normalizer2Impl.isInert(norm16) || this.minYesNo <= norm16 && norm16 < this.minNoNo) {
                    start = end + 1;
                    continue;
                }
                while (c <= end) {
                    int oldValue;
                    int newValue = oldValue = mutableTrie.get((int)c);
                    if (this.isMaybeOrNonZeroCC(norm16)) {
                        newValue |= Integer.MIN_VALUE;
                        if (norm16 < 64512) {
                            newValue |= 0x40000000;
                        }
                    } else if (norm16 < this.minYesNo) {
                        newValue |= 0x40000000;
                    } else {
                        int c2 = c;
                        int norm16_2 = norm16;
                        if (this.isDecompNoAlgorithmic(norm16_2)) {
                            c2 = this.mapAlgorithmic(c2, norm16_2);
                            norm16_2 = this.getRawNorm16(c2);
                            assert (!this.isHangulLV(norm16_2) && !this.isHangulLVT(norm16_2));
                        }
                        if (norm16_2 > this.minYesNo) {
                            int mapping = norm16_2 >> 1;
                            char firstUnit = this.extraData.charAt(mapping);
                            int length = firstUnit & 0x1F;
                            if ((firstUnit & 0x80) != 0 && c == c2 && (this.extraData.charAt(mapping - 1) & 0xFF) != 0) {
                                newValue |= Integer.MIN_VALUE;
                            }
                            if (length != 0) {
                                int limit = ++mapping + length;
                                c2 = this.extraData.codePointAt(mapping);
                                this.addToStartSet(mutableTrie, (int)c, c2);
                                if (norm16_2 >= this.minNoNo) {
                                    while ((mapping += Character.charCount(c2)) < limit) {
                                        c2 = this.extraData.codePointAt(mapping);
                                        int c2Value = mutableTrie.get(c2);
                                        if ((c2Value & Integer.MIN_VALUE) != 0) continue;
                                        mutableTrie.set(c2, c2Value | Integer.MIN_VALUE);
                                    }
                                }
                            }
                        } else {
                            this.addToStartSet(mutableTrie, (int)c, c2);
                        }
                    }
                    if (newValue != oldValue) {
                        mutableTrie.set((int)c, newValue);
                    }
                    ++c;
                }
                int n = end + 1;
            }
            this.canonIterData = var1_1.buildImmutable(CodePointTrie.Type.SMALL, CodePointTrie.ValueWidth.BITS_32);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final int getNorm16(int c) {
        void var1_1;
        if (UTF16Plus.isLeadSurrogate(c)) {
            return 1;
        }
        return this.normTrie.get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private int getRawNorm16(int c) {
        void var1_1;
        return this.normTrie.get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final int getCompQuickCheck(int norm16) {
        void var1_1;
        if (norm16 < this.minNoNo || 65026 <= norm16) {
            return 1;
        }
        if (this.minMaybeYes <= var1_1) {
            return 2;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isAlgorithmicNoNo(int norm16) {
        void var1_1;
        return this.limitNoNo <= norm16 && var1_1 < this.minMaybeYes;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isCompNo(int norm16) {
        void var1_1;
        return this.minNoNo <= norm16 && var1_1 < this.minMaybeYes;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isDecompYes(int norm16) {
        void var1_1;
        return norm16 < this.minYesNo || this.minMaybeYes <= var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final int getCC(int norm16) {
        void var1_1;
        if (norm16 >= 64512) {
            return norm16 >> 1 & 0xFF;
        }
        if (norm16 < this.minNoNo || this.limitNoNo <= norm16) {
            return 0;
        }
        void var2_3 = var1_1;
        Normalizer2Impl normalizer2Impl = this;
        if ((normalizer2Impl.extraData.charAt((int)(var2_3 >>= 1)) & 0x80) != 0) {
            return normalizer2Impl.extraData.charAt((int)(var2_3 - true)) & 0xFF;
        }
        return 0;
    }

    public static int getCCFromYesOrMaybe(int norm16) {
        if (norm16 >= 64512) {
            int n;
            return n >> 1 & 0xFF;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public final int getCCFromYesOrMaybeCP(int c) {
        void var1_1;
        if (c < this.minCompNoMaybeCP) {
            return 0;
        }
        return Normalizer2Impl.getCCFromYesOrMaybe(this.getNorm16((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final int getFCD16(int c) {
        void var1_1;
        if (c < this.minDecompNoCP) {
            return 0;
        }
        if (c <= 65535 && !this.singleLeadMightHaveNonZeroFCD16(c)) {
            return 0;
        }
        return this.getFCD16FromNormData((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private boolean singleLeadMightHaveNonZeroFCD16(int lead) {
        void var1_1;
        void var2_2;
        byte bits = this.smallFCD[lead >> 8];
        if (bits == 0) {
            return false;
        }
        return (var2_2 >> (var1_1 >> 5 & 7) & 1) != 0;
    }

    /*
     * WARNING - void declaration
     */
    private int getFCD16FromNormData(int c) {
        void var2_2;
        void var1_1;
        int norm16 = this.getNorm16(c);
        if (norm16 >= this.limitNoNo) {
            if (norm16 >= 64512) {
                c = norm16;
                norm16 = c >> 1 & 0xFF;
                return norm16 | norm16 << 8;
            }
            if (norm16 >= this.minMaybeYes) {
                return 0;
            }
            int deltaTrailCC = norm16 & 6;
            if (deltaTrailCC <= 2) {
                return deltaTrailCC >> 1;
            }
            c = this.mapAlgorithmic(c, norm16);
            norm16 = this.getRawNorm16(c);
        }
        if (norm16 <= this.minYesNo || this.isHangulLVT(norm16)) {
            return 0;
        }
        int mapping = norm16 >> 1;
        char firstUnit = this.extraData.charAt(mapping);
        int fcd16 = firstUnit >> 8;
        if ((var1_1 & 0x80) != 0) {
            void var3_3;
            fcd16 |= this.extraData.charAt((int)(var3_3 - true)) & 0xFF00;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final String getDecomposition(int c) {
        void var1_1;
        void var2_2;
        void buffer2;
        int norm16;
        block8: {
            block7: {
                if (c < this.minDecompNoCP) break block7;
                Normalizer2Impl normalizer2Impl = this;
                norm16 = normalizer2Impl.getNorm16(c);
                if (!normalizer2Impl.isMaybeOrNonZeroCC(norm16)) break block8;
            }
            return null;
        }
        int decomp = -1;
        if (this.isDecompNoAlgorithmic(norm16)) {
            decomp = c = this.mapAlgorithmic(c, norm16);
            norm16 = this.getRawNorm16(c);
        }
        if (norm16 < this.minYesNo) {
            void var3_4;
            if (decomp < 0) {
                return null;
            }
            return AnimationSpecKt.valueOf((int)var3_4);
        }
        if (this.isHangulLV(norm16) || this.isHangulLVT(norm16)) {
            StringBuilder buffer2 = new StringBuilder();
            Hangul.decompose(c, buffer2);
            return buffer2.toString();
        }
        void mapping = buffer2 >> 1;
        int length = this.extraData.charAt((int)mapping++) & 0x1F;
        void v1 = var2_2;
        return this.extraData.substring((int)v1, (int)(v1 + var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isCanonSegmentStarter(int c) {
        void var1_1;
        return this.canonIterData.get((int)var1_1) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    public final int decompose(CharSequence s, int src, int limit, ReorderingBuffer buffer) {
        void var2_2;
        block10: {
            int minNoCP = this.minDecompNoCP;
            int c = 0;
            int norm16 = 0;
            int prevBoundary = 0;
            int prevCC = 0;
            while (true) {
                int cc;
                int prevSrc = src;
                while (src != limit) {
                    char c2;
                    block12: {
                        block11: {
                            c = s.charAt(src);
                            if (c < minNoCP) break block11;
                            Normalizer2Impl normalizer2Impl = this;
                            norm16 = normalizer2Impl.normTrie.bmpGet(c);
                            if (!normalizer2Impl.isMostDecompYesAndZeroCC(norm16)) break block12;
                        }
                        ++src;
                        continue;
                    }
                    if (!UTF16Plus.isLeadSurrogate(c)) break;
                    if (src + 1 != limit && Character.isLowSurrogate(c2 = s.charAt(src + 1))) {
                        norm16 = this.normTrie.suppGet(c = Character.toCodePoint((char)c, c2));
                        if (!this.isMostDecompYesAndZeroCC(norm16)) break;
                        src += 2;
                        continue;
                    }
                    ++src;
                }
                if (src != prevSrc) {
                    if (buffer != null) {
                        buffer.flushAndAppendZeroCC(s, prevSrc, src);
                    } else {
                        prevCC = 0;
                        prevBoundary = src;
                    }
                }
                if (src == limit) break block10;
                src += Character.charCount(c);
                if (buffer != null) {
                    this.decompose(c, norm16, buffer);
                    continue;
                }
                if (!this.isDecompYes(norm16) || prevCC > (cc = Normalizer2Impl.getCCFromYesOrMaybe(norm16)) && cc != 0) break;
                prevCC = cc;
                if (cc > 1) continue;
                prevBoundary = src;
            }
            return prevBoundary;
        }
        return (int)var2_2;
    }

    /*
     * Unable to fully structure code
     */
    public final boolean compose(CharSequence s, int src, int limit, boolean onlyContiguous, boolean doCompose, ReorderingBuffer buffer) {
        prevBoundary = src;
        minNoMaybeCP = this.minCompNoMaybeCP;
        while (true) {
            block76: {
                block72: {
                    block75: {
                        block70: {
                            block74: {
                                block73: {
                                    block71: {
                                        block69: {
                                            block68: {
                                                if (src == limit) {
                                                    if (prevBoundary != limit && doCompose) {
                                                        buffer.append(s, prevBoundary, limit);
                                                    }
                                                    return true;
                                                }
                                                c = s.charAt(src);
                                                if (c < minNoMaybeCP) break block68;
                                                v0 = this;
                                                norm16 = v0.normTrie.bmpGet(c);
                                                if (!v0.isCompYesAndZeroCC(norm16)) break block69;
                                            }
                                            ++src;
                                            continue;
                                        }
                                        prevSrc = src++;
                                        if (UTF16Plus.isLeadSurrogate(c)) {
                                            if (src == limit || !Character.isLowSurrogate(c2 = s.charAt(src))) continue;
                                            ++src;
                                            norm16 = this.normTrie.suppGet(c = Character.toCodePoint((char)c, c2));
                                            if (this.isCompYesAndZeroCC(norm16)) continue;
                                        }
                                        if (this.isMaybeOrNonZeroCC(norm16)) break block70;
                                        if (!doCompose) {
                                            return false;
                                        }
                                        if (!this.isDecompNoAlgorithmic(norm16)) break block71;
                                        if (this.norm16HasCompBoundaryAfter(norm16, onlyContiguous) || this.hasCompBoundaryBefore(s, src, limit)) {
                                            if (prevBoundary != prevSrc) {
                                                buffer.append(s, prevBoundary, prevSrc);
                                            }
                                            buffer.append(this.mapAlgorithmic(c, norm16), 0);
                                            prevBoundary = src;
                                            continue;
                                        }
                                        break block72;
                                    }
                                    if (norm16 >= this.minNoNoCompBoundaryBefore) break block73;
                                    if (this.norm16HasCompBoundaryAfter(norm16, onlyContiguous) || this.hasCompBoundaryBefore(s, src, limit)) {
                                        if (prevBoundary != prevSrc) {
                                            buffer.append(s, prevBoundary, prevSrc);
                                        }
                                        mapping = norm16 >> 1;
                                        length = this.extraData.charAt(mapping++) & 31;
                                        v1 = mapping;
                                        buffer.append(this.extraData, v1, v1 + length);
                                        prevBoundary = src;
                                        continue;
                                    }
                                    break block72;
                                }
                                if (norm16 < this.minNoNoEmpty) break block72;
                                if (this.hasCompBoundaryBefore(s, src, limit)) break block74;
                                mapping = (int)onlyContiguous;
                                var15_28 = prevSrc;
                                var14_26 = prevBoundary;
                                c = s;
                                length = this;
                                if (var14_26 == var15_28) ** GOTO lbl-1000
                                var17_30 = mapping;
                                var14_27 = length;
                                var16_29 = Character.codePointBefore(c, var15_28);
                                if (var14_27.norm16HasCompBoundaryAfter(var14_27.getNorm16(var16_29), (boolean)var17_30)) lbl-1000:
                                // 2 sources

                                {
                                    v2 = true;
                                } else {
                                    v2 = false;
                                }
                                if (!v2) break block72;
                            }
                            if (prevBoundary != prevSrc) {
                                buffer.append(s, prevBoundary, prevSrc);
                            }
                            prevBoundary = src;
                            continue;
                        }
                        if (!Normalizer2Impl.isJamoVT(norm16) || prevBoundary == prevSrc) break block75;
                        prev = s.charAt(prevSrc - 1);
                        if (c < 4519) {
                            l = (char)(prev - 4352);
                            if (l < '\u0013') {
                                if (!doCompose) {
                                    return false;
                                }
                                if (src != limit && 0 < (t = s.charAt(src) - 4519) && t < 28) {
                                    ++src;
                                } else {
                                    t = this.hasCompBoundaryBefore(s, src, limit) != false ? 0 : -1;
                                }
                                if (t >= 0) {
                                    syllable = 44032 + (l * 21 + (c - 4449)) * 28 + t;
                                    if (prevBoundary != --prevSrc) {
                                        buffer.append(s, prevBoundary, prevSrc);
                                    }
                                    buffer.append((char)syllable);
                                    prevBoundary = src;
                                    continue;
                                }
                            }
                        } else {
                            l = prev;
                            if ((l -= 44032) >= 0 && l < 11172 && l % 28 == 0) {
                                if (!doCompose) {
                                    return false;
                                }
                                syllable = prev + var10_10 - 4519;
                                if (prevBoundary != --prevSrc) {
                                    buffer.append(s, prevBoundary, prevSrc);
                                }
                                buffer.append((char)syllable);
                                prevBoundary = src;
                                continue;
                            }
                        }
                        break block72;
                    }
                    if (norm16 <= 65024) break block72;
                    prev = norm16;
                    cc = prev >> 1 & 255;
                    if (!onlyContiguous) ** GOTO lbl-1000
                    var15_28 = prevSrc;
                    t = prevBoundary;
                    var10_12 = s;
                    syllable = this;
                    if ((t == var15_28 ? 0 : syllable.getFCD16(Character.codePointBefore(var10_12, var15_28))) > cc) {
                        if (!doCompose) {
                            return false;
                        }
                    } else lbl-1000:
                    // 2 sources

                    {
                        while (true) {
                            if (src == limit) {
                                if (doCompose) {
                                    buffer.append(s, prevBoundary, limit);
                                }
                                return true;
                            }
                            prevCC = cc;
                            var10_13 = Character.codePointAt(s, src);
                            n16 = this.normTrie.get(var10_13);
                            if (n16 < 65026) break;
                            cc = n16;
                            if (prevCC > (cc = cc >> 1 & 255)) {
                                if (doCompose) break;
                                return false;
                            }
                            src += Character.charCount(var10_13);
                        }
                        if (this.norm16HasCompBoundaryBefore(n16)) {
                            if (!this.isCompYesAndZeroCC(n16)) continue;
                            src += Character.charCount(var10_13);
                            continue;
                        }
                    }
                }
                if (prevBoundary != prevSrc && !this.norm16HasCompBoundaryBefore(norm16) && !this.norm16HasCompBoundaryAfter(norm16 = this.normTrie.get(var10_14 = Character.codePointBefore(s, prevSrc)), onlyContiguous)) {
                    prevSrc -= Character.charCount(var10_14);
                }
                if (doCompose && prevBoundary != prevSrc) {
                    buffer.append(s, prevBoundary, prevSrc);
                }
                recomposeStartIndex = buffer.length();
                this.decomposeShort(s, prevSrc, src, false, onlyContiguous, buffer);
                src = this.decomposeShort(s, src, limit, true, onlyContiguous, buffer);
                var15_28 = (int)onlyContiguous;
                var14_26 = recomposeStartIndex;
                var10_15 = buffer;
                var13_25 = this;
                var12_18 = var10_15.getStringBuilder();
                if (var14_26 == var12_18.length()) break block76;
                prevBoundary = -1;
                var16_29 = -1;
                var21_36 = false;
                var20_35 = 0;
                while (true) {
                    block77: {
                        block79: {
                            block78: {
                                var11_16 = var12_18.codePointAt(var14_26);
                                var14_26 += Character.charCount(var11_16);
                                var17_30 = var13_25.getNorm16(var11_16);
                                var19_34 = Normalizer2Impl.getCCFromYesOrMaybe(var17_30);
                                var22_37 = var17_30;
                                var18_31 = var13_25;
                                if (!(var18_31.minMaybeYes <= var22_37 && var22_37 <= 65024) || prevBoundary < 0 || var20_35 >= var19_34 && var20_35 != 0) break block77;
                                if (Normalizer2Impl.isJamoVT(var17_30)) {
                                    if (var11_16 < 4519) {
                                        v3 = (char)(var12_18.charAt(var16_29) - 4352);
                                        prevBoundary = v3;
                                        if (v3 < '\u0013') {
                                            var17_30 = var14_26 - 1;
                                            prevBoundary = (char)(44032 + (prevBoundary * 21 + (var11_16 - 4449)) * 28);
                                            if (var14_26 != var12_18.length()) {
                                                v4 = (char)(var12_18.charAt(var14_26) - 4519);
                                                var11_16 = v4;
                                                if (v4 < '\u001c') {
                                                    ++var14_26;
                                                    prevBoundary = (char)(prevBoundary + var11_16);
                                                }
                                            }
                                            var12_18.setCharAt(var16_29, (char)prevBoundary);
                                            var12_18.delete(var17_30, var14_26);
                                            var14_26 = var17_30;
                                        }
                                    }
                                    if (var14_26 == var12_18.length()) break;
                                    prevBoundary = -1;
                                    continue;
                                }
                                var23_38 = var11_16;
                                var22_37 = prevBoundary;
                                var18_31 = var13_25.maybeYesCompositions;
                                if (var23_38 >= 13312) break block78;
                                var24_39 = var23_38 << 1;
                                while (true) {
                                    v5 = var18_31.charAt(var22_37);
                                    var23_38 = v5;
                                    if (var24_39 <= v5) break;
                                    var22_37 += 2 + (var23_38 & 1);
                                }
                                if (var24_39 != (var23_38 & 32766)) ** GOTO lbl-1000
                                v6 = (var23_38 & 1) != 0 ? var18_31.charAt(var22_37 + 1) << 16 | var18_31.charAt(var22_37 + 2) : (int)var18_31.charAt(var22_37 + 1);
                                break block79;
                            }
                            var24_39 = 13312 + (var23_38 >> 9 & -2);
                            var25_40 = var23_38 << 6 & 65535;
                            while (true) {
                                v7 = var18_31.charAt(var22_37);
                                var23_38 = v7;
                                if (var24_39 > v7) {
                                    var22_37 += 2 + (var23_38 & 1);
                                    continue;
                                }
                                if (var24_39 != (var23_38 & 32766)) ** GOTO lbl-1000
                                var26_41 = var18_31.charAt(var22_37 + 1);
                                if (var25_40 <= var26_41) break;
                                if ((var23_38 & 32768) == 0) {
                                    var22_37 += 3;
                                    continue;
                                }
                                ** GOTO lbl-1000
                                break;
                            }
                            if (var25_40 == (var26_41 & 65472)) {
                                v6 = (var26_41 & -65473) << 16 | var18_31.charAt(var22_37 + 2);
                            } else lbl-1000:
                            // 4 sources

                            {
                                v6 = var18_32 = -1;
                            }
                        }
                        if (v6 >= 0) {
                            prevBoundary = var18_32 >> 1;
                            var17_30 = var14_26 - Character.charCount(var11_16);
                            var12_18.delete(var17_30, var14_26);
                            var14_26 = var17_30;
                            if (var21_36) {
                                if (prevBoundary > 65535) {
                                    var12_18.setCharAt(var16_29, AnimationSpecKt.getLeadSurrogate((int)prevBoundary));
                                    var12_18.setCharAt(var16_29 + 1, AnimationSpecKt.getTrailSurrogate((int)prevBoundary));
                                } else {
                                    var12_18.setCharAt(var16_29, (char)var11_16);
                                    var12_18.deleteCharAt(var16_29 + 1);
                                    var21_36 = false;
                                    --var14_26;
                                }
                            } else if (prevBoundary > 65535) {
                                var21_36 = true;
                                var12_18.setCharAt(var16_29, AnimationSpecKt.getLeadSurrogate((int)prevBoundary));
                                var12_18.insert(var16_29 + 1, AnimationSpecKt.getTrailSurrogate((int)prevBoundary));
                                ++var14_26;
                            } else {
                                var12_18.setCharAt(var16_29, (char)prevBoundary);
                            }
                            if (var14_26 == var12_18.length()) break;
                            if ((var18_32 & 1) != 0) {
                                var22_37 = var13_25.getRawNorm16(prevBoundary);
                                var23_38 = 64512 - var18_33.minMaybeYes + var22_37 >> 1;
                                var24_39 = var18_33.maybeYesCompositions.charAt(var23_38);
                                prevBoundary = var23_38 + 1 + (var24_39 & 31);
                                continue;
                            }
                            prevBoundary = -1;
                            continue;
                        }
                    }
                    var20_35 = var19_34;
                    if (var14_26 == var12_18.length()) break;
                    if (var19_34 == 0) {
                        var22_37 = var17_30;
                        var18_31 = var13_25;
                        if (var22_37 < 2 || 64512 <= var22_37) {
                            v8 = -1;
                        } else {
                            if ((var22_37 -= var18_31.minMaybeYes) < 0) {
                                var22_37 += 64512;
                            }
                            v8 = prevBoundary = var22_37 >> 1;
                        }
                        if (v8 < 0) continue;
                        if (var11_16 <= 65535) {
                            var21_36 = false;
                            var16_29 = var14_26 - 1;
                            continue;
                        }
                        var21_36 = true;
                        var16_29 = var14_26 - 2;
                        continue;
                    }
                    if (var15_28 == 0) continue;
                    prevBoundary = -1;
                }
                var10_15.flush();
            }
            if (!doCompose) {
                if (!buffer.equals(s, prevSrc, src)) {
                    return false;
                }
                buffer.remove();
            }
            prevBoundary = src;
        }
    }

    public final int composeQuickCheck(CharSequence s, int src, int limit, boolean onlyContiguous, boolean doSpan) {
        int qcResult = 0;
        int prevBoundary = 0;
        int minNoMaybeCP = this.minCompNoMaybeCP;
        while (true) {
            int norm16;
            int c2;
            block15: {
                block14: {
                    if (src == limit) {
                        return src << 1 | qcResult;
                    }
                    c2 = s.charAt(src);
                    if (c2 < minNoMaybeCP) break block14;
                    Normalizer2Impl normalizer2Impl = this;
                    norm16 = normalizer2Impl.normTrie.bmpGet(c2);
                    if (!normalizer2Impl.isCompYesAndZeroCC(norm16)) break block15;
                }
                ++src;
                continue;
            }
            int prevSrc = src++;
            if (UTF16Plus.isLeadSurrogate(c2)) {
                char c2;
                if (src == limit || !Character.isLowSurrogate(c2 = s.charAt(src))) continue;
                ++src;
                norm16 = this.normTrie.suppGet(c2 = Character.toCodePoint((char)c2, c2));
                if (this.isCompYesAndZeroCC(norm16)) continue;
            }
            int prevNorm16 = 1;
            if (prevBoundary != prevSrc) {
                int n16;
                prevBoundary = prevSrc;
                if (!this.norm16HasCompBoundaryBefore(norm16) && !this.norm16HasCompBoundaryAfter(n16 = this.getNorm16(c2 = Character.codePointBefore(s, prevSrc)), onlyContiguous)) {
                    prevBoundary -= Character.charCount(c2);
                    prevNorm16 = n16;
                }
            }
            if (!this.isMaybeOrNonZeroCC(norm16)) break;
            int cc = Normalizer2Impl.getCCFromYesOrMaybe(norm16);
            if (onlyContiguous && cc != 0) {
                Normalizer2Impl c2 = this;
                if ((prevNorm16 <= c2.minYesNo ? 0 : c2.extraData.charAt(prevNorm16 >> 1) >> 8) > cc) break;
            }
            while (true) {
                if (norm16 < 65026) {
                    if (!doSpan) {
                        qcResult = 1;
                    } else {
                        return prevBoundary << 1;
                    }
                }
                if (src == limit) {
                    return src << 1 | qcResult;
                }
                int prevCC = cc;
                c2 = Character.codePointAt(s, src);
                norm16 = this.getNorm16(c2);
                if (!this.isMaybeOrNonZeroCC(norm16) || prevCC > (cc = Normalizer2Impl.getCCFromYesOrMaybe(norm16)) && cc != 0) break;
                src += Character.charCount(c2);
            }
            if (!this.isCompYesAndZeroCC(norm16)) break;
            prevBoundary = src;
            src += Character.charCount(c2);
        }
        return prevBoundary << 1;
    }

    /*
     * WARNING - void declaration
     */
    public final void composeAndAppend(CharSequence s, boolean doCompose, boolean onlyContiguous, ReorderingBuffer buffer) {
        void var1_1;
        void var2_2;
        int n;
        boolean src = false;
        int limit = s.length();
        if (!buffer.isEmpty()) {
            int firstStarterInSrc;
            int n2;
            int n3;
            int n4;
            int n5 = onlyContiguous;
            int n6 = limit;
            CharSequence charSequence = s;
            Normalizer2Impl normalizer2Impl = this;
            for (n3 = 0; n3 < n6 && !normalizer2Impl.hasCompBoundaryBefore(n4 = Character.codePointAt(charSequence, n3), n2 = normalizer2Impl.normTrie.get(n4)); n3 += Character.charCount(n4)) {
                if (!normalizer2Impl.norm16HasCompBoundaryAfter(n2, n5 != 0)) continue;
            }
            if ((firstStarterInSrc = n3) != 0) {
                n6 = onlyContiguous;
                charSequence = buffer.getStringBuilder();
                normalizer2Impl = this;
                for (n3 = buffer.length(); n3 > 0 && !normalizer2Impl.norm16HasCompBoundaryAfter(n4 = normalizer2Impl.getNorm16(n5 = Character.codePointBefore(charSequence, n3)), n6 != 0); n3 -= Character.charCount(n5)) {
                    if (!normalizer2Impl.hasCompBoundaryBefore(n5, n4)) continue;
                }
                int lastStarterInDest = n3;
                StringBuilder middle = new StringBuilder(buffer.length() - lastStarterInDest + firstStarterInSrc + 16);
                middle.append(buffer.getStringBuilder(), lastStarterInDest, buffer.length());
                ReorderingBuffer reorderingBuffer = buffer;
                reorderingBuffer.removeSuffix(reorderingBuffer.length() - lastStarterInDest);
                middle.append(s, 0, firstStarterInSrc);
                this.compose(middle, 0, middle.length(), onlyContiguous != 0, true, buffer);
                n = firstStarterInSrc;
            }
        }
        if (var2_2 != false) {
            void var3_3;
            this.compose(s, n, limit, (boolean)var3_3, true, buffer);
            return;
        }
        buffer.append((CharSequence)var1_1, n, limit);
    }

    /*
     * WARNING - void declaration
     */
    public final int makeFCD(CharSequence s, int src, int limit, ReorderingBuffer buffer) {
        void var2_2;
        int prevBoundary = src;
        int c = 0;
        int prevFCD16 = 0;
        int fcd16 = 0;
        while (true) {
            int prevSrc = src;
            while (src != limit) {
                char c2;
                c = s.charAt(src);
                if (c < this.minLcccCP) {
                    prevFCD16 = ~c;
                    ++src;
                    continue;
                }
                if (!this.singleLeadMightHaveNonZeroFCD16(c)) {
                    prevFCD16 = 0;
                    ++src;
                    continue;
                }
                if (UTF16Plus.isLeadSurrogate(c) && src + 1 != limit && Character.isLowSurrogate(c2 = s.charAt(src + 1))) {
                    c = Character.toCodePoint((char)c, c2);
                }
                if ((fcd16 = this.getFCD16FromNormData(c)) > 255) break;
                prevFCD16 = fcd16;
                src += Character.charCount(c);
            }
            if (src != prevSrc) {
                if (src == limit) {
                    if (buffer == null) break;
                    buffer.flushAndAppendZeroCC(s, prevSrc, src);
                    break;
                }
                prevBoundary = src;
                if (prevFCD16 < 0) {
                    int prev = ~prevFCD16;
                    if (prev < this.minDecompNoCP) {
                        prevFCD16 = 0;
                    } else {
                        prevFCD16 = this.getFCD16FromNormData(prev);
                        if (prevFCD16 > 1) {
                            --prevBoundary;
                        }
                    }
                } else {
                    int p = src - 1;
                    if (Character.isLowSurrogate(s.charAt(p)) && prevSrc < p && Character.isHighSurrogate(s.charAt(p - 1))) {
                        prevFCD16 = this.getFCD16FromNormData(Character.toCodePoint(s.charAt(--p), s.charAt(p + 1)));
                    }
                    if (prevFCD16 > 1) {
                        prevBoundary = p;
                    }
                }
                if (buffer != null) {
                    buffer.flushAndAppendZeroCC(s, prevSrc, prevBoundary);
                    buffer.append(s, prevBoundary, src);
                }
                prevSrc = src;
            } else if (src == limit) break;
            src += Character.charCount(c);
            if ((prevFCD16 & 0xFF) <= fcd16 >> 8) {
                if ((fcd16 & 0xFF) <= 1) {
                    prevBoundary = src;
                }
                if (buffer != null) {
                    buffer.appendZeroCC(c);
                }
                prevFCD16 = fcd16;
                continue;
            }
            if (buffer == null) {
                return prevBoundary;
            }
            buffer.removeSuffix(prevSrc - prevBoundary);
            src = this.findNextFCDBoundary(s, src, limit);
            this.decomposeShort(s, prevBoundary, src, false, false, buffer);
            prevBoundary = src;
            prevFCD16 = 0;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final void makeFCDAndAppend(CharSequence s, boolean doMakeFCD, ReorderingBuffer buffer) {
        void var1_1;
        void var3_3;
        void var2_2;
        int n;
        int firstBoundaryInSrc;
        boolean src2 = false;
        int limit = s.length();
        if (!buffer.isEmpty() && (firstBoundaryInSrc = this.findNextFCDBoundary(s, 0, limit)) != 0) {
            int n2;
            int n3;
            StringBuilder stringBuilder = buffer.getStringBuilder();
            Normalizer2Impl src2 = this;
            for (n2 = buffer.length(); n2 > 0 && (n3 = Character.codePointBefore(stringBuilder, n2)) >= src2.minDecompNoCP; n2 -= Character.charCount(n3)) {
                Normalizer2Impl normalizer2Impl = src2;
                int n4 = normalizer2Impl.getNorm16(n3);
                if (normalizer2Impl.norm16HasDecompBoundaryAfter(n4)) break;
                if (!src2.norm16HasDecompBoundaryBefore(n4)) continue;
            }
            int lastBoundaryInDest = n2;
            StringBuilder middle = new StringBuilder(buffer.length() - lastBoundaryInDest + firstBoundaryInSrc + 16);
            middle.append(buffer.getStringBuilder(), lastBoundaryInDest, buffer.length());
            ReorderingBuffer reorderingBuffer = buffer;
            reorderingBuffer.removeSuffix(reorderingBuffer.length() - lastBoundaryInDest);
            middle.append(s, 0, firstBoundaryInSrc);
            this.makeFCD(middle, 0, middle.length(), buffer);
            n = firstBoundaryInSrc;
        }
        if (var2_2 != false) {
            this.makeFCD(s, n, limit, buffer);
            return;
        }
        var3_3.append((CharSequence)var1_1, n, limit);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean hasDecompBoundaryBefore(int c) {
        block3: {
            block2: {
                void var1_1;
                if (c < this.minLcccCP || c <= 65535 && !this.singleLeadMightHaveNonZeroFCD16(c)) break block2;
                Normalizer2Impl normalizer2Impl = this;
                if (!normalizer2Impl.norm16HasDecompBoundaryBefore(normalizer2Impl.getNorm16((int)var1_1))) break block3;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean norm16HasDecompBoundaryBefore(int norm16) {
        void var1_1;
        if (norm16 < this.minNoNoCompNoMaybeCC) {
            return true;
        }
        if (norm16 >= this.limitNoNo) {
            return norm16 <= 64512 || norm16 == 65024;
        }
        int mapping = norm16 >> 1;
        char c = this.extraData.charAt(mapping);
        return (c & 0x80) == 0 || (this.extraData.charAt((int)(var1_1 - true)) & 0xFF00) == 0;
    }

    /*
     * WARNING - void declaration
     */
    private boolean norm16HasDecompBoundaryAfter(int norm16) {
        void var1_1;
        void var2_2;
        if (norm16 <= this.minYesNo || this.isHangulLVT(norm16)) {
            return true;
        }
        if (norm16 >= this.limitNoNo) {
            if (this.isMaybeOrNonZeroCC(norm16)) {
                return norm16 <= 64512 || norm16 == 65024;
            }
            return (norm16 & 6) <= 2;
        }
        int mapping = norm16 >> 1;
        char firstUnit = this.extraData.charAt(mapping);
        if (firstUnit > '\u01ff') {
            return false;
        }
        if (firstUnit <= '\u00ff') {
            return true;
        }
        return (var2_2 & 0x80) == 0 || (this.extraData.charAt((int)(var1_1 - true)) & 0xFF00) == 0;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isDecompInert(int c) {
        void var1_1;
        Normalizer2Impl normalizer2Impl = this;
        int n = normalizer2Impl.getNorm16((int)var1_1);
        Normalizer2Impl normalizer2Impl2 = normalizer2Impl;
        return n < normalizer2Impl2.minYesNo || n == 65024 || normalizer2Impl2.minMaybeYes <= n && n <= 64512;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean hasCompBoundaryBefore(int c) {
        block3: {
            block2: {
                void var1_1;
                if (c < this.minCompNoMaybeCP) break block2;
                Normalizer2Impl normalizer2Impl = this;
                if (!normalizer2Impl.norm16HasCompBoundaryBefore(normalizer2Impl.getNorm16((int)var1_1))) break block3;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isCompInert(int c, boolean onlyContiguous) {
        void var1_1;
        void var2_2;
        int norm16 = this.getNorm16(c);
        return this.isCompYesAndZeroCC(norm16) && (norm16 & 1) != 0 && (var2_2 == false || Normalizer2Impl.isInert(norm16) || this.extraData.charAt((int)(var1_1 >> 1)) <= '\u01ff');
    }

    private boolean isMaybeOrNonZeroCC(int norm16) {
        return norm16 >= this.minMaybeYes;
    }

    private static boolean isInert(int norm16) {
        return norm16 == 1;
    }

    private static boolean isJamoVT(int norm16) {
        return norm16 == 65024;
    }

    private boolean isHangulLV(int norm16) {
        return norm16 == this.minYesNo;
    }

    private boolean isHangulLVT(int norm16) {
        Normalizer2Impl normalizer2Impl = this;
        return norm16 == (normalizer2Impl.minYesNoMappingsOnly | 1);
    }

    private boolean isCompYesAndZeroCC(int norm16) {
        return norm16 < this.minNoNo;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isMostDecompYesAndZeroCC(int norm16) {
        void var1_1;
        return norm16 < this.minYesNo || norm16 == 64512 || var1_1 == 65024;
    }

    private boolean isDecompNoAlgorithmic(int norm16) {
        return norm16 >= this.limitNoNo;
    }

    /*
     * WARNING - void declaration
     */
    private int mapAlgorithmic(int c, int norm16) {
        void var2_2;
        return c + (var2_2 >> 3) - this.centerNoNoDelta;
    }

    /*
     * WARNING - void declaration
     */
    private int decomposeShort(CharSequence s, int src, int limit, boolean stopAtCompBoundary, boolean onlyContiguous, ReorderingBuffer buffer) {
        void var2_2;
        while (src < limit) {
            int c = Character.codePointAt(s, src);
            if (stopAtCompBoundary && c < this.minCompNoMaybeCP) {
                return src;
            }
            int norm16 = this.getNorm16(c);
            if (stopAtCompBoundary && this.norm16HasCompBoundaryBefore(norm16)) {
                return src;
            }
            src += Character.charCount(c);
            this.decompose(c, norm16, buffer);
            if (!stopAtCompBoundary || !this.norm16HasCompBoundaryAfter(norm16, onlyContiguous)) continue;
            return src;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private void decompose(int c, int norm16, ReorderingBuffer buffer) {
        void var2_2;
        void var3_3;
        void var1_1;
        if (norm16 >= this.limitNoNo) {
            if (this.isMaybeOrNonZeroCC(norm16)) {
                buffer.append(c, Normalizer2Impl.getCCFromYesOrMaybe(norm16));
                return;
            }
            c = this.mapAlgorithmic(c, norm16);
            norm16 = this.getRawNorm16(c);
        }
        if (norm16 < this.minYesNo) {
            buffer.append(c, 0);
            return;
        }
        if (this.isHangulLV(norm16) || this.isHangulLVT(norm16)) {
            Hangul.decompose(c, buffer);
            return;
        }
        int mapping = norm16 >> 1;
        char firstUnit = this.extraData.charAt(mapping);
        int length = firstUnit & 0x1F;
        int trailCC = firstUnit >> 8;
        int leadCC = (firstUnit & 0x80) != 0 ? this.extraData.charAt(mapping - 1) >> 8 : 0;
        ++mapping;
        void v0 = var1_1;
        var3_3.append(this.extraData, (int)v0, (int)(v0 + length), true, (int)var2_2, trailCC);
    }

    /*
     * WARNING - void declaration
     */
    private boolean hasCompBoundaryBefore(int c, int norm16) {
        void var2_2;
        return c < this.minCompNoMaybeCP || this.norm16HasCompBoundaryBefore((int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private boolean norm16HasCompBoundaryBefore(int norm16) {
        void var1_1;
        return norm16 < this.minNoNoCompNoMaybeCC || this.isAlgorithmicNoNo((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private boolean hasCompBoundaryBefore(CharSequence s, int src, int limit) {
        void var2_2;
        void var1_1;
        void var3_3;
        return src == var3_3 || this.hasCompBoundaryBefore(Character.codePointAt((CharSequence)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    private boolean norm16HasCompBoundaryAfter(int norm16, boolean onlyContiguous) {
        void var1_1;
        void var2_2;
        return (norm16 & 1) != 0 && (var2_2 == false || this.isTrailCC01ForCompBoundaryAfter((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private boolean isTrailCC01ForCompBoundaryAfter(int norm16) {
        void var1_1;
        return Normalizer2Impl.isInert(norm16) || (this.isDecompNoAlgorithmic(norm16) ? (norm16 & 6) <= 2 : this.extraData.charAt((int)(var1_1 >> 1)) <= '\u01ff');
    }

    /*
     * WARNING - void declaration
     */
    private int findNextFCDBoundary(CharSequence s, int p, int limit) {
        void var2_2;
        int c;
        while (p < limit && (c = Character.codePointAt(s, p)) >= this.minLcccCP) {
            Normalizer2Impl normalizer2Impl = this;
            int norm16 = normalizer2Impl.getNorm16(c);
            if (normalizer2Impl.norm16HasDecompBoundaryBefore(norm16)) break;
            p += Character.charCount(c);
            if (!this.norm16HasDecompBoundaryAfter(norm16)) continue;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private void addToStartSet(MutableCodePointTrie mutableTrie, int origin, int decompLead) {
        void var2_2;
        void var1_1;
        UnicodeSet set;
        int canonValue = mutableTrie.get(decompLead);
        if ((canonValue & 0x3FFFFF) == 0 && origin != 0) {
            mutableTrie.set(decompLead, canonValue | origin);
            return;
        }
        if ((canonValue & 0x200000) == 0) {
            void var3_3;
            int firstOrigin = canonValue & 0x1FFFFF;
            canonValue = canonValue & 0xFFE00000 | 0x200000 | this.canonStartSets.size();
            mutableTrie.set((int)var3_3, canonValue);
            set = new UnicodeSet();
            this.canonStartSets.add(set);
            if (firstOrigin != 0) {
                set.add(firstOrigin);
            }
        } else {
            set = this.canonStartSets.get(canonValue & 0x1FFFFF);
        }
        var1_1.add((int)var2_2);
    }

    static final class IsAcceptable
    implements ICUBinary.Authenticate {
        private IsAcceptable() {
        }

        @Override
        public final boolean isDataVersionAcceptable(byte[] version) {
            return version[0] == 4;
        }

        /* synthetic */ IsAcceptable(byte by) {
            this();
        }
    }

    public static final class UTF16Plus {
        public static boolean isLeadSurrogate(int c) {
            return (c & 0xFFFFFC00) == 55296;
        }

        public static boolean equal(CharSequence s1, CharSequence s2) {
            if (s1 == s2) {
                return true;
            }
            int length = s1.length();
            if (length != s2.length()) {
                return false;
            }
            for (int i = 0; i < length; ++i) {
                if (s1.charAt(i) == s2.charAt(i)) continue;
                return false;
            }
            return true;
        }
    }

    public static final class ReorderingBuffer
    implements Appendable {
        private final Normalizer2Impl impl;
        private final Appendable app;
        private final StringBuilder str;
        private final boolean appIsStringBuilder;
        private int reorderStart;
        private int lastCC;
        private int codePointStart;
        private int codePointLimit;

        /*
         * WARNING - void declaration
         */
        public ReorderingBuffer(Normalizer2Impl ni, Appendable dest, int destCapacity) {
            void var1_1;
            this.impl = var1_1;
            this.app = dest;
            if (this.app instanceof StringBuilder) {
                void var3_3;
                void var2_2;
                this.appIsStringBuilder = true;
                this.str = (StringBuilder)var2_2;
                this.str.ensureCapacity((int)var3_3);
                this.reorderStart = 0;
                if (this.str.length() == 0) {
                    this.lastCC = 0;
                    return;
                }
                this.setIterator();
                this.lastCC = this.previousCC();
                if (this.lastCC > 1) {
                    while (this.previousCC() > 1) {
                    }
                }
                this.reorderStart = this.codePointLimit;
                return;
            }
            this.appIsStringBuilder = false;
            this.str = new StringBuilder();
            this.reorderStart = 0;
            this.lastCC = 0;
        }

        public final boolean isEmpty() {
            return this.str.length() == 0;
        }

        public final int length() {
            return this.str.length();
        }

        public final StringBuilder getStringBuilder() {
            return this.str;
        }

        public final boolean equals(CharSequence s, int start, int limit) {
            StringBuilder stringBuilder;
            int n;
            int n2;
            void var6_4 = n2;
            void var5_5 = n;
            void var4_6 = stringBuilder;
            n2 = this.str.length();
            n = 0;
            stringBuilder = this.str;
            if (n2 != var6_4 - var5_5) {
                return false;
            }
            if (stringBuilder != var4_6 || var5_5 != false) {
                while (n < n2) {
                    if (stringBuilder.charAt(n++) == var4_6.charAt((int)var5_5++)) continue;
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public final void append(int c, int cc) {
            if (this.lastCC <= cc || cc == 0) {
                this.str.appendCodePoint(c);
                this.lastCC = cc;
                if (cc <= 1) {
                    this.reorderStart = this.str.length();
                    return;
                }
            } else {
                void var2_2;
                void var1_1;
                this.insert((int)var1_1, (int)var2_2);
            }
        }

        public final void append(CharSequence s, int start, int limit, boolean isNFD, int leadCC, int trailCC) {
            if (start == limit) {
                return;
            }
            if (this.lastCC <= leadCC || leadCC == 0) {
                if (trailCC <= 1) {
                    this.reorderStart = this.str.length() + (limit - start);
                } else if (leadCC <= 1) {
                    this.reorderStart = this.str.length() + 1;
                }
                this.str.append(s, start, limit);
                this.lastCC = trailCC;
                return;
            }
            int c = Character.codePointAt(s, start);
            start += Character.charCount(c);
            this.insert(c, leadCC);
            while (start < limit) {
                leadCC = (start += Character.charCount(c = Character.codePointAt(s, start))) < limit ? (isNFD ? Normalizer2Impl.getCCFromYesOrMaybe(this.impl.getNorm16(c)) : this.impl.getCC(this.impl.getNorm16(c))) : trailCC;
                this.append(c, leadCC);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ReorderingBuffer append(char c) {
            void var1_1;
            this.str.append((char)var1_1);
            this.lastCC = 0;
            this.reorderStart = this.str.length();
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final void appendZeroCC(int c) {
            void var1_1;
            this.str.appendCodePoint((int)var1_1);
            this.lastCC = 0;
            this.reorderStart = this.str.length();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ReorderingBuffer append(CharSequence s, int start, int limit) {
            if (start != limit) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.str.append((CharSequence)var1_1, (int)var2_2, (int)var3_3);
                this.lastCC = 0;
                this.reorderStart = this.str.length();
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final void flush() {
            if (this.appIsStringBuilder) {
                this.reorderStart = this.str.length();
            } else {
                try {
                    this.app.append(this.str);
                    this.str.setLength(0);
                    this.reorderStart = 0;
                }
                catch (IOException e) {
                    void var1_1;
                    throw new ICUUncheckedIOException((Throwable)var1_1);
                }
            }
            this.lastCC = 0;
        }

        /*
         * WARNING - void declaration
         */
        public final ReorderingBuffer flushAndAppendZeroCC(CharSequence s, int start, int limit) {
            if (this.appIsStringBuilder) {
                this.str.append(s, start, limit);
                this.reorderStart = this.str.length();
            } else {
                try {
                    void var3_4;
                    void var2_3;
                    this.app.append(this.str).append(s, (int)var2_3, (int)var3_4);
                    this.str.setLength(0);
                    this.reorderStart = 0;
                }
                catch (IOException e) {
                    void var1_2;
                    throw new ICUUncheckedIOException((Throwable)var1_2);
                }
            }
            this.lastCC = 0;
            return this;
        }

        public final void remove() {
            this.str.setLength(0);
            this.lastCC = 0;
            this.reorderStart = 0;
        }

        /*
         * WARNING - void declaration
         */
        public final void removeSuffix(int suffixLength) {
            void var2_2;
            void var1_1;
            int oldLength = this.str.length();
            this.str.delete(oldLength - var1_1, (int)var2_2);
            this.lastCC = 0;
            this.reorderStart = this.str.length();
        }

        /*
         * WARNING - void declaration
         */
        private void insert(int c, int cc) {
            this.setIterator();
            this.skipPrevious();
            while (this.previousCC() > cc) {
            }
            if (c <= 65535) {
                this.str.insert(this.codePointLimit, (char)c);
                if (cc <= 1) {
                    this.reorderStart = this.codePointLimit + 1;
                    return;
                }
            } else {
                void var2_2;
                void var1_1;
                this.str.insert(this.codePointLimit, Character.toChars((int)var1_1));
                if (var2_2 <= true) {
                    this.reorderStart = this.codePointLimit + 2;
                }
            }
        }

        private void setIterator() {
            this.codePointStart = this.str.length();
        }

        private void skipPrevious() {
            this.codePointLimit = this.codePointStart;
            this.codePointStart = this.str.offsetByCodePoints(this.codePointStart, -1);
        }

        /*
         * WARNING - void declaration
         */
        private int previousCC() {
            void var1_1;
            this.codePointLimit = this.codePointStart;
            if (this.reorderStart >= this.codePointStart) {
                return 0;
            }
            int c = this.str.codePointBefore(this.codePointStart);
            this.codePointStart -= Character.charCount(c);
            return this.impl.getCCFromYesOrMaybeCP((int)var1_1);
        }
    }

    public static final class Hangul {
        /*
         * WARNING - void declaration
         */
        public static int decompose(int c, Appendable buffer) {
            try {
                void var1_1;
                int n;
                int c2 = (c -= 44032) % 28;
                buffer.append((char)(4352 + (c /= 28) / 21));
                buffer.append((char)(4449 + n % 21));
                if (c2 == 0) {
                    return 2;
                }
                var1_1.append((char)(c2 + 4519));
                return 3;
            }
            catch (IOException e) {
                void var2_3;
                throw new ICUUncheckedIOException((Throwable)var2_3);
            }
        }
    }
}

