/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.number.range.StandardPluralRanges;
import com.ibm.icu.text.PluralRules;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.TreeMap;

public final class PluralRulesLoader
extends PluralRules.Factory {
    private final Map<String, PluralRules> pluralRulesCache = new HashMap<String, PluralRules>();
    private Map<String, String> localeIdToCardinalRulesId;
    private Map<String, String> localeIdToOrdinalRulesId;
    public static final PluralRulesLoader loader = new PluralRulesLoader();

    private PluralRulesLoader() {
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, String> getLocaleIdToRulesIdMap(PluralRules.PluralType type) {
        PluralRulesLoader pluralRulesLoader = this;
        TreeMap<String, String> treeMap = pluralRulesLoader;
        synchronized (pluralRulesLoader) {
            void var1_1;
            boolean bl = pluralRulesLoader.localeIdToCardinalRulesId != null;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (!bl) {
                Map<Object, Object> map;
                Object object;
                try {
                    String string;
                    Object object2;
                    int n;
                    object = PluralRulesLoader.getPluralBundle();
                    UResourceBundle uResourceBundle = ((UResourceBundle)object).get("locales");
                    treeMap = new TreeMap<String, String>();
                    map = new HashMap();
                    for (n = 0; n < uResourceBundle.getSize(); ++n) {
                        object2 = uResourceBundle.get(n);
                        string = ((UResourceBundle)object2).getKey();
                        object2 = ((UResourceBundle)object2).getString().intern();
                        treeMap.put(string, (String)object2);
                        if (map.containsKey(object2)) continue;
                        map.put(object2, new ULocale(string));
                    }
                    uResourceBundle = ((UResourceBundle)object).get("locales_ordinals");
                    map = new TreeMap();
                    for (n = 0; n < uResourceBundle.getSize(); ++n) {
                        object2 = uResourceBundle.get(n);
                        string = ((UResourceBundle)object2).getKey();
                        object2 = ((UResourceBundle)object2).getString().intern();
                        map.put(string, object2);
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    treeMap = Collections.emptyMap();
                    map = Collections.emptyMap();
                    Collections.emptyMap();
                }
                object = pluralRulesLoader;
                synchronized (object) {
                    if (pluralRulesLoader.localeIdToCardinalRulesId == null) {
                        pluralRulesLoader.localeIdToCardinalRulesId = treeMap;
                        pluralRulesLoader.localeIdToOrdinalRulesId = map;
                    }
                }
            }
            if (var1_1 == PluralRules.PluralType.CARDINAL) {
                return this.localeIdToCardinalRulesId;
            }
            return this.localeIdToOrdinalRulesId;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final PluralRules getOrCreateRulesForLocale(ULocale locale, PluralRules.PluralType type) {
        boolean hasRules;
        int n;
        Object object = type;
        Object object2 = locale;
        type = this;
        type = ((PluralRulesLoader)type).getLocaleIdToRulesIdMap((PluralRules.PluralType)((Object)object));
        object2 = ULocale.canonicalize(((ULocale)object2).getBaseName());
        while (null == (object = (String)type.get(object2)) && (n = ((String)object2).lastIndexOf("_")) != -1) {
            object2 = ((String)object2).substring(0, n);
        }
        Object rulesId = object;
        if (rulesId == null || ((String)rulesId).trim().length() == 0) {
            return null;
        }
        String rangesId = StandardPluralRanges.getSetForLocale(locale);
        String cacheKey = (String)rulesId + "/" + rangesId;
        PluralRules rules = null;
        Map<String, PluralRules> map = this.pluralRulesCache;
        synchronized (map) {
            hasRules = this.pluralRulesCache.containsKey(cacheKey);
            if (hasRules) {
                rules = this.pluralRulesCache.get(cacheKey);
            }
        }
        if (!hasRules) {
            try {
                void var1_1;
                map = PluralRulesLoader.getPluralBundle();
                UResourceBundle hasRules2 = ((UResourceBundle)((Object)map)).get("rules");
                UResourceBundle setb = hasRules2.get((String)rulesId);
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < setb.getSize(); ++i) {
                    UResourceBundle b = setb.get(i);
                    if (i > 0) {
                        sb.append("; ");
                    }
                    sb.append(b.getKey());
                    sb.append(": ");
                    sb.append(b.getString());
                }
                StandardPluralRanges ranges = StandardPluralRanges.forSet((String)var1_1);
                rules = PluralRules.newInternal(sb.toString(), ranges);
            }
            catch (ParseException parseException) {
            }
            catch (MissingResourceException missingResourceException) {}
            map = this.pluralRulesCache;
            synchronized (map) {
                if (this.pluralRulesCache.containsKey(cacheKey)) {
                    rules = this.pluralRulesCache.get(cacheKey);
                } else {
                    this.pluralRulesCache.put((String)object2, rules);
                }
            }
        }
        return rules;
    }

    private static UResourceBundle getPluralBundle() throws MissingResourceException {
        return ICUResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt73b", "plurals", ICUResourceBundle.ICU_DATA_CLASS_LOADER, true);
    }
}

