/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ICUBinary;
import com.ibm.icu.text.RuleBasedBreakIterator;
import com.ibm.icu.util.CodePointTrie;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public final class RBBIDataWrapper {
    public RBBIDataHeader fHeader;
    public RBBIStateTable fFTable;
    public RBBIStateTable fRTable;
    public CodePointTrie fTrie;
    public String fRuleSource;
    private static final IsAcceptable IS_ACCEPTABLE = new IsAcceptable(0);

    public final int getRowIndex(int state) {
        return state * (this.fHeader.fCatCount + 3);
    }

    RBBIDataWrapper() {
    }

    /*
     * WARNING - void declaration
     */
    public static RBBIDataWrapper get(ByteBuffer bytes) throws IOException {
        void var1_1;
        RBBIDataWrapper rBBIDataWrapper;
        void var2_2;
        RBBIDataWrapper This = new RBBIDataWrapper();
        ICUBinary.readHeader(bytes, 1114794784, IS_ACCEPTABLE);
        This.fHeader = new RBBIDataHeader();
        This.fHeader.fMagic = bytes.getInt();
        This.fHeader.fFormatVersion[0] = bytes.get();
        This.fHeader.fFormatVersion[1] = bytes.get();
        This.fHeader.fFormatVersion[2] = bytes.get();
        This.fHeader.fFormatVersion[3] = bytes.get();
        This.fHeader.fLength = bytes.getInt();
        This.fHeader.fCatCount = bytes.getInt();
        This.fHeader.fFTable = bytes.getInt();
        This.fHeader.fFTableLen = bytes.getInt();
        This.fHeader.fRTable = bytes.getInt();
        This.fHeader.fRTableLen = bytes.getInt();
        This.fHeader.fTrie = bytes.getInt();
        bytes.getInt();
        This.fHeader.fRuleSource = bytes.getInt();
        This.fHeader.fRuleSourceLen = bytes.getInt();
        This.fHeader.fStatusTable = bytes.getInt();
        This.fHeader.fStatusTableLen = bytes.getInt();
        ICUBinary.skipBytes(bytes, 24);
        if (This.fHeader.fMagic != 45472 || !IS_ACCEPTABLE.isDataVersionAcceptable(This.fHeader.fFormatVersion)) {
            throw new IOException("Break Iterator Rule Data Magic Number Incorrect, or unsupported data version.");
        }
        if (This.fHeader.fFTable < 80 || This.fHeader.fFTable > This.fHeader.fLength) {
            throw new IOException("Break iterator Rule data corrupt");
        }
        ICUBinary.skipBytes(bytes, This.fHeader.fFTable - 80);
        int pos = This.fHeader.fFTable;
        This.fFTable = RBBIStateTable.get(bytes, This.fHeader.fFTableLen);
        ICUBinary.skipBytes(bytes, This.fHeader.fRTable - (pos += This.fHeader.fFTableLen));
        pos = This.fHeader.fRTable;
        This.fRTable = RBBIStateTable.get(bytes, This.fHeader.fRTableLen);
        ICUBinary.skipBytes(bytes, This.fHeader.fTrie - (pos += This.fHeader.fRTableLen));
        pos = This.fHeader.fTrie;
        bytes.mark();
        This.fTrie = CodePointTrie.fromBinary(CodePointTrie.Type.FAST, null, bytes);
        bytes.reset();
        if (pos > This.fHeader.fStatusTable) {
            throw new IOException("Break iterator Rule data corrupt");
        }
        ICUBinary.skipBytes(bytes, This.fHeader.fStatusTable - pos);
        pos = This.fHeader.fStatusTable;
        ICUBinary.getInts(bytes, This.fHeader.fStatusTableLen / 4, This.fHeader.fStatusTableLen & 3);
        if ((pos += This.fHeader.fStatusTableLen) > This.fHeader.fRuleSource) {
            throw new IOException("Break iterator Rule data corrupt");
        }
        ICUBinary.skipBytes(bytes, This.fHeader.fRuleSource - var2_2);
        This.fRuleSource = new String(ICUBinary.getBytes((ByteBuffer)((Object)rBBIDataWrapper), This.fHeader.fRuleSourceLen, 0), StandardCharsets.UTF_8);
        if (RuleBasedBreakIterator.fDebugEnv != null && RuleBasedBreakIterator.fDebugEnv.indexOf("data") >= 0) {
            PrintStream printStream = System.out;
            rBBIDataWrapper = This;
            if (rBBIDataWrapper.fFTable == null) {
                throw new NullPointerException();
            }
            printStream.println("RBBI Data Wrapper dump ...");
            printStream.println();
            printStream.println("Forward State Table");
            super.dumpTable(printStream, rBBIDataWrapper.fFTable);
            printStream.println("Reverse State Table");
            super.dumpTable(printStream, rBBIDataWrapper.fRTable);
            super.dumpCharCategories(printStream);
            printStream.println("Source Rules: " + rBBIDataWrapper.fRuleSource);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static String intToString(int n, int width) {
        void var2_2;
        int n2;
        StringBuilder dest = new StringBuilder(width);
        dest.append(n2);
        while (dest.length() < width) {
            dest.insert(0, ' ');
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String intToHexString(int n, int width) {
        void var1_2;
        int n2;
        StringBuilder dest = new StringBuilder(10);
        dest.append(Integer.toHexString(n2));
        while (dest.length() < 10) {
            dest.insert(0, ' ');
        }
        return var1_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    private void dumpTable(PrintStream out, RBBIStateTable table) {
        void var1_1;
        int n;
        if (table == null || table.fTable.length == 0) {
            out.println("  -- null -- ");
            return;
        }
        StringBuilder header = new StringBuilder(" Row  Acc Look  Tag");
        for (n = 0; n < this.fHeader.fCatCount; n = (int)((char)(n + 1))) {
            header.append(RBBIDataWrapper.intToString(n, 5));
        }
        out.println(header.toString());
        for (n = 0; n < header.length(); n = (int)((char)(n + 1))) {
            out.print("-");
        }
        out.println();
        for (char state = '\u0000'; state < table.fNumStates; state = (char)(state + '\u0001')) {
            this.dumpRow(out, table, state);
        }
        var1_1.println();
    }

    /*
     * WARNING - void declaration
     */
    private void dumpRow(PrintStream out, RBBIStateTable table, char state) {
        void var1_1;
        StringBuilder dest = new StringBuilder(this.fHeader.fCatCount * 5 + 20);
        dest.append(RBBIDataWrapper.intToString(state, 4));
        int row = this.getRowIndex(state);
        if (table.fTable[row] != '\u0000') {
            dest.append(RBBIDataWrapper.intToString(table.fTable[row], 5));
        } else {
            dest.append("     ");
        }
        if (table.fTable[row + 1] != '\u0000') {
            dest.append(RBBIDataWrapper.intToString(table.fTable[row + 1], 5));
        } else {
            dest.append("     ");
        }
        dest.append(RBBIDataWrapper.intToString(table.fTable[row + 2], 5));
        for (int col = 0; col < this.fHeader.fCatCount; ++col) {
            dest.append(RBBIDataWrapper.intToString(table.fTable[row + 3 + col], 5));
        }
        var1_1.println(dest);
    }

    /*
     * WARNING - void declaration
     */
    private void dumpCharCategories(PrintStream out) {
        void var1_1;
        int category;
        int n = this.fHeader.fCatCount;
        String[] catStrings = new String[n + 1];
        int rangeStart = 0;
        int rangeEnd = 0;
        int lastCat = -1;
        int[] lastNewline = new int[n + 1];
        for (category = 0; category <= this.fHeader.fCatCount; ++category) {
            catStrings[category] = "";
        }
        out.println("\nCharacter Categories");
        out.println("--------------------");
        for (int char32 = 0; char32 <= 0x10FFFF; ++char32) {
            category = this.fTrie.get(char32);
            if (category < 0 || category > this.fHeader.fCatCount) {
                out.println("Error, bad category " + Integer.toHexString(category) + " for char " + Integer.toHexString(char32));
                break;
            }
            if (category == lastCat) {
                rangeEnd = char32;
                continue;
            }
            if (lastCat >= 0) {
                if (catStrings[lastCat].length() > lastNewline[lastCat] + 70) {
                    lastNewline[lastCat] = catStrings[lastCat].length() + 10;
                    int n2 = lastCat;
                    catStrings[n2] = catStrings[n2] + "\n       ";
                }
                int n3 = lastCat;
                catStrings[n3] = catStrings[n3] + " " + Integer.toHexString(rangeStart);
                if (rangeEnd != rangeStart) {
                    int n4 = lastCat;
                    catStrings[n4] = catStrings[n4] + "-" + Integer.toHexString(rangeEnd);
                }
            }
            lastCat = category;
            rangeStart = rangeEnd = char32;
        }
        int n5 = lastCat;
        catStrings[n5] = catStrings[n5] + " " + Integer.toHexString(rangeStart);
        if (rangeEnd != rangeStart) {
            int n6 = lastCat;
            catStrings[n6] = catStrings[n6] + "-" + Integer.toHexString(rangeEnd);
        }
        for (category = 0; category <= this.fHeader.fCatCount; ++category) {
            out.println(RBBIDataWrapper.intToString(category, 5) + "  " + catStrings[category]);
        }
        var1_1.println();
    }

    public static final class RBBIDataHeader {
        int fMagic = 0;
        byte[] fFormatVersion = new byte[4];
        int fLength;
        public int fCatCount;
        int fFTable;
        int fFTableLen;
        int fRTable;
        int fRTableLen;
        int fTrie;
        int fRuleSource;
        int fRuleSourceLen;
        int fStatusTable;
        int fStatusTableLen;
    }

    static final class IsAcceptable
    implements ICUBinary.Authenticate {
        private IsAcceptable() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean isDataVersionAcceptable(byte[] version) {
            void var1_1;
            int n = (version[0] << 24) + (version[1] << 16) + (version[2] << 8) + var1_1[3];
            return n == 0x6000000;
        }

        /* synthetic */ IsAcceptable(byte by) {
            this();
        }
    }

    public static final class RBBIStateTable {
        public int fNumStates;
        private int fRowLen;
        public int fDictCategoriesStart;
        public int fLookAheadResultsSize;
        public int fFlags;
        private static int fHeaderSize = 20;
        public char[] fTable;

        /*
         * WARNING - void declaration
         */
        static RBBIStateTable get(ByteBuffer bytes, int length) throws IOException {
            void var2_2;
            if (length == 0) {
                return null;
            }
            if (length < fHeaderSize) {
                throw new IOException("Invalid RBBI state table length.");
            }
            RBBIStateTable This = new RBBIStateTable();
            new RBBIStateTable().fNumStates = bytes.getInt();
            This.fRowLen = bytes.getInt();
            This.fDictCategoriesStart = bytes.getInt();
            This.fLookAheadResultsSize = bytes.getInt();
            This.fFlags = bytes.getInt();
            int lengthOfTable = length - fHeaderSize;
            boolean bl = (This.fFlags & 4) == 4;
            if (bl) {
                This.fTable = new char[lengthOfTable];
                for (int i = 0; i < lengthOfTable; ++i) {
                    byte b = bytes.get();
                    This.fTable[i] = (char)(0xFF & b);
                }
                ICUBinary.skipBytes(bytes, lengthOfTable & 1);
            } else {
                void var1_1;
                ByteBuffer byteBuffer;
                This.fTable = ICUBinary.getChars(byteBuffer, lengthOfTable / 2, var1_1 & 1);
            }
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object other) {
            void var1_1;
            if (other == this) {
                return true;
            }
            if (!(other instanceof RBBIStateTable)) {
                return false;
            }
            RBBIStateTable otherST = (RBBIStateTable)other;
            if (this.fNumStates != otherST.fNumStates) {
                return false;
            }
            if (this.fRowLen != otherST.fRowLen) {
                return false;
            }
            if (this.fDictCategoriesStart != otherST.fDictCategoriesStart) {
                return false;
            }
            if (this.fLookAheadResultsSize != otherST.fLookAheadResultsSize) {
                return false;
            }
            if (this.fFlags != otherST.fFlags) {
                return false;
            }
            return Arrays.equals(this.fTable, var1_1.fTable);
        }
    }
}

