/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import androidx.compose.animation.core.AnimationSpecKt;
import com.ibm.icu.impl.PatternProps;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.SymbolTable;
import java.text.ParsePosition;

public final class RuleCharacterIterator {
    private String text;
    private ParsePosition pos;
    private SymbolTable sym;
    private String buf;
    private int bufPos;
    private boolean isEscaped;

    /*
     * WARNING - void declaration
     */
    public RuleCharacterIterator(String text, SymbolTable sym, ParsePosition pos) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (text == null || pos.getIndex() > text.length()) {
            throw new IllegalArgumentException();
        }
        this.text = var1_1;
        this.sym = var2_2;
        this.pos = var3_3;
        this.buf = null;
    }

    public final boolean atEnd() {
        return this.buf == null && this.pos.getIndex() == this.text.length();
    }

    /*
     * WARNING - void declaration
     */
    public final int next(int options) {
        int n;
        block7: {
            void var1_1;
            this.isEscaped = false;
            while (true) {
                int c = this._current();
                this._advance(AnimationSpecKt.getCharCount((int)c));
                if (c == 36 && this.buf == null && (options & 1) != 0 && this.sym != null) {
                    this.text.length();
                    String name = this.sym.parseReference$17476cf8();
                    if (name != null) {
                        void var2_3;
                        this.bufPos = 0;
                        char[] chars = this.sym.lookup$505d7141();
                        if (chars == null) {
                            this.buf = null;
                            throw new IllegalArgumentException("Undefined variable: " + name);
                        }
                        if (chars.length == 0) {
                            this.buf = null;
                        }
                        this.buf = new String((char[])var2_3);
                        continue;
                    }
                    break block7;
                }
                if ((options & 4) == 0 || !PatternProps.isWhiteSpace(n)) break;
            }
            if (n == 92 && (var1_1 & 2) != 0) {
                void var3_5;
                int cpAndLength = Utility.unescapeAndLengthAt(this.getCurrentBuffer(), this.getCurrentBufferPos());
                if (cpAndLength < 0) {
                    throw new IllegalArgumentException("Invalid escape");
                }
                n = Utility.cpFromCodePointAndLength(cpAndLength);
                this.jumpahead(Utility.lengthFromCodePointAndLength((int)var3_5));
                this.isEscaped = true;
            }
        }
        return n;
    }

    public final boolean isEscaped() {
        return this.isEscaped;
    }

    public final boolean inVariable() {
        return this.buf != null;
    }

    /*
     * WARNING - void declaration
     */
    public final Position getPos(Position p) {
        void var1_1;
        if (p == null) {
            p = new Position();
        }
        Position.access$002(p, this.buf);
        Position.access$102(p, this.bufPos);
        Position.access$202(p, this.pos.getIndex());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setPos(Position p) {
        void var1_1;
        this.buf = p.buf;
        this.pos.setIndex(p.posIndex);
        this.bufPos = ((Position)var1_1).bufPos;
    }

    /*
     * WARNING - void declaration
     */
    public final void skipIgnored(int options) {
        if ((options & 4) != 0) {
            int a;
            while (PatternProps.isWhiteSpace(a = this._current())) {
                void var1_1;
                this._advance(AnimationSpecKt.getCharCount((int)var1_1));
            }
        }
    }

    public final String getCurrentBuffer() {
        if (this.buf != null) {
            return this.buf;
        }
        return this.text;
    }

    public final int getCurrentBufferPos() {
        if (this.buf != null) {
            return this.bufPos;
        }
        return this.pos.getIndex();
    }

    /*
     * WARNING - void declaration
     */
    public final void jumpahead(int count) {
        if (count < 0) {
            throw new IllegalArgumentException();
        }
        if (this.buf != null) {
            this.bufPos += count;
            if (this.bufPos > this.buf.length()) {
                throw new IllegalArgumentException();
            }
            if (this.bufPos == this.buf.length()) {
                this.buf = null;
                return;
            }
        } else {
            void var1_1;
            int i = this.pos.getIndex() + count;
            this.pos.setIndex(i);
            if (var1_1 > this.text.length()) {
                throw new IllegalArgumentException();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        int b = this.pos.getIndex();
        return this.text.substring(0, b) + '|' + this.text.substring((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private int _current() {
        if (this.buf != null) {
            return AnimationSpecKt.charAt((String)this.buf, (int)this.bufPos);
        }
        int i = this.pos.getIndex();
        if (i < this.text.length()) {
            void var1_1;
            return AnimationSpecKt.charAt((String)this.text, (int)var1_1);
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private void _advance(int count) {
        if (this.buf != null) {
            this.bufPos += count;
            if (this.bufPos == this.buf.length()) {
                this.buf = null;
                return;
            }
        } else {
            void var1_1;
            this.pos.setIndex(this.pos.getIndex() + var1_1);
            if (this.pos.getIndex() > this.text.length()) {
                this.pos.setIndex(this.text.length());
            }
        }
    }

    public static final class Position {
        private String buf;
        private int bufPos;
        private int posIndex;

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ String access$002(Position x0, String x1) {
            void var1_1;
            x0.buf = var1_1;
            return x0.buf;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ int access$102(Position x0, int x1) {
            void var1_1;
            x0.bufPos = var1_1;
            return x0.bufPos;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ int access$202(Position x0, int x1) {
            void var1_1;
            x0.posIndex = var1_1;
            return x0.posIndex;
        }
    }
}

