/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ICUBinary;
import com.ibm.icu.impl.Trie2_16;
import com.ibm.icu.impl.Trie2_32;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;

public abstract class Trie2
implements Iterable<Range> {
    private static ValueMapper defaultValueMapper = new ValueMapper(){

        @Override
        public final int map(int in) {
            return in;
        }
    };
    UTrie2Header header;
    char[] index;
    private int data16;
    int[] data32;
    private int indexLength;
    int dataLength;
    int index2NullOffset;
    int initialValue;
    int errorValue;
    int highStart;
    int highValueIndex;
    int dataNullOffset;
    private int fHash;

    /*
     * WARNING - void declaration
     */
    public static Trie2 createFromSerialized(ByteBuffer bytes) throws IOException {
        Trie2 trie2;
        ByteOrder outerByteOrder = bytes.order();
        try {
            void var3_7;
            void var2_3;
            Trie2 This;
            ValueWidth width;
            UTrie2Header header = new UTrie2Header();
            new UTrie2Header().signature = bytes.getInt();
            switch (header.signature) {
                case 1416784178: {
                    break;
                }
                case 845771348: {
                    boolean isBigEndian = outerByteOrder == ByteOrder.BIG_ENDIAN;
                    bytes.order(isBigEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
                    header.signature = 1416784178;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Buffer does not contain a serialized UTrie2");
                }
            }
            header.options = bytes.getChar();
            header.indexLength = bytes.getChar();
            header.shiftedDataLength = bytes.getChar();
            header.index2NullOffset = bytes.getChar();
            header.dataNullOffset = bytes.getChar();
            header.shiftedHighStart = bytes.getChar();
            if ((header.options & 0xF) > 1) {
                throw new IllegalArgumentException("UTrie2 serialized format error.");
            }
            if ((header.options & 0xF) == 0) {
                width = ValueWidth.BITS_16;
                This = new Trie2_16();
            } else {
                width = ValueWidth.BITS_32;
                This = new Trie2_32();
            }
            This.header = header;
            This.indexLength = header.indexLength;
            This.dataLength = header.shiftedDataLength << 2;
            This.index2NullOffset = header.index2NullOffset;
            This.dataNullOffset = header.dataNullOffset;
            This.highStart = header.shiftedHighStart << 11;
            This.highValueIndex = This.dataLength - 4;
            if (width == ValueWidth.BITS_16) {
                This.highValueIndex += This.indexLength;
            }
            int indexArraySize = This.indexLength;
            if (width == ValueWidth.BITS_16) {
                indexArraySize += This.dataLength;
            }
            This.index = ICUBinary.getChars(bytes, (int)var2_3, 0);
            if (width == ValueWidth.BITS_16) {
                This.data16 = This.indexLength;
            } else {
                This.data32 = ICUBinary.getInts(bytes, This.dataLength, 0);
            }
            switch (2.$SwitchMap$com$ibm$icu$impl$Trie2$ValueWidth[var3_7.ordinal()]) {
                case 1: {
                    This.data32 = null;
                    This.initialValue = This.index[This.dataNullOffset];
                    This.errorValue = This.index[This.data16 + 128];
                    break;
                }
                case 2: {
                    This.data16 = 0;
                    This.initialValue = This.data32[This.dataNullOffset];
                    This.errorValue = This.data32[128];
                    break;
                }
                default: {
                    throw new IllegalArgumentException("UTrie2 serialized format error.");
                }
            }
            trie2 = This;
            bytes.order(outerByteOrder);
        }
        catch (Throwable throwable) {
            void var1_1;
            ByteBuffer byteBuffer;
            byteBuffer.order((ByteOrder)var1_1);
            throw throwable;
        }
        return trie2;
    }

    public abstract int get(int var1);

    public abstract int getFromU16SingleLead(char var1);

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        void var3_2;
        if (!(other instanceof Trie2)) {
            return false;
        }
        Trie2 OtherTrie = (Trie2)other;
        Iterator<Range> otherIter = OtherTrie.iterator();
        for (Range rangeFromThis : this) {
            void var2_4;
            if (!otherIter.hasNext()) {
                return false;
            }
            Range rangeFromOther = otherIter.next();
            if (rangeFromThis.equals(var2_4)) continue;
            return false;
        }
        if (var3_2.hasNext()) {
            return false;
        }
        return this.errorValue == OtherTrie.errorValue && this.initialValue == var1_1.initialValue;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        if (this.fHash == 0) {
            void var1_1;
            int hash = -2128831035;
            for (Range r : this) {
                void var3_3;
                hash = Trie2.hashInt(hash, var3_3.hashCode());
            }
            if (hash == 0) {
                hash = 1;
            }
            this.fHash = var1_1;
        }
        return this.fHash;
    }

    @Override
    public Iterator<Range> iterator() {
        ValueMapper valueMapper = defaultValueMapper;
        Trie2 trie2 = this;
        return new Trie2Iterator(trie2, valueMapper);
    }

    /*
     * WARNING - void declaration
     */
    int rangeEnd(int start, int limitp, int val) {
        void var1_1;
        int c;
        int limit = Math.min(this.highStart, limitp);
        for (c = start + 1; c < limit && this.get(c) == val; ++c) {
        }
        if (c >= this.highStart) {
            void var2_2;
            c = var2_2;
        }
        return (int)(var1_1 - true);
    }

    /*
     * WARNING - void declaration
     */
    private static int hashByte(int h, int b) {
        void var1_1;
        int n = h * 16777619;
        return n ^= var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static int hashInt(int h, int i) {
        void var1_1;
        int n = Trie2.hashByte(h, i & 0xFF);
        n = Trie2.hashByte(n, i >> 8 & 0xFF);
        n = Trie2.hashByte(n, i >> 16 & 0xFF);
        n = Trie2.hashByte(n, (int)(var1_1 >>> 24));
        return n;
    }

    static /* synthetic */ int access$000() {
        return -2128831035;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$100(int x0, int x1) {
        void var1_1;
        int n = x0;
        n = Trie2.hashByte(n, var1_1 & 0xFF);
        n = Trie2.hashByte(n, var1_1 >> 8 & 0xFF);
        n = Trie2.hashByte(n, (int)(var1_1 >> 16));
        return n;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$200(int x0, int x1) {
        void var1_1;
        return Trie2.hashInt(x0, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$300(int x0, int x1) {
        void var1_1;
        return Trie2.hashByte(x0, (int)var1_1);
    }

    final class Trie2Iterator
    implements Iterator<Range> {
        private ValueMapper mapper;
        private Range returnValue = new Range();
        private int nextStart;
        private int limitCP;
        private boolean doingCodePoints = true;
        private boolean doLeadSurrogates = true;
        private /* synthetic */ Trie2 this$0;

        /*
         * WARNING - void declaration
         */
        Trie2Iterator(Trie2 this$0, ValueMapper vm) {
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.mapper = var2_2;
            this.nextStart = 0;
            this.limitCP = 0x110000;
            this.doLeadSurrogates = true;
        }

        @Override
        public final boolean hasNext() {
            return this.doingCodePoints && (this.doLeadSurrogates || this.nextStart < this.limitCP) || this.nextStart < 56320;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - void declaration
         */
        private int rangeEndLS(char startingLS) {
            void var1_1;
            if (startingLS >= '\udbff') {
                return 56319;
            }
            int val = this.this$0.getFromU16SingleLead(startingLS);
            for (int c = startingLS + '\u0001'; c <= 56319 && this.this$0.getFromU16SingleLead((char)c) == val; ++c) {
            }
            return (int)(var1_1 - true);
        }
    }

    static final class UTrie2Header {
        int signature;
        int options;
        int indexLength;
        int shiftedDataLength;
        int index2NullOffset;
        int dataNullOffset;
        int shiftedHighStart;

        UTrie2Header() {
        }
    }

    static final class ValueWidth
    extends Enum<ValueWidth> {
        public static final /* enum */ ValueWidth BITS_16 = new ValueWidth();
        public static final /* enum */ ValueWidth BITS_32 = new ValueWidth();
        private static final /* synthetic */ ValueWidth[] $VALUES;

        public static ValueWidth[] values() {
            return (ValueWidth[])$VALUES.clone();
        }

        static {
            $VALUES = new ValueWidth[]{BITS_16, BITS_32};
        }
    }

    public static interface ValueMapper {
        public int map(int var1);
    }

    public static final class Range {
        public int startCodePoint;
        public int endCodePoint;
        public int value;
        public boolean leadSurrogate;

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object other) {
            void var1_1;
            if (other == null || !other.getClass().equals(this.getClass())) {
                return false;
            }
            Range tother = (Range)other;
            return this.startCodePoint == tother.startCodePoint && this.endCodePoint == tother.endCodePoint && this.value == tother.value && this.leadSurrogate == var1_1.leadSurrogate;
        }

        public final int hashCode() {
            int n = Trie2.access$000();
            n = Trie2.access$100(n, this.startCodePoint);
            n = Trie2.access$100(n, this.endCodePoint);
            n = Trie2.access$200(n, this.value);
            n = Trie2.access$300(n, this.leadSurrogate ? 1 : 0);
            return n;
        }
    }
}

