/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ICUBinary;
import com.ibm.icu.impl.Trie2;
import com.ibm.icu.impl.Trie2_16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ICUUncheckedIOException;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class UBiDiProps {
    private int[] indexes;
    private int[] mirrors;
    private byte[] jgArray;
    private byte[] jgArray2;
    private Trie2_16 trie;
    public static final UBiDiProps INSTANCE;

    /*
     * WARNING - void declaration
     */
    private UBiDiProps() throws IOException {
        void var1_1;
        ByteBuffer bytes = ICUBinary.getData("ubidi.icu");
        this.readData((ByteBuffer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void readData(ByteBuffer bytes) throws IOException {
        void var1_1;
        int n;
        void var2_3;
        ICUBinary.readHeader(bytes, 1114195049, new IsAcceptable(0));
        int count = bytes.getInt();
        if (count < 16) {
            throw new IOException("indexes[0] too small in ubidi.icu");
        }
        this.indexes = new int[count];
        this.indexes[0] = count;
        for (int i = 1; i < count; ++i) {
            this.indexes[i] = bytes.getInt();
        }
        this.trie = Trie2_16.createFromSerialized(bytes);
        int expectedTrieLength = this.indexes[2];
        int trieLength = this.trie.getSerializedLength();
        if (trieLength > expectedTrieLength) {
            throw new IOException("ubidi.icu: not enough bytes for the trie");
        }
        ICUBinary.skipBytes(bytes, (int)(var2_3 - n));
        n = this.indexes[3];
        if (n > 0) {
            this.mirrors = ICUBinary.getInts(bytes, n, 0);
        }
        n = this.indexes[5] - this.indexes[4];
        this.jgArray = new byte[n];
        bytes.get(this.jgArray);
        n = this.indexes[7] - this.indexes[6];
        this.jgArray2 = new byte[n];
        var1_1.get(this.jgArray2);
    }

    public final void addPropertyStarts(UnicodeSet set) {
        int i;
        for (Trie2.Range range : this.trie) {
            if (range.leadSurrogate) break;
            set.add(range.startCodePoint);
        }
        int length = this.indexes[3];
        for (i = 0; i < length; ++i) {
            int c;
            int n = this.mirrors[i];
            int n2 = c = n & 0x1FFFFF;
            set.add(n2, n2 + 1);
        }
        int start = this.indexes[4];
        int limit = this.indexes[5];
        byte[] jga = this.jgArray;
        while (true) {
            length = limit - start;
            byte prev = 0;
            for (i = 0; i < length; ++i) {
                byte jg = jga[i];
                if (jg != prev) {
                    set.add(start);
                    prev = jg;
                }
                ++start;
            }
            if (prev != 0) {
                set.add(limit);
            }
            if (limit != this.indexes[5]) break;
            start = this.indexes[6];
            limit = this.indexes[7];
            jga = this.jgArray2;
        }
    }

    public final int getClass(int c) {
        int n;
        n = this.trie.get(n);
        return n & 0x1F;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isMirrored(int c) {
        void var1_1;
        return UBiDiProps.getFlagFromProps(this.trie.get((int)var1_1), 12);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isBidiControl(int c) {
        void var1_1;
        return UBiDiProps.getFlagFromProps(this.trie.get((int)var1_1), 11);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isJoinControl(int c) {
        void var1_1;
        return UBiDiProps.getFlagFromProps(this.trie.get((int)var1_1), 10);
    }

    /*
     * WARNING - void declaration
     */
    public final int getJoiningType(int c) {
        void var1_1;
        return (this.trie.get((int)var1_1) & 0xE0) >> 5;
    }

    /*
     * WARNING - void declaration
     */
    public final int getJoiningGroup(int c) {
        void var3_3;
        int start = this.indexes[4];
        int limit = this.indexes[5];
        if (start <= c && c < limit) {
            return this.jgArray[c - start] & 0xFF;
        }
        start = this.indexes[6];
        limit = this.indexes[7];
        if (start <= c && c < var3_3) {
            void var2_2;
            void var1_1;
            return this.jgArray2[var1_1 - var2_2] & 0xFF;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public final int getPairedBracketType(int c) {
        void var1_1;
        return (this.trie.get((int)var1_1) & 0x300) >> 8;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean getFlagFromProps(int props, int shift) {
        void var1_1;
        return (props >> var1_1 & 1) != 0;
    }

    /*
     * WARNING - void declaration
     */
    static {
        try {
            INSTANCE = new UBiDiProps();
            return;
        }
        catch (IOException e) {
            void var0;
            throw new ICUUncheckedIOException((Throwable)var0);
        }
    }

    static final class IsAcceptable
    implements ICUBinary.Authenticate {
        private IsAcceptable() {
        }

        @Override
        public final boolean isDataVersionAcceptable(byte[] version) {
            return version[0] == 2;
        }

        /* synthetic */ IsAcceptable(byte by) {
            this();
        }
    }
}

