/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import androidx.compose.animation.core.AnimationSpecKt;
import com.ibm.icu.impl.ICUBinary;
import com.ibm.icu.impl.Trie2;
import com.ibm.icu.impl.Trie2_16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ICUUncheckedIOException;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class UCaseProps {
    private static final byte[] flagsOffset = new byte[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8};
    public static final StringBuilder dummyStringBuilder = new StringBuilder();
    private int[] indexes;
    private String exceptions;
    private char[] unfold;
    private Trie2_16 trie;
    public static final UCaseProps INSTANCE;

    /*
     * WARNING - void declaration
     */
    private UCaseProps() throws IOException {
        void var1_1;
        ByteBuffer bytes = ICUBinary.getRequiredData("ucase.icu");
        this.readData((ByteBuffer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final void readData(ByteBuffer bytes) throws IOException {
        int n;
        void var3_3;
        ICUBinary.readHeader(bytes, 1665225541, new IsAcceptable(0));
        int count = bytes.getInt();
        if (count < 16) {
            throw new IOException("indexes[0] too small in ucase.icu");
        }
        this.indexes = new int[count];
        this.indexes[0] = count;
        for (int i = 1; i < count; ++i) {
            this.indexes[i] = bytes.getInt();
        }
        this.trie = Trie2_16.createFromSerialized(bytes);
        int expectedTrieLength = this.indexes[2];
        int trieLength = this.trie.getSerializedLength();
        if (trieLength > expectedTrieLength) {
            throw new IOException("ucase.icu: not enough bytes for the trie");
        }
        ICUBinary.skipBytes(bytes, (int)(var3_3 - n));
        n = this.indexes[3];
        if (n > 0) {
            this.exceptions = ICUBinary.getString(bytes, n, 0);
        }
        if ((n = this.indexes[4]) > 0) {
            void var1_1;
            this.unfold = ICUBinary.getChars((ByteBuffer)var1_1, n, 0);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void addPropertyStarts(UnicodeSet set) {
        for (Trie2.Range range : this.trie) {
            void var3_3;
            if (range.leadSurrogate) break;
            set.add(var3_3.startCodePoint);
        }
    }

    static final boolean propsHasException(int props) {
        return (props & 8) != 0;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean hasSlot(int flags, int index) {
        void var1_1;
        return (flags & 1 << var1_1) != 0;
    }

    /*
     * WARNING - void declaration
     */
    private static final byte slotOffset(int flags, int index) {
        void var1_1;
        int n;
        return flagsOffset[n & (1 << var1_1) - 1];
    }

    /*
     * WARNING - void declaration
     */
    private final long getSlotValueAndOffset(int excWord, int index, int excOffset) {
        void var3_3;
        long value;
        if ((excWord & 0x100) == 0) {
            value = this.exceptions.charAt(excOffset += UCaseProps.slotOffset(excWord, index));
        } else {
            void var2_2;
            void var1_1;
            excOffset += 2 * UCaseProps.slotOffset((int)var1_1, (int)var2_2);
            value = this.exceptions.charAt(excOffset++);
            value = value << 16 | (long)this.exceptions.charAt(excOffset);
        }
        return value | (long)var3_3 << 32;
    }

    /*
     * WARNING - void declaration
     */
    private final int getSlotValue(int excWord, int index, int excOffset) {
        void var1_1;
        int value;
        if ((excWord & 0x100) == 0) {
            value = this.exceptions.charAt(excOffset += UCaseProps.slotOffset(excWord, index));
        } else {
            void var3_3;
            void var2_2;
            excOffset += 2 * UCaseProps.slotOffset(value, (int)var2_2);
            value = this.exceptions.charAt(excOffset++);
            value = value << 16 | this.exceptions.charAt((int)var3_3);
        }
        return (int)var1_1;
    }

    public final void addCaseClosure(int c, UnicodeSet set) {
        int delta;
        int props = this.trie.get(c);
        if (!UCaseProps.propsHasException(props)) {
            int n = props;
            if ((n & 3) != 0) {
                n = props;
                delta = (short)n >> 7;
                if (delta != 0) {
                    set.add(c + delta);
                }
                return;
            }
        } else {
            int closureOffset;
            int closureLength;
            long value;
            void var4_5 = delta;
            int excOffset = var4_5 >> 4;
            char excWord = this.exceptions.charAt(excOffset++);
            void excOffset0 = excOffset;
            if ((excWord & 0x8000) != 0) {
                if (c == 73) {
                    set.add(105);
                    return;
                }
                if (c == 304) {
                    set.add("i\u0307");
                    return;
                }
            } else {
                if (c == 105) {
                    set.add(73);
                    return;
                }
                if (c == 305) {
                    return;
                }
            }
            for (int index = 0; index <= 3; ++index) {
                if (!UCaseProps.hasSlot(excWord, index)) continue;
                excOffset = excOffset0;
                int mapping = this.getSlotValue(excWord, index, excOffset);
                set.add(mapping);
            }
            if (UCaseProps.hasSlot(excWord, 4)) {
                excOffset = excOffset0;
                int delta2 = this.getSlotValue(excWord, 4, excOffset);
                set.add((excWord & 0x400) == 0 ? c + delta2 : c - delta2);
            }
            if (UCaseProps.hasSlot(excWord, 6)) {
                excOffset = excOffset0;
                value = this.getSlotValueAndOffset(excWord, 6, excOffset);
                closureLength = (int)value & 0xF;
                closureOffset = (int)(value >> 32) + 1;
            } else {
                closureLength = 0;
                closureOffset = 0;
            }
            if (UCaseProps.hasSlot(excWord, 7)) {
                excOffset = excOffset0;
                value = this.getSlotValueAndOffset(excWord, 7, excOffset);
                int fullLength = (int)value;
                excOffset = (int)(value >> 32) + 1;
                excOffset += (fullLength &= 0xFFFF) & 0xF;
                int length = (fullLength >>= 4) & 0xF;
                if (length != 0) {
                    int n = excOffset;
                    set.add(this.exceptions.substring(n, n + length));
                    excOffset += length;
                }
                excOffset += (fullLength >>= 4) & 0xF;
                closureOffset = var3_3 += (fullLength >>= 4);
            }
            int limit = closureOffset + closureLength;
            for (int index = closureOffset; index < limit; index += AnimationSpecKt.getCharCount((int)c)) {
                int mapping = this.exceptions.codePointAt(index);
                set.add(mapping);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void addOneSimpleCaseClosure(int c, int t, UnicodeSet set) {
        void var1_1;
        void var2_2;
        switch (c) {
            case 912: {
                if (t != 8147) break;
                return;
            }
            case 944: {
                if (t != 8163) break;
                return;
            }
            case 8147: {
                if (t != 912) break;
                return;
            }
            case 8163: {
                if (t != 944) break;
                return;
            }
            case 64261: {
                if (t != 64262) break;
                return;
            }
            case 64262: {
                if (t != 64261) break;
                return;
            }
        }
        var2_2.add((int)var1_1);
    }

    public final void addSimpleCaseClosure(int c, UnicodeSet set) {
        int delta;
        int props = this.trie.get(c);
        if (!UCaseProps.propsHasException(props)) {
            int n = props;
            if ((n & 3) != 0) {
                n = props;
                delta = (short)n >> 7;
                if (delta != 0) {
                    set.add(c + delta);
                }
                return;
            }
        } else {
            int closureOffset;
            int closureLength;
            long value;
            int mapping;
            void var4_5 = delta;
            int excOffset = var4_5 >> 4;
            char excWord = this.exceptions.charAt(excOffset++);
            void excOffset0 = excOffset;
            if ((excWord & 0x8000) != 0) {
                if (c == 73) {
                    set.add(105);
                    return;
                }
                if (c == 304) {
                    return;
                }
            } else {
                if (c == 105) {
                    set.add(73);
                    return;
                }
                if (c == 305) {
                    return;
                }
            }
            for (int index = 0; index <= 3; ++index) {
                if (!UCaseProps.hasSlot(excWord, index)) continue;
                excOffset = excOffset0;
                mapping = this.getSlotValue(excWord, index, excOffset);
                UCaseProps.addOneSimpleCaseClosure(c, mapping, set);
            }
            if (UCaseProps.hasSlot(excWord, 4)) {
                excOffset = excOffset0;
                int delta2 = this.getSlotValue(excWord, 4, excOffset);
                mapping = (excWord & 0x400) == 0 ? c + delta2 : c - delta2;
                UCaseProps.addOneSimpleCaseClosure(c, mapping, set);
            }
            if (UCaseProps.hasSlot(excWord, 6)) {
                excOffset = excOffset0;
                value = this.getSlotValueAndOffset(excWord, 6, excOffset);
                closureLength = (int)value & 0xF;
                closureOffset = (int)(value >> 32) + 1;
            } else {
                closureLength = 0;
                closureOffset = 0;
            }
            if (closureLength > 0 && UCaseProps.hasSlot(excWord, 7)) {
                excOffset = excOffset0;
                value = this.getSlotValueAndOffset(excWord, 7, excOffset);
                int fullLength = (int)value;
                excOffset = (int)(value >> 32) + 1;
                excOffset += (fullLength &= 0xFFFF) & 0xF;
                excOffset += (fullLength >>= 4) & 0xF;
                excOffset += (fullLength >>= 4) & 0xF;
                closureOffset = var3_3 += (fullLength >>= 4);
            }
            int limit = closureOffset + closureLength;
            for (int index = closureOffset; index < limit; index += AnimationSpecKt.getCharCount((int)c)) {
                int mapping2 = this.exceptions.codePointAt(index);
                UCaseProps.addOneSimpleCaseClosure(c, mapping2, set);
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final boolean addStringCaseClosure(String s, UnicodeSet set) {
        if (this.unfold == null || s == null) {
            return false;
        }
        length = s.length();
        if (length <= 1) {
            return false;
        }
        unfoldRows = this.unfold[0];
        unfoldRowWidth = this.unfold[1];
        unfoldStringWidth = this.unfold[2];
        if (length > unfoldStringWidth) {
            return false;
        }
        start = '\u0000';
        limit = unfoldRows;
        while (start < limit) {
            block13: {
                block12: {
                    i = (start + limit) / 2;
                    unfoldOffset = (i + 1) * unfoldRowWidth;
                    var12_16 = unfoldStringWidth;
                    var11_15 = unfoldOffset;
                    var10_13 = s;
                    var6_10 = this;
                    var14_18 = var10_13.length();
                    var12_16 -= var14_18;
                    var13_17 = '\u0000';
                    do {
                        var15_19 = var10_13.charAt(var13_17++);
                        if ((var16_20 = var6_10.unfold[var11_15++]) == '\u0000') {
                            v0 = '\u0001';
                        } else {
                            if ((var15_19 -= var16_20) == '\u0000') continue;
                            v0 = var15_19;
                        }
                        break block12;
                    } while (--var14_18 > '\u0000');
                    v0 = result = var12_16 == '\u0000' || var6_10.unfold[var11_15] == '\u0000' ? '\u0000' : -var12_16;
                }
                if (v0 != '\u0000') break block13;
                for (i = unfoldStringWidth; i < unfoldRowWidth && this.unfold[unfoldOffset + i] != '\u0000'; i += AnimationSpecKt.getCharCount((int)var1_2)) {
                    block15: {
                        block14: {
                            var12_16 = i;
                            var11_15 = this.unfold.length;
                            var10_14 = unfoldOffset;
                            result = this.unfold;
                            if ((var12_16 += var10_14) < var10_14 || var12_16 >= var11_15) {
                                throw new ArrayIndexOutOfBoundsException(var12_16);
                            }
                            var15_19 = var13_17 = result[var12_16];
                            if (!((var13_17 & -2048) == 55296)) ** GOTO lbl-1000
                            if (var13_17 > '\udbff') break block14;
                            if (++var12_16 >= var11_15 || !AnimationSpecKt.isTrailSurrogate((int)(var14_18 = result[var12_16]))) ** GOTO lbl-1000
                            v1 = Character.toCodePoint(var13_17, var14_18);
                            break block15;
                        }
                        if (var12_16 != var10_14 && AnimationSpecKt.isLeadSurrogate((int)(var14_18 = result[--var12_16]))) {
                            v1 = Character.toCodePoint(var14_18, var13_17);
                        } else lbl-1000:
                        // 3 sources

                        {
                            v1 = var13_17;
                        }
                    }
                    c = v1;
                    set.add(c);
                    this.addCaseClosure(c, set);
                }
                return true;
            }
            if (result < '\u0000') {
                limit = i;
                continue;
            }
            start = var3_4 + true;
        }
        return false;
    }

    public final int getType(int c) {
        int n;
        n = this.trie.get(n);
        return n & 3;
    }

    public final int getTypeOrIgnorable(int c) {
        int n;
        n = this.trie.get(n);
        return n & 7;
    }

    /*
     * WARNING - void declaration
     */
    private int getDotType(int c) {
        void var1_1;
        int props = this.trie.get(c);
        if (!UCaseProps.propsHasException(props)) {
            return props & 0x60;
        }
        return this.exceptions.charAt((int)(var1_1 >> 4)) >> 7 & 0x60;
    }

    public static final int getCaseLocale(ULocale locale) {
        String string = locale.getLanguage();
        if (string.length() == 2) {
            if (string.equals("en") || string.charAt(0) > 't') {
                return 1;
            }
            if (string.equals("tr") || string.equals("az")) {
                return 2;
            }
            if (string.equals("el")) {
                return 4;
            }
            if (string.equals("lt")) {
                return 3;
            }
            if (string.equals("nl")) {
                return 5;
            }
            if (string.equals("hy")) {
                return 6;
            }
        } else if (string.length() == 3) {
            if (string.equals("tur") || string.equals("aze")) {
                return 2;
            }
            if (string.equals("ell")) {
                return 4;
            }
            if (string.equals("lit")) {
                return 3;
            }
            if (string.equals("nld")) {
                return 5;
            }
            if (string.equals("hye")) {
                return 6;
            }
        }
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isFollowedByCasedLetter(ContextIterator iter, int dir) {
        int c;
        if (iter == null) {
            return false;
        }
        iter.reset(dir);
        while ((c = iter.next()) >= 0) {
            void var2_2;
            int type = this.getTypeOrIgnorable(c);
            if ((type & 4) != 0) continue;
            return var2_2 != false;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final int toFullLower(int c, ContextIterator iter, Appendable out, int caseLocale) {
        void var1_1;
        int result;
        block45: {
            int excOffset2;
            char excWord;
            int props;
            block50: {
                long value;
                int full;
                int excOffset32;
                block46: {
                    int e2;
                    ContextIterator contextIterator;
                    block47: {
                        block49: {
                            block48: {
                                boolean bl;
                                block41: {
                                    block44: {
                                        result = c;
                                        props = this.trie.get(c);
                                        if (UCaseProps.propsHasException(props)) break block44;
                                        if (UCaseProps.isUpperOrTitleFromProps(props)) {
                                            int n = props;
                                            result = c + ((short)n >> 7);
                                        }
                                        break block45;
                                    }
                                    int n = props;
                                    excOffset32 = n >> 4;
                                    excWord = this.exceptions.charAt(excOffset32++);
                                    excOffset2 = excOffset32;
                                    if ((excWord & 0x4000) == 0) break block46;
                                    if (caseLocale != 3) break block47;
                                    if (c != 73 && c != 74 && c != 302) break block48;
                                    contextIterator = iter;
                                    UCaseProps excOffset32 = this;
                                    if (contextIterator != null) {
                                        int n2;
                                        contextIterator.reset(1);
                                        while ((n2 = contextIterator.next()) >= 0) {
                                            if ((n2 = excOffset32.getDotType(n2)) == 64) {
                                                bl = true;
                                                break block41;
                                            }
                                            if (n2 == 96) continue;
                                        }
                                    }
                                    bl = false;
                                }
                                if (bl) break block49;
                            }
                            if (c != 204 && c != 205 && c != 296) break block47;
                        }
                        try {
                            switch (c) {
                                case 73: {
                                    out.append("i\u0307");
                                    return 2;
                                }
                                case 74: {
                                    out.append("j\u0307");
                                    return 2;
                                }
                                case 302: {
                                    out.append("\u012f\u0307");
                                    return 2;
                                }
                                case 204: {
                                    out.append("i\u0307\u0300");
                                    return 3;
                                }
                                case 205: {
                                    out.append("i\u0307\u0301");
                                    return 3;
                                }
                                case 296: {
                                    out.append("i\u0307\u0303");
                                    return 3;
                                }
                            }
                            return 0;
                        }
                        catch (IOException e2) {
                            throw new ICUUncheckedIOException(e2);
                        }
                    }
                    if (caseLocale == 2 && c == 304) {
                        return 105;
                    }
                    if (caseLocale == 2 && c == 775) {
                        boolean bl;
                        block42: {
                            contextIterator = iter;
                            UCaseProps excOffset32 = this;
                            if (contextIterator != null) {
                                contextIterator.reset(-1);
                                while ((e2 = contextIterator.next()) >= 0) {
                                    if (e2 == 73) {
                                        bl = true;
                                        break block42;
                                    }
                                    if ((e2 = excOffset32.getDotType(e2)) == 96) continue;
                                }
                            }
                            bl = false;
                        }
                        if (bl) {
                            return 0;
                        }
                    }
                    if (caseLocale == 2 && c == 73) {
                        boolean bl;
                        block43: {
                            contextIterator = iter;
                            UCaseProps excOffset32 = this;
                            if (contextIterator != null) {
                                contextIterator.reset(1);
                                while ((e2 = contextIterator.next()) >= 0) {
                                    if (e2 == 775) {
                                        bl = true;
                                        break block43;
                                    }
                                    if ((e2 = excOffset32.getDotType(e2)) == 96) continue;
                                }
                            }
                            bl = false;
                        }
                        if (!bl) {
                            return 305;
                        }
                    }
                    if (c == 304) {
                        try {
                            out.append("i\u0307");
                            return 2;
                        }
                        catch (IOException e3) {
                            throw new ICUUncheckedIOException(e3);
                        }
                    }
                    if (c == 931 && !this.isFollowedByCasedLetter(iter, 1) && this.isFollowedByCasedLetter(iter, -1)) {
                        return 962;
                    }
                    break block50;
                }
                if (UCaseProps.hasSlot(excWord, 7) && (full = (int)(value = this.getSlotValueAndOffset(excWord, 7, excOffset32)) & 0xF) != 0) {
                    excOffset32 = (int)(value >> 32) + 1;
                    try {
                        void var2_4;
                        void var3_5;
                        int n = excOffset32;
                        var3_5.append(this.exceptions, n, n + full);
                        return (int)var2_4;
                    }
                    catch (IOException e) {
                        void var1_2;
                        throw new ICUUncheckedIOException((Throwable)var1_2);
                    }
                }
            }
            if (UCaseProps.hasSlot(excWord, 4) && UCaseProps.isUpperOrTitleFromProps(props)) {
                int delta = this.getSlotValue(excWord, 4, excOffset2);
                if ((excWord & 0x400) == 0) {
                    return (int)(var1_1 + delta);
                }
                return (int)(var1_1 - delta);
            }
            if (UCaseProps.hasSlot(excWord, 0)) {
                result = this.getSlotValue(excWord, 0, excOffset2);
            }
        }
        if (result == var1_1) {
            return ~result;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final int toUpperOrTitle(int c, ContextIterator iter, Appendable out, int loc, boolean upperNotTitle) {
        int n;
        void var1_1;
        int result = c;
        int props = this.trie.get(c);
        if (!UCaseProps.propsHasException(props)) {
            int n2 = props;
            if ((n2 & 3) == 1) {
                n2 = props;
                result = c + ((short)n2 >> 7);
            }
        } else {
            void var2_5;
            int index;
            int n3 = props;
            int excOffset3 = n3 >> 4;
            char excWord = this.exceptions.charAt(excOffset3++);
            int excOffset2 = excOffset3;
            if ((excWord & 0x4000) != 0) {
                if (loc == 2 && c == 105) {
                    return 304;
                }
                if (loc == 3 && c == 775) {
                    boolean bl;
                    block29: {
                        ContextIterator excOffset3 = iter;
                        iter = this;
                        if (excOffset3 != null) {
                            excOffset3.reset(-1);
                            while ((n3 = excOffset3.next()) >= 0) {
                                if ((n3 = ((UCaseProps)iter).getDotType(n3)) == 32) {
                                    bl = true;
                                    break block29;
                                }
                                if (n3 == 96) continue;
                            }
                        }
                        bl = false;
                    }
                    if (bl) {
                        return 0;
                    }
                }
                if (c == 1415) {
                    try {
                        if (loc == 6) {
                            out.append(upperNotTitle ? "\u0535\u054e" : "\u0535\u057e");
                        } else {
                            out.append(upperNotTitle ? "\u0535\u0552" : "\u0535\u0582");
                        }
                        return 2;
                    }
                    catch (IOException e) {
                        throw new ICUUncheckedIOException(e);
                    }
                }
            } else if (UCaseProps.hasSlot(excWord, 7)) {
                long value = this.getSlotValueAndOffset(excWord, 7, excOffset3);
                int full = (int)value & 0xFFFF;
                excOffset3 = (int)(value >> 32) + 1;
                excOffset3 += full & 0xF;
                excOffset3 += (full >>= 4) & 0xF;
                full >>= 4;
                if (upperNotTitle) {
                    full &= 0xF;
                } else {
                    excOffset3 += full & 0xF;
                    full = full >> 4 & 0xF;
                }
                if (full != 0) {
                    try {
                        void var3_6;
                        int n4 = excOffset3;
                        var3_6.append(this.exceptions, n4, n4 + full);
                        return full;
                    }
                    catch (IOException e) {
                        void var1_2;
                        throw new ICUUncheckedIOException((Throwable)var1_2);
                    }
                }
            }
            if (UCaseProps.hasSlot(excWord, 4) && ((n3 = props) & 3) == 1) {
                int delta = this.getSlotValue(excWord, 4, excOffset2);
                if ((excWord & 0x400) == 0) {
                    return (int)(var1_1 + delta);
                }
                return (int)(var1_1 - delta);
            }
            if (!upperNotTitle && UCaseProps.hasSlot(excWord, 3)) {
                index = 3;
            } else if (UCaseProps.hasSlot(excWord, 2)) {
                index = 2;
            } else {
                return (int)(~var1_1);
            }
            n = this.getSlotValue(excWord, (int)var2_5, excOffset2);
        }
        if (n == var1_1) {
            return ~n;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public final int toFullUpper(int c, ContextIterator iter, Appendable out, int caseLocale) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.toUpperOrTitle((int)var1_1, (ContextIterator)var2_2, (Appendable)var3_3, caseLocale, true);
    }

    /*
     * WARNING - void declaration
     */
    public final int toFullTitle(int c, ContextIterator iter, Appendable out, int caseLocale) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.toUpperOrTitle((int)var1_1, (ContextIterator)var2_2, (Appendable)var3_3, caseLocale, false);
    }

    /*
     * WARNING - void declaration
     */
    public final int fold(int c, int options) {
        int n;
        int props = this.trie.get(c);
        if (!UCaseProps.propsHasException(props)) {
            if (UCaseProps.isUpperOrTitleFromProps(props)) {
                int n2 = props;
                c += (short)n2 >> 7;
            }
        } else {
            int index;
            void var3_3;
            char excWord;
            int n3 = props;
            int excOffset = n3 >> 4;
            if (((excWord = this.exceptions.charAt(excOffset++)) & 0x8000) != 0) {
                if ((options & 7) == 0) {
                    if (c == 73) {
                        return 105;
                    }
                    if (c == 304) {
                        return c;
                    }
                } else {
                    if (c == 73) {
                        return 305;
                    }
                    if (c == 304) {
                        return 105;
                    }
                }
            }
            if ((excWord & 0x200) != 0) {
                return c;
            }
            if (UCaseProps.hasSlot(excWord, 4) && UCaseProps.isUpperOrTitleFromProps((int)var3_3)) {
                void var2_2;
                int delta = this.getSlotValue(excWord, 4, excOffset);
                if ((excWord & 0x400) == 0) {
                    return c + delta;
                }
                return c - var2_2;
            }
            if (UCaseProps.hasSlot(excWord, 1)) {
                index = 1;
            } else if (UCaseProps.hasSlot(excWord, 0)) {
                index = 0;
            } else {
                return index;
            }
            n = this.getSlotValue(excWord, n, excOffset);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public final int toFullFolding(int c, Appendable out, int options) {
        int n;
        void var1_1;
        int result = c;
        int props = this.trie.get(c);
        if (!UCaseProps.propsHasException(props)) {
            if (UCaseProps.isUpperOrTitleFromProps(props)) {
                result = props;
                result = c + ((short)result >> 7);
            }
        } else {
            void var2_4;
            boolean index;
            result = props;
            int excOffset = result >> 4;
            char excWord = this.exceptions.charAt(excOffset++);
            int excOffset2 = excOffset;
            if ((excWord & 0x8000) != 0) {
                if ((options & 7) == 0) {
                    if (c == 73) {
                        return 105;
                    }
                    if (c == 304) {
                        try {
                            out.append("i\u0307");
                            return 2;
                        }
                        catch (IOException e) {
                            throw new ICUUncheckedIOException(e);
                        }
                    }
                } else {
                    if (c == 73) {
                        return 305;
                    }
                    if (c == 304) {
                        return 105;
                    }
                }
            } else if (UCaseProps.hasSlot(excWord, 7)) {
                long value = this.getSlotValueAndOffset(excWord, 7, excOffset);
                int full = (int)value & 0xFFFF;
                excOffset = (int)(value >> 32) + 1;
                excOffset += full & 0xF;
                if ((full = full >> 4 & 0xF) != 0) {
                    try {
                        void var3_5;
                        int n2 = excOffset;
                        out.append(this.exceptions, n2, n2 + full);
                        return (int)var3_5;
                    }
                    catch (IOException e) {
                        void var1_2;
                        throw new ICUUncheckedIOException((Throwable)var1_2);
                    }
                }
            }
            if ((excWord & 0x200) != 0) {
                return (int)(~var1_1);
            }
            if (UCaseProps.hasSlot(excWord, 4) && UCaseProps.isUpperOrTitleFromProps(props)) {
                int delta = this.getSlotValue(excWord, 4, excOffset2);
                if ((excWord & 0x400) == 0) {
                    return (int)(var1_1 + delta);
                }
                return (int)(var1_1 - delta);
            }
            if (UCaseProps.hasSlot(excWord, 1)) {
                index = true;
            } else if (UCaseProps.hasSlot(excWord, 0)) {
                index = false;
            } else {
                return (int)(~var1_1);
            }
            n = this.getSlotValue(excWord, (int)var2_4, excOffset2);
        }
        if (n == var1_1) {
            return ~n;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasBinaryProperty(int c3222, int which) {
        switch (which) {
            case 22: {
                if (1 != this.getType(c3222)) return false;
                return true;
            }
            case 30: {
                if (2 != this.getType(c3222)) return false;
                return true;
            }
            case 27: {
                int n = c3222;
                UCaseProps c3222 = this;
                if (c3222.getDotType(n) != 32) return false;
                return true;
            }
            case 34: {
                int c3222;
                int n = c3222;
                UCaseProps c3222 = this;
                n = c3222.trie.get(n);
                if (!UCaseProps.propsHasException(n)) {
                    if ((n & 0x10) == 0) return false;
                    return true;
                }
                int c3222 = n;
                if ((c3222.exceptions.charAt(c3222 >> 4) & 0x800) == 0) return false;
                return true;
            }
            case 49: {
                int c3222;
                if (0 == this.getType(c3222)) return false;
                return true;
            }
            case 50: {
                int c3222;
                if (this.getTypeOrIgnorable(c3222) >> 2 == 0) return false;
                return true;
            }
            case 51: {
                int c3222;
                dummyStringBuilder.setLength(0);
                if (this.toFullLower(c3222, null, dummyStringBuilder, 1) < 0) return false;
                return true;
            }
            case 52: {
                int c3222;
                dummyStringBuilder.setLength(0);
                if (this.toFullUpper(c3222, null, dummyStringBuilder, 1) < 0) return false;
                return true;
            }
            case 53: {
                int c3222;
                dummyStringBuilder.setLength(0);
                if (this.toFullTitle(c3222, null, dummyStringBuilder, 1) < 0) return false;
                return true;
            }
            case 55: {
                void var1_1;
                int c3222;
                dummyStringBuilder.setLength(0);
                if (this.toFullLower(c3222, null, dummyStringBuilder, 1) >= 0) return true;
                if (this.toFullUpper(c3222, null, dummyStringBuilder, 1) >= 0) return true;
                if (this.toFullTitle((int)var1_1, null, dummyStringBuilder, 1) < 0) return false;
                return true;
            }
        }
        return false;
    }

    static Trie2_16 getTrie() {
        return UCaseProps.INSTANCE.trie;
    }

    static final int getTypeFromProps(int props) {
        return props & 3;
    }

    static final boolean isUpperOrTitleFromProps(int props) {
        return (props & 2) != 0;
    }

    static final int getDelta(int props) {
        return (short)props >> 7;
    }

    /*
     * WARNING - void declaration
     */
    static {
        try {
            INSTANCE = new UCaseProps();
            return;
        }
        catch (IOException e) {
            void var0;
            throw new ICUUncheckedIOException((Throwable)var0);
        }
    }

    static final class LatinCase {
        static final byte[] TO_LOWER_NORMAL = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 0, 32, 32, 32, 32, 32, 32, 32, -128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, -128, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, -128, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, -121, 1, 0, 1, 0, 1, 0, -128};
        static final byte[] TO_LOWER_TR_LT = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 32, 32, 32, 32, 32, 32, 32, -128, -128, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, -128, -128, 32, 32, 32, 32, 32, 32, 32, 32, 32, 0, 32, 32, 32, 32, 32, 32, 32, -128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, -128, 0, 1, 0, 1, 0, -128, 0, -128, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, -128, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, -121, 1, 0, 1, 0, 1, 0, -128};
        static final byte[] TO_UPPER_NORMAL = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -128, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, 0, -32, -32, -32, -32, -32, -32, -32, 121, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -128, 0, -1, 0, -1, 0, -1, 0, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, -128, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, 0, -1, 0, -1, 0, -1, -128};
        static final byte[] TO_UPPER_TR = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -32, -32, -32, -32, -32, -32, -32, -32, -128, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -128, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, 0, -32, -32, -32, -32, -32, -32, -32, 121, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -128, 0, -1, 0, -1, 0, -1, 0, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, -128, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0, 0, -1, 0, -1, 0, -1, -128};
    }

    public static interface ContextIterator {
        public void reset(int var1);

        public int next();
    }

    static final class IsAcceptable
    implements ICUBinary.Authenticate {
        private IsAcceptable() {
        }

        @Override
        public final boolean isDataVersionAcceptable(byte[] version) {
            return version[0] == 4;
        }

        /* synthetic */ IsAcceptable(byte by) {
            this();
        }
    }
}

