/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.CacheValue;
import com.ibm.icu.impl.ICUBinary;
import com.ibm.icu.impl.UCharacterNameReader;
import com.ibm.icu.impl.UCharacterProperty;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.MissingResourceException;

public final class UCharacterName {
    public static final UCharacterName INSTANCE;
    public int m_groupcount_ = 0;
    int m_groupsize_ = 0;
    private char[] m_tokentable_;
    private byte[] m_tokenstring_;
    private char[] m_groupinfo_;
    private byte[] m_groupstring_;
    private AlgorithmName[] m_algorithm_;
    private char[] m_groupoffsets_ = new char[33];
    private char[] m_grouplengths_ = new char[33];
    private static final String[] TYPE_NAMES_;

    /*
     * WARNING - void declaration
     */
    public final int getCharFromName(int choice, String name) {
        void var1_1;
        if (name == null || name.length() == 0) {
            return -1;
        }
        int result = UCharacterName.getExtendedChar(name.toLowerCase(Locale.ENGLISH), 2);
        if (result >= -1) {
            return result;
        }
        String upperCaseName = name.toUpperCase(Locale.ENGLISH);
        int count = 0;
        if (this.m_algorithm_ != null) {
            count = this.m_algorithm_.length;
        }
        --count;
        while (count >= 0) {
            result = this.m_algorithm_[count].getChar(upperCaseName);
            if (result >= 0) {
                return result;
            }
            --count;
        }
        result = this.getGroupChar(upperCaseName, 0);
        if (result == -1) {
            void var2_2;
            result = this.getGroupChar((String)var2_2, 3);
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final boolean setToken(char[] token, byte[] tokenstring) {
        if (token != null && token.length > 0 && tokenstring.length > 0) {
            void var2_2;
            void var1_1;
            this.m_tokentable_ = var1_1;
            this.m_tokenstring_ = var2_2;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    final boolean setAlgorithm(AlgorithmName[] alg) {
        if (alg.length != 0) {
            void var1_1;
            this.m_algorithm_ = var1_1;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    final boolean setGroup(char[] group, byte[] groupstring) {
        if (group != null && group.length > 0 && groupstring.length > 0) {
            void var2_2;
            void var1_1;
            this.m_groupinfo_ = var1_1;
            this.m_groupstring_ = var2_2;
            return true;
        }
        return false;
    }

    private UCharacterName() throws IOException {
        UCharacterNameReader uCharacterNameReader;
        new StringBuffer();
        ByteBuffer b = ICUBinary.getRequiredData("unames.icu");
        uCharacterNameReader = new UCharacterNameReader((ByteBuffer)((Object)uCharacterNameReader));
        uCharacterNameReader.read(this);
    }

    private synchronized int getGroupChar(String name, int choice) {
        for (int i = 0; i < this.m_groupcount_; ++i) {
            int result;
            int n;
            block14: {
                int n2;
                int n3;
                int n4;
                Object object = this.m_grouplengths_;
                char[] cArray = this.m_groupoffsets_;
                int n5 = i;
                UCharacterName uCharacterName = this;
                int n6 = 65535;
                int n7 = uCharacterName.m_groupinfo_[(n5 *= uCharacterName.m_groupsize_) + 2];
                int n8 = uCharacterName.m_groupinfo_[n5 + 1];
                int n9 = n8 << 16 | n7;
                cArray[0] = '\u0000';
                int n10 = 0;
                while (n10 < 32) {
                    n4 = uCharacterName.m_groupstring_[n9];
                    for (n3 = 4; n3 >= 0; n3 -= 4) {
                        n2 = n4 >> n3 & 0xF;
                        if (n6 == 65535 && n2 > 11) {
                            n6 = (char)(n2 - 12 << 4);
                            continue;
                        }
                        object[n10] = n6 != 65535 ? (Object)((char)((n6 | n2) + 12)) : (Object)((char)n2);
                        if (n10 < 32) {
                            cArray[n10 + 1] = (char)(cArray[n10] + object[n10]);
                        }
                        n6 = 65535;
                        ++n10;
                    }
                    ++n9;
                }
                int startgpstrindex22 = n9;
                n6 = choice;
                object = name;
                cArray = this.m_grouplengths_;
                n5 = startgpstrindex22;
                UCharacterName startgpstrindex22 = this;
                n9 = ((String)object).length();
                for (n7 = 0; n7 <= 32; ++n7) {
                    n10 = 0;
                    n3 = cArray[n7];
                    if (n6 != 0 && n6 != 2) {
                        n4 = n6 == 4 ? 2 : n6;
                        do {
                            int n11;
                            n2 = n5;
                            int n12 = n5;
                            int n13 = n5;
                            n5 = 59;
                            int n14 = n3;
                            n8 = n13;
                            byte[] byArray = startgpstrindex22.m_groupstring_;
                            for (n11 = 0; n11 < n14; ++n11) {
                                byte by = byArray[n8 + n11];
                                if (by != 59) continue;
                                ++n11;
                                break;
                            }
                            n5 = n12 + n11;
                            n3 -= n5 - n2;
                        } while (--n4 > 0);
                    }
                    n8 = 0;
                    while (n8 < n3 && n10 != -1 && n10 < n9) {
                        n4 = startgpstrindex22.m_groupstring_[n5 + n8];
                        ++n8;
                        if (n4 >= startgpstrindex22.m_tokentable_.length) {
                            if (((String)object).charAt(n10++) == (n4 & 0xFF)) continue;
                            n10 = -1;
                            continue;
                        }
                        n2 = startgpstrindex22.m_tokentable_[n4 & 0xFF];
                        if (n2 == 65534) {
                            n2 = startgpstrindex22.m_tokentable_[n4 << 8 | startgpstrindex22.m_groupstring_[n5 + n8] & 0xFF];
                            ++n8;
                        }
                        if (n2 == 65535) {
                            if (((String)object).charAt(n10++) == (n4 & 0xFF)) continue;
                            n10 = -1;
                            continue;
                        }
                        n10 = CacheValue.1.compareNullTermByteSubString((String)object, startgpstrindex22.m_tokenstring_, n10, n2);
                    }
                    if (n9 == n10 && (n8 == n3 || startgpstrindex22.m_groupstring_[n5 + n8] == 59)) {
                        n = n7;
                        break block14;
                    }
                    n5 += n3;
                }
                n = result = -1;
            }
            if (n == -1) continue;
            return this.m_groupinfo_[i * this.m_groupsize_] << 5 | result;
        }
        return -1;
    }

    private static int getExtendedChar(String name, int choice) {
        if (name.charAt(0) == '<') {
            int startIndex;
            int endIndex;
            if (choice == 2 && name.charAt(endIndex = name.length() - 1) == '>' && (startIndex = name.lastIndexOf(45)) >= 0) {
                int n;
                int result;
                int hexLength;
                if ((hexLength = endIndex - ++startIndex) <= 0 || 8 < hexLength) {
                    return -1;
                }
                try {
                    result = Integer.parseInt(name.substring(startIndex, endIndex), 16);
                }
                catch (NumberFormatException numberFormatException) {
                    return -1;
                }
                if (result < 0 || 0x10FFFF < result) {
                    return -1;
                }
                int n2 = hexLength = result;
                if ((hexLength & 0xFFFE) == 65534 ? true : n2 >= 64976 && n2 <= 65007) {
                    n = 30;
                } else {
                    n2 = hexLength;
                    if ((n2 = UCharacterProperty.INSTANCE.getType(n2)) == 18) {
                        n2 = hexLength <= 56319 ? 31 : 32;
                    }
                    n = n2;
                }
                int charType = n;
                String type = name.substring(1, startIndex - 1);
                int length = TYPE_NAMES_.length;
                for (int i = 0; i < length; ++i) {
                    if (type.compareTo(TYPE_NAMES_[i]) != 0) continue;
                    if (charType != i) break;
                    return result;
                }
            }
            return -1;
        }
        return -2;
    }

    static {
        try {
            INSTANCE = new UCharacterName();
        }
        catch (IOException iOException) {
            throw new MissingResourceException("Could not construct UCharacterName. Missing unames.icu", "", "");
        }
        TYPE_NAMES_ = new String[]{"unassigned", "uppercase letter", "lowercase letter", "titlecase letter", "modifier letter", "other letter", "non spacing mark", "enclosing mark", "combining spacing mark", "decimal digit number", "letter number", "other number", "space separator", "line separator", "paragraph separator", "control", "format", "private use area", "surrogate", "dash punctuation", "start punctuation", "end punctuation", "connector punctuation", "other punctuation", "math symbol", "currency symbol", "modifier symbol", "other symbol", "initial punctuation", "final punctuation", "noncharacter", "lead surrogate", "trail surrogate"};
    }

    static final class AlgorithmName {
        private int m_rangestart_;
        private int m_rangeend_;
        private byte m_type_;
        private byte m_variant_;
        private char[] m_factor_;
        private String m_prefix_;
        private byte[] m_factorstring_;
        private int[] m_utilIntBuffer_;

        AlgorithmName() {
            new StringBuffer();
            this.m_utilIntBuffer_ = new int[256];
        }

        /*
         * WARNING - void declaration
         */
        final boolean setInfo(int rangestart, int rangeend, byte type, byte variant) {
            if (rangestart >= 0 && rangestart <= rangeend && rangeend <= 0x10FFFF && (type == 0 || type == 1)) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.m_rangestart_ = var1_1;
                this.m_rangeend_ = var2_2;
                this.m_type_ = var3_3;
                this.m_variant_ = variant;
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        final boolean setFactor(char[] factor) {
            if (factor.length == this.m_variant_) {
                void var1_1;
                this.m_factor_ = var1_1;
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        final boolean setPrefix(String prefix) {
            if (prefix != null && prefix.length() > 0) {
                void var1_1;
                this.m_prefix_ = var1_1;
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        final boolean setFactorString(byte[] string) {
            void var1_1;
            this.m_factorstring_ = var1_1;
            return true;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        final int getChar(String name) {
            prefixlen = this.m_prefix_.length();
            if (name.length() < prefixlen) return -1;
            if (!this.m_prefix_.equals(name.substring(0, prefixlen))) {
                return -1;
            }
            switch (this.m_type_) {
                case 0: {
                    try {
                        result = Integer.parseInt(name.substring(prefixlen), 16);
                        if (this.m_rangestart_ > result) return -1;
                        if (result > this.m_rangeend_) return -1;
                        return result;
                    }
                    catch (NumberFormatException v0) {
                        return -1;
                    }
                }
                case 1: {
                    ch = this.m_rangestart_;
                    while (ch <= this.m_rangeend_) {
                        offset = ch - this.m_rangestart_;
                        indexes = this.m_utilIntBuffer_;
                        var7_9 = this.m_utilIntBuffer_;
                        // MONITORENTER : this.m_utilIntBuffer_
                        for (i = this.m_variant_ - 1; i > 0; offset /= factor, --i) {
                            factor = this.m_factor_[i] & 255;
                            indexes[i] = offset % factor;
                        }
                        indexes[0] = offset;
                        var9_12 = prefixlen;
                        var8_10 = name;
                        var6_8 = this.m_variant_;
                        var5_7 = indexes;
                        var4_5 = this;
                        var10_13 = var4_5.m_factor_.length;
                        if (var5_7 != null && var6_8 == var10_13) ** GOTO lbl35
                        v1 = false;
                        ** GOTO lbl46
lbl35:
                        // 1 sources

                        var6_8 = 0;
                        --var10_13;
                        for (var12_15 = 0; var12_15 <= var10_13; ++var12_15) {
                            var11_14 = var4_5.m_factor_[var12_15];
                            if ((var9_12 = CacheValue.1.compareNullTermByteSubString(var8_10, var4_5.m_factorstring_, var9_12, var6_8 = CacheValue.1.skipNullTermByteSubString(var4_5.m_factorstring_, var6_8, var5_7[var12_15]))) >= 0) ** GOTO lbl42
                            v1 = false;
                            ** GOTO lbl46
lbl42:
                            // 1 sources

                            if (var12_15 == var10_13) continue;
                            var6_8 = CacheValue.1.skipNullTermByteSubString(var4_5.m_factorstring_, var6_8, var11_14 - var5_7[var12_15]);
                        }
                        v1 = var9_12 == var8_10.length();
lbl46:
                        // 3 sources

                        if (v1) {
                            // MONITOREXIT : var7_9
                            return ch;
                        }
                        // MONITOREXIT : var7_9
                        ++ch;
                    }
                    return -1;
                }
            }
            return -1;
        }
    }
}

