/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ICUBinary;
import com.ibm.icu.impl.IllegalIcuArgumentException;
import com.ibm.icu.util.BytesTrie;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.MissingResourceException;

public final class UPropertyAliases {
    private int[] valueMaps;
    private byte[] bytesTries;
    private String nameGroups;
    private static final IsAcceptable IS_ACCEPTABLE = new IsAcceptable(0);
    public static final UPropertyAliases INSTANCE;

    /*
     * WARNING - void declaration
     */
    private void load(ByteBuffer bytes) throws IOException {
        void var2_3;
        ICUBinary.readHeader(bytes, 1886282093, IS_ACCEPTABLE);
        int indexesLength = bytes.getInt() / 4;
        if (indexesLength < 8) {
            throw new IOException("pnames.icu: not enough indexes");
        }
        int[] nArray = new int[indexesLength];
        int[] inIndexes = nArray;
        nArray[0] = indexesLength << 2;
        for (int i = 1; i < indexesLength; ++i) {
            inIndexes[i] = bytes.getInt();
        }
        int offset = inIndexes[0];
        int nextOffset = inIndexes[1];
        int numInts = (nextOffset - offset) / 4;
        this.valueMaps = ICUBinary.getInts(bytes, numInts, 0);
        numInts = nextOffset;
        nextOffset = inIndexes[2];
        int numBytes = nextOffset - numInts;
        this.bytesTries = new byte[numBytes];
        bytes.get(this.bytesTries);
        numBytes = nextOffset;
        nextOffset = inIndexes[3];
        numBytes = nextOffset - numBytes;
        StringBuilder sb = new StringBuilder(numBytes);
        for (int i = 0; i < numBytes; ++i) {
            sb.append((char)bytes.get());
        }
        this.nameGroups = var2_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    private UPropertyAliases() throws IOException {
        void var1_1;
        ByteBuffer bytes = ICUBinary.getRequiredData("pnames.icu");
        this.load((ByteBuffer)var1_1);
    }

    private int findProperty(int property) {
        int i = 1;
        for (int numRanges = this.valueMaps[0]; numRanges > 0; --numRanges) {
            int start = this.valueMaps[i];
            int limit = this.valueMaps[i + 1];
            i += 2;
            if (property < start) break;
            if (property < limit) {
                return i + (property - start << 1);
            }
            i += limit - start << 1;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private int findPropertyValueNameGroup(int valueMapIndex, int value) {
        if (valueMapIndex == 0) {
            return 0;
        }
        int n = ++valueMapIndex;
        ++valueMapIndex;
        int numRanges = this.valueMaps[n];
        if (numRanges < 16) {
            while (numRanges > 0) {
                int start = this.valueMaps[valueMapIndex];
                int limit = this.valueMaps[valueMapIndex + 1];
                valueMapIndex += 2;
                if (value >= start) {
                    if (value < limit) {
                        return this.valueMaps[valueMapIndex + value - start];
                    }
                    valueMapIndex += limit - start;
                    --numRanges;
                    continue;
                }
                break;
            }
        } else {
            int v;
            int valuesStart = valueMapIndex;
            int nameGroupOffsetsStart = valueMapIndex + numRanges - 16;
            while (value >= (v = this.valueMaps[valueMapIndex])) {
                void var3_3;
                if (value == var3_3) {
                    return this.valueMaps[nameGroupOffsetsStart + valueMapIndex - valuesStart];
                }
                if (++valueMapIndex < nameGroupOffsetsStart) continue;
            }
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private String getName(int nameGroupsIndex, int nameIndex) {
        void var1_1;
        void var2_2;
        void var3_3;
        char numNames = this.nameGroups.charAt(nameGroupsIndex++);
        if (nameIndex < 0 || var3_3 <= nameIndex) {
            throw new IllegalIcuArgumentException("Invalid property (value) name choice");
        }
        while (nameIndex > 0) {
            while ('\u0000' != this.nameGroups.charAt(nameGroupsIndex++)) {
            }
            --nameIndex;
        }
        int nameStart = nameGroupsIndex;
        while ('\u0000' != this.nameGroups.charAt(nameGroupsIndex)) {
            ++nameGroupsIndex;
        }
        if (nameStart == nameGroupsIndex) {
            return null;
        }
        return this.nameGroups.substring((int)var2_2, (int)var1_1);
    }

    private static int asciiToLowercase(int c) {
        int n;
        if (65 <= c && c <= 90) {
            return c + 32;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public final String getPropertyValueName(int property, int value, int nameChoice) {
        void var3_3;
        void var2_2;
        int valueMapIndex = this.findProperty(property);
        if (valueMapIndex == 0) {
            throw new IllegalArgumentException("Invalid property enum " + property + " (0x" + Integer.toHexString(property) + ")");
        }
        UPropertyAliases uPropertyAliases = this;
        int nameGroupOffset = uPropertyAliases.findPropertyValueNameGroup(uPropertyAliases.valueMaps[valueMapIndex + 1], value);
        if (nameGroupOffset == 0) {
            void var1_1;
            throw new IllegalArgumentException("Property " + property + " (0x" + Integer.toHexString((int)var1_1) + ") does not have named values");
        }
        return this.getName((int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private int getPropertyOrValueEnum(int bytesTrieOffset, CharSequence alias) {
        boolean bl;
        block3: {
            BytesTrie bytesTrie;
            BytesTrie trie = new BytesTrie(this.bytesTries, bytesTrieOffset);
            void var3_4 = bytesTrie;
            bytesTrie = trie;
            BytesTrie.Result result = BytesTrie.Result.NO_VALUE;
            for (int i = 0; i < var3_4.length(); ++i) {
                int n = var3_4.charAt(i);
                if (n == 45 || n == 95 || n == 32 || 9 <= n && n <= 13) continue;
                if (!result.hasNext()) {
                    bl = false;
                    break block3;
                }
                n = UPropertyAliases.asciiToLowercase(n);
                result = bytesTrie.next(n);
            }
            bl = result.hasValue();
        }
        if (bl) {
            void var1_2;
            return var1_2.getValue();
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public final int getPropertyEnum(CharSequence alias) {
        void var1_1;
        return this.getPropertyOrValueEnum(0, (CharSequence)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final int getPropertyValueEnum(int property, CharSequence alias) {
        void var2_2;
        void var3_3;
        int valueMapIndex = this.findProperty(property);
        if (valueMapIndex == 0) {
            throw new IllegalArgumentException("Invalid property enum " + property + " (0x" + Integer.toHexString(property) + ")");
        }
        if ((valueMapIndex = this.valueMaps[valueMapIndex + 1]) == 0) {
            void var1_1;
            throw new IllegalArgumentException("Property " + property + " (0x" + Integer.toHexString((int)var1_1) + ") does not have named values");
        }
        UPropertyAliases uPropertyAliases = this;
        return uPropertyAliases.getPropertyOrValueEnum(uPropertyAliases.valueMaps[var3_3], (CharSequence)var2_2);
    }

    public static int compare(String stra, String strb) {
        int istra = 0;
        int istrb = 0;
        char cstra = '\u0000';
        char cstrb = '\u0000';
        block6: while (true) {
            boolean endstrb;
            if (istra < stra.length()) {
                cstra = stra.charAt(istra);
                switch (cstra) {
                    case '\t': 
                    case '\n': 
                    case '\u000b': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case '-': 
                    case '_': {
                        ++istra;
                        continue block6;
                    }
                }
            }
            block7: while (istrb < strb.length()) {
                cstrb = strb.charAt(istrb);
                switch (cstrb) {
                    case '\t': 
                    case '\n': 
                    case '\u000b': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case '-': 
                    case '_': {
                        ++istrb;
                        continue block7;
                    }
                }
            }
            boolean endstra = istra == stra.length();
            boolean bl = endstrb = istrb == strb.length();
            if (endstra) {
                if (endstrb) {
                    return 0;
                }
                cstra = '\u0000';
            } else if (endstrb) {
                cstrb = '\u0000';
            }
            int rc = UPropertyAliases.asciiToLowercase(cstra) - UPropertyAliases.asciiToLowercase(cstrb);
            if (rc != 0) {
                return rc;
            }
            ++istra;
            ++istrb;
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        try {
            INSTANCE = new UPropertyAliases();
            return;
        }
        catch (IOException e) {
            void var1_1;
            void var0;
            MissingResourceException mre = new MissingResourceException("Could not construct UPropertyAliases. Missing pnames.icu", "", "");
            mre.initCause((Throwable)var0);
            throw var1_1;
        }
    }

    static final class IsAcceptable
    implements ICUBinary.Authenticate {
        private IsAcceptable() {
        }

        @Override
        public final boolean isDataVersionAcceptable(byte[] version) {
            return version[0] == 2;
        }

        /* synthetic */ IsAcceptable(byte by) {
            this();
        }
    }
}

