/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ClassLoaderUtil;
import com.ibm.icu.impl.ICUDebug;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public abstract class URLHandler {
    private static final Map<String, Method> handlers;
    private static final boolean DEBUG;

    /*
     * WARNING - void declaration
     */
    public static URLHandler get(URL url) {
        URL uRL;
        block9: {
            Method m;
            if (url == null) {
                return null;
            }
            String protocol = url.getProtocol();
            if (handlers != null && (m = handlers.get(protocol)) != null) {
                try {
                    URLHandler handler = (URLHandler)m.invoke(null, url);
                    if (handler != null) {
                        return handler;
                    }
                }
                catch (IllegalAccessException e) {
                    if (DEBUG) {
                        System.err.println(e);
                    }
                }
                catch (IllegalArgumentException e) {
                    if (DEBUG) {
                        System.err.println(e);
                    }
                }
                catch (InvocationTargetException e) {
                    void var1_4;
                    if (!DEBUG) break block9;
                    System.err.println(var1_4);
                }
            }
        }
        return URLHandler.getDefault(uRL);
    }

    /*
     * WARNING - void declaration
     */
    private static URLHandler getDefault(URL url) {
        void var1_1;
        URLHandler handler = null;
        String protocol = url.getProtocol();
        try {
            void var2_2;
            if (protocol.equals("file")) {
                handler = new FileURLHandler(url);
            } else if (protocol.equals("jar") || var2_2.equals("wsjar")) {
                URL uRL;
                handler = new JarURLHandler(uRL);
            }
        }
        catch (Exception exception) {}
        return var1_1;
    }

    public abstract void guide(URLVisitor var1, boolean var2, boolean var3);

    /*
     * Unable to fully structure code
     */
    static {
        URLHandler.DEBUG = ICUDebug.enabled("URLHandler");
        h = null;
        br = null;
        try {
            var2_3 = ClassLoaderUtil.getClassLoader(URLHandler.class);
            is = var2_3.getResourceAsStream("urlhandler.props");
            if (is != null) {
                params = new Class[]{URL.class};
                br = new BufferedReader(new InputStreamReader(is));
                line = br.readLine();
                while (line != null) {
                    block25: {
                        if ((line = line.trim()).length() != 0 && line.charAt(0) != '#') {
                            ix = line.indexOf(61);
                            if (ix == -1) {
                                if (!URLHandler.DEBUG) break;
                                System.err.println("bad urlhandler line: '" + line + "'");
                                break;
                            }
                            key = line.substring(0, ix).trim();
                            value = line.substring(ix + 1).trim();
                            try {
                                value = Class.forName((String)value);
                                m = value.getDeclaredMethod("get", params);
                                if (h == null) {
                                    h = new HashMap<String, Method>();
                                }
                                h.put(key, m);
                            }
                            catch (ClassNotFoundException e) {
                                if (URLHandler.DEBUG) {
                                    System.err.println(e);
                                }
                            }
                            catch (NoSuchMethodException e) {
                                if (URLHandler.DEBUG) {
                                    System.err.println(e);
                                }
                            }
                            catch (SecurityException e) {
                                if (!URLHandler.DEBUG) break block25;
                                System.err.println(e);
                            }
                        }
                    }
                    e = br.readLine();
                }
                br.close();
            }
            ** if (br == null) goto lbl-1000
        }
        catch (Throwable t) {
            try {
                if (URLHandler.DEBUG) {
                    System.err.println(var2_7);
                }
                ** if (br == null) goto lbl-1000
            }
            catch (Throwable h) {
                if (br != null) {
                    try {
                        var1_2.close();
                    }
                    catch (IOException v2) {}
                }
                throw h;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    br.close();
                }
                catch (IOException v1) {}
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            try {
                br.close();
            }
            catch (IOException v0) {}
        }
lbl-1000:
        // 2 sources

        {
        }
        URLHandler.handlers = var0;
    }

    public static interface URLVisitor {
        public void visit(String var1);
    }

    static final class JarURLHandler
    extends URLHandler {
        private JarFile jarFile;
        private String prefix;

        /*
         * WARNING - void declaration
         */
        JarURLHandler(URL url) {
            try {
                void var1_1;
                String urlStr;
                int idx;
                this.prefix = url.getPath();
                int ix = this.prefix.lastIndexOf("!/");
                if (ix >= 0) {
                    this.prefix = this.prefix.substring(ix + 2);
                }
                if (!(ix = url.getProtocol()).equals("jar") && (idx = (urlStr = url.toString()).indexOf(":")) != -1) {
                    void var3_5;
                    url = new URL("jar" + urlStr.substring((int)var3_5));
                }
                JarURLConnection conn = (JarURLConnection)var1_1.openConnection();
                this.jarFile = conn.getJarFile();
                return;
            }
            catch (Exception e) {
                void var2_4;
                if (DEBUG) {
                    System.err.println("icurb jar error: " + e);
                }
                throw new IllegalArgumentException("jar error: " + var2_4.getMessage());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void guide(URLVisitor v, boolean recurse, boolean strip) {
            try {
                Enumeration<JarEntry> entries = this.jarFile.entries();
                while (entries.hasMoreElements()) {
                    int ix;
                    String name;
                    JarEntry entry = entries.nextElement();
                    if (entry.isDirectory() || !(name = entry.getName()).startsWith(this.prefix) || (ix = (name = name.substring(this.prefix.length())).lastIndexOf(47)) > 0 && !recurse) continue;
                    if (ix != -1) {
                        name = name.substring(ix + 1);
                    }
                    v.visit(name);
                }
                return;
            }
            catch (Exception e) {
                if (DEBUG) {
                    void var3_5;
                    System.err.println("icurb jar error: " + var3_5);
                }
                return;
            }
        }
    }

    static final class FileURLHandler
    extends URLHandler {
        private File file;

        /*
         * WARNING - void declaration
         */
        FileURLHandler(URL url) {
            try {
                this.file = new File(url.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {}
            if (this.file == null || !this.file.exists()) {
                if (DEBUG) {
                    void var1_1;
                    System.err.println("file does not exist - " + var1_1.toString());
                }
                throw new IllegalArgumentException();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void guide(URLVisitor v, boolean recurse, boolean strip) {
            void var1_1;
            if (this.file.isDirectory()) {
                void var2_2;
                this.process(v, (boolean)var2_2, true, "/", this.file.listFiles());
                return;
            }
            var1_1.visit(this.file.getName());
        }

        private void process(URLVisitor v, boolean recurse, boolean strip, String path, File[] files) {
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    File f = files[i];
                    if (f.isDirectory()) {
                        if (!recurse) continue;
                        this.process(v, recurse, strip, path + f.getName() + '/', f.listFiles());
                        continue;
                    }
                    v.visit(strip ? f.getName() : path + f.getName());
                }
            }
        }
    }
}

