/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import androidx.compose.animation.core.AnimationSpecKt;
import androidx.compose.foundation.gestures.DraggableKt;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.UnicodeSet;
import java.util.ArrayList;

public class UnicodeSetStringSpan {
    private UnicodeSet spanSet = new UnicodeSet(0, 0x10FFFF);
    private UnicodeSet spanNotSet;
    private ArrayList<String> strings;
    private short[] spanLengths;
    private final int maxLength16;
    private boolean someRelevant;
    private boolean all;
    private OffsetList offsets;

    public UnicodeSetStringSpan(UnicodeSet set, ArrayList<String> setStrings, int which) {
        int length16;
        this.strings = setStrings;
        this.all = which == 127;
        this.spanSet.retainAll(set);
        if (0 != (which & 1)) {
            this.spanNotSet = this.spanSet;
        }
        this.offsets = new OffsetList();
        int stringsLength = this.strings.size();
        int maxLength16 = 0;
        this.someRelevant = false;
        int i = 0;
        while (i < stringsLength) {
            String string = this.strings.get(i);
            length16 = string.length();
            if (length16 == 0) {
                this.strings.remove(i);
                --stringsLength;
                continue;
            }
            int n = this.spanSet.span(string, UnicodeSet.SpanCondition.CONTAINED);
            if (n < length16) {
                this.someRelevant = true;
            }
            if (length16 > maxLength16) {
                maxLength16 = length16;
            }
            ++i;
        }
        this.maxLength16 = maxLength16;
        if (!this.someRelevant && (which & 0x40) == 0) {
            return;
        }
        if (this.all) {
            this.spanSet.freeze();
        }
        int allocSize = this.all ? stringsLength << 1 : stringsLength;
        this.spanLengths = new short[allocSize];
        int spanBackLengthsOffset = this.all ? stringsLength : 0;
        for (i = 0; i < stringsLength; ++i) {
            String string = this.strings.get(i);
            length16 = string.length();
            int spanLength = this.spanSet.span(string, UnicodeSet.SpanCondition.CONTAINED);
            if (spanLength < length16) {
                int c;
                if (0 != (which & 2)) {
                    if (0 != (which & 0x20)) {
                        this.spanLengths[i] = UnicodeSetStringSpan.makeSpanLengthByte(spanLength);
                    }
                    if (0 != (which & 0x10)) {
                        spanLength = length16 - this.spanSet.spanBack(string, length16, UnicodeSet.SpanCondition.CONTAINED);
                        this.spanLengths[spanBackLengthsOffset + i] = UnicodeSetStringSpan.makeSpanLengthByte(spanLength);
                    }
                } else {
                    this.spanLengths[spanBackLengthsOffset + i] = 0;
                    this.spanLengths[i] = 0;
                }
                if (0 == (which & 1)) continue;
                if (0 != (which & 0x20)) {
                    c = string.codePointAt(0);
                    this.addToSpanNotSet(c);
                }
                if (0 == (which & 0x10)) continue;
                c = string.codePointBefore(length16);
                this.addToSpanNotSet(c);
                continue;
            }
            if (this.all) {
                this.spanLengths[spanBackLengthsOffset + i] = 255;
                this.spanLengths[i] = 255;
                continue;
            }
            this.spanLengths[i] = 255;
        }
        if (this.all) {
            this.spanNotSet.freeze();
        }
    }

    public final boolean needsStringSpanUTF16() {
        return this.someRelevant;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean contains(int c) {
        void var1_1;
        return this.spanSet.contains((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void addToSpanNotSet(int c) {
        void var1_1;
        if (Utility.sameObjects(this.spanNotSet, null) || Utility.sameObjects(this.spanNotSet, this.spanSet)) {
            if (this.spanSet.contains(c)) {
                return;
            }
            this.spanNotSet = this.spanSet.cloneAsThawed();
        }
        this.spanNotSet.add((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final int span(CharSequence s, int start, UnicodeSet.SpanCondition spanCondition) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (spanCondition == UnicodeSet.SpanCondition.NOT_CONTAINED) {
            return this.spanNot$16a03792(s, start, null);
        }
        int spanLimit = this.spanSet.span(s, start, UnicodeSet.SpanCondition.CONTAINED);
        if (spanLimit == s.length()) {
            return spanLimit;
        }
        return this.spanWithStrings((CharSequence)var1_1, (int)var2_2, spanLimit, (UnicodeSet.SpanCondition)var3_3);
    }

    private synchronized int spanWithStrings(CharSequence s, int start, int spanLimit, UnicodeSet.SpanCondition spanCondition) {
        int initSize = 0;
        if (spanCondition == UnicodeSet.SpanCondition.CONTAINED) {
            initSize = this.maxLength16;
        }
        this.offsets.setMaxLength(initSize);
        int length = s.length();
        int pos = spanLimit;
        int rest = length - spanLimit;
        int spanLength = spanLimit - start;
        int stringsLength = this.strings.size();
        while (true) {
            int i;
            if (spanCondition == UnicodeSet.SpanCondition.CONTAINED) {
                block1: for (i = 0; i < stringsLength; ++i) {
                    int overlap = this.spanLengths[i];
                    if (overlap == 255) continue;
                    String string = this.strings.get(i);
                    int length16 = string.length();
                    if (overlap >= 254) {
                        overlap = length16;
                        overlap = string.offsetByCodePoints(overlap, -1);
                    }
                    if (overlap > spanLength) {
                        overlap = spanLength;
                    }
                    for (int inc = length16 - overlap; inc <= rest; ++inc) {
                        if (!this.offsets.containsOffset(inc) && UnicodeSetStringSpan.matches16CPB(s, pos - overlap, length, string, length16)) {
                            if (inc == rest) {
                                return length;
                            }
                            this.offsets.addOffset(inc);
                        }
                        if (overlap == 0) continue block1;
                        --overlap;
                    }
                }
            } else {
                int maxInc = 0;
                int maxOverlap = 0;
                block3: for (i = 0; i < stringsLength; ++i) {
                    int overlap = this.spanLengths[i];
                    String string = this.strings.get(i);
                    int length16 = string.length();
                    if (overlap >= 254) {
                        overlap = length16;
                    }
                    if (overlap > spanLength) {
                        overlap = spanLength;
                    }
                    for (int inc = length16 - overlap; inc <= rest && overlap >= maxOverlap; --overlap, ++inc) {
                        if (overlap <= maxOverlap && inc <= maxInc || !UnicodeSetStringSpan.matches16CPB(s, pos - overlap, length, string, length16)) continue;
                        maxInc = inc;
                        maxOverlap = overlap;
                        continue block3;
                    }
                }
                if (maxInc != 0 || maxOverlap != 0) {
                    pos += maxInc;
                    if ((rest -= maxInc) == 0) {
                        return length;
                    }
                    spanLength = 0;
                    continue;
                }
            }
            if (spanLength != 0 || pos == 0) {
                if (this.offsets.isEmpty()) {
                    return pos;
                }
            } else {
                if (this.offsets.isEmpty()) {
                    int n = this.spanSet.span(s, pos, UnicodeSet.SpanCondition.CONTAINED);
                    spanLength = n - pos;
                    if (spanLength == rest || spanLength == 0) {
                        return n;
                    }
                    pos += spanLength;
                    rest -= spanLength;
                    continue;
                }
                spanLength = UnicodeSetStringSpan.spanOne(this.spanSet, s, pos, rest);
                if (spanLength > 0) {
                    if (spanLength == rest) {
                        return length;
                    }
                    pos += spanLength;
                    rest -= spanLength;
                    this.offsets.shift(spanLength);
                    spanLength = 0;
                    continue;
                }
            }
            int minOffset = this.offsets.popMinimum$5b9c0059(null);
            pos += minOffset;
            rest -= minOffset;
            spanLength = 0;
        }
    }

    public final int spanAndCount$3279c9dc(CharSequence s, int start, UnicodeSet.SpanCondition spanCondition, DraggableKt outCount) {
        int maxInc;
        if (spanCondition == UnicodeSet.SpanCondition.NOT_CONTAINED) {
            return this.spanNot$16a03792(s, start, outCount);
        }
        if (spanCondition == UnicodeSet.SpanCondition.CONTAINED) {
            return this.spanContainedAndCount$16a03792(s, start, outCount);
        }
        int stringsLength = this.strings.size();
        int length = s.length();
        int pos = start;
        int count = 0;
        for (int rest = length - start; rest != 0; rest -= maxInc) {
            int cpLength = UnicodeSetStringSpan.spanOne(this.spanSet, s, pos, rest);
            maxInc = cpLength > 0 ? cpLength : 0;
            for (int i = 0; i < stringsLength; ++i) {
                String string = this.strings.get(i);
                int length16 = string.length();
                if (maxInc >= length16 || length16 > rest || !UnicodeSetStringSpan.matches16CPB(s, pos, length, string, length16)) continue;
                maxInc = length16;
            }
            if (maxInc == 0) {
                DraggableKt draggableKt = outCount;
                int n = count;
                throw null;
            }
            ++count;
            pos += maxInc;
        }
        DraggableKt draggableKt = outCount;
        int n = count;
        throw null;
    }

    /*
     * WARNING - void declaration
     */
    private synchronized int spanContainedAndCount$16a03792(CharSequence s, int start, DraggableKt outCount) {
        void var3_3;
        this.offsets.setMaxLength(this.maxLength16);
        int stringsLength = this.strings.size();
        int length = s.length();
        int pos = start;
        int rest = length - start;
        int count = 0;
        if (rest != 0) {
            int cpLength = UnicodeSetStringSpan.spanOne(this.spanSet, s, pos, rest);
            if (cpLength > 0) {
                this.offsets.addOffsetAndCount(cpLength, count + 1);
            }
            for (int i = 0; i < stringsLength; ++i) {
                String string = this.strings.get(i);
                int length16 = string.length();
                if (length16 > rest || this.offsets.hasCountAtOffset(length16, count + 1) || !UnicodeSetStringSpan.matches16CPB(s, pos, length, string, length16)) continue;
                this.offsets.addOffsetAndCount(length16, count + 1);
            }
            if (this.offsets.isEmpty()) {
                DraggableKt draggableKt = outCount;
                int n = count;
                throw null;
            }
            int n = this.offsets.popMinimum$5b9c0059(outCount);
            DraggableKt draggableKt = outCount;
            throw null;
        }
        void v3 = var3_3;
        int n = count;
        throw null;
    }

    public final synchronized int spanBack(CharSequence s, int length22, UnicodeSet.SpanCondition spanCondition22) {
        UnicodeSet.SpanCondition spanCondition22;
        int length22;
        if (spanCondition22 == UnicodeSet.SpanCondition.NOT_CONTAINED) {
            int n;
            int spanCondition22 = length22;
            CharSequence length22 = s;
            s = this;
            int n2 = spanCondition22;
            int n3 = ((UnicodeSetStringSpan)s).strings.size();
            do {
                if ((n2 = ((UnicodeSetStringSpan)s).spanNotSet.spanBack(length22, n2, UnicodeSet.SpanCondition.NOT_CONTAINED)) == 0) {
                    return 0;
                }
                n = UnicodeSetStringSpan.spanOneBack(((UnicodeSetStringSpan)s).spanSet, length22, n2);
                if (n > 0) {
                    return n2;
                }
                for (int i = 0; i < n3; ++i) {
                    String string;
                    int n4;
                    if (((UnicodeSetStringSpan)s).spanLengths[i] == 255 || (n4 = (string = ((UnicodeSetStringSpan)s).strings.get(i)).length()) > n2 || !UnicodeSetStringSpan.matches16CPB(length22, n2 - n4, spanCondition22, string, n4)) continue;
                    return n2;
                }
            } while ((n2 += n) != 0);
            return 0;
        }
        int pos = this.spanSet.spanBack((CharSequence)s, length22, UnicodeSet.SpanCondition.CONTAINED);
        if (pos == 0) {
            return 0;
        }
        int spanLength = length22 - pos;
        int initSize = 0;
        if (spanCondition22 == UnicodeSet.SpanCondition.CONTAINED) {
            initSize = this.maxLength16;
        }
        this.offsets.setMaxLength(initSize);
        int stringsLength = this.strings.size();
        int spanBackLengthsOffset = 0;
        if (this.all) {
            spanBackLengthsOffset = stringsLength;
        }
        while (true) {
            int i;
            if (spanCondition22 == UnicodeSet.SpanCondition.CONTAINED) {
                block3: for (i = 0; i < stringsLength; ++i) {
                    int overlap = this.spanLengths[spanBackLengthsOffset + i];
                    if (overlap == 255) continue;
                    String string = this.strings.get(i);
                    int length16 = string.length();
                    if (overlap >= 254) {
                        overlap = length16;
                        int len1 = string.offsetByCodePoints(0, 1);
                        overlap -= len1;
                    }
                    if (overlap > spanLength) {
                        overlap = spanLength;
                    }
                    for (int dec = length16 - overlap; dec <= pos; ++dec) {
                        if (!this.offsets.containsOffset(dec) && UnicodeSetStringSpan.matches16CPB((CharSequence)s, pos - dec, length22, string, length16)) {
                            if (dec == pos) {
                                return 0;
                            }
                            this.offsets.addOffset(dec);
                        }
                        if (overlap == 0) continue block3;
                        --overlap;
                    }
                }
            } else {
                int maxDec = 0;
                int maxOverlap = 0;
                block5: for (i = 0; i < stringsLength; ++i) {
                    int overlap = this.spanLengths[spanBackLengthsOffset + i];
                    String string = this.strings.get(i);
                    int length16 = string.length();
                    if (overlap >= 254) {
                        overlap = length16;
                    }
                    if (overlap > spanLength) {
                        overlap = spanLength;
                    }
                    for (int dec = length16 - overlap; dec <= pos && overlap >= maxOverlap; --overlap, ++dec) {
                        if (overlap <= maxOverlap && dec <= maxDec || !UnicodeSetStringSpan.matches16CPB((CharSequence)s, pos - dec, length22, string, length16)) continue;
                        maxDec = dec;
                        maxOverlap = overlap;
                        continue block5;
                    }
                }
                if (maxDec != 0 || maxOverlap != 0) {
                    if ((pos -= maxDec) == 0) {
                        return 0;
                    }
                    spanLength = 0;
                    continue;
                }
            }
            if (spanLength != 0 || pos == length22) {
                if (this.offsets.isEmpty()) {
                    return pos;
                }
            } else {
                if (this.offsets.isEmpty()) {
                    int oldPos = pos;
                    pos = this.spanSet.spanBack((CharSequence)s, oldPos, UnicodeSet.SpanCondition.CONTAINED);
                    spanLength = oldPos - pos;
                    if (pos != 0 && spanLength != 0) continue;
                    return pos;
                }
                spanLength = UnicodeSetStringSpan.spanOneBack(this.spanSet, (CharSequence)s, pos);
                if (spanLength > 0) {
                    if (spanLength == pos) {
                        return 0;
                    }
                    pos -= spanLength;
                    this.offsets.shift(spanLength);
                    spanLength = 0;
                    continue;
                }
            }
            pos -= this.offsets.popMinimum$5b9c0059(null);
            spanLength = 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    private int spanNot$16a03792(CharSequence s, int start, DraggableKt outCount) {
        int cpLength;
        int length = s.length();
        int stringsLength = this.strings.size();
        int count = 0;
        do {
            int spanLimit;
            int pos;
            if (outCount != null) {
                spanLimit = this.spanNotSet.spanAndCount$3279c9dc(s, pos, UnicodeSet.SpanCondition.NOT_CONTAINED, outCount);
                DraggableKt draggableKt = outCount;
                int n = count;
                DraggableKt draggableKt2 = outCount;
                throw null;
            }
            spanLimit = this.spanNotSet.span(s, pos, UnicodeSet.SpanCondition.NOT_CONTAINED);
            if (spanLimit == length) {
                return length;
            }
            pos = spanLimit;
            int rest = length - spanLimit;
            cpLength = UnicodeSetStringSpan.spanOne(this.spanSet, s, pos, rest);
            if (cpLength > 0) {
                return pos;
            }
            for (int i = 0; i < stringsLength; ++i) {
                String string;
                int length16;
                if (this.spanLengths[i] == 255 || (length16 = (string = this.strings.get(i)).length()) > rest || !UnicodeSetStringSpan.matches16CPB(s, pos, length, string, length16)) continue;
                return pos;
            }
            pos -= cpLength;
            ++count;
        } while ((rest += cpLength) != 0);
        if (outCount != null) {
            void var3_3;
            void v3 = var3_3;
            int n = count;
            throw null;
        }
        return length;
    }

    private static short makeSpanLengthByte(int spanLength) {
        if (spanLength < 254) {
            int n;
            return (short)n;
        }
        return 254;
    }

    private static boolean matches16(CharSequence s, int start, String t, int length) {
        int end = start + length;
        while (length-- > 0) {
            if (s.charAt(--end) == t.charAt(length)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean matches16CPB(CharSequence s, int start, int limit, String t, int tlength) {
        void var1_1;
        CharSequence charSequence;
        void var2_2;
        void var3_3;
        return !(!UnicodeSetStringSpan.matches16(s, start, (String)var3_3, tlength) || start > 0 && Character.isHighSurrogate(s.charAt(start - 1)) && Character.isLowSurrogate(s.charAt(start)) || start + tlength < var2_2 && Character.isHighSurrogate(s.charAt(start + tlength - 1)) && Character.isLowSurrogate(charSequence.charAt((int)(var1_1 + tlength))));
    }

    /*
     * WARNING - void declaration
     */
    private static int spanOne(UnicodeSet set, CharSequence s, int start, int length) {
        UnicodeSet unicodeSet;
        void var2_3;
        char c2;
        void var3_4;
        char c = s.charAt(start);
        if (c >= '\ud800' && c <= '\udbff' && var3_4 >= 2 && AnimationSpecKt.isTrailSurrogate((int)(c2 = s.charAt((int)(var2_3 + true))))) {
            void var1_2;
            int supplementary = Character.toCodePoint(c, c2);
            if (set.contains((int)var1_2)) {
                return 2;
            }
            return -2;
        }
        if (unicodeSet.contains(c)) {
            return 1;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private static int spanOneBack(UnicodeSet set, CharSequence s, int length) {
        void var3_4;
        UnicodeSet unicodeSet;
        void var2_3;
        char c2;
        char c = s.charAt(length - 1);
        if (c >= '\udc00' && c <= '\udfff' && length >= 2 && AnimationSpecKt.isLeadSurrogate((int)(c2 = s.charAt((int)(var2_3 - 2))))) {
            void var1_2;
            int supplementary = Character.toCodePoint(c2, c);
            if (set.contains((int)var1_2)) {
                return 2;
            }
            return -2;
        }
        if (unicodeSet.contains((int)var3_4)) {
            return 1;
        }
        return -1;
    }

    static final class OffsetList {
        private int[] list = new int[16];
        private int length;
        private int start;

        /*
         * WARNING - void declaration
         */
        public final void setMaxLength(int maxLength) {
            if (maxLength > this.list.length) {
                void var1_1;
                this.list = new int[var1_1];
            }
            OffsetList offsetList = this;
            int n = offsetList.list.length;
            while (n-- > 0) {
                offsetList.list[n] = 0;
            }
            OffsetList offsetList2 = offsetList;
            offsetList2.length = 0;
            offsetList2.start = 0;
        }

        public final boolean isEmpty() {
            return this.length == 0;
        }

        /*
         * WARNING - void declaration
         */
        public final void shift(int delta) {
            void var1_1;
            int i = this.start + delta;
            if (i >= this.list.length) {
                i -= this.list.length;
            }
            if (this.list[i] != 0) {
                this.list[i] = 0;
                --this.length;
            }
            this.start = var1_1;
        }

        public final void addOffset(int offset) {
            int i = this.start + offset;
            if (i >= this.list.length) {
                i -= this.list.length;
            }
            assert (this.list[i] == 0);
            this.list[var1_1] = 1;
            ++this.length;
        }

        /*
         * WARNING - void declaration
         */
        public final void addOffsetAndCount(int offset, int count) {
            assert (count > 0);
            int i = this.start + offset;
            if (i >= this.list.length) {
                i -= this.list.length;
            }
            if (this.list[i] == 0) {
                this.list[i] = count;
                ++this.length;
                return;
            }
            if (count < this.list[i]) {
                void var2_2;
                this.list[var1_1] = var2_2;
            }
        }

        /*
         * WARNING - void declaration
         */
        public final boolean containsOffset(int offset) {
            void var1_1;
            int i = this.start + offset;
            if (i >= this.list.length) {
                i -= this.list.length;
            }
            return this.list[var1_1] != 0;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean hasCountAtOffset(int offset, int count) {
            void var2_2;
            void var1_1;
            int oldCount;
            int i = this.start + offset;
            if (i >= this.list.length) {
                i -= this.list.length;
            }
            return (oldCount = this.list[i]) != 0 && var1_1 <= var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public final int popMinimum$5b9c0059(DraggableKt outCount) {
            void var2_2;
            void var3_5;
            int count;
            int i = this.start;
            while (++i < this.list.length) {
                count = this.list[i];
                if (count == 0) continue;
                this.list[i] = 0;
                --this.length;
                int result = i - this.start;
                this.start = i;
                if (outCount != null) {
                    DraggableKt draggableKt = outCount;
                    int n = count;
                    throw null;
                }
                return result;
            }
            int result = this.list.length - this.start;
            i = 0;
            while ((count = this.list[i]) == 0) {
                ++i;
            }
            this.list[i] = 0;
            --this.length;
            this.start = i;
            if (outCount != null) {
                void var1_1;
                void v2 = var1_1;
                int n = count;
                throw null;
            }
            return (int)(var3_5 + var2_2);
        }
    }
}

