/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import androidx.compose.animation.core.AnimationSpecKt;
import com.ibm.icu.util.ICUUncheckedIOException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;

public final class Utility {
    private static final char[] UNESCAPE_MAP;
    private static char[] DIGITS;

    /*
     * WARNING - void declaration
     */
    public static final boolean sameObjects(Object a, Object b) {
        void var1_1;
        return a == var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final String escape(String s) {
        void var1_1;
        int c;
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < s.length(); i += AnimationSpecKt.getCharCount((int)c)) {
            void var3_3;
            c = Character.codePointAt(s, i);
            if (c >= 32 && c <= 127) {
                if (c == 92) {
                    buf.append("\\\\");
                    continue;
                }
                buf.append((char)c);
                continue;
            }
            boolean four = c <= 65535;
            buf.append(four ? "\\u" : "\\U");
            buf.append(Utility.hex((long)var3_3, four ? 4 : 8));
        }
        return var1_1.toString();
    }

    private static final int _digit8(int c) {
        if (c >= 48 && c <= 55) {
            int n;
            return n - 48;
        }
        return -1;
    }

    private static final int _digit16(int c) {
        if (c >= 48 && c <= 57) {
            return c - 48;
        }
        if (c >= 65 && c <= 70) {
            return c - 55;
        }
        if (c >= 97 && c <= 102) {
            int n;
            return n - 87;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int unescapeAndLengthAt(CharSequence s, int offset) {
        CharSequence charSequence;
        void var1_1;
        return Utility.unescapeAndLengthAt(s, (int)var1_1, charSequence.length());
    }

    /*
     * WARNING - void declaration
     */
    private static int unescapeAndLengthAt(CharSequence s, int offset, int length) {
        int n;
        char c2;
        void var2_7;
        CharSequence charSequence;
        int dig;
        int result = 0;
        int n2 = 0;
        int minDig = 0;
        int maxDig = 0;
        int bitsPerDigit = 4;
        boolean braces = false;
        if (offset < 0 || offset >= length) {
            return -1;
        }
        int start = offset;
        int c = s.charAt(offset++);
        switch (c) {
            case 117: {
                maxDig = 4;
                minDig = 4;
                break;
            }
            case 85: {
                maxDig = 8;
                minDig = 8;
                break;
            }
            case 120: {
                minDig = 1;
                if (offset < length && s.charAt(offset) == '{') {
                    ++offset;
                    braces = true;
                    maxDig = 8;
                    break;
                }
                maxDig = 2;
                break;
            }
            default: {
                dig = Utility._digit8(c);
                if (dig < 0) break;
                minDig = 1;
                maxDig = 3;
                n2 = 1;
                bitsPerDigit = 3;
                result = dig;
            }
        }
        if (minDig != 0) {
            void var3_8;
            while (offset < length && n2 < maxDig) {
                c = s.charAt(offset);
                dig = bitsPerDigit == 3 ? Utility._digit8(c) : Utility._digit16(c);
                if (dig < 0) break;
                result = result << bitsPerDigit | dig;
                ++offset;
                ++n2;
            }
            if (n2 < minDig) {
                return -1;
            }
            if (braces) {
                if (c != 125) {
                    return -1;
                }
                ++offset;
            }
            if (result < 0 || result >= 0x110000) {
                return -1;
            }
            if (offset < length && AnimationSpecKt.isLeadSurrogate((int)result)) {
                int ahead = offset + 1;
                char c3 = s.charAt(offset);
                c = c3;
                if (c3 == '\\' && ahead < length) {
                    int cpAndLength;
                    int tailLimit = ahead + 11;
                    if (tailLimit > length) {
                        tailLimit = length;
                    }
                    if ((cpAndLength = Utility.unescapeAndLengthAt(s, ahead, tailLimit)) >= 0) {
                        void var0_1;
                        c = cpAndLength >> 8;
                        ahead += var0_1 & 0xFF;
                    }
                }
                if (AnimationSpecKt.isTrailSurrogate((int)c)) {
                    offset = ahead;
                    result = AnimationSpecKt.toCodePoint((int)result, (int)c);
                }
            }
            length = offset;
            offset = start;
            void var0_2 = var3_8;
            return Utility.codePointAndLength((int)var0_2, length - offset);
        }
        for (int i = 0; i < UNESCAPE_MAP.length; i += 2) {
            if (c == UNESCAPE_MAP[i]) {
                length = offset;
                offset = start;
                char c4 = UNESCAPE_MAP[i + 1];
                return Utility.codePointAndLength(c4, length - offset);
            }
            if (c < UNESCAPE_MAP[i]) break;
        }
        if (c == 99 && offset < length) {
            c = Character.codePointAt(charSequence, offset);
            length = offset + Character.charCount(c);
            offset = start;
            int n3 = c & 0x1F;
            return Utility.codePointAndLength(n3, length - offset);
        }
        if (AnimationSpecKt.isLeadSurrogate((int)c) && offset < var2_7 && AnimationSpecKt.isTrailSurrogate((int)(c2 = charSequence.charAt(offset)))) {
            ++offset;
            c = AnimationSpecKt.toCodePoint((int)c, (int)c2);
        }
        var2_7 = n;
        n = start;
        int n4 = c;
        return Utility.codePointAndLength(n4, (int)(var2_7 - n));
    }

    /*
     * WARNING - void declaration
     */
    private static int codePointAndLength(int c, int length) {
        void var1_1;
        int n;
        assert (c >= 0 && c <= 0x10FFFF);
        assert (length >= 0 && length <= 255);
        return n << 8 | var1_1;
    }

    public static int cpFromCodePointAndLength(int cpAndLength) {
        int n;
        assert (cpAndLength >= 0);
        return n >> 8;
    }

    public static int lengthFromCodePointAndLength(int cpAndLength) {
        int n;
        assert (cpAndLength >= 0);
        return n & 0xFF;
    }

    /*
     * WARNING - void declaration
     */
    public static String hex(long i, int places) {
        void var0_1;
        void var3_3;
        String result;
        if (i == Long.MIN_VALUE) {
            return "-8000000000000000";
        }
        boolean negative = i < 0L;
        if (negative) {
            i = -i;
        }
        if ((result = Long.toString(i, 16).toUpperCase(Locale.ENGLISH)).length() < places) {
            void var2_2;
            result = "0000000000000000".substring(result.length(), (int)var2_2) + result;
        }
        if (var3_3 != false) {
            return "-" + result;
        }
        return var0_1;
    }

    public static boolean isUnprintable(int c) {
        int n;
        return c < 32 || n > 126;
    }

    public static boolean shouldAlwaysBeEscaped(int c) {
        int n;
        if (c < 32) {
            return true;
        }
        if (c <= 126) {
            return false;
        }
        if (c <= 159) {
            return true;
        }
        if (c < 55296) {
            return false;
        }
        if (c <= 57343 || 64976 <= c && c <= 65007 || (c & 0xFFFE) == 65534) {
            return true;
        }
        return n > 0x10FFFF;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Appendable> T escape(T result, int c) {
        try {
            void var1_2;
            result.append('\\');
            if ((c & 0xFFFF0000) != 0) {
                result.append('U');
                result.append(DIGITS[0xF & c >> 28]);
                result.append(DIGITS[0xF & c >> 24]);
                result.append(DIGITS[0xF & c >> 20]);
                result.append(DIGITS[0xF & c >> 16]);
            } else {
                result.append('u');
            }
            result.append(DIGITS[0xF & c >> 12]);
            result.append(DIGITS[0xF & c >> 8]);
            result.append(DIGITS[0xF & c >> 4]);
            result.append(DIGITS[0xF & var1_2]);
            return result;
        }
        catch (IOException e) {
            void var0_1;
            throw new ICUUncheckedIOException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String joinStrings(CharSequence delimiter, Iterable<? extends CharSequence> elements) {
        void var2_2;
        if (elements == null) {
            throw new NullPointerException("Delimiter or elements is null");
        }
        StringBuilder buf = new StringBuilder();
        Iterator<? extends CharSequence> itr = elements.iterator();
        boolean isFirstElem = true;
        while (itr.hasNext()) {
            CharSequence element = itr.next();
            if (element == null) continue;
            if (!isFirstElem) {
                buf.append(delimiter);
            } else {
                isFirstElem = false;
            }
            buf.append(element);
        }
        return var2_2.toString();
    }

    static {
        System.getProperty("line.separator");
        UNESCAPE_MAP = new char[]{'a', '\u0007', 'b', '\b', 'e', '\u001b', 'f', '\f', 'n', '\n', 'r', '\r', 't', '\t', 'v', '\u000b'};
        DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    }
}

