/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.breakiter;

import androidx.compose.animation.core.AnimationSpecKt;
import com.ibm.icu.impl.breakiter.DictionaryMatcher;
import com.ibm.icu.text.UCharacterIterator;
import com.ibm.icu.util.BytesTrie;
import java.text.CharacterIterator;

final class BytesDictionaryMatcher
extends DictionaryMatcher {
    private final byte[] characters;
    private final int transform;

    /*
     * WARNING - void declaration
     */
    public BytesDictionaryMatcher(byte[] chars, int transform) {
        void var2_2;
        void var1_1;
        this.characters = var1_1;
        AnimationSpecKt.assrt(((transform & 0x7F000000) == 0x1000000 ? 1 : 0) != 0);
        this.transform = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private int transform(int c) {
        void var1_1;
        if (c == 8205) {
            return 255;
        }
        if (c == 8204) {
            return 254;
        }
        int delta = c - (this.transform & 0x1FFFFF);
        if (delta < 0 || 253 < delta) {
            return -1;
        }
        return (int)var1_1;
    }

    @Override
    public final int matches(CharacterIterator text_, int maxLength, int[] lengths, int[] count_, int limit, int[] values) {
        UCharacterIterator text = UCharacterIterator.getInstance(text_);
        BytesTrie bt = new BytesTrie(this.characters, 0);
        int c = text.nextCodePoint();
        if (c == -1) {
            return 0;
        }
        BytesTrie.Result result = bt.first(this.transform(c));
        int numChars = 1;
        int count = 0;
        while (true) {
            if (result.hasValue()) {
                if (count < limit) {
                    if (values != null) {
                        values[count] = bt.getValue();
                    }
                    lengths[count] = numChars;
                    ++count;
                }
                if (result == BytesTrie.Result.FINAL_VALUE) {
                    break;
                }
            } else if (result == BytesTrie.Result.NO_MATCH) break;
            if (numChars >= maxLength || (result = text.nextCodePoint()) == -1) break;
            ++numChars;
            result = bt.next(this.transform(result));
        }
        count_[0] = count;
        return numChars;
    }
}

