/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.breakiter;

import androidx.compose.animation.core.AnimationSpecKt;
import androidx.compose.foundation.text.TextFieldKeyInput_desktopKt;
import com.ibm.icu.impl.ICUConfig;
import com.ibm.icu.impl.breakiter.DictionaryBreakEngine;
import com.ibm.icu.impl.breakiter.DictionaryData;
import com.ibm.icu.impl.breakiter.DictionaryMatcher;
import com.ibm.icu.impl.breakiter.MlBreakEngine;
import com.ibm.icu.text.Edits;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.UResourceBundle;
import java.io.IOException;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.HashSet;
import java.util.Iterator;

public final class CjkBreakEngine
extends DictionaryBreakEngine {
    private UnicodeSet fHangulWordSet = new UnicodeSet("[\\uac00-\\ud7a3]");
    private UnicodeSet fDigitOrOpenPunctuationOrAlphabetSet;
    private UnicodeSet fClosePunctuationSet;
    private DictionaryMatcher fDictionary = null;
    private HashSet<String> fSkipSet;
    private MlBreakEngine fMlBreakEngine;
    private boolean isCj = false;

    public CjkBreakEngine(boolean korean) throws IOException {
        CjkBreakEngine cjkBreakEngine;
        this.fHangulWordSet.freeze();
        this.fDigitOrOpenPunctuationOrAlphabetSet = new UnicodeSet("[[:Nd:][:Pi:][:Ps:][:Alphabetic:]]");
        this.fDigitOrOpenPunctuationOrAlphabetSet.freeze();
        this.fClosePunctuationSet = new UnicodeSet("[[:Pc:][:Pd:][:Pe:][:Pf:][:Po:]]");
        this.fClosePunctuationSet.freeze();
        this.fSkipSet = new HashSet();
        this.fDictionary = DictionaryData.loadDictionaryFor("Hira");
        if (korean) {
            CjkBreakEngine cjkBreakEngine2 = this;
            cjkBreakEngine2.setCharacters(cjkBreakEngine2.fHangulWordSet);
            return;
        }
        this.isCj = true;
        UnicodeSet cjSet = new UnicodeSet("[[:Han:][:Hiragana:][:Katakana:]\\u30fc\\uff70\\uff9e\\uff9f]");
        this.setCharacters((UnicodeSet)((Object)cjkBreakEngine));
        if (Boolean.parseBoolean(ICUConfig.get("com.ibm.icu.impl.breakiter.useMLPhraseBreaking", "false"))) {
            this.fMlBreakEngine = new MlBreakEngine(this.fDigitOrOpenPunctuationOrAlphabetSet, this.fClosePunctuationSet);
            return;
        }
        cjkBreakEngine = this;
        cjkBreakEngine.loadJapaneseExtensions();
        cjkBreakEngine.loadHiragana();
    }

    private void loadJapaneseExtensions() {
        UResourceBundle uResourceBundle = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt73b/brkitr", "ja");
        uResourceBundle = uResourceBundle.get("extensions");
        TextFieldKeyInput_desktopKt iterator = uResourceBundle.getIterator$7a0e042d();
        while (iterator.hasNext()) {
            this.fSkipSet.add(iterator.nextString());
        }
    }

    private void loadHiragana() {
        UnicodeSet hiraganaWordSet = new UnicodeSet("[:Hiragana:]");
        hiraganaWordSet.freeze();
        Object iterator = new Object(hiraganaWordSet){
            private int codepoint;
            private String string;
            private UnicodeSet set;
            private int endRange;
            private int range;
            private int endElement;
            private int nextElement;
            private Iterator<String> stringIterator;
            {
                void var1_1;
                this.endRange = 0;
                this.range = 0;
                this.stringIterator = null;
                this.reset((UnicodeSet)var1_1);
            }
            {
                this.endRange = 0;
                this.range = 0;
                this.stringIterator = null;
                this.reset(new UnicodeSet());
            }

            public boolean next() {
                if (this.nextElement <= this.endElement) {
                    this.codepoint = this.nextElement++;
                    return true;
                }
                if (this.range < this.endRange) {
                    Edits.1 v0 = this;
                    v0.loadRange(++v0.range);
                    this.codepoint = this.nextElement++;
                    return true;
                }
                if (this.stringIterator == null) {
                    return false;
                }
                this.codepoint = -1;
                this.string = this.stringIterator.next();
                if (!this.stringIterator.hasNext()) {
                    this.stringIterator = null;
                }
                return true;
            }

            /*
             * WARNING - void declaration
             */
            public void reset(UnicodeSet uset) {
                void var1_1;
                this.set = var1_1;
                this.reset();
            }

            public void reset() {
                this.endRange = this.set.getRangeCount() - 1;
                this.range = 0;
                this.endElement = -1;
                this.nextElement = 0;
                if (this.endRange >= 0) {
                    Edits.1 v0 = this;
                    v0.loadRange(v0.range);
                }
                if (this.set.hasStrings()) {
                    this.stringIterator = this.set.strings.iterator();
                    return;
                }
                this.stringIterator = null;
            }

            public String getString() {
                if (this.codepoint != -1) {
                    return AnimationSpecKt.valueOf((int)this.codepoint);
                }
                return this.string;
            }

            /*
             * WARNING - void declaration
             */
            private void loadRange(int aRange) {
                void var1_1;
                this.nextElement = this.set.getRangeStart(aRange);
                this.endElement = this.set.getRangeEnd((int)var1_1);
            }
        };
        while (iterator.next()) {
            this.fSkipSet.add(iterator.getString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object obj) {
        if (obj instanceof CjkBreakEngine) {
            void var1_1;
            CjkBreakEngine other = (CjkBreakEngine)obj;
            return this.fSet.equals(var1_1.fSet);
        }
        return false;
    }

    public final int hashCode() {
        return this.getClass().hashCode();
    }

    private static boolean isKatakana(int value) {
        int n;
        return value >= 12449 && value <= 12542 && value != 12539 || value >= 65382 && n <= 65439;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int divideUpDictionaryRange(CharacterIterator inText, int startPos, int endPos, DictionaryBreakEngine.DequeI foundBreaks, boolean isPhraseBreaking) {
        int is_katakana;
        StringCharacterIterator text;
        if (startPos >= endPos) {
            return 0;
        }
        inText.setIndex(startPos);
        int n = endPos - startPos;
        int[] charPositions = new int[n + 1];
        StringBuffer s = new StringBuffer("");
        inText.setIndex(startPos);
        while (inText.getIndex() < endPos) {
            s.append(inText.current());
            inText.next();
        }
        String prenormstr = s.toString();
        boolean isNormalized = Normalizer.quickCheck(prenormstr, Normalizer.NFKC) == Normalizer.YES || Normalizer.isNormalized(prenormstr, Normalizer.NFKC, 0);
        int numCodePts = 0;
        if (isNormalized) {
            text = new StringCharacterIterator(prenormstr);
            int index = 0;
            charPositions[0] = 0;
            while (index < prenormstr.length()) {
                int codepoint = prenormstr.codePointAt(index);
                charPositions[++numCodePts] = index += Character.charCount(codepoint);
            }
        } else {
            String normStr = Normalizer.normalize(prenormstr, Normalizer.NFKC);
            text = new StringCharacterIterator(normStr);
            charPositions = new int[normStr.length() + 1];
            Normalizer normalizer = new Normalizer(prenormstr, Normalizer.NFKC, 0);
            int index = 0;
            charPositions[0] = 0;
            while (index < normalizer.endIndex()) {
                normalizer.next();
                charPositions[++numCodePts] = index = normalizer.getIndex();
            }
        }
        if (Boolean.parseBoolean(ICUConfig.get("com.ibm.icu.impl.breakiter.useMLPhraseBreaking", "false")) && isPhraseBreaking && this.isCj) {
            return this.fMlBreakEngine.divideUpRange(inText, startPos, endPos, text, numCodePts, charPositions, foundBreaks);
        }
        int[] nArray = new int[numCodePts + 1];
        int[] bestSnlp = nArray;
        nArray[0] = 0;
        for (int i = 1; i <= numCodePts; ++i) {
            bestSnlp[i] = Integer.MAX_VALUE;
        }
        int[] prev = new int[numCodePts + 1];
        for (int i = 0; i <= numCodePts; ++i) {
            prev[i] = -1;
        }
        int[] values = new int[numCodePts];
        int[] lengths = new int[numCodePts];
        text.setIndex(0);
        int is_prev_katakana = 0;
        for (int i = 0; i < numCodePts; ++i) {
            int ix = text.getIndex();
            if (bestSnlp[i] != Integer.MAX_VALUE) {
                int newSnlp;
                int maxSearchLength2 = i + 20 < numCodePts ? 20 : numCodePts - i;
                int[] count_ = new int[1];
                this.fDictionary.matches(text, maxSearchLength2, lengths, count_, maxSearchLength2, values);
                int count = count_[0];
                text.setIndex(ix);
                if (!(count != 0 && lengths[0] == 1 || AnimationSpecKt.current32((CharacterIterator)text) == Integer.MAX_VALUE || this.fHangulWordSet.contains(AnimationSpecKt.current32((CharacterIterator)text)))) {
                    values[count] = 255;
                    lengths[count] = 1;
                    ++count;
                }
                for (int j = 0; j < count; ++j) {
                    int newSnlp2 = bestSnlp[i] + values[j];
                    if (newSnlp2 >= bestSnlp[lengths[j] + i]) continue;
                    bestSnlp[lengths[j] + i] = newSnlp2;
                    prev[lengths[j] + i] = i;
                }
                is_katakana = CjkBreakEngine.isKatakana(AnimationSpecKt.current32((CharacterIterator)text)) ? 1 : 0;
                if (is_prev_katakana == 0 && is_katakana != 0) {
                    int j;
                    AnimationSpecKt.next32((CharacterIterator)text);
                    for (j = i + 1; j < numCodePts && j - i < 20 && CjkBreakEngine.isKatakana(AnimationSpecKt.current32((CharacterIterator)text)); ++j) {
                        AnimationSpecKt.next32((CharacterIterator)text);
                    }
                    if (j - i < 20) {
                        is_prev_katakana = j - i;
                        int[] maxSearchLength2 = new int[]{8192, 984, 408, 240, 204, 252, 300, 372, 480};
                        newSnlp = bestSnlp[i] + (is_prev_katakana > 8 ? 8192 : maxSearchLength2[is_prev_katakana]);
                        if (newSnlp < bestSnlp[j]) {
                            bestSnlp[j] = newSnlp;
                            prev[j] = i;
                        }
                    }
                }
                newSnlp = is_katakana;
            }
            text.setIndex(ix);
            AnimationSpecKt.next32((CharacterIterator)text);
        }
        int[] t_boundary = new int[numCodePts + 1];
        int numBreaks = 0;
        if (bestSnlp[numCodePts] == Integer.MAX_VALUE) {
            t_boundary[0] = numCodePts;
            ++numBreaks;
        } else if (isPhraseBreaking) {
            t_boundary[0] = numCodePts;
            ++numBreaks;
            int prevIdx = numCodePts;
            int i = prev[numCodePts];
            while (i > 0) {
                int codeUnitIdx = prenormstr.offsetByCodePoints(0, i);
                is_katakana = prenormstr.offsetByCodePoints(0, prevIdx);
                int length = is_katakana - codeUnitIdx;
                prevIdx = i;
                String pattern = CjkBreakEngine.getPatternFromText(text, s, codeUnitIdx, length);
                text.setIndex(codeUnitIdx);
                if (!(this.fSkipSet.contains(pattern) || CjkBreakEngine.isKatakana(AnimationSpecKt.current32((CharacterIterator)text)) && CjkBreakEngine.isKatakana(AnimationSpecKt.previous32((CharacterIterator)text)))) {
                    t_boundary[numBreaks] = i;
                    ++numBreaks;
                }
                i = prev[i];
            }
        } else {
            void var10_12;
            int i = var10_12;
            while (i > 0) {
                t_boundary[numBreaks] = i;
                ++numBreaks;
                i = prev[i];
            }
            AnimationSpecKt.assrt((prev[t_boundary[numBreaks - 1]] == 0 ? 1 : 0) != 0);
        }
        if (foundBreaks.size() == 0 || foundBreaks.peek() < startPos) {
            t_boundary[numBreaks++] = 0;
        }
        int correctedNumBreaks = 0;
        int previous = -1;
        for (int i = numBreaks - 1; i >= 0; --i) {
            int pos = charPositions[t_boundary[i]] + startPos;
            inText.setIndex(pos);
            if (pos > previous && (pos != startPos || isPhraseBreaking && pos > 0 && this.fClosePunctuationSet.contains(AnimationSpecKt.previous32((CharacterIterator)inText)))) {
                foundBreaks.push(charPositions[t_boundary[i]] + startPos);
                ++correctedNumBreaks;
            }
            previous = pos;
        }
        if (!foundBreaks.isEmpty() && foundBreaks.peek() == endPos) {
            if (isPhraseBreaking) {
                void var3_3;
                inText.setIndex((int)var3_3);
                int current = AnimationSpecKt.current32((CharacterIterator)inText);
                if (current != Integer.MAX_VALUE && !this.fDigitOrOpenPunctuationOrAlphabetSet.contains(current)) {
                    foundBreaks.pop();
                    --correctedNumBreaks;
                }
            } else {
                foundBreaks.pop();
                --correctedNumBreaks;
            }
        }
        if (!foundBreaks.isEmpty()) {
            void var1_1;
            var1_1.setIndex(foundBreaks.peek());
        }
        return correctedNumBreaks;
    }

    /*
     * WARNING - void declaration
     */
    private static String getPatternFromText(CharacterIterator text, StringBuffer sb, int start, int length) {
        void var1_1;
        sb.setLength(0);
        if (length > 0) {
            text.setIndex(start);
            sb.append(text.current());
            for (int i = 1; i < length; ++i) {
                sb.append(text.next());
            }
        }
        return var1_1.toString();
    }
}

