/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.breakiter;

import androidx.compose.animation.core.AnimationSpecKt;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.breakiter.DictionaryBreakEngine;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.UResourceBundle;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LSTMBreakEngine
extends DictionaryBreakEngine {
    private final LSTMData fData;
    private int fScript;
    private final Vectorizer fVectorizer;

    /*
     * WARNING - void declaration
     */
    private LSTMBreakEngine(int script, UnicodeSet set, LSTMData data) {
        Vectorizer vectorizer;
        void var3_4;
        void var1_1;
        LSTMData lSTMData;
        this.setCharacters((UnicodeSet)((Object)lSTMData));
        this.fScript = var1_1;
        lSTMData = this.fData = var3_4;
        LSTMBreakEngine lSTMBreakEngine = this;
        switch (lSTMData.fType) {
            case CODE_POINTS: {
                vectorizer = new CodePointsVectorizer(lSTMBreakEngine, lSTMData.fDict);
                break;
            }
            case GRAPHEME_CLUSTER: {
                vectorizer = new GraphemeClusterVectorizer(lSTMBreakEngine, lSTMData.fDict);
                break;
            }
            default: {
                vectorizer = null;
            }
        }
        this.fVectorizer = vectorizer;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean handles(int c) {
        void var1_1;
        return this.fScript == AnimationSpecKt.getIntPropertyValue((int)var1_1, (int)4106);
    }

    private static void addDotProductTo(float[] a, float[][] b, float[] result) {
        assert (a.length == b.length);
        assert (b[0].length == result.length);
        for (int i = 0; i < result.length; ++i) {
            for (int j = 0; j < a.length; ++j) {
                int n = i;
                result[n] = result[n] + a[j] * b[j][i];
            }
        }
    }

    private static void hadamardProductTo(float[] a, float[] result) {
        assert (a.length == result.length);
        for (int i = 0; i < result.length; ++i) {
            int n = i;
            result[n] = result[n] * a[i];
        }
    }

    private static void sigmoid(float[] result, int start, int length) {
        assert (start < result.length);
        assert (start + length <= result.length);
        for (int i = start; i < start + length; ++i) {
            result[i] = (float)(1.0 / (1.0 + Math.exp(-result[i])));
        }
    }

    private static void tanh(float[] result, int start, int length) {
        assert (start < result.length);
        assert (start + length <= result.length);
        for (int i = start; i < start + length; ++i) {
            result[i] = (float)Math.tanh(result[i]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static int maxIndex(float[] data) {
        void var1_1;
        int index = 0;
        float max = data[0];
        for (int i = 1; i < data.length; ++i) {
            if (!(data[i] > max)) continue;
            max = data[i];
            index = i;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static float[] compute(float[][] W, float[][] U, float[] B, float[] x, float[] h2, float[] c) {
        void var0_1;
        float[] fArray;
        float[] fArray2;
        float[] fArray3;
        float[] ifco = Arrays.copyOf(B, B.length);
        LSTMBreakEngine.addDotProductTo(fArray3, W, ifco);
        LSTMBreakEngine.addDotProductTo(h2, (float[][])fArray2, ifco);
        int hunits = fArray.length / 4;
        LSTMBreakEngine.sigmoid(ifco, 0 * hunits, hunits);
        LSTMBreakEngine.sigmoid(ifco, 1 * hunits, hunits);
        LSTMBreakEngine.tanh(ifco, 2 * hunits, hunits);
        LSTMBreakEngine.sigmoid(ifco, 3 * hunits, hunits);
        LSTMBreakEngine.hadamardProductTo(Arrays.copyOfRange(ifco, hunits, 2 * hunits), c);
        fArray3 = c;
        fArray = Arrays.copyOfRange(ifco, 2 * hunits, 3 * hunits);
        fArray2 = Arrays.copyOf(ifco, hunits);
        assert (fArray2.length == fArray3.length);
        assert (fArray.length == fArray3.length);
        for (int h2 = 0; h2 < fArray3.length; ++h2) {
            int n = h2;
            fArray3[n] = fArray3[n] + fArray2[h2] * fArray[h2];
        }
        float[] h2 = Arrays.copyOf(c, c.length);
        LSTMBreakEngine.tanh(h2, 0, h2.length);
        LSTMBreakEngine.hadamardProductTo(Arrays.copyOfRange(ifco, 3 * hunits, 4 * var0_1), h2);
        return h2;
    }

    @Override
    public final int divideUpDictionaryRange(CharacterIterator fIter, int rangeStart, int rangeEnd, DictionaryBreakEngine.DequeI foundBreaks, boolean isPhraseBreaking) {
        int beginSize = foundBreaks.size();
        if (rangeEnd - rangeStart < 4) {
            return 0;
        }
        ArrayList<Integer> offsets = new ArrayList<Integer>(rangeEnd - rangeStart);
        ArrayList<Integer> indicies = new ArrayList<Integer>(rangeEnd - rangeStart);
        this.fVectorizer.vectorize(fIter, rangeStart, rangeEnd, offsets, indicies);
        int inputSeqLength = indicies.size();
        int hunits = this.fData.fForwardU.length;
        float[] c = new float[hunits];
        float[][] hBackward = new float[inputSeqLength][hunits];
        for (int i = inputSeqLength - 1; i >= 0; --i) {
            if (i != inputSeqLength - 1) {
                hBackward[i] = Arrays.copyOf(hBackward[i + 1], hunits);
            }
            hBackward[i] = LSTMBreakEngine.compute(this.fData.fBackwardW, this.fData.fBackwardU, this.fData.fBackwardB, this.fData.fEmbedding[(Integer)indicies.get(i)], hBackward[i], c);
        }
        c = new float[hunits];
        float[] forwardH = new float[hunits];
        float[] both = new float[2 * hunits];
        for (int i = 0; i < inputSeqLength; ++i) {
            forwardH = LSTMBreakEngine.compute(this.fData.fForwardW, this.fData.fForwardU, this.fData.fForwardB, this.fData.fEmbedding[(Integer)indicies.get(i)], forwardH, c);
            System.arraycopy(forwardH, 0, both, 0, hunits);
            int n = hunits;
            System.arraycopy(hBackward[i], 0, both, n, n);
            float[] logp = Arrays.copyOf(this.fData.fOutputB, this.fData.fOutputB.length);
            LSTMBreakEngine.addDotProductTo(both, this.fData.fOutputW, logp);
            int current = LSTMBreakEngine.maxIndex(logp);
            if (current != LSTMClass.BEGIN.ordinal() && current != LSTMClass.SINGLE.ordinal() || i == 0) continue;
            foundBreaks.push((Integer)offsets.get(i));
        }
        return foundBreaks.size() - beginSize;
    }

    public static LSTMData createData(int script) {
        UResourceBundle uResourceBundle;
        if (script != 23 && script != 24 && script != 28 && script != 38) {
            return null;
        }
        ICUResourceBundle iCUResourceBundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt73b/brkitr");
        String name = iCUResourceBundle.getStringWithFallback("lstm/" + UScript.getShortName(script));
        name = name.substring(0, name.indexOf("."));
        uResourceBundle = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt73b/brkitr", (String)((Object)uResourceBundle), ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        return new LSTMData(uResourceBundle);
    }

    /*
     * WARNING - void declaration
     */
    public static LSTMBreakEngine create(int script, LSTMData data) {
        void var1_1;
        void var3_3;
        int n;
        void var2_2;
        String setExpr = "[[:" + UScript.getShortName(script) + ":]&[:LineBreak=SA:]]";
        UnicodeSet set = new UnicodeSet();
        set.applyPattern((String)var2_2);
        set.compact();
        return new LSTMBreakEngine(n, (UnicodeSet)var3_3, (LSTMData)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ float[][] access$000(int[] x0, int x1, int x2, int x3) {
        int n;
        int n2;
        int[] nArray = x0;
        byte[] byArray = new byte[4];
        float[][] fArray = new float[n2][n];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                void var1_1;
                int n3 = nArray[var1_1++];
                byArray[0] = (byte)(n3 >> 24);
                byArray[1] = (byte)(n3 >> 16);
                byArray[2] = (byte)(n3 >> 8);
                byArray[3] = (byte)n3;
                fArray[i][j] = ByteBuffer.wrap(byArray).order(ByteOrder.BIG_ENDIAN).getFloat();
            }
        }
        return fArray;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ float[] access$100(int[] x0, int x1, int x2) {
        int n;
        int[] nArray = x0;
        byte[] byArray = new byte[4];
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            void var1_1;
            int n2 = nArray[var1_1++];
            byArray[0] = (byte)(n2 >> 24);
            byArray[1] = (byte)(n2 >> 16);
            byArray[2] = (byte)(n2 >> 8);
            byArray[3] = (byte)n2;
            fArray[i] = ByteBuffer.wrap(byArray).order(ByteOrder.BIG_ENDIAN).getFloat();
        }
        return fArray;
    }

    final class GraphemeClusterVectorizer
    extends Vectorizer {
        /*
         * WARNING - void declaration
         */
        public GraphemeClusterVectorizer(LSTMBreakEngine this$0, Map<String, Integer> dict) {
            super((LSTMBreakEngine)var1_1, (Map<String, Integer>)var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        public final void vectorize(CharacterIterator text, int startPos, int endPos, List<Integer> offsets, List<Integer> indicies) {
            BreakIterator iter = BreakIterator.getCharacterInstance();
            iter.setText(text);
            int last2 = iter.next(startPos);
            int curr = iter.next();
            while (curr != -1 && curr <= endPos) {
                int n;
                offsets.add(last2);
                int n2 = curr;
                int n3 = last2;
                CharacterIterator last2 = text;
                int n4 = last2.getIndex();
                last2.setIndex(n3);
                StringBuilder stringBuilder = new StringBuilder();
                char c = last2.current();
                while (c != '\uffff' && last2.getIndex() < n2) {
                    stringBuilder.append(c);
                    c = last2.next();
                }
                last2.setIndex(n4);
                String segment = stringBuilder.toString();
                int index = this.getIndex(segment);
                indicies.add(n);
                n = curr;
                curr = iter.next();
            }
        }
    }

    final class CodePointsVectorizer
    extends Vectorizer {
        /*
         * WARNING - void declaration
         */
        public CodePointsVectorizer(LSTMBreakEngine this$0, Map<String, Integer> dict) {
            super((LSTMBreakEngine)var1_1, (Map<String, Integer>)var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        public final void vectorize(CharacterIterator fIter, int rangeStart, int rangeEnd, List<Integer> offsets, List<Integer> indicies) {
            fIter.setIndex(rangeStart);
            char c = fIter.current();
            while (c != '\uffff' && fIter.getIndex() < rangeEnd) {
                offsets.add(fIter.getIndex());
                indicies.add(this.getIndex(String.valueOf(c)));
                c = fIter.next();
            }
        }
    }

    abstract class Vectorizer {
        private Map<String, Integer> fDict;

        /*
         * WARNING - void declaration
         */
        public Vectorizer(LSTMBreakEngine this$0, Map<String, Integer> dict) {
            void var2_2;
            this.fDict = var2_2;
        }

        public abstract void vectorize(CharacterIterator var1, int var2, int var3, List<Integer> var4, List<Integer> var5);

        /*
         * WARNING - void declaration
         */
        protected final int getIndex(String token) {
            void var1_1;
            Integer res = this.fDict.get(token);
            if (res == null) {
                return this.fDict.size();
            }
            return var1_1.intValue();
        }
    }

    public static final class LSTMData {
        public EmbeddingType fType;
        public Map<String, Integer> fDict;
        public float[][] fEmbedding;
        public float[][] fForwardW;
        public float[][] fForwardU;
        public float[] fForwardB;
        public float[][] fBackwardW;
        public float[][] fBackwardU;
        public float[] fBackwardB;
        public float[][] fOutputW;
        public float[] fOutputB;

        private LSTMData() {
        }

        /*
         * WARNING - void declaration
         */
        public LSTMData(UResourceBundle rb) {
            void var1_1;
            void var3_3;
            void var2_2;
            int embeddings = rb.get("embeddings").getInt();
            int hunits = rb.get("hunits").getInt();
            this.fType = EmbeddingType.UNKNOWN;
            rb.get("model").getString();
            String typeString = rb.get("type").getString();
            if (typeString.equals("codepoints")) {
                this.fType = EmbeddingType.CODE_POINTS;
            } else if (typeString.equals("graphclust")) {
                this.fType = EmbeddingType.GRAPHEME_CLUSTER;
            }
            String[] dict = rb.get("dict").getStringArray();
            int[] data = rb.get("data").getIntVector();
            int dataLen = data.length;
            int numIndex = dict.length;
            this.fDict = new HashMap<String, Integer>(numIndex + 1);
            int idx = 0;
            for (String embedding : dict) {
                this.fDict.put(embedding, idx++);
            }
            int mat1Size = (numIndex + 1) * embeddings;
            int mat2Size = (embeddings << 2) * hunits;
            int mat3Size = (hunits << 2) * hunits;
            int mat4Size = 4 * hunits;
            int mat5Size = mat2Size;
            int mat6Size = mat3Size;
            int mat7Size = mat4Size;
            int mat8Size = 2 * hunits << 2;
            assert (dataLen == mat1Size + mat2Size + mat3Size + mat4Size + mat5Size + mat6Size + mat7Size + mat8Size + 4);
            this.fEmbedding = LSTMBreakEngine.access$000(data, 0, numIndex + 1, embeddings);
            int start = mat1Size + 0;
            this.fForwardW = LSTMBreakEngine.access$000(data, start, embeddings, 4 * hunits);
            this.fForwardU = LSTMBreakEngine.access$000(data, start += mat2Size, hunits, 4 * hunits);
            this.fForwardB = LSTMBreakEngine.access$100(data, start += mat3Size, 4 * hunits);
            this.fBackwardW = LSTMBreakEngine.access$000(data, start += mat4Size, (int)var2_2, 4 * hunits);
            this.fBackwardU = LSTMBreakEngine.access$000(data, start += mat5Size, hunits, 4 * hunits);
            this.fBackwardB = LSTMBreakEngine.access$100(data, start += mat6Size, 4 * hunits);
            this.fOutputW = LSTMBreakEngine.access$000(data, start += mat7Size, 2 * var3_3, 4);
            this.fOutputB = LSTMBreakEngine.access$100((int[])var1_1, start += mat8Size, 4);
        }
    }

    public static final class LSTMClass
    extends Enum<LSTMClass> {
        public static final /* enum */ LSTMClass BEGIN = new LSTMClass();
        private static /* enum */ LSTMClass INSIDE = new LSTMClass();
        private static /* enum */ LSTMClass END = new LSTMClass();
        public static final /* enum */ LSTMClass SINGLE = new LSTMClass();

        static {
            LSTMClass[] lSTMClassArray = new LSTMClass[]{BEGIN, INSIDE, END, SINGLE};
        }
    }

    public static final class EmbeddingType
    extends Enum<EmbeddingType> {
        public static final /* enum */ EmbeddingType UNKNOWN = new EmbeddingType();
        public static final /* enum */ EmbeddingType CODE_POINTS = new EmbeddingType();
        public static final /* enum */ EmbeddingType GRAPHEME_CLUSTER = new EmbeddingType();
        private static final /* synthetic */ EmbeddingType[] $VALUES;

        public static EmbeddingType[] values() {
            return (EmbeddingType[])$VALUES.clone();
        }

        static {
            $VALUES = new EmbeddingType[]{UNKNOWN, CODE_POINTS, GRAPHEME_CLUSTER};
        }
    }
}

