/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.breakiter;

import androidx.compose.animation.core.AnimationSpecKt;
import com.ibm.icu.impl.breakiter.DictionaryBreakEngine;
import com.ibm.icu.impl.breakiter.DictionaryData;
import com.ibm.icu.impl.breakiter.DictionaryMatcher;
import com.ibm.icu.text.UnicodeSet;
import java.io.IOException;
import java.text.CharacterIterator;

public final class LaoBreakEngine
extends DictionaryBreakEngine {
    private DictionaryMatcher fDictionary;
    private UnicodeSet fEndWordSet;
    private UnicodeSet fBeginWordSet;
    private UnicodeSet fMarkSet;

    /*
     * WARNING - void declaration
     */
    public LaoBreakEngine() throws IOException {
        void var1_1;
        UnicodeSet laoWordSet = new UnicodeSet("[[:Laoo:]&[:LineBreak=SA:]]");
        this.fMarkSet = new UnicodeSet("[[:Laoo:]&[:LineBreak=SA:]&[:M:]]");
        this.fMarkSet.add(32);
        this.fBeginWordSet = new UnicodeSet(3713, 3758, 3776, 3780, 3804, 3805);
        laoWordSet.compact();
        this.fEndWordSet = new UnicodeSet(laoWordSet);
        this.fEndWordSet.remove(3776, 3780);
        this.fMarkSet.compact();
        this.fEndWordSet.compact();
        this.fBeginWordSet.compact();
        laoWordSet.freeze();
        this.fMarkSet.freeze();
        this.fEndWordSet.freeze();
        this.fBeginWordSet.freeze();
        this.setCharacters((UnicodeSet)var1_1);
        this.fDictionary = DictionaryData.loadDictionaryFor("Laoo");
    }

    public final boolean equals(Object obj) {
        return obj instanceof LaoBreakEngine;
    }

    public final int hashCode() {
        return this.getClass().hashCode();
    }

    @Override
    public final boolean handles(int c) {
        int n = AnimationSpecKt.getIntPropertyValue((int)c, (int)4106);
        return n == 24;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int divideUpDictionaryRange(CharacterIterator fIter, int rangeStart, int rangeEnd, DictionaryBreakEngine.DequeI foundBreaks, boolean isPhraseBreaking) {
        void var3_3;
        int current;
        if (rangeEnd - rangeStart < 2) {
            return 0;
        }
        int wordsFound = 0;
        DictionaryBreakEngine.PossibleWord[] words = new DictionaryBreakEngine.PossibleWord[3];
        for (int i = 0; i < 3; ++i) {
            words[i] = new DictionaryBreakEngine.PossibleWord();
        }
        fIter.setIndex(rangeStart);
        while ((current = fIter.getIndex()) < rangeEnd) {
            void var2_2;
            int currPos;
            int wordLength;
            block18: {
                block17: {
                    wordLength = 0;
                    int candidates = words[wordsFound % 3].candidates(fIter, this.fDictionary, rangeEnd);
                    if (candidates == 1) break block17;
                    if (candidates <= 1) break block18;
                    boolean foundBest = false;
                    if (fIter.getIndex() < rangeEnd) {
                        block2: do {
                            if (words[(wordsFound + 1) % 3].candidates(fIter, this.fDictionary, rangeEnd) <= 0) continue;
                            words[wordsFound % 3].markCurrent();
                            if (fIter.getIndex() >= rangeEnd) break;
                            do {
                                if (words[(wordsFound + 2) % 3].candidates(fIter, this.fDictionary, rangeEnd) <= 0) continue;
                                words[wordsFound % 3].markCurrent();
                                foundBest = true;
                                continue block2;
                            } while (words[(wordsFound + 1) % 3].backUp(fIter));
                        } while (words[wordsFound % 3].backUp(fIter) && !foundBest);
                    }
                }
                wordLength = words[wordsFound % 3].acceptMarked(fIter);
                ++wordsFound;
            }
            if (fIter.getIndex() < rangeEnd && wordLength < 3) {
                if (words[wordsFound % 3].candidates(fIter, this.fDictionary, rangeEnd) <= 0 && (wordLength == 0 || words[wordsFound % 3].longestPrefix() < 3)) {
                    int remaining = rangeEnd - (current + wordLength);
                    char pc = fIter.current();
                    int chars = 0;
                    while (true) {
                        fIter.next();
                        char uc = fIter.current();
                        ++chars;
                        if (--remaining <= 0) break;
                        if (this.fEndWordSet.contains(pc) && this.fBeginWordSet.contains(uc)) {
                            int candidate = words[(wordsFound + 1) % 3].candidates(fIter, this.fDictionary, rangeEnd);
                            fIter.setIndex(current + wordLength + chars);
                            if (candidate > 0) break;
                        }
                        char c = uc;
                    }
                    if (wordLength <= 0) {
                        ++wordsFound;
                    }
                    wordLength += chars;
                } else {
                    fIter.setIndex(current + wordLength);
                }
            }
            while ((currPos = fIter.getIndex()) < rangeEnd && this.fMarkSet.contains(fIter.current())) {
                fIter.next();
                wordLength += fIter.getIndex() - currPos;
            }
            if (wordLength <= 0) continue;
            foundBreaks.push(current + var2_2);
        }
        if (foundBreaks.peek() >= var3_3) {
            foundBreaks.pop();
            --wordsFound;
        }
        return wordsFound;
    }
}

