/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.breakiter;

import androidx.compose.animation.core.AnimationSpecKt;
import androidx.compose.foundation.text.TextFieldKeyInput_desktopKt;
import com.ibm.icu.impl.breakiter.DictionaryBreakEngine;
import com.ibm.icu.impl.breakiter.ModelIndex;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.UResourceBundle;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public final class MlBreakEngine {
    private UnicodeSet fDigitOrOpenPunctuationOrAlphabetSet;
    private UnicodeSet fClosePunctuationSet;
    private List<HashMap<String, Integer>> fModel;
    private int fNegativeSum;

    public MlBreakEngine(UnicodeSet digitOrOpenPunctuationOrAlphabetSet, UnicodeSet closePunctuationSet) {
        UResourceBundle uResourceBundle;
        this.fDigitOrOpenPunctuationOrAlphabetSet = digitOrOpenPunctuationOrAlphabetSet;
        this.fClosePunctuationSet = uResourceBundle;
        this.fModel = new ArrayList<HashMap<String, Integer>>(13);
        for (int i = 0; i < 13; ++i) {
            this.fModel.add(new HashMap());
        }
        this.fNegativeSum = 0;
        MlBreakEngine mlBreakEngine = this;
        uResourceBundle = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt73b/brkitr", "jaml");
        mlBreakEngine.initKeyValue(uResourceBundle, "UW1Keys", "UW1Values", mlBreakEngine.fModel.get(0));
        mlBreakEngine.initKeyValue(uResourceBundle, "UW2Keys", "UW2Values", mlBreakEngine.fModel.get(1));
        mlBreakEngine.initKeyValue(uResourceBundle, "UW3Keys", "UW3Values", mlBreakEngine.fModel.get(2));
        mlBreakEngine.initKeyValue(uResourceBundle, "UW4Keys", "UW4Values", mlBreakEngine.fModel.get(3));
        mlBreakEngine.initKeyValue(uResourceBundle, "UW5Keys", "UW5Values", mlBreakEngine.fModel.get(4));
        mlBreakEngine.initKeyValue(uResourceBundle, "UW6Keys", "UW6Values", mlBreakEngine.fModel.get(5));
        mlBreakEngine.initKeyValue(uResourceBundle, "BW1Keys", "BW1Values", mlBreakEngine.fModel.get(6));
        mlBreakEngine.initKeyValue(uResourceBundle, "BW2Keys", "BW2Values", mlBreakEngine.fModel.get(7));
        mlBreakEngine.initKeyValue(uResourceBundle, "BW3Keys", "BW3Values", mlBreakEngine.fModel.get(8));
        mlBreakEngine.initKeyValue(uResourceBundle, "TW1Keys", "TW1Values", mlBreakEngine.fModel.get(9));
        mlBreakEngine.initKeyValue(uResourceBundle, "TW2Keys", "TW2Values", mlBreakEngine.fModel.get(10));
        mlBreakEngine.initKeyValue(uResourceBundle, "TW3Keys", "TW3Values", mlBreakEngine.fModel.get(11));
        mlBreakEngine.initKeyValue(uResourceBundle, "TW4Keys", "TW4Values", mlBreakEngine.fModel.get(12));
        mlBreakEngine.fNegativeSum /= 2;
    }

    /*
     * WARNING - void declaration
     */
    public final int divideUpRange(CharacterIterator inText, int startPos, int endPos, CharacterIterator inString, int codePointLength, int[] charPositions, DictionaryBreakEngine.DequeI foundBreaks) {
        if (startPos >= endPos) {
            return 0;
        }
        ArrayList<Integer> boundary = new ArrayList<Integer>(codePointLength);
        String inputStr = MlBreakEngine.transform(inString);
        int n = codePointLength + 4;
        int[] indexList = new int[n];
        int n2 = codePointLength;
        int[] nArray = indexList;
        CharacterIterator characterIterator = inString;
        int n3 = 0;
        characterIterator.setIndex(0);
        Arrays.fill(nArray, -1);
        if (n2 > 0) {
            nArray[2] = 0;
            n3 = 0 + Character.charCount(AnimationSpecKt.current32((CharacterIterator)characterIterator));
            if (n2 > 1) {
                nArray[3] = n3;
                n3 += Character.charCount(AnimationSpecKt.next32((CharacterIterator)characterIterator));
                if (n2 > 2) {
                    nArray[4] = n3;
                    n3 += Character.charCount(AnimationSpecKt.next32((CharacterIterator)characterIterator));
                    if (n2 > 3) {
                        nArray[5] = n3;
                        n3 += Character.charCount(AnimationSpecKt.next32((CharacterIterator)characterIterator));
                    }
                }
            }
        }
        int numCodeUnits = n3;
        boundary.add(0, 0);
        int idx = 0;
        while (idx + 1 < codePointLength) {
            this.evaluateBreakpoint(inputStr, indexList, idx, numCodeUnits, boundary);
            if (idx + 4 < codePointLength) {
                indexList[idx + 6] = numCodeUnits;
                numCodeUnits += Character.charCount(AnimationSpecKt.next32((CharacterIterator)inString));
            }
            ++idx;
        }
        ArrayList<Integer> arrayList = boundary;
        if ((Integer)arrayList.get(arrayList.size() - 1) != codePointLength) {
            boundary.add(codePointLength);
        }
        int correctedNumBreaks = 0;
        int previous = -1;
        int numBreaks = boundary.size();
        for (int i = 0; i < numBreaks; ++i) {
            int pos = charPositions[boundary.get(i)] + startPos;
            inText.setIndex(pos);
            if (pos > previous && (pos != startPos || pos > 0 && this.fClosePunctuationSet.contains(AnimationSpecKt.previous32((CharacterIterator)inText)))) {
                foundBreaks.push(pos);
                ++correctedNumBreaks;
            }
            previous = pos;
        }
        if (!foundBreaks.isEmpty() && foundBreaks.peek() == endPos) {
            void var3_3;
            inText.setIndex((int)var3_3);
            int current = AnimationSpecKt.current32((CharacterIterator)inText);
            if (current != Integer.MAX_VALUE && !this.fDigitOrOpenPunctuationOrAlphabetSet.contains(current)) {
                foundBreaks.pop();
                --correctedNumBreaks;
            }
        }
        if (!foundBreaks.isEmpty()) {
            void var1_1;
            var1_1.setIndex(foundBreaks.peek());
        }
        return correctedNumBreaks;
    }

    /*
     * WARNING - void declaration
     */
    private static String transform(CharacterIterator inString) {
        void var1_1;
        StringBuilder sb = new StringBuilder();
        inString.setIndex(0);
        char c = inString.first();
        while (c != '\uffff') {
            sb.append(c);
            c = inString.next();
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    private void evaluateBreakpoint(String inputStr, int[] indexList, int startIdx, int numCodeUnits, ArrayList<Integer> boundary) {
        int end;
        int start;
        int i;
        int score = this.fNegativeSum;
        for (i = 0; i < 6; ++i) {
            start = startIdx + i;
            if (indexList[start] == -1) continue;
            end = indexList[start + 1] != -1 ? indexList[start + 1] : numCodeUnits;
            score += this.fModel.get(ModelIndex.kUWStart.getValue() + i).getOrDefault(inputStr.substring(indexList[start], end), 0).intValue();
        }
        for (i = 0; i < 3; ++i) {
            start = startIdx + i + 1;
            if (indexList[start] == -1 || indexList[start + 1] == -1) continue;
            end = indexList[start + 2] != -1 ? indexList[start + 2] : numCodeUnits;
            score += this.fModel.get(ModelIndex.kBWStart.getValue() + i).getOrDefault(inputStr.substring(indexList[start], end), 0).intValue();
        }
        for (i = 0; i < 4; ++i) {
            start = startIdx + i;
            if (indexList[start] == -1 || indexList[start + 1] == -1 || indexList[start + 2] == -1) continue;
            end = indexList[start + 3] != -1 ? indexList[start + 3] : numCodeUnits;
            score += this.fModel.get(ModelIndex.kTWStart.getValue() + i).getOrDefault(inputStr.substring(indexList[start], end), 0).intValue();
        }
        if (score > 0) {
            void var3_3;
            boundary.add((int)(var3_3 + true));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void initKeyValue(UResourceBundle rb, String keyName, String valueName, HashMap<String, Integer> map) {
        void var3_3;
        int idx = 0;
        UResourceBundle keyBundle = rb.get(keyName);
        rb = rb.get((String)var3_3);
        int[] value = rb.getIntVector();
        TextFieldKeyInput_desktopKt iterator = keyBundle.getIterator$7a0e042d();
        while (iterator.hasNext()) {
            this.fNegativeSum -= value[idx];
            map.put(iterator.nextString(), value[idx++]);
        }
    }
}

