/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.locale;

import com.ibm.icu.impl.locale.AsciiUtil;
import com.ibm.icu.impl.locale.LocaleObjectCache;

public final class BaseLocale {
    private static final Cache CACHE = new Cache();
    public static final BaseLocale ROOT = BaseLocale.getInstance("", "", "", "");
    private String _language = "";
    private String _script = "";
    private String _region = "";
    private String _variant = "";
    private volatile transient int _hash = 0;

    /*
     * WARNING - void declaration
     */
    private BaseLocale(String language, String script, String region, String variant) {
        if (language != null) {
            void var1_1;
            this._language = AsciiUtil.toLowerString((String)var1_1).intern();
        }
        if (script != null) {
            void var2_2;
            this._script = AsciiUtil.toTitleString((String)var2_2).intern();
        }
        if (region != null) {
            void var3_3;
            this._region = AsciiUtil.toUpperString((String)var3_3).intern();
        }
        if (variant != null) {
            this._variant = AsciiUtil.toUpperString(variant).intern();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static BaseLocale getInstance(String language, String script, String region, String variant) {
        Key key;
        void var3_3;
        void var2_2;
        void var1_1;
        Key key2 = new Key(language, (String)var1_1, (String)var2_2, (String)var3_3);
        key = (BaseLocale)CACHE.get(key);
        return key;
    }

    public final String getLanguage() {
        return this._language;
    }

    public final String getScript() {
        return this._script;
    }

    public final String getRegion() {
        return this._region;
    }

    public final String getVariant() {
        return this._variant;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object obj) {
        void var1_1;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BaseLocale)) {
            return false;
        }
        BaseLocale other = (BaseLocale)obj;
        return this.hashCode() == other.hashCode() && this._language.equals(other._language) && this._script.equals(other._script) && this._region.equals(other._region) && this._variant.equals(var1_1._variant);
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuilder buf = new StringBuilder();
        if (this._language.length() > 0) {
            buf.append("language=");
            buf.append(this._language);
        }
        if (this._script.length() > 0) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append("script=");
            buf.append(this._script);
        }
        if (this._region.length() > 0) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append("region=");
            buf.append(this._region);
        }
        if (this._variant.length() > 0) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append("variant=");
            buf.append(this._variant);
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var1_1;
        int h = this._hash;
        if (h == 0) {
            int i;
            for (i = 0; i < this._language.length(); ++i) {
                h = h * 31 + this._language.charAt(i);
            }
            for (i = 0; i < this._script.length(); ++i) {
                h = h * 31 + this._script.charAt(i);
            }
            for (i = 0; i < this._region.length(); ++i) {
                h = h * 31 + this._region.charAt(i);
            }
            for (i = 0; i < this._variant.length(); ++i) {
                h = h * 31 + this._variant.charAt(i);
            }
            this._hash = h;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    /* synthetic */ BaseLocale(String x0, String x1, String x2, String x3, byte by) {
        this((String)var1_1, (String)var2_2, (String)var3_3, x3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    static final class Cache
    extends LocaleObjectCache<Key, BaseLocale> {
    }

    static final class Key
    implements Comparable<Key> {
        private String _lang = "";
        private String _scrt = "";
        private String _regn = "";
        private String _vart = "";
        private volatile int _hash;

        /*
         * WARNING - void declaration
         */
        public Key(String language, String script, String region, String variant) {
            if (language != null) {
                void var1_1;
                this._lang = var1_1;
            }
            if (script != null) {
                void var2_2;
                this._scrt = var2_2;
            }
            if (region != null) {
                void var3_3;
                this._regn = var3_3;
            }
            if (variant != null) {
                this._vart = variant;
            }
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object obj) {
            void var1_1;
            return this == obj || obj instanceof Key && AsciiUtil.caseIgnoreMatch(((Key)obj)._lang, this._lang) && AsciiUtil.caseIgnoreMatch(((Key)obj)._scrt, this._scrt) && AsciiUtil.caseIgnoreMatch(((Key)obj)._regn, this._regn) && AsciiUtil.caseIgnoreMatch(((Key)var1_1)._vart, this._vart);
        }

        /*
         * WARNING - void declaration
         */
        public final int hashCode() {
            void var1_1;
            int h = this._hash;
            if (h == 0) {
                int i;
                for (i = 0; i < this._lang.length(); ++i) {
                    h = h * 31 + AsciiUtil.toLower(this._lang.charAt(i));
                }
                for (i = 0; i < this._scrt.length(); ++i) {
                    h = h * 31 + AsciiUtil.toLower(this._scrt.charAt(i));
                }
                for (i = 0; i < this._regn.length(); ++i) {
                    h = h * 31 + AsciiUtil.toLower(this._regn.charAt(i));
                }
                for (i = 0; i < this._vart.length(); ++i) {
                    h = h * 31 + AsciiUtil.toLower(this._vart.charAt(i));
                }
                this._hash = h;
            }
            return (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public static Key normalize(Key key) {
            String string;
            void var3_3;
            void var2_2;
            void var1_1;
            String lang = AsciiUtil.toLowerString(key._lang).intern();
            String scrt = AsciiUtil.toTitleString(key._scrt).intern();
            String regn = AsciiUtil.toUpperString(key._regn).intern();
            String vart = AsciiUtil.toUpperString(key._vart).intern();
            return new Key((String)var1_1, (String)var2_2, (String)var3_3, string);
        }
    }
}

