/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.locale;

import androidx.compose.foundation.text.TextFieldGestureModifiersKt;
import com.ibm.icu.impl.locale.AsciiUtil;
import com.ibm.icu.impl.locale.BaseLocale;
import com.ibm.icu.impl.locale.LanguageTag;
import com.ibm.icu.impl.locale.LocaleExtensions;
import com.ibm.icu.impl.locale.LocaleSyntaxException;
import com.ibm.icu.impl.locale.UnicodeLocaleExtension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class InternalLocaleBuilder {
    private String _language = "";
    private String _script = "";
    private String _region = "";
    private String _variant = "";
    private static final CaseInsensitiveChar PRIVUSE_KEY = new CaseInsensitiveChar("x".charAt(0));
    private HashMap<CaseInsensitiveChar, String> _extensions;
    private HashSet<CaseInsensitiveString> _uattributes;
    private HashMap<CaseInsensitiveString, String> _ukeywords;

    /*
     * WARNING - void declaration
     */
    public final InternalLocaleBuilder addUnicodeLocaleAttribute(String attribute) throws LocaleSyntaxException {
        void var1_1;
        if (attribute == null || !UnicodeLocaleExtension.isAttribute(attribute)) {
            throw new LocaleSyntaxException("Ill-formed Unicode locale attribute: " + attribute);
        }
        if (this._uattributes == null) {
            this._uattributes = new HashSet(4);
        }
        this._uattributes.add(new CaseInsensitiveString((String)var1_1));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final InternalLocaleBuilder setUnicodeLocaleKeyword(String key, String type) throws LocaleSyntaxException {
        if (!UnicodeLocaleExtension.isKey(key)) {
            throw new LocaleSyntaxException("Ill-formed Unicode locale keyword key: " + key);
        }
        CaseInsensitiveString cikey = new CaseInsensitiveString(key);
        if (type == null) {
            if (this._ukeywords != null) {
                this._ukeywords.remove(cikey);
            }
        } else {
            void var2_2;
            void var1_1;
            if (type.length() != 0) {
                String tp = type.replaceAll("_", "-");
                TextFieldGestureModifiersKt itr = new TextFieldGestureModifiersKt(tp, "-");
                while (!itr.isDone()) {
                    String string = itr.current();
                    if (!UnicodeLocaleExtension.isTypeSubtag(string)) {
                        throw new LocaleSyntaxException("Ill-formed Unicode locale keyword type: " + type, itr.currentStart());
                    }
                    itr.next();
                }
            }
            if (this._ukeywords == null) {
                this._ukeywords = new HashMap(4);
            }
            this._ukeywords.put((CaseInsensitiveString)var1_1, (String)var2_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final InternalLocaleBuilder setExtension(char singleton, String value) throws LocaleSyntaxException {
        boolean isBcpPrivateuse = LanguageTag.isPrivateusePrefixChar(singleton);
        if (!isBcpPrivateuse && !LanguageTag.isExtensionSingletonChar(singleton)) {
            throw new LocaleSyntaxException("Ill-formed extension key: " + singleton);
        }
        boolean remove = value == null || value.length() == 0;
        CaseInsensitiveChar key = new CaseInsensitiveChar(singleton);
        if (remove) {
            if (UnicodeLocaleExtension.isSingletonChar(key.value())) {
                if (this._uattributes != null) {
                    this._uattributes.clear();
                }
                if (this._ukeywords != null) {
                    this._ukeywords.clear();
                }
            } else if (this._extensions != null && this._extensions.containsKey(key)) {
                this._extensions.remove(key);
            }
        } else {
            String val = value.replaceAll("_", "-");
            TextFieldGestureModifiersKt itr = new TextFieldGestureModifiersKt(val, "-");
            while (!itr.isDone()) {
                String s = itr.current();
                boolean validSubtag = isBcpPrivateuse ? LanguageTag.isPrivateuseSubtag(s) : LanguageTag.isExtensionSubtag(s);
                if (!validSubtag) {
                    throw new LocaleSyntaxException("Ill-formed extension value: " + s, itr.currentStart());
                }
                itr.next();
            }
            if (UnicodeLocaleExtension.isSingletonChar(key.value())) {
                this.setUnicodeLocaleExtension(val);
            } else {
                void var2_3;
                void var1_2;
                if (this._extensions == null) {
                    this._extensions = new HashMap(4);
                }
                this._extensions.put((CaseInsensitiveChar)var1_2, (String)var2_3);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private InternalLocaleBuilder setExtensions(List<String> bcpExtensions, String privateuse) {
        this.clearExtensions();
        if (bcpExtensions != null && bcpExtensions.size() > 0) {
            Iterator iterator;
            HashSet processedExtensions = new HashSet(bcpExtensions.size());
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                String bcpExt = (String)iterator.next();
                CaseInsensitiveChar key = new CaseInsensitiveChar(bcpExt.charAt(0));
                if (processedExtensions.contains(key)) continue;
                if (UnicodeLocaleExtension.isSingletonChar(key.value())) {
                    this.setUnicodeLocaleExtension(bcpExt.substring(2));
                    continue;
                }
                if (this._extensions == null) {
                    this._extensions = new HashMap(4);
                }
                this._extensions.put(key, bcpExt.substring(2));
            }
        }
        if (privateuse != null && privateuse.length() > 0) {
            void var2_2;
            if (this._extensions == null) {
                this._extensions = new HashMap(1);
            }
            this._extensions.put(new CaseInsensitiveChar(privateuse.charAt(0)), var2_2.substring(2));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final InternalLocaleBuilder setLanguageTag(LanguageTag langtag) {
        void var1_1;
        InternalLocaleBuilder internalLocaleBuilder = this;
        this._language = "";
        internalLocaleBuilder._script = "";
        internalLocaleBuilder._region = "";
        internalLocaleBuilder._variant = "";
        internalLocaleBuilder.clearExtensions();
        if (langtag.getExtlangs().size() > 0) {
            this._language = langtag.getExtlangs().get(0);
        } else {
            String language = langtag.getLanguage();
            if (!language.equals(LanguageTag.UNDETERMINED)) {
                this._language = language;
            }
        }
        this._script = langtag.getScript();
        this._region = langtag.getRegion();
        ArrayList<String> bcpVariants = new ArrayList<String>(langtag.getVariants());
        Collections.sort(bcpVariants);
        if (bcpVariants.size() > 0) {
            void var3_3;
            StringBuilder var = new StringBuilder(bcpVariants.get(0));
            for (int i = 1; i < bcpVariants.size(); ++i) {
                var.append("_").append(bcpVariants.get(i));
            }
            this._variant = var3_3.toString();
        }
        this.setExtensions(langtag.getExtensions(), var1_1.getPrivateuse());
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final InternalLocaleBuilder setLocale(BaseLocale base, LocaleExtensions extensions) throws LocaleSyntaxException {
        Iterator<Character> iterator;
        int errIdx;
        String language = base.getLanguage();
        String script = base.getScript();
        String region = base.getRegion();
        String variant = base.getVariant();
        if (language.length() > 0 && !LanguageTag.isLanguage(language)) {
            throw new LocaleSyntaxException("Ill-formed language: " + language);
        }
        if (script.length() > 0 && !LanguageTag.isScript(script)) {
            throw new LocaleSyntaxException("Ill-formed script: " + script);
        }
        if (region.length() > 0 && !LanguageTag.isRegion(region)) {
            throw new LocaleSyntaxException("Ill-formed region: " + region);
        }
        if (variant.length() > 0 && (errIdx = InternalLocaleBuilder.checkVariants(variant, "_")) != -1) {
            throw new LocaleSyntaxException("Ill-formed variant: " + variant, errIdx);
        }
        this._language = language;
        this._script = script;
        this._region = region;
        this._variant = iterator;
        this.clearExtensions();
        Set<Character> extKeys = extensions == null ? null : extensions.getKeys();
        if (extKeys != null) {
            for (Character key : extKeys) {
                void var3_3;
                AsciiUtil e = extensions.getExtension$f40ab2c(key);
                if (e instanceof UnicodeLocaleExtension) {
                    UnicodeLocaleExtension ue = (UnicodeLocaleExtension)e;
                    for (String uatr : ue.getUnicodeLocaleAttributes()) {
                        if (this._uattributes == null) {
                            this._uattributes = new HashSet(4);
                        }
                        this._uattributes.add(new CaseInsensitiveString(uatr));
                    }
                    for (String ukey : ue.getUnicodeLocaleKeys()) {
                        if (this._ukeywords == null) {
                            this._ukeywords = new HashMap(4);
                        }
                        this._ukeywords.put(new CaseInsensitiveString(ukey), ue.getUnicodeLocaleType(ukey));
                    }
                    continue;
                }
                if (this._extensions == null) {
                    this._extensions = new HashMap(4);
                }
                this._extensions.put(new CaseInsensitiveChar(var3_3.charValue()), e.getValue());
            }
        }
        return this;
    }

    private InternalLocaleBuilder clearExtensions() {
        if (this._extensions != null) {
            this._extensions.clear();
        }
        if (this._uattributes != null) {
            this._uattributes.clear();
        }
        if (this._ukeywords != null) {
            this._ukeywords.clear();
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final BaseLocale getBaseLocale() {
        void var3_3;
        void var2_2;
        void var1_1;
        String string;
        String privuse;
        String language = this._language;
        String script = this._script;
        String region = this._region;
        String variant = this._variant;
        if (this._extensions != null && (privuse = this._extensions.get(PRIVUSE_KEY)) != null) {
            TextFieldGestureModifiersKt itr = new TextFieldGestureModifiersKt(privuse, "-");
            boolean sawPrefix = false;
            int privVarStart = -1;
            while (!itr.isDone()) {
                if (sawPrefix) {
                    privVarStart = itr.currentStart();
                    break;
                }
                if (AsciiUtil.caseIgnoreMatch(itr.current(), "lvariant")) {
                    sawPrefix = true;
                }
                itr.next();
            }
            if (privVarStart != -1) {
                StringBuilder sb = new StringBuilder(variant);
                if (sb.length() != 0) {
                    sb.append("_");
                }
                sb.append(privuse.substring(privVarStart).replaceAll("-", "_"));
                string = sb.toString();
            }
        }
        return BaseLocale.getInstance((String)var1_1, (String)var2_2, (String)var3_3, string);
    }

    public final LocaleExtensions getLocaleExtensions() {
        if (!(this._extensions != null && this._extensions.size() != 0 || this._uattributes != null && this._uattributes.size() != 0 || this._ukeywords != null && this._ukeywords.size() != 0)) {
            return LocaleExtensions.EMPTY_EXTENSIONS;
        }
        return new LocaleExtensions(this._extensions, this._uattributes, this._ukeywords);
    }

    /*
     * WARNING - void declaration
     */
    static String removePrivateuseVariant(String privuseVal) {
        void var2_2;
        String string;
        void var3_3;
        TextFieldGestureModifiersKt itr = new TextFieldGestureModifiersKt(privuseVal, "-");
        int prefixStart = -1;
        boolean sawPrivuseVar = false;
        while (!itr.isDone()) {
            if (prefixStart != -1) {
                sawPrivuseVar = true;
                break;
            }
            if (AsciiUtil.caseIgnoreMatch(itr.current(), "lvariant")) {
                prefixStart = itr.currentStart();
            }
            itr.next();
        }
        if (var3_3 == false) {
            return privuseVal;
        }
        assert (prefixStart == 0 || prefixStart > 1);
        if (prefixStart == 0) {
            return null;
        }
        return string.substring(0, (int)(var2_2 - true));
    }

    private static int checkVariants(String variants, String sep) {
        String string;
        String itr = new TextFieldGestureModifiersKt(variants, string);
        while (!itr.isDone()) {
            string = itr.current();
            if (!LanguageTag.isVariant(string)) {
                return itr.currentStart();
            }
            itr.next();
        }
        return -1;
    }

    private void setUnicodeLocaleExtension(String subtags) {
        if (this._uattributes != null) {
            this._uattributes.clear();
        }
        if (this._ukeywords != null) {
            this._ukeywords.clear();
        }
        TextFieldGestureModifiersKt itr = new TextFieldGestureModifiersKt(subtags, "-");
        while (!itr.isDone() && UnicodeLocaleExtension.isAttribute(itr.current())) {
            if (this._uattributes == null) {
                this._uattributes = new HashSet(4);
            }
            this._uattributes.add(new CaseInsensitiveString(itr.current()));
            itr.next();
        }
        Object key = null;
        int typeStart = -1;
        int typeEnd = -1;
        while (!itr.isDone()) {
            int type22;
            CaseInsensitiveString caseInsensitiveString;
            if (key != null) {
                if (UnicodeLocaleExtension.isKey(itr.current())) {
                    String type22;
                    assert (typeStart == -1 || typeEnd != -1);
                    String string = type22 = typeStart == -1 ? "" : subtags.substring(typeStart, typeEnd);
                    if (this._ukeywords == null) {
                        this._ukeywords = new HashMap(4);
                    }
                    this._ukeywords.put((CaseInsensitiveString)key, type22);
                    CaseInsensitiveString tmpKey = new CaseInsensitiveString(itr.current());
                    caseInsensitiveString = this._ukeywords.containsKey(tmpKey) ? null : caseInsensitiveString;
                    typeEnd = -1;
                    type22 = -1;
                } else {
                    if (type22 == -1) {
                        type22 = itr.currentStart();
                    }
                    typeEnd = itr.currentEnd();
                }
            } else if (UnicodeLocaleExtension.isKey(itr.current())) {
                caseInsensitiveString = new CaseInsensitiveString(itr.current());
                if (this._ukeywords != null && this._ukeywords.containsKey(caseInsensitiveString)) {
                    caseInsensitiveString = null;
                }
            }
            if (!itr.hasNext()) {
                String type;
                if (caseInsensitiveString == null) break;
                assert (type22 == -1 || typeEnd != -1);
                String string = type = type22 == -1 ? "" : subtags.substring(type22, typeEnd);
                if (this._ukeywords == null) {
                    this._ukeywords = new HashMap(4);
                }
                this._ukeywords.put(caseInsensitiveString, type);
                return;
            }
            itr.next();
        }
    }

    static final class CaseInsensitiveChar {
        private char _c;

        /*
         * WARNING - void declaration
         */
        CaseInsensitiveChar(char c) {
            void var1_1;
            this._c = var1_1;
        }

        public final char value() {
            return this._c;
        }

        public final int hashCode() {
            return AsciiUtil.toLower(this._c);
        }

        public final boolean equals(Object obj) {
            CaseInsensitiveChar caseInsensitiveChar;
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CaseInsensitiveChar)) {
                return false;
            }
            caseInsensitiveChar = caseInsensitiveChar;
            return this._c == AsciiUtil.toLower(caseInsensitiveChar._c);
        }
    }

    static final class CaseInsensitiveString {
        private String _s;

        /*
         * WARNING - void declaration
         */
        CaseInsensitiveString(String s) {
            void var1_1;
            this._s = var1_1;
        }

        public final String value() {
            return this._s;
        }

        public final int hashCode() {
            return AsciiUtil.toLowerString(this._s).hashCode();
        }

        public final boolean equals(Object obj) {
            CaseInsensitiveString caseInsensitiveString;
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CaseInsensitiveString)) {
                return false;
            }
            caseInsensitiveString = caseInsensitiveString;
            return AsciiUtil.caseIgnoreMatch(this._s, caseInsensitiveString._s);
        }
    }
}

