/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.locale;

import androidx.compose.foundation.text.TextFieldKeyInput_desktopKt;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.locale.AsciiUtil;
import com.ibm.icu.util.Output;
import com.ibm.icu.util.UResourceBundle;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.regex.Pattern;

public class KeyTypeData {
    private static final Map<String, KeyData> KEYMAP;

    public static String toBcpKey(String key) {
        KeyData keyData = KEYMAP.get(key = AsciiUtil.toLowerString(key));
        if (keyData != null) {
            KeyData keyData2;
            return keyData2.bcpId;
        }
        return null;
    }

    public static String toLegacyKey(String key) {
        KeyData keyData = KEYMAP.get(key = AsciiUtil.toLowerString(key));
        if (keyData != null) {
            KeyData keyData2;
            return keyData2.legacyId;
        }
        return null;
    }

    public static String toBcpType(String key, String type, Output<Boolean> isKnownKey, Output<Boolean> isSpecialType) {
        if (isKnownKey != null) {
            Output<Boolean> output = isKnownKey;
            Boolean bl = Boolean.FALSE;
            throw null;
        }
        if (isSpecialType != null) {
            Output<Boolean> output = isSpecialType;
            Boolean bl = Boolean.FALSE;
            throw null;
        }
        key = AsciiUtil.toLowerString(key);
        type = AsciiUtil.toLowerString(type);
        KeyData keyData = KEYMAP.get(key);
        if (keyData != null) {
            SpecialType specialType;
            if (isKnownKey != null) {
                Output<Boolean> output = isKnownKey;
                Boolean bl = Boolean.TRUE;
                throw null;
            }
            Type t = keyData.typeMap.get(type);
            if (t != null) {
                return ((Type)((Object)specialType)).bcpId;
            }
            if (keyData.specialTypes != null) {
                KeyData keyData2;
                keyData2 = keyData2.specialTypes.iterator();
                while (keyData2.hasNext()) {
                    specialType = (SpecialType)((Object)keyData2.next());
                    if (!specialType.handler.isWellFormed(type)) continue;
                    if (isSpecialType != null) {
                        Output<Boolean> output = isSpecialType;
                        Boolean bl = Boolean.TRUE;
                        throw null;
                    }
                    keyData2 = type;
                    return AsciiUtil.toLowerString((String)((Object)keyData2));
                }
            }
        }
        return null;
    }

    public static String toLegacyType(String key, String type, Output<Boolean> isKnownKey, Output<Boolean> isSpecialType) {
        if (isKnownKey != null) {
            Output<Boolean> output = isKnownKey;
            Boolean bl = Boolean.FALSE;
            throw null;
        }
        if (isSpecialType != null) {
            Output<Boolean> output = isSpecialType;
            Boolean bl = Boolean.FALSE;
            throw null;
        }
        key = AsciiUtil.toLowerString(key);
        type = AsciiUtil.toLowerString(type);
        KeyData keyData = KEYMAP.get(key);
        if (keyData != null) {
            SpecialType specialType;
            if (isKnownKey != null) {
                Output<Boolean> output = isKnownKey;
                Boolean bl = Boolean.TRUE;
                throw null;
            }
            Type t = keyData.typeMap.get(type);
            if (t != null) {
                return ((Type)((Object)specialType)).legacyId;
            }
            if (keyData.specialTypes != null) {
                KeyData keyData2;
                keyData2 = keyData2.specialTypes.iterator();
                while (keyData2.hasNext()) {
                    specialType = (SpecialType)((Object)keyData2.next());
                    if (!specialType.handler.isWellFormed(type)) continue;
                    if (isSpecialType != null) {
                        Output<Boolean> output = isSpecialType;
                        Boolean bl = Boolean.TRUE;
                        throw null;
                    }
                    keyData2 = type;
                    return AsciiUtil.toLowerString((String)((Object)keyData2));
                }
            }
        }
        return null;
    }

    private static void initFromResourceBundle() {
        ICUResourceBundle keyTypeDataRes = ICUResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt73b", "keyTypeData", ICUResourceBundle.ICU_DATA_CLASS_LOADER, ICUResourceBundle.OpenType.DIRECT);
        UResourceBundle uResourceBundle = keyTypeDataRes.get("keyInfo");
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        LinkedHashMap<String, ValueType> linkedHashMap = new LinkedHashMap<String, ValueType>();
        uResourceBundle = uResourceBundle.getIterator$7a0e042d();
        while (uResourceBundle.hasNext()) {
            UResourceBundle uResourceBundle2 = uResourceBundle.next();
            Object object = uResourceBundle2.getKey();
            object = KeyInfoType.valueOf((String)object);
            uResourceBundle2 = uResourceBundle2.getIterator$7a0e042d();
            while (uResourceBundle2.hasNext()) {
                Object object2 = uResourceBundle2.next();
                String string = ((UResourceBundle)object2).getKey();
                object2 = ((UResourceBundle)object2).getString();
                switch (1.$SwitchMap$com$ibm$icu$impl$locale$KeyTypeData$KeyInfoType[((Enum)object).ordinal()]) {
                    case 1: {
                        linkedHashSet.add(string);
                        break;
                    }
                    case 2: {
                        linkedHashMap.put(string, ValueType.valueOf((String)object2));
                    }
                }
            }
        }
        Collections.unmodifiableSet(linkedHashSet);
        Collections.unmodifiableMap(linkedHashMap);
        KeyTypeData.getTypeInfo(keyTypeDataRes.get("typeInfo"));
        UResourceBundle keyMapRes = keyTypeDataRes.get("keyMap");
        UResourceBundle typeMapRes = keyTypeDataRes.get("typeMap");
        UResourceBundle typeAliasRes = null;
        UResourceBundle bcpTypeAliasRes = null;
        try {
            typeAliasRes = keyTypeDataRes.get("typeAlias");
        }
        catch (MissingResourceException missingResourceException) {}
        try {
            bcpTypeAliasRes = keyTypeDataRes.get("bcpTypeAlias");
        }
        catch (MissingResourceException missingResourceException) {}
        TextFieldKeyInput_desktopKt keyMapItr = keyMapRes.getIterator$7a0e042d();
        LinkedHashMap _Bcp47Keys = new LinkedHashMap();
        while (keyMapItr.hasNext()) {
            UResourceBundle typeMapResByKey;
            EnumSet<SpecialType> specialTypeSet;
            HashMap<String, Type> typeDataMap;
            HashMap<String, HashSet<String>> bcpTypeAliasMap;
            HashMap<String, HashSet<String>> typeAliasMap;
            boolean isTZ;
            LinkedHashSet<String> _bcp47Types;
            boolean hasSameKey;
            String bcpKeyId;
            String legacyKeyId;
            block37: {
                UResourceBundle keyMapEntry = keyMapItr.next();
                legacyKeyId = keyMapEntry.getKey();
                bcpKeyId = keyMapEntry.getString();
                hasSameKey = false;
                if (bcpKeyId.length() == 0) {
                    bcpKeyId = legacyKeyId;
                    hasSameKey = true;
                }
                _bcp47Types = new LinkedHashSet<String>();
                _Bcp47Keys.put(bcpKeyId, Collections.unmodifiableSet(_bcp47Types));
                isTZ = legacyKeyId.equals("timezone");
                typeAliasMap = null;
                if (typeAliasRes != null) {
                    UResourceBundle typeAliasResByKey = null;
                    try {
                        typeAliasResByKey = typeAliasRes.get(legacyKeyId);
                    }
                    catch (MissingResourceException missingResourceException) {}
                    if (typeAliasResByKey != null) {
                        typeAliasMap = new HashMap<String, HashSet<String>>();
                        TextFieldKeyInput_desktopKt typeAliasResItr = typeAliasResByKey.getIterator$7a0e042d();
                        while (typeAliasResItr.hasNext()) {
                            HashSet<String> aliasSet;
                            UResourceBundle typeAliasDataEntry = typeAliasResItr.next();
                            String from = typeAliasDataEntry.getKey();
                            String to = typeAliasDataEntry.getString();
                            if (isTZ) {
                                from = from.replace(':', '/');
                            }
                            if ((aliasSet = (HashSet<String>)typeAliasMap.get(to)) == null) {
                                aliasSet = new HashSet<String>();
                                typeAliasMap.put(to, aliasSet);
                            }
                            aliasSet.add(from);
                        }
                    }
                }
                bcpTypeAliasMap = null;
                if (bcpTypeAliasRes != null) {
                    UResourceBundle bcpTypeAliasResByKey = null;
                    try {
                        bcpTypeAliasResByKey = bcpTypeAliasRes.get(bcpKeyId);
                    }
                    catch (MissingResourceException missingResourceException) {}
                    if (bcpTypeAliasResByKey != null) {
                        bcpTypeAliasMap = new HashMap<String, HashSet<String>>();
                        TextFieldKeyInput_desktopKt bcpTypeAliasResItr = bcpTypeAliasResByKey.getIterator$7a0e042d();
                        while (bcpTypeAliasResItr.hasNext()) {
                            UResourceBundle bcpTypeAliasDataEntry = bcpTypeAliasResItr.next();
                            String from = bcpTypeAliasDataEntry.getKey();
                            String to = bcpTypeAliasDataEntry.getString();
                            HashSet<String> aliasSet = (HashSet<String>)bcpTypeAliasMap.get(to);
                            if (aliasSet == null) {
                                aliasSet = new HashSet<String>();
                                bcpTypeAliasMap.put(to, aliasSet);
                            }
                            aliasSet.add(from);
                        }
                    }
                }
                typeDataMap = new HashMap<String, Type>();
                specialTypeSet = null;
                typeMapResByKey = null;
                try {
                    typeMapResByKey = typeMapRes.get(legacyKeyId);
                }
                catch (MissingResourceException missingResourceException) {
                    if ($assertionsDisabled) break block37;
                    throw new AssertionError();
                }
            }
            if (typeMapResByKey != null) {
                TextFieldKeyInput_desktopKt typeMapResByKeyItr = typeMapResByKey.getIterator$7a0e042d();
                while (typeMapResByKeyItr.hasNext()) {
                    Set bcpTypeAliasSet;
                    Object typeAliasSet;
                    UResourceBundle typeMapEntry = typeMapResByKeyItr.next();
                    String legacyTypeId = typeMapEntry.getKey();
                    String bcpTypeId = typeMapEntry.getString();
                    char first = legacyTypeId.charAt(0);
                    first = '9' < first && first < 'a' && bcpTypeId.length() == 0 ? (char)'\u0001' : '\u0000';
                    if (first != '\u0000') {
                        if (specialTypeSet == null) {
                            specialTypeSet = EnumSet.noneOf(SpecialType.class);
                        }
                        specialTypeSet.add(SpecialType.valueOf(legacyTypeId));
                        _bcp47Types.add(legacyTypeId);
                        continue;
                    }
                    if (isTZ) {
                        legacyTypeId = legacyTypeId.replace(':', '/');
                    }
                    boolean hasSameType = false;
                    if (bcpTypeId.length() == 0) {
                        bcpTypeId = legacyTypeId;
                        hasSameType = true;
                    }
                    _bcp47Types.add(bcpTypeId);
                    Type t = new Type(legacyTypeId, bcpTypeId);
                    typeDataMap.put(AsciiUtil.toLowerString(legacyTypeId), t);
                    if (!hasSameType) {
                        typeDataMap.put(AsciiUtil.toLowerString(bcpTypeId), t);
                    }
                    if (typeAliasMap != null && (typeAliasSet = (Set)typeAliasMap.get(legacyTypeId)) != null) {
                        typeAliasSet = typeAliasSet.iterator();
                        while (typeAliasSet.hasNext()) {
                            String alias = (String)typeAliasSet.next();
                            typeDataMap.put(AsciiUtil.toLowerString(alias), t);
                        }
                    }
                    if (bcpTypeAliasMap == null || (bcpTypeAliasSet = (Set)bcpTypeAliasMap.get(bcpTypeId)) == null) continue;
                    for (String alias : bcpTypeAliasSet) {
                        typeDataMap.put(AsciiUtil.toLowerString(alias), t);
                    }
                }
            }
            KeyData keyData = new KeyData(legacyKeyId, bcpKeyId, typeDataMap, specialTypeSet);
            KEYMAP.put(AsciiUtil.toLowerString(legacyKeyId), keyData);
            if (hasSameKey) continue;
            KEYMAP.put(AsciiUtil.toLowerString(bcpKeyId), keyData);
        }
        Collections.unmodifiableMap(uResourceBundle);
    }

    /*
     * WARNING - void declaration
     */
    private static void getTypeInfo(UResourceBundle typeInfoRes) {
        void var1_1;
        LinkedHashMap _deprecatedKeyTypes = new LinkedHashMap();
        UResourceBundle keyInfoIt = typeInfoRes.getIterator$7a0e042d();
        while (keyInfoIt.hasNext()) {
            UResourceBundle keyInfoEntry = keyInfoIt.next();
            String string = keyInfoEntry.getKey();
            TypeInfoType typeInfo = TypeInfoType.valueOf(string);
            TextFieldKeyInput_desktopKt keyInfoIt2 = keyInfoEntry.getIterator$7a0e042d();
            while (keyInfoIt2.hasNext()) {
                UResourceBundle keyInfoEntry2 = keyInfoIt2.next();
                String key2 = keyInfoEntry2.getKey();
                LinkedHashSet<String> _deprecatedTypes = new LinkedHashSet<String>();
                TextFieldKeyInput_desktopKt keyInfoIt3 = keyInfoEntry2.getIterator$7a0e042d();
                while (keyInfoIt3.hasNext()) {
                    UResourceBundle uResourceBundle = keyInfoIt3.next();
                    String key3 = uResourceBundle.getKey();
                    switch (typeInfo) {
                        case deprecated: {
                            _deprecatedTypes.add(key3);
                        }
                    }
                }
                _deprecatedKeyTypes.put(key2, Collections.unmodifiableSet(_deprecatedTypes));
            }
        }
        Collections.unmodifiableMap(var1_1);
    }

    static {
        Collections.emptySet();
        Collections.emptyMap();
        Collections.emptyMap();
        KEYMAP = new HashMap<String, KeyData>();
        KeyTypeData.initFromResourceBundle();
    }

    /*
     * Exception performing whole class analysis.
     */
    static final class TypeInfoType
    extends Enum<TypeInfoType> {
    }

    static enum KeyInfoType {
        deprecated,
        valueType;

    }

    static final class Type {
        String legacyId;
        String bcpId;

        /*
         * WARNING - void declaration
         */
        Type(String legacyId, String bcpId) {
            void var2_2;
            void var1_1;
            this.legacyId = var1_1;
            this.bcpId = var2_2;
        }
    }

    static final class KeyData {
        String legacyId;
        String bcpId;
        Map<String, Type> typeMap;
        EnumSet<SpecialType> specialTypes;

        /*
         * WARNING - void declaration
         */
        KeyData(String legacyId, String bcpId, Map<String, Type> typeMap, EnumSet<SpecialType> specialTypes) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.legacyId = var1_1;
            this.bcpId = var2_2;
            this.typeMap = var3_3;
            this.specialTypes = specialTypes;
        }
    }

    private static final class SpecialType
    extends Enum<SpecialType> {
        private static /* enum */ SpecialType CODEPOINTS = new SpecialType(new CodepointsTypeHandler(0));
        private static /* enum */ SpecialType REORDER_CODE = new SpecialType(new ReorderCodeTypeHandler(0));
        private static /* enum */ SpecialType RG_KEY_VALUE = new SpecialType(new RgKeyValueTypeHandler(0));
        private static /* enum */ SpecialType SCRIPT_CODE = new SpecialType(new ScriptCodeTypeHandler(0));
        private static /* enum */ SpecialType SUBDIVISION_CODE = new SpecialType(new SubdivisionKeyValueTypeHandler(0));
        private static /* enum */ SpecialType PRIVATE_USE = new SpecialType(new PrivateUseKeyValueTypeHandler(0));
        SpecialTypeHandler handler;

        public static SpecialType valueOf(String name) {
            String string;
            return Enum.valueOf(SpecialType.class, string);
        }

        /*
         * WARNING - void declaration
         */
        private SpecialType(SpecialTypeHandler handler) {
            void var3_3;
            this.handler = var3_3;
        }

        static {
            SpecialType[] specialTypeArray = new SpecialType[]{CODEPOINTS, REORDER_CODE, RG_KEY_VALUE, SCRIPT_CODE, SUBDIVISION_CODE, PRIVATE_USE};
        }
    }

    static final class PrivateUseKeyValueTypeHandler
    extends SpecialTypeHandler {
        private static final Pattern pat = Pattern.compile("[a-zA-Z0-9]{3,8}(-[a-zA-Z0-9]{3,8})*");

        private PrivateUseKeyValueTypeHandler() {
            super((byte)0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean isWellFormed(String value) {
            void var1_1;
            return pat.matcher((CharSequence)var1_1).matches();
        }

        /* synthetic */ PrivateUseKeyValueTypeHandler(byte by) {
            this();
        }
    }

    static final class SubdivisionKeyValueTypeHandler
    extends SpecialTypeHandler {
        private static final Pattern pat = Pattern.compile("([a-zA-Z]{2}|[0-9]{3})");

        private SubdivisionKeyValueTypeHandler() {
            super((byte)0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean isWellFormed(String value) {
            void var1_1;
            return pat.matcher((CharSequence)var1_1).matches();
        }

        /* synthetic */ SubdivisionKeyValueTypeHandler(byte by) {
            this();
        }
    }

    static final class ScriptCodeTypeHandler
    extends SpecialTypeHandler {
        private static final Pattern pat = Pattern.compile("[a-zA-Z]{4}(-[a-zA-Z]{4})*");

        private ScriptCodeTypeHandler() {
            super((byte)0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean isWellFormed(String value) {
            void var1_1;
            return pat.matcher((CharSequence)var1_1).matches();
        }

        /* synthetic */ ScriptCodeTypeHandler(byte by) {
            this();
        }
    }

    static final class RgKeyValueTypeHandler
    extends SpecialTypeHandler {
        private static final Pattern pat = Pattern.compile("([a-zA-Z]{2}|[0-9]{3})[zZ]{4}");

        private RgKeyValueTypeHandler() {
            super((byte)0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean isWellFormed(String value) {
            void var1_1;
            return pat.matcher((CharSequence)var1_1).matches();
        }

        /* synthetic */ RgKeyValueTypeHandler(byte by) {
            this();
        }
    }

    static final class ReorderCodeTypeHandler
    extends SpecialTypeHandler {
        private static final Pattern pat = Pattern.compile("[a-zA-Z]{3,8}(-[a-zA-Z]{3,8})*");

        private ReorderCodeTypeHandler() {
            super((byte)0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean isWellFormed(String value) {
            void var1_1;
            return pat.matcher((CharSequence)var1_1).matches();
        }

        /* synthetic */ ReorderCodeTypeHandler(byte by) {
            this();
        }
    }

    static final class CodepointsTypeHandler
    extends SpecialTypeHandler {
        private static final Pattern pat = Pattern.compile("[0-9a-fA-F]{4,6}(-[0-9a-fA-F]{4,6})*");

        private CodepointsTypeHandler() {
            super((byte)0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean isWellFormed(String value) {
            void var1_1;
            return pat.matcher((CharSequence)var1_1).matches();
        }

        /* synthetic */ CodepointsTypeHandler(byte by) {
            this();
        }
    }

    static abstract class SpecialTypeHandler {
        private SpecialTypeHandler() {
        }

        abstract boolean isWellFormed(String var1);

        /* synthetic */ SpecialTypeHandler(byte by) {
            this();
        }
    }

    public static final class ValueType
    extends Enum<ValueType> {
        private static /* enum */ ValueType single = new ValueType();
        private static /* enum */ ValueType multiple = new ValueType();
        private static /* enum */ ValueType incremental = new ValueType();
        private static /* enum */ ValueType any = new ValueType();

        public static ValueType valueOf(String name) {
            String string;
            return Enum.valueOf(ValueType.class, string);
        }

        static {
            ValueType[] valueTypeArray = new ValueType[]{single, multiple, incremental, any};
        }
    }
}

