/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.locale;

import androidx.compose.foundation.text.TextFieldGestureModifiersKt;
import com.ibm.icu.impl.locale.AsciiUtil;
import com.ibm.icu.impl.locale.BaseLocale;
import com.ibm.icu.impl.locale.LocaleExtensions;
import com.ibm.icu.impl.locale.ParseStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LanguageTag {
    public static String UNDETERMINED = "und";
    private String _language = "";
    private String _script = "";
    private String _region = "";
    private String _privateuse = "";
    private List<String> _extlangs = Collections.emptyList();
    private List<String> _variants = Collections.emptyList();
    private List<String> _extensions = Collections.emptyList();
    private static final Map<AsciiUtil.CaseInsensitiveKey, String[]> LEGACY = new HashMap<AsciiUtil.CaseInsensitiveKey, String[]>();

    private LanguageTag() {
    }

    /*
     * WARNING - void declaration
     */
    public static LanguageTag parse(String languageTag, ParseStatus sts) {
        void var3_3;
        String string;
        boolean bl;
        boolean bl2;
        TextFieldGestureModifiersKt itr;
        Object object;
        if (sts == null) {
            sts = new ParseStatus();
        } else {
            object = sts;
            sts._parseLength = 0;
            ((ParseStatus)object)._errorIndex = -1;
        }
        boolean isLegacy = false;
        String[] gfmap = LEGACY.get(new AsciiUtil.CaseInsensitiveKey(languageTag));
        int dash = 2;
        while (gfmap == null && (dash = languageTag.indexOf(45, dash + 1)) != -1) {
            gfmap = LEGACY.get(new AsciiUtil.CaseInsensitiveKey(languageTag.substring(0, dash)));
        }
        if (gfmap != null) {
            itr = gfmap[0].length() == languageTag.length() ? new TextFieldGestureModifiersKt(gfmap[1], "-") : new TextFieldGestureModifiersKt((String)itr[1] + languageTag.substring(dash), "-");
            isLegacy = true;
        } else {
            itr = new TextFieldGestureModifiersKt(languageTag, "-");
        }
        LanguageTag tag = new LanguageTag();
        ParseStatus parseStatus = sts;
        TextFieldGestureModifiersKt textFieldGestureModifiersKt = itr;
        object = tag;
        if (textFieldGestureModifiersKt.isDone() || parseStatus.isError()) {
            bl2 = false;
        } else {
            bl = false;
            string = textFieldGestureModifiersKt.current();
            if (LanguageTag.isLanguage(string)) {
                bl = true;
                ((LanguageTag)object)._language = string;
                parseStatus._parseLength = textFieldGestureModifiersKt.currentEnd();
                textFieldGestureModifiersKt.next();
            }
            bl2 = bl;
        }
        if (bl2) {
            boolean bl3;
            boolean bl4;
            if (tag._language.length() <= 3) {
                tag.parseExtlangs$466eb0a(itr, sts);
            }
            parseStatus = sts;
            textFieldGestureModifiersKt = itr;
            object = tag;
            if (textFieldGestureModifiersKt.isDone() || parseStatus.isError()) {
                bl4 = false;
            } else {
                bl = false;
                string = textFieldGestureModifiersKt.current();
                if (LanguageTag.isScript(string)) {
                    bl = true;
                    ((LanguageTag)object)._script = string;
                    parseStatus._parseLength = textFieldGestureModifiersKt.currentEnd();
                    textFieldGestureModifiersKt.next();
                }
                bl4 = bl;
            }
            parseStatus = sts;
            textFieldGestureModifiersKt = itr;
            object = tag;
            if (textFieldGestureModifiersKt.isDone() || parseStatus.isError()) {
                bl3 = false;
            } else {
                bl = false;
                string = textFieldGestureModifiersKt.current();
                if (LanguageTag.isRegion(string)) {
                    bl = true;
                    ((LanguageTag)object)._region = string;
                    parseStatus._parseLength = textFieldGestureModifiersKt.currentEnd();
                    textFieldGestureModifiersKt.next();
                }
                bl3 = bl;
            }
            tag.parseVariants$466eb0a(itr, sts);
            tag.parseExtensions$466eb0a(itr, sts);
        }
        tag.parsePrivateuse$466eb0a(itr, sts);
        if (var3_3 != false) {
            assert (itr.isDone());
            assert (!sts.isError());
            sts._parseLength = languageTag.length();
        } else if (!itr.isDone() && !sts.isError()) {
            void var2_4;
            String s = itr.current();
            var1_1._errorIndex = var2_4.currentStart();
            if (s.length() != 0) {
                String string2;
                new StringBuilder("Invalid subtag: ").append(string2);
            }
        }
        return tag;
    }

    /*
     * WARNING - void declaration
     */
    private boolean parseExtlangs$466eb0a(TextFieldGestureModifiersKt itr, ParseStatus sts) {
        void var3_3;
        if (itr.isDone() || sts.isError()) {
            return false;
        }
        boolean found = false;
        while (!itr.isDone()) {
            String s;
            String string = s = itr.current();
            if (!(s.length() == 3 && AsciiUtil.isAlphaString(string))) break;
            found = true;
            if (this._extlangs.isEmpty()) {
                this._extlangs = new ArrayList<String>(3);
            }
            this._extlangs.add(s);
            sts._parseLength = itr.currentEnd();
            itr.next();
            if (this._extlangs.size() != 3) continue;
        }
        return (boolean)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private boolean parseVariants$466eb0a(TextFieldGestureModifiersKt itr, ParseStatus sts) {
        void var3_3;
        String s;
        if (itr.isDone() || sts.isError()) {
            return false;
        }
        boolean found = false;
        while (!itr.isDone() && LanguageTag.isVariant(s = itr.current())) {
            found = true;
            if (this._variants.isEmpty()) {
                this._variants = new ArrayList<String>(3);
            }
            if (!this._variants.contains(s = s.toUpperCase())) {
                this._variants.add(s);
            }
            sts._parseLength = itr.currentEnd();
            itr.next();
        }
        return (boolean)var3_3;
    }

    private boolean parseExtensions$466eb0a(TextFieldGestureModifiersKt itr, ParseStatus sts) {
        boolean bl;
        String s;
        if (itr.isDone() || sts.isError()) {
            return false;
        }
        boolean found = false;
        while (!itr.isDone() && LanguageTag.isExtensionSingleton(s = itr.current())) {
            int start = itr.currentStart();
            String singleton = s.toLowerCase();
            StringBuilder sb = new StringBuilder(singleton);
            itr.next();
            while (!itr.isDone() && LanguageTag.isExtensionSubtag(s = itr.current())) {
                sb.append("-").append(s);
                sts._parseLength = itr.currentEnd();
                itr.next();
            }
            if (sts._parseLength <= start) {
                sts._errorIndex = start;
                new StringBuilder("Incomplete extension '").append(singleton).append("'");
                break;
            }
            if (this._extensions.size() == 0) {
                this._extensions = new ArrayList<String>(4);
            }
            boolean alreadyHas = false;
            for (String extension : this._extensions) {
                alreadyHas |= extension.charAt(0) == sb.charAt(0);
            }
            if (!bl) {
                this._extensions.add(sb.toString());
            }
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private boolean parsePrivateuse$466eb0a(TextFieldGestureModifiersKt itr, ParseStatus sts) {
        void var3_3;
        String s;
        if (itr.isDone() || sts.isError()) {
            return false;
        }
        boolean found = false;
        String string = s = itr.current();
        if (s.length() == 1 && AsciiUtil.caseIgnoreMatch("x", string)) {
            int start = itr.currentStart();
            StringBuilder sb = new StringBuilder(s);
            itr.next();
            while (!itr.isDone() && LanguageTag.isPrivateuseSubtag(s = itr.current())) {
                sb.append("-").append(s);
                sts._parseLength = itr.currentEnd();
                itr.next();
            }
            if (sts._parseLength <= start) {
                var2_2._errorIndex = start;
            } else {
                this._privateuse = sb.toString();
                found = true;
            }
        }
        return (boolean)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static LanguageTag parseLocale(BaseLocale baseLocale, LocaleExtensions localeExtensions) {
        void var2_2;
        String string;
        Object buf;
        LanguageTag tag = new LanguageTag();
        String language = baseLocale.getLanguage();
        String script = baseLocale.getScript();
        String region = baseLocale.getRegion();
        String variant = baseLocale.getVariant();
        boolean hasSubtag = false;
        String privuseVar = null;
        if (language.length() > 0 && LanguageTag.isLanguage(language)) {
            if (language.equals("iw")) {
                language = "he";
            } else if (language.equals("ji")) {
                language = "yi";
            } else if (language.equals("in")) {
                language = "id";
            }
            tag._language = language;
        }
        if (script.length() > 0 && LanguageTag.isScript(script)) {
            language = script;
            tag._script = AsciiUtil.toTitleString(language);
            hasSubtag = true;
        }
        if (region.length() > 0 && LanguageTag.isRegion(region)) {
            language = region;
            tag._region = AsciiUtil.toUpperString(language);
            hasSubtag = true;
        }
        if (variant.length() > 0) {
            String var;
            ArrayList<String> variants = null;
            String varitr = new TextFieldGestureModifiersKt(variant, "_");
            while (!varitr.isDone() && LanguageTag.isVariant(var = varitr.current())) {
                if (variants == null) {
                    variants = new ArrayList<String>();
                }
                variants.add(LanguageTag.canonicalizeVariant(var));
                varitr.next();
            }
            if (variants != null) {
                tag._variants = variants;
                hasSubtag = true;
            }
            if (!varitr.isDone()) {
                String prvv;
                buf = new StringBuilder();
                while (!varitr.isDone() && LanguageTag.isPrivateuseSubtag(prvv = varitr.current())) {
                    if (((StringBuilder)buf).length() > 0) {
                        ((StringBuilder)buf).append("-");
                    }
                    prvv = AsciiUtil.toLowerString(prvv);
                    ((StringBuilder)buf).append(prvv);
                    varitr.next();
                }
                if (((StringBuilder)buf).length() > 0) {
                    privuseVar = ((StringBuilder)buf).toString();
                }
            }
        }
        ArrayList<String> extensions = null;
        String privateuse = null;
        buf = localeExtensions.getKeys();
        Iterator<Character> iterator = buf.iterator();
        while (iterator.hasNext()) {
            Character locextKey = iterator.next();
            AsciiUtil ext = localeExtensions.getExtension$f40ab2c(locextKey);
            if (LanguageTag.isPrivateusePrefixChar(locextKey.charValue())) {
                privateuse = ext.getValue();
                continue;
            }
            if (extensions == null) {
                extensions = new ArrayList<String>();
            }
            extensions.add(locextKey.toString() + "-" + ext.getValue());
        }
        if (extensions != null) {
            void var3_3;
            tag._extensions = var3_3;
            hasSubtag = true;
        }
        if (privuseVar != null) {
            privateuse = privateuse == null ? "lvariant-" + privuseVar : (String)privateuse + "-lvariant" + "-" + privuseVar.replace("_", "-");
        }
        if (privateuse != null) {
            tag._privateuse = privateuse;
        }
        if (tag._language.length() == 0 && (hasSubtag || string == null)) {
            tag._language = UNDETERMINED;
        }
        return var2_2;
    }

    public final String getLanguage() {
        return this._language;
    }

    public final List<String> getExtlangs() {
        return Collections.unmodifiableList(this._extlangs);
    }

    public final String getScript() {
        return this._script;
    }

    public final String getRegion() {
        return this._region;
    }

    public final List<String> getVariants() {
        return Collections.unmodifiableList(this._variants);
    }

    public final List<String> getExtensions() {
        return Collections.unmodifiableList(this._extensions);
    }

    public final String getPrivateuse() {
        return this._privateuse;
    }

    public static boolean isLanguage(String s) {
        String string;
        return s.length() >= 2 && s.length() <= 8 && AsciiUtil.isAlphaString(string);
    }

    public static boolean isScript(String s) {
        String string;
        return s.length() == 4 && AsciiUtil.isAlphaString(string);
    }

    public static boolean isRegion(String s) {
        String string;
        return s.length() == 2 && AsciiUtil.isAlphaString(s) || s.length() == 3 && AsciiUtil.isNumericString(string);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isVariant(String s) {
        void var1_1;
        int len = s.length();
        if (len >= 5 && len <= 8) {
            return AsciiUtil.isAlphaNumericString(s);
        }
        if (var1_1 == 4) {
            String string;
            return AsciiUtil.isNumeric(s.charAt(0)) && AsciiUtil.isAlphaNumeric(s.charAt(1)) && AsciiUtil.isAlphaNumeric(s.charAt(2)) && AsciiUtil.isAlphaNumeric(string.charAt(3));
        }
        return false;
    }

    public static boolean isTKey(String s) {
        String string;
        return s.length() == 2 && AsciiUtil.isAlpha(s.charAt(0)) && AsciiUtil.isNumeric(string.charAt(1));
    }

    private static boolean isExtensionSingleton(String s) {
        String string;
        return s.length() == 1 && AsciiUtil.isAlphaNumericString(s) && !AsciiUtil.caseIgnoreMatch("x", string);
    }

    public static boolean isExtensionSingletonChar(char c) {
        return LanguageTag.isExtensionSingleton(String.valueOf(c));
    }

    public static boolean isExtensionSubtag(String s) {
        String string;
        return s.length() >= 2 && s.length() <= 8 && AsciiUtil.isAlphaNumericString(string);
    }

    public static boolean isPrivateusePrefixChar(char c) {
        char c2;
        return AsciiUtil.caseIgnoreMatch("x", String.valueOf(c2));
    }

    public static boolean isPrivateuseSubtag(String s) {
        String string;
        return s.length() > 0 && s.length() <= 8 && AsciiUtil.isAlphaNumericString(string);
    }

    public static String canonicalizeLanguage(String s) {
        return AsciiUtil.toLowerString(s);
    }

    public static String canonicalizeScript(String s) {
        return AsciiUtil.toTitleString(s);
    }

    public static String canonicalizeRegion(String s) {
        return AsciiUtil.toUpperString(s);
    }

    public static String canonicalizeVariant(String s) {
        return AsciiUtil.toLowerString(s);
    }

    /*
     * WARNING - void declaration
     */
    public static String canonicalizeExtension(String s) {
        String string;
        if ((s = AsciiUtil.toLowerString(s)).startsWith("u-")) {
            int found;
            while (s.endsWith("-true")) {
                s = s.substring(0, s.length() - 5);
            }
            while ((found = s.indexOf("-true-")) > 0) {
                s = s.substring(0, found) + s.substring(found + 5);
            }
            while (s.endsWith("-yes")) {
                s = s.substring(0, s.length() - 4);
            }
            while ((found = s.indexOf("-yes-")) > 0) {
                void var1_1;
                s = s.substring(0, found) + s.substring((int)(var1_1 + 4));
            }
        }
        return string;
    }

    public static String canonicalizePrivateuse(String s) {
        return AsciiUtil.toLowerString(s);
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder();
        if (this._language.length() > 0) {
            sb.append(this._language);
            for (String extlang : this._extlangs) {
                sb.append("-").append(extlang);
            }
            if (this._script.length() > 0) {
                sb.append("-").append(this._script);
            }
            if (this._region.length() > 0) {
                sb.append("-").append(this._region);
            }
            for (String variant : this._variants) {
                sb.append("-").append(variant);
            }
            for (String extension : this._extensions) {
                void var3_3;
                sb.append("-").append((String)var3_3);
            }
        }
        if (this._privateuse.length() > 0) {
            if (sb.length() > 0) {
                sb.append("-");
            }
            sb.append(this._privateuse);
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    static {
        String[][] stringArrayArray = new String[][]{{"art-lojban", "jbo"}, {"cel-gaulish", "xtg"}, {"en-GB-oed", "en-GB-x-oed"}, {"i-ami", "ami"}, {"i-bnn", "bnn"}, {"i-default", "en-x-i-default"}, {"i-enochian", "und-x-i-enochian"}, {"i-hak", "hak"}, {"i-klingon", "tlh"}, {"i-lux", "lb"}, {"i-mingo", "see-x-i-mingo"}, {"i-navajo", "nv"}, {"i-pwn", "pwn"}, {"i-tao", "tao"}, {"i-tay", "tay"}, {"i-tsu", "tsu"}, {"no-bok", "nb"}, {"no-nyn", "nn"}, {"sgn-BE-FR", "sfb"}, {"sgn-BE-NL", "vgt"}, {"sgn-CH-DE", "sgg"}, {"zh-guoyu", "cmn"}, {"zh-hakka", "hak"}, {"zh-min", "nan-x-zh-min"}, {"zh-min-nan", "nan"}, {"zh-xiang", "hsn"}};
        stringArrayArray = stringArrayArray;
        for (int i = 0; i < 26; ++i) {
            void var2_2;
            String[] e = stringArrayArray[i];
            LEGACY.put(new AsciiUtil.CaseInsensitiveKey(e[0]), (String[])var2_2);
        }
    }
}

