/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.locale;

import com.ibm.icu.impl.locale.AsciiUtil;
import com.ibm.icu.impl.locale.InternalLocaleBuilder;
import com.ibm.icu.impl.locale.LanguageTag;
import com.ibm.icu.impl.locale.UnicodeLocaleExtension;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class LocaleExtensions {
    private SortedMap<Character, AsciiUtil> _map;
    private String _id;
    private static final SortedMap<Character, AsciiUtil> EMPTY_MAP = Collections.unmodifiableSortedMap(new TreeMap());
    public static final LocaleExtensions EMPTY_EXTENSIONS = new LocaleExtensions();
    private static LocaleExtensions CALENDAR_JAPANESE;
    private static LocaleExtensions NUMBER_THAI;

    private LocaleExtensions() {
    }

    /*
     * WARNING - void declaration
     */
    LocaleExtensions(Map<InternalLocaleBuilder.CaseInsensitiveChar, String> extensions, Set<InternalLocaleBuilder.CaseInsensitiveString> uattributes, Map<InternalLocaleBuilder.CaseInsensitiveString, String> ukeywords) {
        boolean hasUKeywords;
        boolean bl = extensions != null && extensions.size() > 0;
        boolean hasUAttributes = uattributes != null && uattributes.size() > 0;
        boolean bl2 = hasUKeywords = ukeywords != null && ukeywords.size() > 0;
        if (!(bl || hasUAttributes || hasUKeywords)) {
            this._map = EMPTY_MAP;
            this._id = "";
            return;
        }
        this._map = new TreeMap<Character, AsciiUtil>();
        if (bl) {
            for (Map.Entry entry : extensions.entrySet()) {
                char key = AsciiUtil.toLower(((InternalLocaleBuilder.CaseInsensitiveChar)entry.getKey()).value());
                String value = (String)entry.getValue();
                if (LanguageTag.isPrivateusePrefixChar(key) && (value = InternalLocaleBuilder.removePrivateuseVariant(value)) == null) continue;
                AsciiUtil e = new AsciiUtil(key, AsciiUtil.toLowerString(value));
                this._map.put(Character.valueOf(key), e);
            }
        }
        if (hasUAttributes || hasUKeywords) {
            void var4_8;
            void var1_1;
            TreeSet<String> uaset = null;
            Object var4_6 = null;
            if (hasUAttributes) {
                uaset = new TreeSet<String>();
                for (InternalLocaleBuilder.CaseInsensitiveString cis : uattributes) {
                    uaset.add(AsciiUtil.toLowerString(cis.value()));
                }
            }
            if (hasUKeywords) {
                void var3_3;
                TreeMap<String, void> treeMap = new TreeMap<String, void>();
                for (Map.Entry kwd : var3_3.entrySet()) {
                    void var2_2;
                    String key = AsciiUtil.toLowerString(((InternalLocaleBuilder.CaseInsensitiveString)kwd.getKey()).value());
                    String type = AsciiUtil.toLowerString((String)kwd.getValue());
                    treeMap.put(key, var2_2);
                }
            }
            UnicodeLocaleExtension ule = new UnicodeLocaleExtension((SortedSet<String>)var1_1, (SortedMap<String, String>)var4_8);
            this._map.put(Character.valueOf('u'), ule);
        }
        if (this._map.size() == 0) {
            this._map = EMPTY_MAP;
            this._id = "";
            return;
        }
        this._id = LocaleExtensions.toID(this._map);
    }

    public final Set<Character> getKeys() {
        return Collections.unmodifiableSet(this._map.keySet());
    }

    /*
     * WARNING - void declaration
     */
    public final AsciiUtil getExtension$f40ab2c(Character key) {
        void var1_1;
        return (AsciiUtil)this._map.get(Character.valueOf(AsciiUtil.toLower(var1_1.charValue())));
    }

    /*
     * WARNING - void declaration
     */
    public final String getUnicodeLocaleType(String unicodeLocaleKey) {
        void var1_1;
        void var2_2;
        AsciiUtil ext = (AsciiUtil)this._map.get(Character.valueOf('u'));
        if (ext == null) {
            return null;
        }
        assert (ext instanceof UnicodeLocaleExtension);
        return ((UnicodeLocaleExtension)var2_2).getUnicodeLocaleType(AsciiUtil.toLowerString((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private static String toID(SortedMap<Character, AsciiUtil> map) {
        void var1_1;
        Object object;
        StringBuilder buf = new StringBuilder();
        AsciiUtil privuse = null;
        for (Map.Entry entry : object.entrySet()) {
            char singleton = ((Character)entry.getKey()).charValue();
            AsciiUtil asciiUtil = (AsciiUtil)entry.getValue();
            if (LanguageTag.isPrivateusePrefixChar(singleton)) {
                privuse = asciiUtil;
                continue;
            }
            if (buf.length() > 0) {
                buf.append("-");
            }
            buf.append(asciiUtil);
        }
        if (privuse != null) {
            void var2_2;
            if (buf.length() > 0) {
                buf.append("-");
            }
            buf.append(var2_2);
        }
        return var1_1.toString();
    }

    public String toString() {
        return this._id;
    }

    public int hashCode() {
        return this._id.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object other) {
        void var1_1;
        if (this == other) {
            return true;
        }
        if (!(other instanceof LocaleExtensions)) {
            return false;
        }
        return this._id.equals(((LocaleExtensions)var1_1)._id);
    }

    static {
        new LocaleExtensions()._id = "";
        LocaleExtensions.EMPTY_EXTENSIONS._map = EMPTY_MAP;
        CALENDAR_JAPANESE = new LocaleExtensions();
        new LocaleExtensions()._id = "u-ca-japanese";
        LocaleExtensions.CALENDAR_JAPANESE._map = new TreeMap<Character, AsciiUtil>();
        LocaleExtensions.CALENDAR_JAPANESE._map.put(Character.valueOf('u'), UnicodeLocaleExtension.CA_JAPANESE);
        NUMBER_THAI = new LocaleExtensions();
        new LocaleExtensions()._id = "u-nu-thai";
        LocaleExtensions.NUMBER_THAI._map = new TreeMap<Character, AsciiUtil>();
        LocaleExtensions.NUMBER_THAI._map.put(Character.valueOf('u'), UnicodeLocaleExtension.NU_THAI);
    }
}

