/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.locale;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.concurrent.ConcurrentHashMap;

public abstract class LocaleObjectCache<K, V> {
    private ConcurrentHashMap<K, CacheEntry<K, V>> _map;
    private ReferenceQueue<V> _queue = new ReferenceQueue();

    public LocaleObjectCache() {
        this(16, 0.75f, 16);
    }

    private LocaleObjectCache(int initialCapacity, float loadFactor, int concurrencyLevel) {
        this._map = new ConcurrentHashMap(16, 0.75f, 16);
    }

    /*
     * WARNING - void declaration
     */
    public final V get(K key) {
        void var2_2;
        Object value = null;
        this.cleanStaleEntries();
        CacheEntry<K, V> entry = this._map.get(key);
        if (entry != null) {
            value = entry.get();
        }
        if (value == null) {
            key = this.normalizeKey(key);
            V newVal = this.createObject(key);
            if (key == null || newVal == null) {
                return null;
            }
            CacheEntry<K, V> newEntry = new CacheEntry<K, V>(key, newVal, this._queue);
            while (value == null) {
                void var3_3;
                this.cleanStaleEntries();
                entry = this._map.putIfAbsent(key, newEntry);
                if (entry == null) {
                    value = newVal;
                    break;
                }
                value = var3_3.get();
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private void cleanStaleEntries() {
        CacheEntry entry;
        while ((entry = (CacheEntry)this._queue.poll()) != null) {
            void var1_1;
            this._map.remove(var1_1.getKey());
        }
    }

    protected abstract V createObject(K var1);

    protected K normalizeKey(K key) {
        return key;
    }

    static final class CacheEntry<K, V>
    extends SoftReference<V> {
        private K _key;

        /*
         * WARNING - void declaration
         */
        CacheEntry(K key, V value, ReferenceQueue<V> queue) {
            super(var2_2, var3_3);
            void var1_1;
            void var3_3;
            void var2_2;
            this._key = var1_1;
        }

        final K getKey() {
            return this._key;
        }
    }
}

