/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.locale;

import com.ibm.icu.impl.locale.AsciiUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public final class UnicodeLocaleExtension
extends AsciiUtil {
    private static final SortedSet<String> EMPTY_SORTED_SET = new TreeSet<String>();
    private static final SortedMap<String, String> EMPTY_SORTED_MAP = new TreeMap<String, String>();
    private SortedSet<String> _attributes = EMPTY_SORTED_SET;
    private SortedMap<String, String> _keywords = EMPTY_SORTED_MAP;
    public static final UnicodeLocaleExtension CA_JAPANESE = new UnicodeLocaleExtension();
    public static final UnicodeLocaleExtension NU_THAI;

    private UnicodeLocaleExtension() {
        super('u');
    }

    /*
     * WARNING - void declaration
     */
    UnicodeLocaleExtension(SortedSet<String> attributes, SortedMap<String, String> keywords) {
        this();
        if (attributes != null && attributes.size() > 0) {
            this._attributes = attributes;
        }
        if (keywords != null && keywords.size() > 0) {
            Iterator<Object> iterator;
            this._keywords = iterator;
        }
        if (this._attributes.size() > 0 || this._keywords.size() > 0) {
            void var1_1;
            StringBuilder sb = new StringBuilder();
            for (String string : this._attributes) {
                sb.append("-").append(string);
            }
            for (Map.Entry entry : this._keywords.entrySet()) {
                String key = (String)entry.getKey();
                String string = (String)entry.getValue();
                sb.append("-").append(key);
                if (string.length() <= 0) continue;
                sb.append("-").append(string);
            }
            this._value = var1_1.substring(1);
        }
    }

    public final Set<String> getUnicodeLocaleAttributes() {
        return Collections.unmodifiableSet(this._attributes);
    }

    public final Set<String> getUnicodeLocaleKeys() {
        return Collections.unmodifiableSet(this._keywords.keySet());
    }

    /*
     * WARNING - void declaration
     */
    public final String getUnicodeLocaleType(String unicodeLocaleKey) {
        void var1_1;
        return (String)this._keywords.get(var1_1);
    }

    public static boolean isSingletonChar(char c) {
        char c2;
        return 'u' == AsciiUtil.toLower(c2);
    }

    public static boolean isAttribute(String s) {
        String string;
        return s.length() >= 3 && s.length() <= 8 && AsciiUtil.isAlphaNumericString(string);
    }

    public static boolean isKey(String s) {
        String string;
        return s.length() == 2 && AsciiUtil.isAlphaNumeric(s.charAt(0)) && AsciiUtil.isAlpha(string.charAt(1));
    }

    public static boolean isTypeSubtag(String s) {
        String string;
        return s.length() >= 3 && s.length() <= 8 && AsciiUtil.isAlphaNumericString(string);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isType(String s) {
        String string;
        void var1_1;
        int startIdx = 0;
        while (true) {
            void var2_2;
            int idx;
            String string2;
            if (!UnicodeLocaleExtension.isTypeSubtag(string2 = (idx = s.indexOf("-", startIdx)) < 0 ? s.substring(startIdx) : s.substring(startIdx, idx))) {
                return false;
            }
            if (idx < 0) break;
            startIdx = var2_2 + true;
        }
        return var1_1 < string.length();
    }

    static {
        new UnicodeLocaleExtension()._keywords = new TreeMap<String, String>();
        UnicodeLocaleExtension.CA_JAPANESE._keywords.put("ca", "japanese");
        UnicodeLocaleExtension.CA_JAPANESE._value = "ca-japanese";
        NU_THAI = new UnicodeLocaleExtension();
        new UnicodeLocaleExtension()._keywords = new TreeMap<String, String>();
        UnicodeLocaleExtension.NU_THAI._keywords.put("nu", "thai");
        UnicodeLocaleExtension.NU_THAI._value = "nu-thai";
    }
}

