/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.number;

import com.ibm.icu.impl.number.DecimalQuantity;
import com.ibm.icu.text.PluralRules;
import java.math.BigDecimal;
import java.math.BigInteger;

public abstract class DecimalQuantity_AbstractBCD
implements DecimalQuantity {
    protected int scale;
    protected int precision;
    protected byte flags;
    protected double origDouble;
    protected int origDelta;
    protected boolean isApproximate;
    protected int lReqPos = 0;
    protected int rReqPos = 0;
    protected int exponent = 0;
    private static final double[] DOUBLE_MULTIPLIERS = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21};
    private static byte[] INT64_BCD = new byte[]{9, 2, 2, 3, 3, 7, 2, 0, 3, 6, 8, 5, 4, 7, 7, 5, 8, 0, 8};

    /*
     * WARNING - void declaration
     */
    public final void setMinFraction(int minFrac) {
        void var1_1;
        assert (minFrac >= 0);
        this.rReqPos = -var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void adjustExponent(int delta) {
        void var1_1;
        this.exponent += var1_1;
    }

    @Override
    public final double getPluralOperand(PluralRules.Operand operand) {
        double d;
        DecimalQuantity_AbstractBCD decimalQuantity_AbstractBCD;
        assert (!this.isApproximate);
        switch (1.$SwitchMap$com$ibm$icu$text$PluralRules$Operand[((Enum)((Object)decimalQuantity_AbstractBCD)).ordinal()]) {
            case 1: {
                if (this.isNegative()) {
                    return -this.toLong(true);
                }
                return this.toLong(true);
            }
            case 2: {
                return this.toFractionLong(true);
            }
            case 3: {
                return this.toFractionLong(false);
            }
            case 4: {
                decimalQuantity_AbstractBCD = this;
                return Math.max(0, -decimalQuantity_AbstractBCD.getLowerDisplayMagnitude() - decimalQuantity_AbstractBCD.exponent);
            }
            case 5: {
                decimalQuantity_AbstractBCD = this;
                return Math.max(-decimalQuantity_AbstractBCD.scale - decimalQuantity_AbstractBCD.exponent, 0);
            }
            case 6: {
                decimalQuantity_AbstractBCD = this;
                return decimalQuantity_AbstractBCD.exponent;
            }
            case 7: {
                decimalQuantity_AbstractBCD = this;
                return decimalQuantity_AbstractBCD.exponent;
            }
        }
        decimalQuantity_AbstractBCD = this;
        assert (!decimalQuantity_AbstractBCD.isApproximate);
        if (decimalQuantity_AbstractBCD.isNaN()) {
            d = Double.NaN;
        } else if (decimalQuantity_AbstractBCD.isInfinite()) {
            d = decimalQuantity_AbstractBCD.isNegative() ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            decimalQuantity_AbstractBCD.toScientificString(stringBuilder);
            d = Double.valueOf(stringBuilder.toString());
        }
        return Math.abs(d);
    }

    private int getLowerDisplayMagnitude() {
        int n;
        assert (!this.isApproximate);
        int magnitude = this.scale;
        n = this.rReqPos < magnitude ? this.rReqPos : n;
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private byte getDigit(int magnitude) {
        void var1_1;
        assert (!this.isApproximate);
        return this.getDigitPos((int)(var1_1 - this.scale));
    }

    public final boolean isNegative() {
        return (this.flags & 1) != 0;
    }

    @Override
    public final boolean isInfinite() {
        return (this.flags & 2) != 0;
    }

    @Override
    public final boolean isNaN() {
        return (this.flags & 4) != 0;
    }

    /*
     * WARNING - void declaration
     */
    private void _setToLong(long n) {
        void var1_1;
        if (n == Long.MIN_VALUE) {
            this.readBigIntegerToBcd(BigInteger.valueOf(n).negate());
            return;
        }
        if (n <= Integer.MAX_VALUE) {
            this.readIntToBcd((int)n);
            return;
        }
        this.readLongToBcd((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setToDouble(double n) {
        this.setBcdToZero();
        this.flags = 0;
        if (Double.doubleToRawLongBits(n) < 0L) {
            this.flags = (byte)(this.flags | 1);
            n = -n;
        }
        if (Double.isNaN(n)) {
            this.flags = (byte)(this.flags | 4);
            return;
        }
        if (Double.isInfinite(n)) {
            this.flags = (byte)(this.flags | 2);
            return;
        }
        if (n != 0.0) {
            void var1_1;
            void var4_3 = var1_1;
            DecimalQuantity_AbstractBCD decimalQuantity_AbstractBCD = this;
            this.isApproximate = true;
            decimalQuantity_AbstractBCD.origDouble = var4_3;
            decimalQuantity_AbstractBCD.origDelta = 0;
            long l = Double.doubleToLongBits((double)var4_3);
            int n2 = (int)((l & 0x7FF0000000000000L) >> 52) - 1023;
            if (n2 <= 52 && (double)((long)var4_3) == var4_3) {
                decimalQuantity_AbstractBCD._setToLong((long)var4_3);
            } else if (n2 == -1023 || n2 == 1024) {
                double d = decimalQuantity_AbstractBCD.origDouble;
                assert (d != 0.0);
                decimalQuantity_AbstractBCD.setBcdToZero();
                String string = Double.toString(d);
                if (string.indexOf(69) != -1) {
                    assert (string.indexOf(46) == 1);
                    int n3 = string.indexOf(69);
                    decimalQuantity_AbstractBCD._setToLong(Long.parseLong(string.charAt(0) + string.substring(2, n3)));
                    decimalQuantity_AbstractBCD.scale += Integer.parseInt(string.substring(n3 + 1)) - (n3 - 1) + 1;
                } else if (string.charAt(0) == '0') {
                    assert (string.indexOf(46) == 1);
                    decimalQuantity_AbstractBCD._setToLong(Long.parseLong(string.substring(2)));
                    decimalQuantity_AbstractBCD.scale += 2 - string.length();
                } else {
                    String string2 = string;
                    if (string2.charAt(string2.length() - 1) == '0') {
                        assert (string.indexOf(46) == string.length() - 2);
                        assert (string.length() - 2 <= 18);
                        decimalQuantity_AbstractBCD._setToLong(Long.parseLong(string.substring(0, string.length() - 2)));
                    } else {
                        int n4 = string.indexOf(46);
                        decimalQuantity_AbstractBCD._setToLong(Long.parseLong(string.substring(0, n4) + string.substring(n4 + 1)));
                        decimalQuantity_AbstractBCD.scale += n4 - string.length() + 1;
                    }
                }
                decimalQuantity_AbstractBCD.scale = decimalQuantity_AbstractBCD.scale;
                decimalQuantity_AbstractBCD.compact();
            } else {
                int n5;
                if ((n2 = (int)((double)(52 - n2) / 3.321928094887362)) >= 0) {
                    for (n5 = n2; n5 >= 22; n5 -= 22) {
                        var4_3 *= 1.0E22;
                    }
                    var4_3 *= DOUBLE_MULTIPLIERS[n5];
                } else {
                    for (n5 = n2; n5 <= -22; n5 += 22) {
                        var4_3 /= 1.0E22;
                    }
                    var4_3 /= DOUBLE_MULTIPLIERS[-n5];
                }
                long l2 = Math.round((double)var4_3);
                if (l2 != 0L) {
                    decimalQuantity_AbstractBCD._setToLong(l2);
                    decimalQuantity_AbstractBCD.scale -= n2;
                }
            }
            this.compact();
        }
    }

    public final void setToBigDecimal(BigDecimal n) {
        this.setBcdToZero();
        this.flags = 0;
        if (n.signum() == -1) {
            this.flags = (byte)(this.flags | 1);
            n = n.negate();
        }
        if (n.signum() != 0) {
            DecimalQuantity_AbstractBCD decimalQuantity_AbstractBCD;
            Object object = decimalQuantity_AbstractBCD;
            decimalQuantity_AbstractBCD = this;
            int n2 = ((BigDecimal)object).scale();
            object = ((BigDecimal)object).scaleByPowerOfTen(n2);
            object = ((BigDecimal)object).toBigInteger();
            Number number = object;
            object = decimalQuantity_AbstractBCD;
            if (((BigInteger)number).bitLength() < 32) {
                ((DecimalQuantity_AbstractBCD)object).readIntToBcd(((BigInteger)number).intValue());
            } else if (((BigInteger)number).bitLength() < 64) {
                ((DecimalQuantity_AbstractBCD)object).readLongToBcd(((BigInteger)number).longValue());
            } else {
                ((DecimalQuantity_AbstractBCD)object).readBigIntegerToBcd((BigInteger)number);
            }
            decimalQuantity_AbstractBCD.scale -= n2;
            this.compact();
        }
    }

    /*
     * WARNING - void declaration
     */
    private long toLong(boolean truncateIfOverflow2) {
        void var2_6;
        int magnitude;
        long result = 0L;
        int magnitude = this.exponent + this.scale + this.precision - 1;
        magnitude = magnitude = Math.min(magnitude, 17);
        while (magnitude >= 0) {
            result = result * 10L + (long)this.getDigitPos((int)(magnitude - this.scale - this.exponent));
            --magnitude;
        }
        if (this.isNegative()) {
            result = -result;
        }
        return (long)var2_6;
    }

    /*
     * WARNING - void declaration
     */
    private long toFractionLong(boolean includeTrailingZeros) {
        void var2_2;
        void var1_1;
        long result = 0L;
        int magnitude = -1 - this.exponent;
        int lowerMagnitude = this.scale;
        if (includeTrailingZeros) {
            lowerMagnitude = Math.min(lowerMagnitude, this.rReqPos);
        }
        while (magnitude >= lowerMagnitude && (double)result <= 1.0E17) {
            result = result * 10L + (long)this.getDigitPos(magnitude - this.scale);
            --magnitude;
        }
        if (var1_1 == false) {
            while (result > 0L && result % 10L == 0L) {
                result /= 10L;
            }
        }
        return (long)var2_2;
    }

    private void toScientificString(StringBuilder result) {
        int upperPos;
        assert (!this.isApproximate);
        if (this.isNegative()) {
            result.append('-');
        }
        if (this.precision == 0) {
            result.append("0E+0");
            return;
        }
        int p = upperPos = this.precision - 1;
        result.append((char)(48 + this.getDigitPos(p)));
        if (--p >= 0) {
            result.append('.');
            while (p >= 0) {
                result.append((char)(48 + this.getDigitPos(p)));
                --p;
            }
        }
        result.append('E');
        int _scale = upperPos + this.scale + this.exponent;
        if (_scale == Integer.MIN_VALUE) {
            result.append("-2147483648");
            return;
        }
        if (_scale < 0) {
            _scale = -_scale;
            result.append('-');
        } else {
            result.append('+');
        }
        if (_scale == 0) {
            result.append('0');
        }
        int insertIndex = result.length();
        while (_scale > 0) {
            int n;
            int quot = _scale / 10;
            int rem = _scale % 10;
            result.insert(insertIndex, (char)(n + 48));
            n = quot;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String toExponentString() {
        void var1_1;
        StringBuilder sb = new StringBuilder();
        this.toExponentString(sb);
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    private void toExponentString(StringBuilder result) {
        int p;
        assert (!this.isApproximate);
        if (this.isNegative()) {
            result.append('-');
        }
        int upper = this.scale + this.precision - 1;
        int lower = this.scale;
        if (upper < -1) {
            upper = -1;
        }
        if (lower > this.rReqPos) {
            lower = this.rReqPos;
        }
        if ((p = upper) < 0) {
            result.append('0');
        }
        while (p >= 0) {
            result.append((char)(48 + this.getDigitPos(p - this.scale)));
            --p;
        }
        if (lower < 0) {
            result.append('.');
        }
        while (p >= lower) {
            result.append((char)(48 + this.getDigitPos(p - this.scale)));
            --p;
        }
        if (this.exponent != 0) {
            void var1_1;
            result.append('c');
            var1_1.append(this.exponent);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof DecimalQuantity_AbstractBCD)) {
            return false;
        }
        DecimalQuantity_AbstractBCD _other = (DecimalQuantity_AbstractBCD)other;
        boolean bl = this.scale == _other.scale && this.precision == _other.precision && this.flags == _other.flags && this.rReqPos == _other.rReqPos && this.isApproximate == _other.isApproximate;
        if (!bl) {
            return false;
        }
        if (this.precision == 0) {
            return true;
        }
        if (this.isApproximate) {
            return this.origDouble == _other.origDouble;
        }
        DecimalQuantity_AbstractBCD decimalQuantity_AbstractBCD = this;
        assert (!decimalQuantity_AbstractBCD.isApproximate);
        int n = decimalQuantity_AbstractBCD.scale + decimalQuantity_AbstractBCD.precision;
        n = n < 0 ? 0 : n;
        for (int m = n - 1; m >= this.getLowerDisplayMagnitude(); --m) {
            if (this.getDigit(m) == _other.getDigit(m)) continue;
            return false;
        }
        return true;
    }

    protected abstract byte getDigitPos(int var1);

    protected abstract void setBcdToZero();

    protected abstract void readIntToBcd(int var1);

    protected abstract void readLongToBcd(long var1);

    protected abstract void readBigIntegerToBcd(BigInteger var1);

    protected abstract void compact();
}

