/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.number;

import com.ibm.icu.impl.number.DecimalQuantity;
import com.ibm.icu.impl.number.DecimalQuantity_AbstractBCD;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class DecimalQuantity_DualStorageBCD
extends DecimalQuantity_AbstractBCD {
    private byte[] bcdBytes;
    private long bcdLong = 0L;
    private boolean usingBytes = false;

    public DecimalQuantity_DualStorageBCD() {
        this.setBcdToZero();
        this.flags = 0;
    }

    public DecimalQuantity_DualStorageBCD(double input) {
        this.setToDouble(-0.00123456777);
    }

    /*
     * WARNING - void declaration
     */
    private DecimalQuantity_DualStorageBCD(BigDecimal input) {
        void var1_1;
        this.setToBigDecimal((BigDecimal)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static DecimalQuantity fromExponentString(String num) {
        void var2_8;
        void var1_4;
        String string;
        if (num.contains("e") || num.contains("c") || num.contains("E") || num.contains("C")) {
            void var0_1;
            int ePos = num.lastIndexOf(101);
            if (ePos < 0) {
                ePos = num.lastIndexOf(99);
            }
            if (ePos < 0) {
                ePos = num.lastIndexOf(69);
            }
            if (ePos < 0) {
                ePos = num.lastIndexOf(67);
            }
            int expNumPos22 = ePos + 1;
            String expNumPos22 = num.substring(expNumPos22);
            int exponent = Integer.parseInt(expNumPos22);
            String fractionStr = num.substring(0, ePos);
            BigDecimal fraction = new BigDecimal(fractionStr);
            DecimalQuantity_DualStorageBCD dq = new DecimalQuantity_DualStorageBCD(fraction);
            int numFracDigit = DecimalQuantity_DualStorageBCD.getVisibleFractionCount(fractionStr);
            dq.setMinFraction((int)var0_1);
            dq.adjustExponent(exponent);
            return dq;
        }
        int numFracDigit = DecimalQuantity_DualStorageBCD.getVisibleFractionCount(string);
        DecimalQuantity_DualStorageBCD dq = new DecimalQuantity_DualStorageBCD(new BigDecimal(string));
        dq.setMinFraction((int)var1_4);
        return var2_8;
    }

    /*
     * WARNING - void declaration
     */
    private static int getVisibleFractionCount(String value) {
        void var1_1;
        String string;
        int decimalPos = value.indexOf(46) + 1;
        if (decimalPos == 0) {
            return 0;
        }
        return string.length() - var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final byte getDigitPos(int position) {
        void var1_1;
        if (this.usingBytes) {
            if (position < 0 || position >= this.precision) {
                return 0;
            }
            return this.bcdBytes[position];
        }
        if (position < 0 || position >= 16) {
            return 0;
        }
        return (byte)(this.bcdLong >>> (var1_1 << 2) & 0xFL);
    }

    @Override
    protected final void setBcdToZero() {
        if (this.usingBytes) {
            this.bcdBytes = null;
            this.usingBytes = false;
        }
        this.bcdLong = 0L;
        this.scale = 0;
        this.precision = 0;
        this.isApproximate = false;
        this.origDouble = 0.0;
        this.origDelta = 0;
        this.exponent = 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void readIntToBcd(int n) {
        void var2_2;
        assert (n != 0);
        long result = 0L;
        int i = 16;
        while (n != 0) {
            result = (result >>> 4) + ((long)n % 10L << 60);
            n /= 10;
            --i;
        }
        assert (!this.usingBytes);
        this.bcdLong = var2_2 >>> (i << 2);
        this.scale = 0;
        this.precision = 16 - i;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void readLongToBcd(long n) {
        void var3_4;
        assert (n != 0L);
        if (n >= 10000000000000000L) {
            DecimalQuantity_DualStorageBCD decimalQuantity_DualStorageBCD = this;
            decimalQuantity_DualStorageBCD.ensureCapacity(40);
            int i = 0;
            while (n != 0L) {
                this.bcdBytes[i] = (byte)(n % 10L);
                n /= 10L;
                ++i;
            }
            assert (this.usingBytes);
            this.scale = 0;
            this.precision = i;
            return;
        }
        long result = 0L;
        int i = 16;
        while (n != 0L) {
            result = (result >>> 4) + (n % 10L << 60);
            n /= 10L;
            --i;
        }
        assert (i >= 0);
        assert (!this.usingBytes);
        this.bcdLong = var3_4 >>> (i << 2);
        this.scale = 0;
        this.precision = 16 - i;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void readBigIntegerToBcd(BigInteger n) {
        void var2_3;
        assert (n.signum() != 0);
        DecimalQuantity_DualStorageBCD decimalQuantity_DualStorageBCD = this;
        decimalQuantity_DualStorageBCD.ensureCapacity(40);
        int i = 0;
        while (n.signum() != 0) {
            void var1_1;
            BigInteger[] temp = n.divideAndRemainder(BigInteger.TEN);
            this.ensureCapacity(i + 1);
            this.bcdBytes[i] = temp[1].byteValue();
            var1_1 = var1_1[0];
            ++i;
        }
        this.scale = 0;
        this.precision = var2_3;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    protected final void compact() {
        void var1_5;
        if (this.usingBytes) {
            int leading22;
            int delta22;
            for (delta22 = 0; delta22 < this.precision && this.bcdBytes[delta22] == 0; ++delta22) {
            }
            if (delta22 == this.precision) {
                this.setBcdToZero();
                return;
            }
            int n = delta22;
            DecimalQuantity_DualStorageBCD delta22 = this;
            if (delta22.usingBytes) {
                int n2;
                for (n2 = 0; n2 < delta22.precision - n; ++n2) {
                    delta22.bcdBytes[n2] = delta22.bcdBytes[n2 + n];
                }
                while (n2 < delta22.precision) {
                    delta22.bcdBytes[n2] = 0;
                    ++n2;
                }
            } else {
                delta22.bcdLong >>>= n << 2;
            }
            delta22.scale += n;
            delta22.precision -= n;
            for (leading22 = this.precision - 1; leading22 >= 0 && this.bcdBytes[leading22] == 0; --leading22) {
            }
            this.precision = leading22 + 1;
            if (this.precision > 16) return;
            DecimalQuantity_DualStorageBCD leading22 = this;
            if (leading22.usingBytes) {
                leading22.bcdLong = 0L;
                n = leading22.precision - 1;
                while (true) {
                    if (n < 0) {
                        leading22.bcdBytes = null;
                        leading22.usingBytes = false;
                        return;
                    }
                    leading22.bcdLong <<= 4;
                    leading22.bcdLong |= (long)leading22.bcdBytes[n];
                    --n;
                }
            }
            DecimalQuantity_DualStorageBCD decimalQuantity_DualStorageBCD = leading22;
            decimalQuantity_DualStorageBCD.ensureCapacity(40);
            int n3 = 0;
            while (true) {
                if (n3 >= leading22.precision) {
                    if ($assertionsDisabled) return;
                    if (leading22.usingBytes) return;
                    throw new AssertionError();
                }
                leading22.bcdBytes[n3] = (byte)(leading22.bcdLong & 0xFL);
                leading22.bcdLong >>>= 4;
                ++n3;
            }
        }
        if (this.bcdLong == 0L) {
            this.setBcdToZero();
            return;
        }
        int delta = Long.numberOfTrailingZeros(this.bcdLong) / 4;
        this.bcdLong >>>= delta << 2;
        this.scale += var1_5;
        this.precision = 16 - Long.numberOfLeadingZeros(this.bcdLong) / 4;
    }

    /*
     * WARNING - void declaration
     */
    private void ensureCapacity(int capacity) {
        int oldCapacity;
        if (capacity == 0) {
            return;
        }
        int n = oldCapacity = this.usingBytes ? this.bcdBytes.length : 0;
        if (!this.usingBytes) {
            this.bcdBytes = new byte[capacity];
        } else if (oldCapacity < capacity) {
            void var1_2;
            void var2_3;
            byte[] bcd1 = new byte[capacity << 1];
            System.arraycopy(this.bcdBytes, 0, bcd1, 0, (int)var2_3);
            this.bcdBytes = var1_2;
        }
        this.usingBytes = true;
    }

    public final String toString() {
        Object[] objectArray = new Object[5];
        objectArray[0] = 0;
        objectArray[1] = this.rReqPos;
        objectArray[2] = this.usingBytes ? "bytes" : "long";
        objectArray[3] = this.isNegative() ? "-" : "";
        DecimalQuantity_DualStorageBCD decimalQuantity_DualStorageBCD = this;
        StringBuilder stringBuilder = new StringBuilder();
        if (decimalQuantity_DualStorageBCD.usingBytes) {
            if (decimalQuantity_DualStorageBCD.precision == 0) {
                stringBuilder.append('0');
            }
            for (int i = decimalQuantity_DualStorageBCD.precision - 1; i >= 0; --i) {
                stringBuilder.append(decimalQuantity_DualStorageBCD.bcdBytes[i]);
            }
        } else {
            stringBuilder.append(Long.toHexString(decimalQuantity_DualStorageBCD.bcdLong));
        }
        stringBuilder.append("E");
        stringBuilder.append(decimalQuantity_DualStorageBCD.scale);
        objectArray[4] = stringBuilder.toString();
        return String.format("<DecimalQuantity %d:%d %s %s%s>", objectArray);
    }
}

