/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.CacheValue;
import com.ibm.icu.impl.ICUDebug;
import com.ibm.icu.util.ICUCloneNotSupportedException;
import com.ibm.icu.util.ULocale;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.MissingResourceException;

public abstract class BreakIterator
implements Cloneable {
    private static final boolean DEBUG = ICUDebug.enabled("breakiterator");
    private static final CacheValue<?>[] iterCache = new CacheValue[5];
    private static BreakIteratorServiceShim shim;

    protected BreakIterator() {
    }

    /*
     * WARNING - void declaration
     */
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            void var1_1;
            throw new ICUCloneNotSupportedException((Throwable)var1_1);
        }
    }

    public abstract int first();

    public abstract int next(int var1);

    public abstract int next();

    public abstract CharacterIterator getText();

    /*
     * WARNING - void declaration
     */
    public void setText(String newText) {
        void var1_1;
        this.setText(new StringCharacterIterator((String)var1_1));
    }

    public abstract void setText(CharacterIterator var1);

    public static BreakIterator getWordInstance(ULocale where) {
        return BreakIterator.getBreakInstance(where, 1);
    }

    public static BreakIterator getCharacterInstance() {
        ULocale uLocale = ULocale.getDefault();
        return BreakIterator.getBreakInstance(uLocale, 0);
    }

    public static BreakIterator getSentenceInstance(ULocale where) {
        return BreakIterator.getBreakInstance(where, 3);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    private static BreakIterator getBreakInstance(ULocale where, int kind) {
        void var2_2;
        BreakIteratorCache breakIteratorCache;
        BreakIteratorCache cache;
        if (where == null) {
            throw new NullPointerException("Specified locale is null");
        }
        if (iterCache[kind] != null && (cache = (BreakIteratorCache)iterCache[kind].get()) != null && cache.getLocale().equals(where)) {
            return cache.createBreakInstance();
        }
        BreakIterator result = BreakIterator.getShim().createBreakIterator(where, kind);
        BreakIteratorCache cache2 = new BreakIteratorCache(where, result);
        BreakIterator.iterCache[var1_1] = CacheValue.getInstance(breakIteratorCache);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static BreakIteratorServiceShim getShim() {
        if (shim == null) {
            try {
                Class<?> clazz = Class.forName("com.ibm.icu.text.BreakIteratorFactory");
                shim = (BreakIteratorServiceShim)clazz.newInstance();
            }
            catch (MissingResourceException missingResourceException) {
                MissingResourceException missingResourceException2 = missingResourceException;
                throw missingResourceException;
            }
            catch (Exception e) {
                void var0_2;
                if (DEBUG) {
                    e.printStackTrace();
                }
                throw new RuntimeException(var0_2.getMessage());
            }
        }
        return shim;
    }

    /*
     * WARNING - void declaration
     */
    final void setLocale(ULocale valid, ULocale actual) {
        void var2_2;
        if (valid == null != (var2_2 == null)) {
            throw new IllegalArgumentException();
        }
    }

    static abstract class BreakIteratorServiceShim {
        BreakIteratorServiceShim() {
        }

        public abstract BreakIterator createBreakIterator(ULocale var1, int var2);
    }

    static final class BreakIteratorCache {
        private BreakIterator iter;
        private ULocale where;

        /*
         * WARNING - void declaration
         */
        BreakIteratorCache(ULocale where, BreakIterator iter) {
            void var2_2;
            void var1_1;
            this.where = var1_1;
            this.iter = (BreakIterator)var2_2.clone();
        }

        final ULocale getLocale() {
            return this.where;
        }

        final BreakIterator createBreakInstance() {
            return (BreakIterator)this.iter.clone();
        }
    }
}

