/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.ICUBinary;
import com.ibm.icu.impl.ICULocaleService;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.ICUService;
import com.ibm.icu.impl.SimpleFilteredSentenceBreakIterator;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.FilteredBreakIteratorBuilder;
import com.ibm.icu.text.RuleBasedBreakIterator;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.MissingResourceException;

final class BreakIteratorFactory
extends BreakIterator.BreakIteratorServiceShim {
    private static ICULocaleService service = new BFService();
    private static final String[] KIND_NAMES = new String[]{"grapheme", "word", "line", "sentence", "title"};

    BreakIteratorFactory() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final BreakIterator createBreakIterator(ULocale locale, int kind) {
        void var1_1;
        void var3_5;
        void var2_2;
        ULocale[] actualLoc;
        if (service.isDefault()) {
            return BreakIteratorFactory.createBreakInstance((ULocale)locale, kind);
        }
        ULocale[] uLocaleArray = actualLoc = new ULocale[1];
        void var4_7 = var2_2;
        Object object = locale;
        locale = service;
        void var6_9 = var4_7;
        String[] stringArray = object;
        object = locale;
        object = ICULocaleService.LocaleKey.createWithCanonical((ULocale)stringArray, ((ICULocaleService)object).validateFallbackLocale(), (int)var6_9);
        stringArray = new String[1];
        String[] stringArray2 = stringArray;
        if ((locale = ((ICUService)locale).getKey((ICUService.Key)object, stringArray2, null)) != null) {
            int n = stringArray[0].indexOf("/");
            if (n >= 0) {
                stringArray[0] = stringArray[0].substring(n + 1);
            }
            uLocaleArray[0] = new ULocale(stringArray[0]);
        }
        BreakIterator iter = (BreakIterator)locale;
        iter.setLocale(actualLoc[0], (ULocale)var3_5[0]);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static BreakIterator createBreakInstance(ULocale locale, int kind) {
        String ssKeyword;
        void var1_1;
        void var3_3;
        ULocale uloc;
        RuleBasedBreakIterator iter;
        ByteBuffer bytes;
        String brkfname;
        BreakIterator breakIterator = null;
        ICUResourceBundle rb = ICUResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt73b/brkitr", (ULocale)locale, ICUResourceBundle.OpenType.LOCALE_ROOT);
        String typeKeyExt = "";
        if (kind == 2) {
            String language;
            String keyValue = ((ULocale)locale).getKeywordValue("lb");
            if (keyValue != null && (keyValue.equals("strict") || keyValue.equals("normal") || keyValue.equals("loose"))) {
                typeKeyExt = "_" + keyValue;
            }
            if ((language = ((ULocale)locale).getLanguage()) != null && (language.equals("ja") || language.equals("ko")) && (language = ((ULocale)locale).getKeywordValue("lw")) != null && language.equals("phrase")) {
                typeKeyExt = typeKeyExt + "_" + language;
            }
        }
        try {
            String typeKey = typeKeyExt.isEmpty() ? KIND_NAMES[kind] : KIND_NAMES[kind] + typeKeyExt;
            brkfname = rb.getStringWithFallback("boundaries/" + typeKey);
            String string = "brkitr/" + brkfname;
            bytes = ICUBinary.getData(string);
        }
        catch (Exception e) {
            throw new MissingResourceException(e.toString(), "", "");
        }
        try {
            boolean isPhraseBreaking = brkfname != null && brkfname.contains("phrase");
            iter = RuleBasedBreakIterator.getInstanceFromCompiledRules(bytes, isPhraseBreaking);
        }
        catch (IOException iOException) {
            IOException isPhraseBreaking = iOException;
            locale = iOException;
            locale = iOException.toString();
            throw new IllegalStateException("failure '" + (String)locale + "'");
        }
        ULocale uLocale = uloc = ULocale.forLocale(var3_3.getLocale());
        iter.setLocale(uLocale, uLocale);
        if (var1_1 == 3 && (ssKeyword = ((ULocale)locale).getKeywordValue("ss")) != null && ssKeyword.equals("standard")) {
            ULocale uLocale2;
            uLocale2 = new ULocale(uLocale2.getBaseName());
            return ((FilteredBreakIteratorBuilder)new SimpleFilteredSentenceBreakIterator.Builder(uLocale2)).wrapIteratorWithFilter(iter);
        }
        return breakIterator;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ BreakIterator access$000(ULocale x0, int x1) {
        void var1_1;
        return BreakIteratorFactory.createBreakInstance(x0, (int)var1_1);
    }

    static final class BFService
    extends ICULocaleService {
        BFService() {
            super("BreakIterator");
            final class RBBreakIteratorFactory
            extends ICULocaleService.ICUResourceBundleFactory {
                RBBreakIteratorFactory(BFService this$0) {
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                protected final Object handleCreate$6df53f5b(ULocale loc, int kind) {
                    void var2_2;
                    return BreakIteratorFactory.access$000(loc, (int)var2_2);
                }
            }
            this.registerFactory(new RBBreakIteratorFactory(this));
            this.markDefault();
        }

        @Override
        public final String validateFallbackLocale() {
            return "";
        }
    }
}

