/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import java.nio.BufferOverflowException;
import java.util.Arrays;

public final class Edits {
    private char[] array = new char[100];
    private int length;
    private int delta;
    private int numChanges;

    public final void reset() {
        Edits edits = this;
        this.numChanges = 0;
        edits.delta = 0;
        edits.length = 0;
    }

    /*
     * WARNING - void declaration
     */
    private void setLastUnit(int last) {
        void var1_1;
        this.array[this.length - 1] = (char)var1_1;
    }

    private int lastUnit() {
        if (this.length > 0) {
            return this.array[this.length - 1];
        }
        return 65535;
    }

    /*
     * WARNING - void declaration
     */
    public final void addUnchanged(int unchangedLength) {
        if (unchangedLength < 0) {
            throw new IllegalArgumentException("addUnchanged(" + unchangedLength + "): length must not be negative");
        }
        int last = this.lastUnit();
        if (last < 4095) {
            void var3_3;
            int remaining = 4095 - last;
            if (remaining >= unchangedLength) {
                void var2_2;
                this.setLastUnit((int)(var2_2 + unchangedLength));
                return;
            }
            this.setLastUnit(4095);
            unchangedLength -= var3_3;
        }
        while (unchangedLength >= 4096) {
            this.append(4095);
            unchangedLength -= 4096;
        }
        if (unchangedLength > 0) {
            void var1_1;
            this.append((int)(var1_1 - true));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void addReplace(int oldLength, int newLength) {
        void var3_3;
        int head;
        int u;
        if (oldLength < 0 || newLength < 0) {
            throw new IllegalArgumentException("addReplace(" + oldLength + ", " + newLength + "): both lengths must be non-negative");
        }
        if (oldLength == 0 && newLength == 0) {
            return;
        }
        ++this.numChanges;
        int newDelta = newLength - oldLength;
        if (newDelta != 0) {
            if (newDelta > 0 && this.delta >= 0 && newDelta > Integer.MAX_VALUE - this.delta || newDelta < 0 && this.delta < 0 && newDelta < Integer.MIN_VALUE - this.delta) {
                throw new IndexOutOfBoundsException();
            }
            this.delta += newDelta;
        }
        if (oldLength > 0 && oldLength <= 6 && newLength <= 7) {
            u = oldLength << 12 | newLength << 9;
            int last = this.lastUnit();
            if (4095 < last && last < 28671 && (last & 0xFFFFFE00) == u && (last & 0x1FF) < 511) {
                this.setLastUnit(last + 1);
                return;
            }
            this.append(u);
            return;
        }
        if (oldLength < 61 && newLength < 61) {
            u = 0x7000 | oldLength << 6;
            head = u | newLength;
            this.append(head);
            return;
        }
        if (this.array.length - this.length < 5) {
            this.growArray();
        }
        int limit = this.length + 1;
        if (oldLength < 61) {
            head = 0x7000 | oldLength << 6;
        } else if (oldLength <= Short.MAX_VALUE) {
            head = 32576;
            this.array[limit++] = (char)(0x8000 | oldLength);
        } else {
            void var1_1;
            head = 0x7000 | 62 + (oldLength >> 30) << 6;
            this.array[limit++] = (char)(0x8000 | oldLength >> 15);
            this.array[limit++] = (char)(0x8000 | var1_1);
        }
        if (newLength < 61) {
            head |= newLength;
        } else if (newLength <= Short.MAX_VALUE) {
            head |= 0x3D;
            this.array[limit++] = (char)(0x8000 | newLength);
        } else {
            void var2_2;
            head |= 62 + (newLength >> 30);
            this.array[limit++] = (char)(0x8000 | newLength >> 15);
            this.array[limit++] = (char)(0x8000 | var2_2);
        }
        this.array[this.length] = (char)var3_3;
        this.length = limit;
    }

    /*
     * WARNING - void declaration
     */
    private void append(int r) {
        void var1_1;
        if (this.length >= this.array.length) {
            this.growArray();
        }
        this.array[this.length++] = (char)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private boolean growArray() {
        void var1_1;
        int newCapacity;
        if (this.array.length == 100) {
            newCapacity = 2000;
        } else {
            if (this.array.length == Integer.MAX_VALUE) {
                throw new BufferOverflowException();
            }
            newCapacity = this.array.length >= 0x3FFFFFFF ? Integer.MAX_VALUE : 2 * this.array.length;
        }
        if (newCapacity - this.array.length < 5) {
            throw new BufferOverflowException();
        }
        this.array = Arrays.copyOf(this.array, (int)var1_1);
        return true;
    }

    public final int lengthDelta() {
        return this.delta;
    }

    public final boolean hasChanges() {
        return this.numChanges != 0;
    }

    public final Iterator getCoarseIterator() {
        return new Iterator(this.array, this.length, false, true, 0);
    }

    public static final class Iterator {
        private final char[] array;
        private int index;
        private final int length;
        private int remaining;
        private final boolean onlyChanges_;
        private final boolean coarse;
        private int dir;
        private boolean changed;
        private int oldLength_;
        private int newLength_;
        private int srcIndex;
        private int replIndex;
        private int destIndex;

        /*
         * WARNING - void declaration
         */
        private Iterator(char[] a, int len, boolean oc, boolean crs) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.array = var1_1;
            this.length = var2_2;
            this.onlyChanges_ = var3_3;
            this.coarse = crs;
        }

        /*
         * WARNING - void declaration
         */
        private int readLength(int head) {
            void var1_1;
            if (head < 61) {
                return head;
            }
            if (head < 62) {
                assert (this.index < this.length);
                assert (this.array[this.index] >= '\u8000');
                return this.array[this.index++] & Short.MAX_VALUE;
            }
            assert (this.index + 2 <= this.length);
            assert (this.array[this.index] >= '\u8000');
            assert (this.array[this.index + 1] >= '\u8000');
            int len = (head & 1) << 30 | (this.array[this.index] & Short.MAX_VALUE) << 15 | this.array[this.index + 1] & Short.MAX_VALUE;
            this.index += 2;
            return (int)var1_1;
        }

        private void updateNextIndexes() {
            this.srcIndex += this.oldLength_;
            if (this.changed) {
                this.replIndex += this.newLength_;
            }
            this.destIndex += this.newLength_;
        }

        private boolean noNext() {
            this.dir = 0;
            this.changed = false;
            Iterator iterator = this;
            iterator.newLength_ = 0;
            iterator.oldLength_ = 0;
            return false;
        }

        public final boolean next() {
            block17: {
                int n;
                Iterator iterator;
                int n2;
                block22: {
                    block20: {
                        int n3;
                        block21: {
                            block18: {
                                block19: {
                                    block15: {
                                        block16: {
                                            block14: {
                                                Iterator iterator2 = this;
                                                n2 = iterator2.onlyChanges_;
                                                iterator = iterator2;
                                                if (iterator2.dir <= 0) break block14;
                                                iterator.updateNextIndexes();
                                                break block15;
                                            }
                                            if (iterator.dir >= 0 || iterator.remaining <= 0) break block16;
                                            ++iterator.index;
                                            iterator.dir = 1;
                                            break block17;
                                        }
                                        iterator.dir = 1;
                                    }
                                    if (iterator.remaining <= 0) break block18;
                                    if (iterator.remaining <= 1) break block19;
                                    --iterator.remaining;
                                    break block17;
                                }
                                iterator.remaining = 0;
                            }
                            if (iterator.index >= iterator.length) {
                                return iterator.noNext();
                            }
                            if ((n = iterator.array[iterator.index++]) <= 4095) {
                                iterator.changed = false;
                                iterator.oldLength_ = n + '\u0001';
                                while (iterator.index < iterator.length && (n = iterator.array[iterator.index]) <= 4095) {
                                    ++iterator.index;
                                    iterator.oldLength_ += n + 1;
                                }
                                iterator.newLength_ = iterator.oldLength_;
                                if (n2 != 0) {
                                    iterator.updateNextIndexes();
                                    if (iterator.index >= iterator.length) {
                                        return iterator.noNext();
                                    }
                                    ++iterator.index;
                                } else {
                                    return true;
                                }
                            }
                            iterator.changed = true;
                            if (n > 28671) break block20;
                            n2 = n >> 12;
                            n3 = n >> 9 & 7;
                            n = (n & 0x1FF) + 1;
                            if (!iterator.coarse) break block21;
                            iterator.oldLength_ = n * n2;
                            iterator.newLength_ = n * n3;
                            break block22;
                        }
                        iterator.oldLength_ = n2;
                        iterator.newLength_ = n3;
                        if (n > 1) {
                            iterator.remaining = n;
                        }
                        return true;
                    }
                    assert (n <= Short.MAX_VALUE);
                    iterator.oldLength_ = iterator.readLength(n >> 6 & 0x3F);
                    iterator.newLength_ = iterator.readLength(n & 0x3F);
                    if (!iterator.coarse) break block17;
                }
                while (iterator.index < iterator.length && (n = iterator.array[iterator.index]) > 4095) {
                    ++iterator.index;
                    if (n <= 28671) {
                        n2 = (n & 0x1FF) + 1;
                        iterator.oldLength_ += (n >> 12) * n2;
                        iterator.newLength_ += (n >> 9 & 7) * n2;
                        continue;
                    }
                    assert (n <= Short.MAX_VALUE);
                    iterator.oldLength_ += iterator.readLength(n >> 6 & 0x3F);
                    iterator.newLength_ += iterator.readLength(n & 0x3F);
                }
            }
            return true;
        }

        public final boolean hasChange() {
            return this.changed;
        }

        public final int oldLength() {
            return this.oldLength_;
        }

        public final int newLength() {
            return this.newLength_;
        }

        public final int sourceIndex() {
            return this.srcIndex;
        }

        public final int replacementIndex() {
            return this.replIndex;
        }

        /*
         * WARNING - void declaration
         */
        public final String toString() {
            void var1_1;
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            sb.append("{ src[");
            sb.append(this.srcIndex);
            sb.append("..");
            sb.append(this.srcIndex + this.oldLength_);
            if (this.changed) {
                sb.append("] \u21dd dest[");
            } else {
                sb.append("] \u2261 dest[");
            }
            sb.append(this.destIndex);
            sb.append("..");
            sb.append(this.destIndex + this.newLength_);
            if (this.changed) {
                sb.append("], repl[");
                sb.append(this.replIndex);
                sb.append("..");
                sb.append(this.replIndex + this.newLength_);
                sb.append("] }");
            } else {
                sb.append("] (no-change) }");
            }
            return var1_1.toString();
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ Iterator(char[] x0, int x1, boolean x2, boolean x3, byte by) {
            this((char[])var1_1, (int)var2_2, false, true);
            void var2_2;
            void var1_1;
        }
    }
}

