/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.Normalizer2;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ICUUncheckedIOException;
import java.io.IOException;

public final class FilteredNormalizer2
extends Normalizer2 {
    private Normalizer2 norm2;
    private UnicodeSet set;

    /*
     * WARNING - void declaration
     */
    public FilteredNormalizer2(Normalizer2 n2, UnicodeSet filterSet) {
        void var2_2;
        void var1_1;
        this.norm2 = var1_1;
        this.set = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final StringBuilder normalize(CharSequence src, StringBuilder dest) {
        void var2_2;
        void var1_1;
        if (dest == src) {
            throw new IllegalArgumentException();
        }
        dest.setLength(0);
        this.normalize((CharSequence)var1_1, dest, UnicodeSet.SpanCondition.SIMPLE);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final StringBuilder normalizeSecondAndAppend(StringBuilder first, CharSequence second) {
        void var2_2;
        void var1_1;
        return this.normalizeSecondAndAppend((StringBuilder)var1_1, (CharSequence)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final StringBuilder append(StringBuilder first, CharSequence second) {
        void var2_2;
        void var1_1;
        return this.normalizeSecondAndAppend((StringBuilder)var1_1, (CharSequence)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getCombiningClass(int c) {
        if (this.set.contains(c)) {
            void var1_1;
            return this.norm2.getCombiningClass((int)var1_1);
        }
        return 0;
    }

    @Override
    public final boolean isNormalized(CharSequence s) {
        UnicodeSet.SpanCondition spanCondition = UnicodeSet.SpanCondition.SIMPLE;
        int prevSpanLimit = 0;
        while (prevSpanLimit < s.length()) {
            int spanLimit = this.set.span(s, prevSpanLimit, spanCondition);
            if (spanCondition == UnicodeSet.SpanCondition.NOT_CONTAINED) {
                spanCondition = UnicodeSet.SpanCondition.SIMPLE;
            } else {
                if (!this.norm2.isNormalized(s.subSequence(prevSpanLimit, spanLimit))) {
                    return false;
                }
                spanCondition = UnicodeSet.SpanCondition.NOT_CONTAINED;
            }
            prevSpanLimit = spanLimit;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Normalizer.QuickCheckResult quickCheck(CharSequence s) {
        void var2_2;
        Normalizer.QuickCheckResult result = Normalizer.YES;
        UnicodeSet.SpanCondition spanCondition = UnicodeSet.SpanCondition.SIMPLE;
        int prevSpanLimit = 0;
        while (prevSpanLimit < s.length()) {
            int spanLimit = this.set.span(s, prevSpanLimit, spanCondition);
            if (spanCondition == UnicodeSet.SpanCondition.NOT_CONTAINED) {
                spanCondition = UnicodeSet.SpanCondition.SIMPLE;
            } else {
                UnicodeSet.SpanCondition spanCondition2;
                Normalizer.QuickCheckResult qcResult = this.norm2.quickCheck(s.subSequence(prevSpanLimit, spanLimit));
                if (qcResult == Normalizer.NO) {
                    return qcResult;
                }
                if (qcResult == Normalizer.MAYBE) {
                    result = spanCondition2;
                }
                spanCondition2 = UnicodeSet.SpanCondition.NOT_CONTAINED;
            }
            prevSpanLimit = spanLimit;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int spanQuickCheckYes(CharSequence s) {
        void var1_1;
        UnicodeSet.SpanCondition spanCondition = UnicodeSet.SpanCondition.SIMPLE;
        int prevSpanLimit = 0;
        while (prevSpanLimit < s.length()) {
            int spanLimit = this.set.span(s, prevSpanLimit, spanCondition);
            if (spanCondition == UnicodeSet.SpanCondition.NOT_CONTAINED) {
                spanCondition = UnicodeSet.SpanCondition.SIMPLE;
            } else {
                int yesLimit = prevSpanLimit + this.norm2.spanQuickCheckYes(s.subSequence(prevSpanLimit, spanLimit));
                if (yesLimit < spanLimit) {
                    void var2_3;
                    return (int)var2_3;
                }
                UnicodeSet.SpanCondition spanCondition2 = UnicodeSet.SpanCondition.NOT_CONTAINED;
            }
            prevSpanLimit = spanLimit;
        }
        return var1_1.length();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean hasBoundaryBefore(int c) {
        void var1_1;
        return !this.set.contains(c) || this.norm2.hasBoundaryBefore((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean isInert(int c) {
        void var1_1;
        return !this.set.contains(c) || this.norm2.isInert((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private Appendable normalize(CharSequence src, Appendable dest, UnicodeSet.SpanCondition spanCondition) {
        void var2_2;
        StringBuilder tempDest = new StringBuilder();
        try {
            int prevSpanLimit = 0;
            while (prevSpanLimit < src.length()) {
                int spanLimit = this.set.span(src, prevSpanLimit, spanCondition);
                int spanLength = spanLimit - prevSpanLimit;
                if (spanCondition == UnicodeSet.SpanCondition.NOT_CONTAINED) {
                    if (spanLength != 0) {
                        dest.append(src, prevSpanLimit, spanLimit);
                    }
                    spanCondition = UnicodeSet.SpanCondition.SIMPLE;
                } else {
                    if (spanLength != 0) {
                        dest.append(this.norm2.normalize(src.subSequence(prevSpanLimit, spanLimit), tempDest));
                    }
                    spanCondition = UnicodeSet.SpanCondition.NOT_CONTAINED;
                }
                prevSpanLimit = spanLimit;
            }
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private StringBuilder normalizeSecondAndAppend(StringBuilder first, CharSequence second, boolean doNormalize) {
        void var1_1;
        if (first == second) {
            throw new IllegalArgumentException();
        }
        if (first.length() == 0) {
            if (doNormalize) {
                return this.normalize(second, first);
            }
            return first.append(second);
        }
        int prefixLimit = this.set.span(second, 0, UnicodeSet.SpanCondition.SIMPLE);
        if (prefixLimit != 0) {
            CharSequence prefix = second.subSequence(0, prefixLimit);
            int suffixStart = this.set.spanBack(first, Integer.MAX_VALUE, UnicodeSet.SpanCondition.SIMPLE);
            if (suffixStart == 0) {
                if (doNormalize) {
                    this.norm2.normalizeSecondAndAppend(first, prefix);
                } else {
                    this.norm2.append(first, prefix);
                }
            } else {
                StringBuilder middle = new StringBuilder(first.subSequence(suffixStart, first.length()));
                if (doNormalize) {
                    this.norm2.normalizeSecondAndAppend(middle, prefix);
                } else {
                    this.norm2.append(middle, prefix);
                }
                first.delete(suffixStart, Integer.MAX_VALUE).append((CharSequence)middle);
            }
        }
        if (prefixLimit < second.length()) {
            void var3_3;
            void var2_2;
            CharSequence rest = second.subSequence(prefixLimit, var2_2.length());
            if (var3_3 != false) {
                this.normalize(rest, first, UnicodeSet.SpanCondition.NOT_CONTAINED);
            } else {
                first.append(rest);
            }
        }
        return var1_1;
    }
}

