/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.Norm2AllModes;
import com.ibm.icu.impl.ReplaceableUCharacterIterator;
import com.ibm.icu.text.FilteredNormalizer2;
import com.ibm.icu.text.Normalizer2;
import com.ibm.icu.text.UCharacterIterator;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ICUCloneNotSupportedException;

public final class Normalizer
implements Cloneable {
    private UCharacterIterator text;
    private Normalizer2 norm2;
    private Mode mode;
    private int options;
    private int currentIndex;
    private int nextIndex;
    private StringBuilder buffer;
    private int bufferPos;
    @Deprecated
    private static Mode NONE = new NONEMode(0);
    @Deprecated
    private static Mode NFD = new NFDMode(0);
    @Deprecated
    private static Mode NFKD = new NFKDMode(0);
    @Deprecated
    private static Mode NFC = new NFCMode(0);
    @Deprecated
    public static final Mode NFKC = new NFKCMode(0);
    public static final QuickCheckResult NO;
    public static final QuickCheckResult YES;
    public static final QuickCheckResult MAYBE;

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public Normalizer(String str, Mode mode, int opt) {
        void var2_2;
        void var1_1;
        this.text = new ReplaceableUCharacterIterator((String)var1_1);
        this.mode = mode;
        this.options = 0;
        this.norm2 = var2_2.getNormalizer2(0);
        this.buffer = new StringBuilder();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public final Object clone() {
        try {
            Normalizer copy = (Normalizer)super.clone();
            ((Normalizer)super.clone()).text = (UCharacterIterator)this.text.clone();
            copy.mode = this.mode;
            copy.options = this.options;
            copy.norm2 = this.norm2;
            copy.buffer = new StringBuilder(this.buffer);
            copy.bufferPos = this.bufferPos;
            copy.currentIndex = this.currentIndex;
            copy.nextIndex = this.nextIndex;
            return copy;
        }
        catch (CloneNotSupportedException e) {
            void var1_2;
            throw new ICUCloneNotSupportedException((Throwable)var1_2);
        }
    }

    @Deprecated
    public static String normalize(String src, Mode mode) {
        String string;
        boolean bl = false;
        Object object = src;
        Normalizer2 normalizer2 = ((Mode)((Object)string)).getNormalizer2(0);
        string = object;
        object = normalizer2;
        if (string instanceof String) {
            int n = ((Normalizer2)object).spanQuickCheckYes(string);
            if (n == string.length()) {
                return string;
            }
            if (n != 0) {
                StringBuilder stringBuilder = new StringBuilder(string.length()).append(string, 0, n);
                return ((Normalizer2)object).normalizeSecondAndAppend(stringBuilder, string.subSequence(n, string.length())).toString();
            }
        }
        return ((Normalizer2)object).normalize(string, new StringBuilder(string.length())).toString();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static QuickCheckResult quickCheck(String source, Mode mode) {
        void var1_3;
        boolean bl = false;
        String string = source;
        return var1_3.getNormalizer2(0).quickCheck(string);
    }

    @Deprecated
    public static boolean isNormalized(String str, Mode mode, int options) {
        String string;
        return mode.getNormalizer2(0).isNormalized(string);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public final int next() {
        void var1_2;
        if (this.bufferPos >= this.buffer.length()) {
            Normalizer normalizer;
            Normalizer normalizer2 = normalizer = this;
            normalizer.buffer.setLength(0);
            normalizer2.bufferPos = 0;
            normalizer.currentIndex = normalizer.nextIndex;
            normalizer.text.setIndex(normalizer.nextIndex);
            int n = normalizer.text.nextCodePoint();
            if (n < 0) return -1;
            StringBuilder stringBuilder = new StringBuilder().appendCodePoint(n);
            while ((n = normalizer.text.nextCodePoint()) >= 0) {
                if (normalizer.norm2.hasBoundaryBefore(n)) {
                    normalizer.text.moveCodePointIndex(-1);
                    break;
                }
                stringBuilder.appendCodePoint(n);
            }
            normalizer.nextIndex = normalizer.text.getIndex();
            normalizer.norm2.normalize(stringBuilder, normalizer.buffer);
            if (normalizer.buffer.length() == 0) return -1;
            boolean bl = true;
            if (!bl) return -1;
        }
        int c = this.buffer.codePointAt(this.bufferPos);
        this.bufferPos += Character.charCount(c);
        return (int)var1_2;
    }

    @Deprecated
    public final int getIndex() {
        if (this.bufferPos < this.buffer.length()) {
            return this.currentIndex;
        }
        return this.nextIndex;
    }

    @Deprecated
    public final int endIndex() {
        return this.text.getLength();
    }

    static {
        new FCDMode(0);
        NO = new QuickCheckResult(0);
        YES = new QuickCheckResult(1);
        MAYBE = new QuickCheckResult(2);
    }

    public static final class QuickCheckResult {
        private QuickCheckResult() {
        }

        /* synthetic */ QuickCheckResult(int x0) {
            this();
        }
    }

    static final class FCDMode
    extends Mode {
        private FCDMode() {
        }

        @Override
        protected final Normalizer2 getNormalizer2(int options) {
            if ((options & 0x20) != 0) {
                return FCD32ModeImpl.INSTANCE.normalizer2;
            }
            return FCDModeImpl.INSTANCE.normalizer2;
        }

        /* synthetic */ FCDMode(byte by) {
            this();
        }
    }

    static final class NFKCMode
    extends Mode {
        private NFKCMode() {
        }

        @Override
        protected final Normalizer2 getNormalizer2(int options) {
            if ((options & 0x20) != 0) {
                return NFKC32ModeImpl.INSTANCE.normalizer2;
            }
            return NFKCModeImpl.INSTANCE.normalizer2;
        }

        /* synthetic */ NFKCMode(byte by) {
            this();
        }
    }

    static final class NFCMode
    extends Mode {
        private NFCMode() {
        }

        @Override
        protected final Normalizer2 getNormalizer2(int options) {
            if ((options & 0x20) != 0) {
                return NFC32ModeImpl.INSTANCE.normalizer2;
            }
            return NFCModeImpl.INSTANCE.normalizer2;
        }

        /* synthetic */ NFCMode(byte by) {
            this();
        }
    }

    static final class NFKDMode
    extends Mode {
        private NFKDMode() {
        }

        @Override
        protected final Normalizer2 getNormalizer2(int options) {
            if ((options & 0x20) != 0) {
                return NFKD32ModeImpl.INSTANCE.normalizer2;
            }
            return NFKDModeImpl.INSTANCE.normalizer2;
        }

        /* synthetic */ NFKDMode(byte by) {
            this();
        }
    }

    static final class NFDMode
    extends Mode {
        private NFDMode() {
        }

        @Override
        protected final Normalizer2 getNormalizer2(int options) {
            if ((options & 0x20) != 0) {
                return NFD32ModeImpl.INSTANCE.normalizer2;
            }
            return NFDModeImpl.INSTANCE.normalizer2;
        }

        /* synthetic */ NFDMode(byte by) {
            this();
        }
    }

    static final class NONEMode
    extends Mode {
        private NONEMode() {
        }

        @Override
        protected final Normalizer2 getNormalizer2(int options) {
            return Norm2AllModes.NOOP_NORMALIZER2;
        }

        /* synthetic */ NONEMode(byte by) {
            this();
        }
    }

    @Deprecated
    public static abstract class Mode {
        @Deprecated
        protected Mode() {
        }

        @Deprecated
        protected abstract Normalizer2 getNormalizer2(int var1);
    }

    static final class FCD32ModeImpl {
        private static final ModeImpl INSTANCE = new ModeImpl(new FilteredNormalizer2(Norm2AllModes.getFCDNormalizer2(), Unicode32.access$100()), 0);
    }

    static final class NFKC32ModeImpl {
        private static final ModeImpl INSTANCE = new ModeImpl(new FilteredNormalizer2(Norm2AllModes.getNFKCInstance().comp, Unicode32.access$100()), 0);
    }

    static final class NFC32ModeImpl {
        private static final ModeImpl INSTANCE = new ModeImpl(new FilteredNormalizer2(Norm2AllModes.getNFCInstance().comp, Unicode32.access$100()), 0);
    }

    static final class NFKD32ModeImpl {
        private static final ModeImpl INSTANCE = new ModeImpl(new FilteredNormalizer2(Norm2AllModes.getNFKCInstance().decomp, Unicode32.access$100()), 0);
    }

    static final class NFD32ModeImpl {
        private static final ModeImpl INSTANCE = new ModeImpl(new FilteredNormalizer2(Norm2AllModes.getNFCInstance().decomp, Unicode32.access$100()), 0);
    }

    static final class Unicode32 {
        private static final UnicodeSet INSTANCE = new UnicodeSet("[:age=3.2:]").freeze();

        static /* synthetic */ UnicodeSet access$100() {
            return INSTANCE;
        }
    }

    static final class FCDModeImpl {
        private static final ModeImpl INSTANCE = new ModeImpl(Norm2AllModes.getFCDNormalizer2(), 0);
    }

    static final class NFKCModeImpl {
        private static final ModeImpl INSTANCE = new ModeImpl(Norm2AllModes.getNFKCInstance().comp, 0);
    }

    static final class NFCModeImpl {
        private static final ModeImpl INSTANCE = new ModeImpl(Norm2AllModes.getNFCInstance().comp, 0);
    }

    static final class NFKDModeImpl {
        private static final ModeImpl INSTANCE = new ModeImpl(Norm2AllModes.getNFKCInstance().decomp, 0);
    }

    static final class NFDModeImpl {
        private static final ModeImpl INSTANCE = new ModeImpl(Norm2AllModes.getNFCInstance().decomp, 0);
    }

    static final class ModeImpl {
        private final Normalizer2 normalizer2;

        /*
         * WARNING - void declaration
         */
        private ModeImpl(Normalizer2 n2) {
            void var1_1;
            this.normalizer2 = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ ModeImpl(Normalizer2 x0, byte by) {
            this((Normalizer2)var1_1);
            void var1_1;
        }
    }
}

