/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.PluralRulesLoader;
import com.ibm.icu.impl.number.DecimalQuantity;
import com.ibm.icu.impl.number.DecimalQuantity_DualStorageBCD;
import com.ibm.icu.impl.number.range.StandardPluralRanges;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ULocale;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;

public final class PluralRules
implements Serializable {
    private static UnicodeSet ALLOWED_ID = new UnicodeSet("[a-z]").freeze();
    private final RuleList rules;
    private static final Constraint NO_CONSTRAINT;
    private static final Rule DEFAULT_RULE;
    public static final PluralRules DEFAULT;
    private static Pattern AT_SEPARATED;
    private static Pattern OR_SEPARATED;
    private static Pattern AND_SEPARATED;
    static final Pattern COMMA_SEPARATED;
    static final Pattern TILDE_SEPARATED;
    private static Pattern SEMI_SEPARATED;

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static PluralRules newInternal(String description, StandardPluralRanges ranges) throws ParseException {
        void var1_1;
        String string;
        if ((description = description.trim()).length() == 0) {
            return DEFAULT;
        }
        return new PluralRules(PluralRules.parseRuleChain(string), (StandardPluralRanges)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static Constraint parseConstraint(String description) throws ParseException {
        void var1_1;
        Constraint result = null;
        String[] or_together = OR_SEPARATED.split(description, 0);
        for (int i = 0; i < or_together.length; ++i) {
            void var3_3;
            Constraint andConstraint = null;
            String[] and_together = AND_SEPARATED.split(or_together[i], 0);
            for (int j = 0; j < and_together.length; ++j) {
                RangeConstraint rangeConstraint;
                Operand operand;
                Constraint newConstraint = NO_CONSTRAINT;
                String condition = and_together[j].trim();
                String[] tokens = SimpleTokenizer.split(condition);
                int mod = 0;
                boolean inRange = true;
                boolean integersOnly = true;
                double lowBound = 9.223372036854776E18;
                double highBound = -9.223372036854776E18;
                int x = 0;
                ++x;
                String t = tokens[0];
                boolean hackForCompatibility = false;
                try {
                    operand = FixedDecimal.getOperand(t);
                }
                catch (Exception exception) {
                    throw PluralRules.unexpected(t, condition);
                }
                if (1 < tokens.length) {
                    long[] vals;
                    ++x;
                    t = tokens[1];
                    if ("mod".equals(t) || "%".equals(t)) {
                        ++x;
                        mod = Integer.parseInt(tokens[2]);
                        ++x;
                        t = PluralRules.nextToken(tokens, 3, condition);
                    }
                    if ("not".equals(t)) {
                        inRange = false;
                        if ("=".equals(t = PluralRules.nextToken(tokens, x++, condition))) {
                            throw PluralRules.unexpected(t, condition);
                        }
                    } else if ("!".equals(t)) {
                        inRange = false;
                        if (!"=".equals(t = PluralRules.nextToken(tokens, x++, condition))) {
                            throw PluralRules.unexpected(t, condition);
                        }
                    }
                    if ("is".equals(t) || "in".equals(t) || "=".equals(t)) {
                        hackForCompatibility = "is".equals(t);
                        if (hackForCompatibility && !inRange) {
                            throw PluralRules.unexpected(t, condition);
                        }
                        t = PluralRules.nextToken(tokens, x++, condition);
                    } else if ("within".equals(t)) {
                        integersOnly = false;
                        t = PluralRules.nextToken(tokens, x++, condition);
                    } else {
                        throw PluralRules.unexpected(t, condition);
                    }
                    if ("not".equals(t)) {
                        if (!hackForCompatibility && !inRange) {
                            throw PluralRules.unexpected(t, condition);
                        }
                        inRange = !inRange;
                        t = PluralRules.nextToken(tokens, x++, condition);
                    }
                    ArrayList<Long> valueList = new ArrayList<Long>();
                    while (true) {
                        long low;
                        long high = low = Long.parseLong(t);
                        if (x < tokens.length) {
                            if ((t = PluralRules.nextToken(tokens, x++, condition)).equals(".")) {
                                if (!(t = PluralRules.nextToken(tokens, x++, condition)).equals(".")) {
                                    throw PluralRules.unexpected(t, condition);
                                }
                                t = PluralRules.nextToken(tokens, x++, condition);
                                high = Long.parseLong(t);
                                if (x < tokens.length && !(t = PluralRules.nextToken(tokens, x++, condition)).equals(",")) {
                                    throw PluralRules.unexpected(t, condition);
                                }
                            } else if (!t.equals(",")) {
                                throw PluralRules.unexpected(t, condition);
                            }
                        }
                        if (low > high) {
                            throw PluralRules.unexpected(low + "~" + high, condition);
                        }
                        if (mod != 0 && high >= (long)mod) {
                            throw PluralRules.unexpected(high + ">mod=" + mod, condition);
                        }
                        valueList.add(low);
                        valueList.add(high);
                        lowBound = Math.min(lowBound, (double)low);
                        highBound = Math.max(highBound, (double)high);
                        if (x >= tokens.length) break;
                        t = PluralRules.nextToken(tokens, x++, condition);
                    }
                    if (t.equals(",")) {
                        throw PluralRules.unexpected(t, condition);
                    }
                    if (valueList.size() == 2) {
                        vals = null;
                    } else {
                        vals = new long[valueList.size()];
                        for (int k = 0; k < vals.length; ++k) {
                            vals[k] = (Long)valueList.get(k);
                        }
                    }
                    if (lowBound != highBound && hackForCompatibility && !inRange) {
                        throw PluralRules.unexpected("is not <range>", condition);
                    }
                    rangeConstraint = new RangeConstraint(mod, inRange, operand, integersOnly, lowBound, highBound, vals);
                }
                andConstraint = andConstraint == null ? rangeConstraint : new AndConstraint(andConstraint, rangeConstraint);
            }
            result = result == null ? andConstraint : new OrConstraint(result, (Constraint)var3_3);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static ParseException unexpected(String token, String context) {
        void var1_1;
        String string;
        return new ParseException("unexpected token '" + string + "' in '" + (String)var1_1 + "'", -1);
    }

    /*
     * WARNING - void declaration
     */
    private static String nextToken(String[] tokens, int x, String context) throws ParseException {
        void var2_2;
        if (x < tokens.length) {
            void var1_1;
            String[] stringArray;
            return stringArray[var1_1];
        }
        throw new ParseException("missing token at end of '" + (String)var2_2 + "'", -1);
    }

    /*
     * WARNING - void declaration
     */
    private static Rule parseRule(String description) throws ParseException {
        void var0_2;
        void var2_5;
        void var1_4;
        if (description.length() == 0) {
            return DEFAULT_RULE;
        }
        int x = (description = description.toLowerCase(Locale.ENGLISH)).indexOf(58);
        if (x == -1) {
            throw new ParseException("missing ':' in rule description '" + description + "'", 0);
        }
        String keyword = description.substring(0, x).trim();
        String string = keyword;
        if (!ALLOWED_ID.containsAll(string)) {
            throw new ParseException("keyword '" + keyword + " is not valid", 0);
        }
        description = description.substring(x + 1).trim();
        String[] constraintOrSamples = AT_SEPARATED.split(description, 0);
        DecimalQuantitySamples integerSamples = null;
        DecimalQuantitySamples decimalSamples = null;
        switch (constraintOrSamples.length) {
            case 1: {
                break;
            }
            case 2: {
                integerSamples = DecimalQuantitySamples.parse(constraintOrSamples[1]);
                if (integerSamples.sampleType != SampleType.DECIMAL) break;
                decimalSamples = integerSamples;
                integerSamples = null;
                break;
            }
            case 3: {
                integerSamples = DecimalQuantitySamples.parse(constraintOrSamples[1]);
                decimalSamples = DecimalQuantitySamples.parse(constraintOrSamples[2]);
                if (integerSamples.sampleType == SampleType.INTEGER && decimalSamples.sampleType == SampleType.DECIMAL) break;
                throw new IllegalArgumentException("Must have @integer then @decimal in " + description);
            }
            default: {
                throw new IllegalArgumentException("Too many samples in " + description);
            }
        }
        boolean isOther = keyword.equals("other");
        if (isOther != (constraintOrSamples[0].length() == 0)) {
            throw new IllegalArgumentException("The keyword 'other' must have no constraints, just samples.");
        }
        Constraint constraint = isOther ? NO_CONSTRAINT : PluralRules.parseConstraint((String)var1_4[0]);
        return new Rule((String)var2_5, (Constraint)var0_2, (DecimalQuantitySamples)((Object)string), decimalSamples);
    }

    /*
     * WARNING - void declaration
     */
    private static RuleList parseRuleChain(String description) throws ParseException {
        void var1_1;
        RuleList result = new RuleList(0);
        if (description.endsWith(";")) {
            description = description.substring(0, description.length() - 1);
        }
        String[] rules = SEMI_SEPARATED.split(description, 0);
        for (int i = 0; i < rules.length; ++i) {
            void var3_3;
            Rule rule = PluralRules.parseRule(rules[i].trim());
            RuleList ruleList = result;
            RuleList.access$102(ruleList, ruleList.hasExplicitBoundingInfo | (rule.integerSamples != null || rule.decimalSamples != null));
            result.addRule((Rule)var3_3);
        }
        return var1_1.finish();
    }

    /*
     * WARNING - void declaration
     */
    private static String format(double lb) {
        double d;
        long lbi = (long)lb;
        if (lb == (double)lbi) {
            void var2_1;
            return String.valueOf((long)var2_1);
        }
        return String.valueOf(d);
    }

    public static PluralRules forLocale(ULocale locale) {
        Object object;
        PluralType pluralType = PluralType.CARDINAL;
        ULocale uLocale = object;
        object = PluralRulesLoader.loader;
        if ((object = ((PluralRulesLoader)object).getOrCreateRulesForLocale(uLocale, pluralType)) == null) {
            object = DEFAULT;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private PluralRules(RuleList rules, StandardPluralRanges standardPluralRanges) {
        void var1_1;
        this.rules = rules;
        Collections.unmodifiableSet(var1_1.getKeywords());
    }

    public final int hashCode() {
        return this.rules.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public final String select(double number) {
        void var1_1;
        return this.rules.select(new FixedDecimal((double)var1_1));
    }

    public final String toString() {
        return this.rules.toString();
    }

    public final boolean equals(Object rhs) {
        if (rhs instanceof PluralRules) {
            PluralRules pluralRules;
            PluralRules pluralRules2 = pluralRules;
            pluralRules = this;
            if (pluralRules2 != null && pluralRules.toString().equals(pluralRules2.toString())) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$400(StringBuilder x0, double x1, double x2, boolean x3) {
        void var1_1;
        void var3_3;
        boolean bl = x3;
        void var9_5 = var3_3;
        void var7_6 = var1_1;
        StringBuilder stringBuilder = x0;
        if (bl) {
            stringBuilder.append(",");
        }
        if (var7_6 == var9_5) {
            stringBuilder.append(PluralRules.format((double)var7_6));
            return;
        }
        stringBuilder.append(PluralRules.format((double)var7_6) + ".." + PluralRules.format((double)var9_5));
    }

    static {
        new DecimalQuantity_DualStorageBCD(-0.00123456777);
        NO_CONSTRAINT = new Constraint(){

            @Override
            public final boolean isFulfilled(IFixedDecimal n) {
                return true;
            }

            public final String toString() {
                return "";
            }
        };
        DEFAULT_RULE = new Rule("other", NO_CONSTRAINT, null, null);
        DEFAULT = new PluralRules(new RuleList(0).addRule(DEFAULT_RULE), StandardPluralRanges.DEFAULT);
        AT_SEPARATED = Pattern.compile("\\s*\\Q\\E@\\s*");
        OR_SEPARATED = Pattern.compile("\\s*or\\s*");
        AND_SEPARATED = Pattern.compile("\\s*and\\s*");
        COMMA_SEPARATED = Pattern.compile("\\s*,\\s*");
        Pattern.compile("\\s*\\Q..\\E\\s*");
        TILDE_SEPARATED = Pattern.compile("\\s*~\\s*");
        SEMI_SEPARATED = Pattern.compile("\\s*;\\s*");
    }

    static final class RuleList
    implements Serializable {
        private boolean hasExplicitBoundingInfo = false;
        private final List<Rule> rules = new ArrayList<Rule>();

        private RuleList() {
        }

        /*
         * WARNING - void declaration
         */
        public final RuleList addRule(Rule nextRule) {
            void var1_1;
            String keyword = nextRule.getKeyword();
            for (Rule rule : this.rules) {
                if (!keyword.equals(rule.getKeyword())) continue;
                throw new IllegalArgumentException("Duplicate keyword: " + keyword);
            }
            this.rules.add((Rule)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final RuleList finish() throws ParseException {
            void var1_1;
            Rule otherRule = null;
            Iterator<Rule> it = this.rules.iterator();
            while (it.hasNext()) {
                void var3_3;
                Rule rule = it.next();
                if (!"other".equals(rule.getKeyword())) continue;
                otherRule = var3_3;
                it.remove();
            }
            if (otherRule == null) {
                otherRule = PluralRules.parseRule("other:");
            }
            this.rules.add((Rule)var1_1);
            return this;
        }

        public final String select(IFixedDecimal n) {
            Rule rule;
            Object object;
            block2: {
                if (n.isInfinite() || n.isNaN()) {
                    return "other";
                }
                void var2_2 = object;
                object = this;
                for (Rule rule2 : ((RuleList)object).rules) {
                    if (!rule2.appliesTo((IFixedDecimal)var2_2)) continue;
                    rule = rule2;
                    break block2;
                }
                rule = null;
            }
            object = rule;
            return rule.getKeyword();
        }

        /*
         * WARNING - void declaration
         */
        public final Set<String> getKeywords() {
            void var1_1;
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            for (Rule rule : this.rules) {
                void var3_3;
                result.add(var3_3.getKeyword());
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final String toString() {
            void var1_1;
            StringBuilder builder = new StringBuilder();
            for (Rule rule : this.rules) {
                void var3_3;
                if (builder.length() != 0) {
                    builder.append(";  ");
                }
                builder.append(var3_3);
            }
            return var1_1.toString();
        }

        /* synthetic */ RuleList(byte by) {
            this();
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ boolean access$102(RuleList x0, boolean x1) {
            void var1_1;
            x0.hasExplicitBoundingInfo = var1_1;
            return x0.hasExplicitBoundingInfo;
        }
    }

    static final class Rule
    implements Serializable {
        private final String keyword;
        private final Constraint constraint;
        private final DecimalQuantitySamples integerSamples;
        private final DecimalQuantitySamples decimalSamples;

        /*
         * WARNING - void declaration
         */
        public Rule(String keyword, Constraint constraint, DecimalQuantitySamples integerSamples, DecimalQuantitySamples decimalSamples) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.keyword = var1_1;
            this.constraint = var2_2;
            this.integerSamples = var3_3;
            this.decimalSamples = decimalSamples;
        }

        public final String getKeyword() {
            return this.keyword;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean appliesTo(IFixedDecimal n) {
            void var1_1;
            return this.constraint.isFulfilled((IFixedDecimal)var1_1);
        }

        public final String toString() {
            return this.keyword + ": " + this.constraint.toString() + (this.integerSamples == null ? "" : " " + this.integerSamples.toString()) + (this.decimalSamples == null ? "" : " " + this.decimalSamples.toString());
        }

        public final int hashCode() {
            return this.keyword.hashCode() ^ this.constraint.hashCode();
        }
    }

    static final class OrConstraint
    extends BinaryConstraint {
        /*
         * WARNING - void declaration
         */
        OrConstraint(Constraint a, Constraint b) {
            super((Constraint)var1_1, (Constraint)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean isFulfilled(IFixedDecimal n) {
            void var1_1;
            return this.a.isFulfilled(n) || this.b.isFulfilled((IFixedDecimal)var1_1);
        }

        public final String toString() {
            return this.a.toString() + " or " + this.b.toString();
        }
    }

    static final class AndConstraint
    extends BinaryConstraint {
        /*
         * WARNING - void declaration
         */
        AndConstraint(Constraint a, Constraint b) {
            super((Constraint)var1_1, (Constraint)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean isFulfilled(IFixedDecimal n) {
            void var1_1;
            return this.a.isFulfilled(n) && this.b.isFulfilled((IFixedDecimal)var1_1);
        }

        public final String toString() {
            return this.a.toString() + " and " + this.b.toString();
        }
    }

    static abstract class BinaryConstraint
    implements Constraint,
    Serializable {
        protected final Constraint a;
        protected final Constraint b;

        /*
         * WARNING - void declaration
         */
        protected BinaryConstraint(Constraint a, Constraint b) {
            void var2_2;
            void var1_1;
            this.a = var1_1;
            this.b = var2_2;
        }
    }

    static final class RangeConstraint
    implements Constraint,
    Serializable {
        private final int mod;
        private final boolean inRange;
        private final boolean integersOnly;
        private final double lowerBound;
        private final double upperBound;
        private final long[] range_list;
        private final Operand operand;

        /*
         * WARNING - void declaration
         */
        RangeConstraint(int mod, boolean inRange, Operand operand, boolean integersOnly, double lowBound, double highBound, long[] vals) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.mod = var1_1;
            this.inRange = var2_2;
            this.integersOnly = integersOnly;
            this.lowerBound = lowBound;
            this.upperBound = highBound;
            this.range_list = vals;
            this.operand = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean isFulfilled(IFixedDecimal number) {
            void var1_2;
            boolean test;
            double n;
            block8: {
                block7: {
                    block6: {
                        n = number.getPluralOperand(this.operand);
                        if (!this.integersOnly) break block6;
                        double d = n;
                        if (d - (double)((long)d) != 0.0) break block7;
                    }
                    if (this.operand != Operand.j || number.getPluralOperand(Operand.v) == 0.0) break block8;
                }
                return !this.inRange;
            }
            if (this.mod != 0) {
                n %= (double)this.mod;
            }
            if ((test = n >= this.lowerBound && n <= this.upperBound) && this.range_list != null) {
                test = false;
                for (int i = 0; !test && i < this.range_list.length; i += 2) {
                    test = n >= (double)this.range_list[i] && n <= (double)this.range_list[i + 1];
                }
            }
            return this.inRange == var1_2;
        }

        /*
         * WARNING - void declaration
         */
        public final String toString() {
            void var1_1;
            boolean isList;
            StringBuilder result = new StringBuilder();
            result.append((Object)this.operand);
            if (this.mod != 0) {
                result.append(" % ").append(this.mod);
            }
            boolean bl = isList = this.lowerBound != this.upperBound;
            result.append(!isList ? (this.inRange ? " = " : " != ") : (this.integersOnly ? (this.inRange ? " = " : " != ") : (this.inRange ? " within " : " not within ")));
            if (this.range_list != null) {
                for (int i = 0; i < this.range_list.length; i += 2) {
                    PluralRules.access$400(result, this.range_list[i], this.range_list[i + 1], i != 0);
                }
            } else {
                PluralRules.access$400(result, this.lowerBound, this.upperBound, false);
            }
            return var1_1.toString();
        }
    }

    static final class SimpleTokenizer {
        private static UnicodeSet BREAK_AND_IGNORE = new UnicodeSet(9, 10, 12, 13, 32, 32).freeze();
        private static UnicodeSet BREAK_AND_KEEP = new UnicodeSet(33, 33, 37, 37, 44, 44, 46, 46, 61, 61).freeze();

        /*
         * WARNING - void declaration
         */
        static String[] split(String source) {
            void var2_2;
            int last = -1;
            ArrayList<String> result = new ArrayList<String>();
            for (int i = 0; i < source.length(); ++i) {
                char ch = source.charAt(i);
                if (BREAK_AND_IGNORE.contains(ch)) {
                    if (last < 0) continue;
                    result.add(source.substring(last, i));
                    last = -1;
                    continue;
                }
                if (BREAK_AND_KEEP.contains(ch)) {
                    if (last >= 0) {
                        result.add(source.substring(last, i));
                    }
                    int n = i;
                    result.add(source.substring(n, n + 1));
                    last = -1;
                    continue;
                }
                if (last >= 0) continue;
                last = i;
            }
            if (last >= 0) {
                void var1_1;
                String string;
                result.add(string.substring((int)var1_1));
            }
            void v1 = var2_2;
            return v1.toArray(new String[v1.size()]);
        }
    }

    static interface Constraint
    extends Serializable {
        public boolean isFulfilled(IFixedDecimal var1);
    }

    @Deprecated
    public static final class DecimalQuantitySamples {
        @Deprecated
        public final SampleType sampleType;
        @Deprecated
        private Set<DecimalQuantitySamplesRange> samples;
        @Deprecated
        private boolean bounded;

        /*
         * WARNING - void declaration
         */
        private DecimalQuantitySamples(SampleType sampleType, Set<DecimalQuantitySamplesRange> samples, boolean bounded) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.sampleType = var1_1;
            this.samples = var2_2;
            this.bounded = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        static DecimalQuantitySamples parse(String source) {
            void var2_1;
            void var1_4;
            String[] stringArray;
            SampleType sampleType2;
            boolean bounded2 = true;
            boolean haveBound = false;
            LinkedHashSet<DecimalQuantitySamplesRange> samples2 = new LinkedHashSet<DecimalQuantitySamplesRange>();
            if (source.startsWith("integer")) {
                sampleType2 = SampleType.INTEGER;
            } else if (source.startsWith("decimal")) {
                sampleType2 = SampleType.DECIMAL;
            } else {
                throw new IllegalArgumentException("Samples must start with 'integer' or 'decimal'");
            }
            source = source.substring(7).trim();
            block4: for (String range : COMMA_SEPARATED.split((CharSequence)stringArray, 0)) {
                if (range.equals("\u2026") || range.equals("...")) {
                    bounded2 = false;
                    haveBound = true;
                    continue;
                }
                if (haveBound) {
                    throw new IllegalArgumentException("Can only have \u2026 at the end of samples: " + range);
                }
                String[] rangeParts = TILDE_SEPARATED.split(range, 0);
                switch (rangeParts.length) {
                    case 1: {
                        DecimalQuantity sample = DecimalQuantity_DualStorageBCD.fromExponentString(rangeParts[0]);
                        DecimalQuantitySamples.checkDecimal(sampleType2, sample);
                        DecimalQuantity decimalQuantity = sample;
                        samples2.add(new DecimalQuantitySamplesRange(decimalQuantity, decimalQuantity));
                        continue block4;
                    }
                    case 2: {
                        DecimalQuantity start = DecimalQuantity_DualStorageBCD.fromExponentString(rangeParts[0]);
                        DecimalQuantity end = DecimalQuantity_DualStorageBCD.fromExponentString(rangeParts[1]);
                        DecimalQuantitySamples.checkDecimal(sampleType2, start);
                        DecimalQuantitySamples.checkDecimal(sampleType2, end);
                        samples2.add(new DecimalQuantitySamplesRange(start, end));
                        continue block4;
                    }
                    default: {
                        void var7_7;
                        throw new IllegalArgumentException("Ill-formed number range: " + (String)var7_7);
                    }
                }
            }
            return new DecimalQuantitySamples((SampleType)var1_4, Collections.unmodifiableSet(samples2), (boolean)var2_1);
        }

        /*
         * WARNING - void declaration
         */
        private static void checkDecimal(SampleType sampleType2, DecimalQuantity sample) {
            SampleType sampleType;
            if (sampleType2 == SampleType.INTEGER && sample.getPluralOperand(Operand.v) != 0.0 || sampleType == SampleType.DECIMAL && sample.getPluralOperand(Operand.v) == 0.0 && sample.getPluralOperand(Operand.e) == 0.0) {
                void var1_1;
                throw new IllegalArgumentException("Ill-formed number range: " + var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public final String toString() {
            void var1_1;
            StringBuilder b = new StringBuilder("@").append(this.sampleType.toString().toLowerCase(Locale.ENGLISH));
            boolean first = true;
            for (DecimalQuantitySamplesRange item : this.samples) {
                if (first) {
                    first = false;
                } else {
                    b.append(",");
                }
                b.append(' ').append(item);
            }
            if (!this.bounded) {
                b.append(", \u2026");
            }
            return var1_1.toString();
        }
    }

    @Deprecated
    public static final class DecimalQuantitySamplesRange {
        @Deprecated
        private DecimalQuantity start;
        @Deprecated
        private DecimalQuantity end;

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public DecimalQuantitySamplesRange(DecimalQuantity start, DecimalQuantity end) {
            void var2_2;
            void var1_1;
            if (start.getPluralOperand(Operand.v) != end.getPluralOperand(Operand.v)) {
                throw new IllegalArgumentException("Ranges must have the same number of visible decimals: " + start + "~" + end);
            }
            this.start = var1_1;
            this.end = var2_2;
        }

        @Deprecated
        public final String toString() {
            return this.start.toExponentString() + (this.end == this.start ? "" : "~" + this.end.toExponentString());
        }
    }

    @Deprecated
    public static final class SampleType
    extends Enum<SampleType> {
        @Deprecated
        public static final /* enum */ SampleType INTEGER = new SampleType();
        @Deprecated
        public static final /* enum */ SampleType DECIMAL = new SampleType();
        private static final /* synthetic */ SampleType[] $VALUES;

        public static SampleType[] values() {
            return (SampleType[])$VALUES.clone();
        }

        static {
            $VALUES = new SampleType[]{INTEGER, DECIMAL};
        }
    }

    @Deprecated
    public static final class FixedDecimal
    extends Number
    implements IFixedDecimal,
    Comparable<FixedDecimal> {
        private double source;
        private int visibleDecimalDigitCount;
        private int visibleDecimalDigitCountWithoutTrailingZeros;
        private long decimalDigits;
        private long decimalDigitsWithoutTrailingZeros;
        private long integerValue;
        private boolean isNegative;
        private int exponent;

        /*
         * WARNING - void declaration
         */
        @Deprecated
        private FixedDecimal(double n, int v, long f, int e, int c) {
            void var3_3;
            this.isNegative = n < 0.0;
            this.source = this.isNegative ? -n : n;
            this.visibleDecimalDigitCount = v;
            this.decimalDigits = f;
            this.integerValue = n > 1.0E18 ? 1000000000000000000L : (long)this.source;
            int initExpVal = e;
            if (initExpVal == 0) {
                initExpVal = c;
            }
            this.exponent = initExpVal;
            if (f == 0L) {
                this.decimalDigitsWithoutTrailingZeros = 0L;
                this.visibleDecimalDigitCountWithoutTrailingZeros = 0;
            } else {
                void var1_2;
                long fdwtz = f;
                int trimmedCount = v;
                while (fdwtz % 10L == 0L) {
                    fdwtz /= 10L;
                    --trimmedCount;
                }
                this.decimalDigitsWithoutTrailingZeros = fdwtz;
                this.visibleDecimalDigitCountWithoutTrailingZeros = var1_2;
            }
            Math.pow(10.0, (double)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        private FixedDecimal(double n, int v, long f, int e) {
            this((double)var1_1, (int)var3_2, f, 0, 0);
            void var3_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        private FixedDecimal(double n, int v, long f) {
            this((double)var1_1, (int)var3_2, f, 0);
            void var3_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        private FixedDecimal(double n, int v) {
            int n2;
            void var1_1;
            void var3_3;
            int n3 = var3_3;
            void var4_4 = var1_1;
            if (n3 == 0) {
                n2 = 0;
            } else {
                if (var4_4 < 0.0) {
                    var4_4 = -var4_4;
                }
                n3 = (int)Math.pow(10.0, n3);
                long l = Math.round((double)(var4_4 * (double)n3));
                n2 = (int)(l % (long)n3);
            }
            this(n, v, n2);
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public FixedDecimal(double n) {
            void var1_1;
            void v0 = var1_1;
            this((double)v0, FixedDecimal.decimals((double)v0));
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        private static int decimals(double n) {
            void var0_2;
            void var3_8;
            String digits2;
            int exponent;
            int numFractionDigits;
            int ePos;
            int expNumPos;
            double mask2;
            if (Double.isInfinite(n) || Double.isNaN(n)) {
                return 0;
            }
            if (n < 0.0) {
                n = -n;
            }
            double d = n;
            if (d == Math.floor(d)) {
                return 0;
            }
            if (n < 1.0E9) {
                long temp = (long)(n * 1000000.0) % 1000000L;
                int mask2 = 10;
                for (int digits2 = 6; digits2 > 0; --digits2) {
                    if (temp % (long)mask2 != 0L) {
                        return digits2;
                    }
                    mask2 *= 10;
                }
                return 0;
            }
            String buf = String.format(Locale.ENGLISH, "%1.15e", mask2);
            if (buf.charAt(expNumPos = (ePos = buf.lastIndexOf(101)) + 1) == '+') {
                ++expNumPos;
            }
            if ((numFractionDigits = ePos - 2 - (exponent = Integer.parseInt(digits2 = buf.substring(expNumPos)))) < 0) {
                return 0;
            }
            void i = var3_8 - true;
            while (numFractionDigits > 0 && buf.charAt((int)i) == '0') {
                --numFractionDigits;
                --i;
            }
            return (int)var0_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Deprecated
        public final double getPluralOperand(Operand operand) {
            void var1_1;
            switch (2.$SwitchMap$com$ibm$icu$text$PluralRules$Operand[var1_1.ordinal()]) {
                case 1: {
                    if (this.exponent == 0) {
                        return this.source;
                    }
                    return this.source * Math.pow(10.0, this.exponent);
                }
                case 2: {
                    return this.intValue();
                }
                case 3: {
                    return this.decimalDigits;
                }
                case 4: {
                    return this.decimalDigitsWithoutTrailingZeros;
                }
                case 5: {
                    return this.visibleDecimalDigitCount;
                }
                case 6: {
                    return this.visibleDecimalDigitCountWithoutTrailingZeros;
                }
                case 7: {
                    return this.exponent;
                }
                case 8: {
                    return this.exponent;
                }
            }
            return this.doubleValue();
        }

        @Deprecated
        public static Operand getOperand(String t) {
            return Operand.valueOf(t);
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public final boolean equals(Object arg0) {
            void var1_1;
            if (arg0 == null) {
                return false;
            }
            if (arg0 == this) {
                return true;
            }
            if (!(arg0 instanceof FixedDecimal)) {
                return false;
            }
            FixedDecimal other = (FixedDecimal)arg0;
            return this.source == other.source && this.visibleDecimalDigitCount == other.visibleDecimalDigitCount && this.decimalDigits == other.decimalDigits && this.exponent == var1_1.exponent;
        }

        @Deprecated
        public final int hashCode() {
            return (int)(this.decimalDigits + (long)(37 * (this.visibleDecimalDigitCount + (int)(37.0 * this.source))));
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public final String toString() {
            void var1_1;
            String baseString = String.format(Locale.ROOT, "%." + this.visibleDecimalDigitCount + "f", this.source);
            if (this.exponent != 0) {
                return baseString + "e" + this.exponent;
            }
            return var1_1;
        }

        @Override
        @Deprecated
        public final int intValue() {
            return (int)this.longValue();
        }

        @Override
        @Deprecated
        public final long longValue() {
            if (this.exponent == 0) {
                return this.integerValue;
            }
            return (long)(Math.pow(10.0, this.exponent) * (double)this.integerValue);
        }

        @Override
        @Deprecated
        public final float floatValue() {
            return (float)(this.source * Math.pow(10.0, this.exponent));
        }

        @Override
        @Deprecated
        public final double doubleValue() {
            return (this.isNegative ? -this.source : this.source) * Math.pow(10.0, this.exponent);
        }

        @Override
        @Deprecated
        public final boolean isNaN() {
            return Double.isNaN(this.source);
        }

        @Override
        @Deprecated
        public final boolean isInfinite() {
            return Double.isInfinite(this.source);
        }
    }

    @Deprecated
    public static interface IFixedDecimal {
        @Deprecated
        public double getPluralOperand(Operand var1);

        @Deprecated
        public boolean isNaN();

        @Deprecated
        public boolean isInfinite();
    }

    @Deprecated
    public static enum Operand {
        n,
        i,
        f,
        t,
        v,
        w,
        e,
        c,
        j;

    }

    public static final class PluralType
    extends Enum<PluralType> {
        public static final /* enum */ PluralType CARDINAL = new PluralType();
        private static /* enum */ PluralType ORDINAL = new PluralType();

        static {
            PluralType[] pluralTypeArray = new PluralType[]{CARDINAL, ORDINAL};
        }
    }

    @Deprecated
    public static abstract class Factory {
        @Deprecated
        protected Factory() {
        }
    }
}

