/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import androidx.compose.animation.core.AnimationSpecKt;
import com.ibm.icu.impl.ICUDebug;
import com.ibm.icu.impl.RBBIDataWrapper;
import com.ibm.icu.impl.breakiter.BurmeseBreakEngine;
import com.ibm.icu.impl.breakiter.CjkBreakEngine;
import com.ibm.icu.impl.breakiter.DictionaryBreakEngine;
import com.ibm.icu.impl.breakiter.KhmerBreakEngine;
import com.ibm.icu.impl.breakiter.LSTMBreakEngine;
import com.ibm.icu.impl.breakiter.LanguageBreakEngine;
import com.ibm.icu.impl.breakiter.LaoBreakEngine;
import com.ibm.icu.impl.breakiter.ThaiBreakEngine;
import com.ibm.icu.impl.breakiter.UnhandledBreakEngine;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.util.CodePointTrie;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;

public class RuleBasedBreakIterator
extends BreakIterator {
    private CharacterIterator fText = new StringCharacterIterator("");
    @Deprecated
    public RBBIDataWrapper fRData;
    private int fPosition;
    private int fRuleStatusIndex;
    private boolean fDone;
    private int[] fLookAheadMatches;
    private BreakCache fBreakCache = new BreakCache(this);
    private boolean fPhraseBreaking = false;
    private int fDictionaryCharCount = 0;
    private DictionaryCache fDictionaryCache = new DictionaryCache(this);
    private static final boolean TRACE = ICUDebug.enabled("rbbi") && ICUDebug.value("rbbi").indexOf("trace") >= 0;
    private static final UnhandledBreakEngine gUnhandledBreakEngine = new UnhandledBreakEngine();
    private static final List<LanguageBreakEngine> gAllBreakEngines = new ArrayList<LanguageBreakEngine>();
    private List<LanguageBreakEngine> fBreakEngines;
    @Deprecated
    public static final String fDebugEnv;

    private RuleBasedBreakIterator() {
        List<LanguageBreakEngine> list = gAllBreakEngines;
        synchronized (list) {
            this.fBreakEngines = new ArrayList<LanguageBreakEngine>(gAllBreakEngines);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    static RuleBasedBreakIterator getInstanceFromCompiledRules(ByteBuffer bytes, boolean phraseBreaking) throws IOException {
        RuleBasedBreakIterator ruleBasedBreakIterator;
        void var1_1;
        RuleBasedBreakIterator ruleBasedBreakIterator2 = new RuleBasedBreakIterator();
        new RuleBasedBreakIterator().fRData = RBBIDataWrapper.get(bytes);
        ruleBasedBreakIterator2.fLookAheadMatches = new int[ruleBasedBreakIterator2.fRData.fFTable.fLookAheadResultsSize];
        RuleBasedBreakIterator instance = ruleBasedBreakIterator2;
        ruleBasedBreakIterator2.fPhraseBreaking = var1_1;
        return ruleBasedBreakIterator;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object clone() {
        void var1_1;
        RuleBasedBreakIterator result = (RuleBasedBreakIterator)super.clone();
        if (this.fText != null) {
            result.fText = (CharacterIterator)this.fText.clone();
        }
        List<LanguageBreakEngine> list = gAllBreakEngines;
        synchronized (list) {
            result.fBreakEngines = new ArrayList<LanguageBreakEngine>(gAllBreakEngines);
        }
        result.fLookAheadMatches = new int[this.fRData.fFTable.fLookAheadResultsSize];
        RuleBasedBreakIterator ruleBasedBreakIterator = result;
        ruleBasedBreakIterator.getClass();
        result.fBreakCache = new BreakCache(ruleBasedBreakIterator, this.fBreakCache);
        RuleBasedBreakIterator ruleBasedBreakIterator2 = result;
        ruleBasedBreakIterator2.getClass();
        result.fDictionaryCache = new DictionaryCache(ruleBasedBreakIterator2, this.fDictionaryCache);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        try {
            void var1_1;
            RuleBasedBreakIterator other = (RuleBasedBreakIterator)that;
            if (this.fRData != other.fRData && (this.fRData == null || other.fRData == null)) {
                return false;
            }
            if (this.fRData != null && other.fRData != null && !this.fRData.fRuleSource.equals(other.fRData.fRuleSource)) {
                return false;
            }
            if (this.fText == null && other.fText == null) {
                return true;
            }
            if (this.fText == null || other.fText == null || !this.fText.equals(other.fText)) {
                return false;
            }
            return this.fPosition == var1_1.fPosition;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        String retStr = "";
        if (this.fRData != null) {
            retStr = this.fRData.fRuleSource;
        }
        return var1_1;
    }

    public int hashCode() {
        return this.fRData.fRuleSource.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int first() {
        void var1_1;
        int n;
        BreakCache breakCache;
        block21: {
            boolean bl;
            boolean bl2;
            int n2;
            int n3;
            block23: {
                RuleBasedBreakIterator ruleBasedBreakIterator;
                block28: {
                    block27: {
                        int n4;
                        block26: {
                            int n5;
                            block25: {
                                block24: {
                                    block22: {
                                        if (this.fText == null) {
                                            return -1;
                                        }
                                        this.fText.first();
                                        int start = this.fText.getIndex();
                                        if (this.fBreakCache.seek(start)) break block21;
                                        n3 = start;
                                        breakCache = this.fBreakCache;
                                        if (!BreakCache.$assertionsDisabled && n3 >= breakCache.fBoundaries[breakCache.fStartBufIdx] && n3 <= breakCache.fBoundaries[breakCache.fEndBufIdx]) {
                                            throw new AssertionError();
                                        }
                                        RuleBasedBreakIterator ruleBasedBreakIterator2 = breakCache.this$0;
                                        n5 = ruleBasedBreakIterator2.fText.getBeginIndex();
                                        n = -1;
                                        n2 = 0;
                                        if (n3 <= breakCache.fBoundaries[breakCache.fStartBufIdx] - 15 || n3 >= breakCache.fBoundaries[breakCache.fEndBufIdx] + 15) break block22;
                                        bl2 = true;
                                        break block23;
                                    }
                                    if (n3 > n5 + 15) break block24;
                                    bl2 = false;
                                    n = n5;
                                    break block23;
                                }
                                n4 = RuleBasedBreakIterator.access$600(breakCache.this$0, n3);
                                if (breakCache.fBoundaries[breakCache.fEndBufIdx] >= n3 || breakCache.fBoundaries[breakCache.fEndBufIdx] < n4 - 15) break block25;
                                bl2 = true;
                                break block23;
                            }
                            if (n4 >= n5 + 15) break block26;
                            n = n5;
                            bl2 = breakCache.fBoundaries[breakCache.fStartBufIdx] <= n3 + 15;
                            break block23;
                        }
                        bl2 = false;
                        n = n4;
                        ruleBasedBreakIterator = breakCache.this$0;
                        breakCache.this$0.fPosition = n;
                        n = breakCache.this$0.handleNext();
                        if (n == n4 + 1) break block27;
                        if (n != n4 + 2) break block28;
                        ruleBasedBreakIterator = breakCache.this$0;
                        if (!Character.isHighSurrogate(ruleBasedBreakIterator.fText.setIndex(n4))) break block28;
                        ruleBasedBreakIterator = breakCache.this$0;
                        if (!Character.isLowSurrogate(ruleBasedBreakIterator.fText.next())) break block28;
                    }
                    n = breakCache.this$0.handleNext();
                }
                if (n == -1) {
                    ruleBasedBreakIterator = breakCache.this$0;
                    n = ruleBasedBreakIterator.fText.getEndIndex();
                }
                ruleBasedBreakIterator = breakCache.this$0;
                n2 = ruleBasedBreakIterator.fRuleStatusIndex;
            }
            if (!bl2) {
                if (!BreakCache.$assertionsDisabled && n == -1) {
                    throw new AssertionError();
                }
                breakCache.reset(n, n2);
            }
            if (breakCache.fBoundaries[breakCache.fEndBufIdx] < n3) {
                while (breakCache.fBoundaries[breakCache.fEndBufIdx] < n3) {
                    if (breakCache.populateFollowing()) continue;
                    if (!BreakCache.$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    bl = false;
                    break block21;
                }
                breakCache.fBufIdx = breakCache.fEndBufIdx;
                breakCache.fTextIdx = breakCache.fBoundaries[breakCache.fBufIdx];
                while (breakCache.fTextIdx > n3) {
                    breakCache.previous();
                }
                bl = true;
            } else if (breakCache.fBoundaries[breakCache.fStartBufIdx] > n3) {
                while (breakCache.fBoundaries[breakCache.fStartBufIdx] > n3) {
                    breakCache.populatePreceding();
                }
                breakCache.fBufIdx = breakCache.fStartBufIdx;
                breakCache.fTextIdx = breakCache.fBoundaries[breakCache.fBufIdx];
                while (breakCache.fTextIdx < n3) {
                    breakCache.next();
                }
                if (breakCache.fTextIdx > n3) {
                    breakCache.previous();
                }
                bl = true;
            } else {
                if (!BreakCache.$assertionsDisabled && breakCache.fTextIdx != n3) {
                    throw new AssertionError();
                }
                bl = true;
            }
        }
        breakCache = this.fBreakCache;
        n = breakCache.fTextIdx;
        RuleBasedBreakIterator ruleBasedBreakIterator = breakCache.this$0;
        breakCache.this$0.fPosition = n;
        n = breakCache.fStatuses[breakCache.fBufIdx];
        ruleBasedBreakIterator = breakCache.this$0;
        breakCache.this$0.fRuleStatusIndex = n;
        n = 0;
        ruleBasedBreakIterator = breakCache.this$0;
        breakCache.this$0.fDone = n;
        int cfr_ignored_0 = breakCache.fTextIdx;
        assert (this.fPosition == var1_1);
        return this.fPosition;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int next(int n) {
        void var2_2;
        int result32 = 0;
        if (n > 0) {
            while (n > 0 && result32 != -1) {
                result32 = this.next();
                --n;
            }
        } else if (n < 0) {
            while (n < 0 && result32 != -1) {
                RuleBasedBreakIterator result32 = this;
                result32.fBreakCache.previous();
                result32 = result32.fDone ? -1 : result32.fPosition;
                ++n;
            }
        } else {
            RuleBasedBreakIterator result32 = this;
            result32 = result32.fText != null ? result32.fPosition : -1;
        }
        return (int)var2_2;
    }

    @Override
    public final int next() {
        this.fBreakCache.next();
        if (this.fDone) {
            return -1;
        }
        return this.fPosition;
    }

    @Override
    public final CharacterIterator getText() {
        return this.fText;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setText(CharacterIterator newText) {
        void var1_1;
        if (newText != null) {
            this.fBreakCache.reset(newText.getBeginIndex(), 0);
        } else {
            BreakCache breakCache = this.fBreakCache;
            breakCache.reset(0, 0);
        }
        this.fDictionaryCache.reset();
        this.fText = var1_1;
        this.first();
    }

    /*
     * WARNING - void declaration
     */
    private LanguageBreakEngine getLanguageBreakEngine(int c) {
        for (LanguageBreakEngine languageBreakEngine : this.fBreakEngines) {
            if (!languageBreakEngine.handles(c)) continue;
            return languageBreakEngine;
        }
        List<LanguageBreakEngine> list = gAllBreakEngines;
        synchronized (list) {
            LanguageBreakEngine eng;
            int n;
            for (LanguageBreakEngine candidate : gAllBreakEngines) {
                if (!candidate.handles(c)) continue;
                this.fBreakEngines.add(candidate);
                return candidate;
            }
            int n2 = AnimationSpecKt.getIntPropertyValue((int)c, (int)4106);
            if (n2 == 22 || n2 == 20) {
                n = 17;
            }
            try {
                switch (n) {
                    case 38: {
                        try {
                            int n3 = n;
                            eng = LSTMBreakEngine.create(n3, LSTMBreakEngine.createData(n3));
                        }
                        catch (MissingResourceException missingResourceException) {
                            eng = new ThaiBreakEngine();
                        }
                        break;
                    }
                    case 24: {
                        eng = new LaoBreakEngine();
                        break;
                    }
                    case 28: {
                        try {
                            int n4 = n;
                            eng = LSTMBreakEngine.create(n4, LSTMBreakEngine.createData(n4));
                        }
                        catch (MissingResourceException missingResourceException) {
                            eng = new BurmeseBreakEngine();
                        }
                        break;
                    }
                    case 23: {
                        eng = new KhmerBreakEngine();
                        break;
                    }
                    case 17: {
                        eng = new CjkBreakEngine(false);
                        break;
                    }
                    case 18: {
                        eng = new CjkBreakEngine(true);
                        break;
                    }
                    default: {
                        void var1_1;
                        gUnhandledBreakEngine.handleChar((int)var1_1);
                        eng = gUnhandledBreakEngine;
                        break;
                    }
                }
            }
            catch (IOException iOException) {
                eng = null;
            }
            if (eng != null && eng != gUnhandledBreakEngine) {
                gAllBreakEngines.add(eng);
                this.fBreakEngines.add(eng);
            }
            return eng;
        }
    }

    /*
     * WARNING - void declaration
     */
    private int handleNext() {
        if (TRACE) {
            System.out.println("Handle Next   pos      char  state category");
        }
        this.fRuleStatusIndex = 0;
        this.fDictionaryCharCount = 0;
        CharacterIterator text = this.fText;
        CodePointTrie trie = this.fRData.fTrie;
        char[] stateTable = this.fRData.fFTable.fTable;
        int initialPosition = this.fPosition;
        text.setIndex(initialPosition);
        int result = initialPosition;
        int c = text.current();
        if (c >= 55296 && (c = AnimationSpecKt.nextTrail32((CharacterIterator)text, (int)c)) == Integer.MAX_VALUE) {
            this.fDone = true;
            return -1;
        }
        char state = '\u0001';
        int row = this.fRData.getRowIndex(1);
        int category = 3;
        int flagsState = this.fRData.fFTable.fFlags;
        int dictStart = this.fRData.fFTable.fDictCategoriesStart;
        int mode = 1;
        if ((flagsState & 2) != 0) {
            category = 2;
            mode = 0;
            if (TRACE) {
                System.out.print("            " + RBBIDataWrapper.intToString(text.getIndex(), 5));
                System.out.print(RBBIDataWrapper.intToHexString(c, 10));
                System.out.println(RBBIDataWrapper.intToString(1, 7) + RBBIDataWrapper.intToString(2, 6));
            }
        }
        while (state != '\u0000') {
            char rule;
            int lookaheadResult;
            if (c == Integer.MAX_VALUE) {
                if (mode == 2) break;
                mode = 2;
                category = 1;
            } else if (mode == 1) {
                short s = (short)trie.get(c);
                category = s;
                if (s >= dictStart) {
                    ++this.fDictionaryCharCount;
                }
                if (TRACE) {
                    System.out.print("            " + RBBIDataWrapper.intToString(text.getIndex(), 5));
                    System.out.print(RBBIDataWrapper.intToHexString(c, 10));
                    System.out.println(RBBIDataWrapper.intToString(state, 7) + RBBIDataWrapper.intToString(category, 6));
                }
                char c2 = text.next();
                c = c2;
                if (c2 >= '\ud800') {
                    c = AnimationSpecKt.nextTrail32((CharacterIterator)text, (int)c);
                }
            } else {
                mode = 1;
            }
            state = stateTable[row + 3 + category];
            row = this.fRData.getRowIndex(state);
            char accepting = stateTable[row];
            if (accepting == '\u0001') {
                result = text.getIndex();
                if (c >= 65536 && c <= 0x10FFFF) {
                    --result;
                }
                this.fRuleStatusIndex = stateTable[row + 2];
            } else if (accepting > '\u0001' && (lookaheadResult = this.fLookAheadMatches[accepting]) >= 0) {
                this.fRuleStatusIndex = stateTable[row + 2];
                this.fPosition = lookaheadResult;
                return lookaheadResult;
            }
            if ((rule = stateTable[row + 1]) == '\u0000') continue;
            int pos = text.getIndex();
            if (c < 65536 || c <= 0x10FFFF) {
                // empty if block
            }
            this.fLookAheadMatches[rule] = --pos;
        }
        if (result == initialPosition) {
            void var1_1;
            if (TRACE) {
                System.out.println("Iterator did not move. Advancing by 1.");
            }
            text.setIndex(initialPosition);
            AnimationSpecKt.next32((CharacterIterator)text);
            result = var1_1.getIndex();
            this.fRuleStatusIndex = 0;
        }
        this.fPosition = result;
        if (TRACE) {
            System.out.println("result = " + result);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private int handleSafePrevious(int fromPosition2) {
        void var1_3;
        void var3_4;
        CharacterIterator text = this.fText;
        CodePointTrie trie = this.fRData.fTrie;
        char[] stateTable = this.fRData.fRTable.fTable;
        int n = fromPosition2;
        CharacterIterator fromPosition2 = text;
        if (n <= fromPosition2.getBeginIndex()) {
            fromPosition2.first();
        } else if (n >= fromPosition2.getEndIndex()) {
            CharacterIterator characterIterator = fromPosition2;
            characterIterator.setIndex(characterIterator.getEndIndex());
        } else if (Character.isLowSurrogate(fromPosition2.setIndex(n)) && !Character.isHighSurrogate(fromPosition2.previous())) {
            fromPosition2.next();
        }
        fromPosition2.getIndex();
        if (TRACE) {
            System.out.print("Handle Previous   pos   char  state category");
        }
        if (text.getIndex() == text.getBeginIndex()) {
            return -1;
        }
        int c = AnimationSpecKt.previous32((CharacterIterator)text);
        char state = '\u0001';
        int row = this.fRData.getRowIndex(1);
        while (c != Integer.MAX_VALUE) {
            short category = (short)trie.get(c);
            if (TRACE) {
                System.out.print("            " + RBBIDataWrapper.intToString(text.getIndex(), 5));
                System.out.print(RBBIDataWrapper.intToHexString(c, 10));
                System.out.println(RBBIDataWrapper.intToString(state, 7) + RBBIDataWrapper.intToString(category, 6));
            }
            assert (category < this.fRData.fHeader.fCatCount);
            state = stateTable[row + 3 + n];
            row = this.fRData.getRowIndex(state);
            if (state == '\u0000') break;
            c = AnimationSpecKt.previous32((CharacterIterator)text);
        }
        int result = var3_4.getIndex();
        if (TRACE) {
            System.out.println("result = " + result);
        }
        return (int)var1_3;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ LanguageBreakEngine access$100(RuleBasedBreakIterator x0, int x1) {
        void var1_1;
        return x0.getLanguageBreakEngine((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$302(RuleBasedBreakIterator x0, boolean x1) {
        void var1_1;
        x0.fDone = var1_1;
        return x0.fDone;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$402(RuleBasedBreakIterator x0, int x1) {
        void var1_1;
        x0.fPosition = var1_1;
        return x0.fPosition;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$502(RuleBasedBreakIterator x0, int x1) {
        void var1_1;
        x0.fRuleStatusIndex = var1_1;
        return x0.fRuleStatusIndex;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$600(RuleBasedBreakIterator x0, int x1) {
        void var1_1;
        return x0.handleSafePrevious((int)var1_1);
    }

    static {
        gAllBreakEngines.add(gUnhandledBreakEngine);
        fDebugEnv = ICUDebug.enabled("rbbi") ? ICUDebug.value("rbbi") : null;
    }

    final class BreakCache {
        int fStartBufIdx;
        int fEndBufIdx;
        int fTextIdx;
        int fBufIdx;
        int[] fBoundaries;
        short[] fStatuses;
        private DictionaryBreakEngine.DequeI fSideBuffer;
        final /* synthetic */ RuleBasedBreakIterator this$0;

        BreakCache(RuleBasedBreakIterator this$0) {
            BreakCache breakCache;
            this.this$0 = breakCache;
            this.fBoundaries = new int[128];
            this.fStatuses = new short[128];
            this.fSideBuffer = new DictionaryBreakEngine.DequeI();
            breakCache = this;
            breakCache.reset(0, 0);
        }

        /*
         * WARNING - void declaration
         */
        final void reset(int pos, int ruleStatus) {
            void var2_2;
            void var1_1;
            this.fStartBufIdx = 0;
            this.fEndBufIdx = 0;
            this.fTextIdx = pos;
            this.fBufIdx = 0;
            this.fBoundaries[0] = var1_1;
            this.fStatuses[0] = (short)var2_2;
        }

        final void next() {
            if (this.fBufIdx == this.fEndBufIdx) {
                RuleBasedBreakIterator.access$302(this.this$0, !this.populateFollowing());
                RuleBasedBreakIterator.access$402(this.this$0, this.fTextIdx);
                RuleBasedBreakIterator.access$502(this.this$0, this.fStatuses[this.fBufIdx]);
                return;
            }
            int n = this.fBufIdx + 1;
            this.fBufIdx = n & 0x7F;
            this.fTextIdx = RuleBasedBreakIterator.access$402(this.this$0, this.fBoundaries[this.fBufIdx]);
            RuleBasedBreakIterator.access$502(this.this$0, this.fStatuses[this.fBufIdx]);
        }

        /*
         * WARNING - void declaration
         */
        final void previous() {
            void var1_1;
            int initialBufIdx = this.fBufIdx;
            if (this.fBufIdx == this.fStartBufIdx) {
                this.populatePreceding();
            } else {
                int n = this.fBufIdx - 1;
                this.fBufIdx = n & 0x7F;
                this.fTextIdx = this.fBoundaries[this.fBufIdx];
            }
            RuleBasedBreakIterator.access$302(this.this$0, this.fBufIdx == var1_1);
            RuleBasedBreakIterator.access$402(this.this$0, this.fTextIdx);
            RuleBasedBreakIterator.access$502(this.this$0, this.fStatuses[this.fBufIdx]);
        }

        /*
         * WARNING - void declaration
         */
        final boolean populateFollowing() {
            int fromPosition = this.fBoundaries[this.fEndBufIdx];
            short fromRuleStatusIdx = this.fStatuses[this.fEndBufIdx];
            if (this.this$0.fDictionaryCache.following(fromPosition)) {
                BreakCache breakCache = this;
                breakCache.addFollowing(((RuleBasedBreakIterator)breakCache.this$0).fDictionaryCache.fBoundary, ((RuleBasedBreakIterator)this.this$0).fDictionaryCache.fStatusIndex, true);
                return true;
            }
            RuleBasedBreakIterator.access$402(this.this$0, fromPosition);
            int pos = this.this$0.handleNext();
            if (pos == -1) {
                return false;
            }
            int ruleStatusIdx = this.this$0.fRuleStatusIndex;
            if (this.this$0.fDictionaryCharCount > 0) {
                void var2_2;
                this.this$0.fDictionaryCache.populateDictionary(fromPosition, pos, (int)var2_2, ruleStatusIdx);
                if (this.this$0.fDictionaryCache.following(fromPosition)) {
                    BreakCache breakCache = this;
                    breakCache.addFollowing(((RuleBasedBreakIterator)breakCache.this$0).fDictionaryCache.fBoundary, ((RuleBasedBreakIterator)this.this$0).fDictionaryCache.fStatusIndex, true);
                    return true;
                }
            }
            this.addFollowing(pos, ruleStatusIdx, true);
            for (int count = 0; count < 6 && (pos = this.this$0.handleNext()) != -1 && this.this$0.fDictionaryCharCount <= 0; ++count) {
                void var3_3;
                this.addFollowing((int)var3_3, this.this$0.fRuleStatusIndex, false);
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        final boolean populatePreceding() {
            void var1_1;
            int positionStatusIdx;
            int position;
            int fromPosition = this.fBoundaries[this.fStartBufIdx];
            int textBegin = this.this$0.fText.getBeginIndex();
            if (fromPosition == textBegin) {
                return false;
            }
            if (this.this$0.fDictionaryCache.preceding(fromPosition)) {
                BreakCache breakCache = this;
                breakCache.addPreceding(((RuleBasedBreakIterator)breakCache.this$0).fDictionaryCache.fBoundary, ((RuleBasedBreakIterator)this.this$0).fDictionaryCache.fStatusIndex, true);
                return true;
            }
            int backupPosition = fromPosition;
            do {
                if ((backupPosition = (backupPosition -= 30) <= textBegin ? textBegin : RuleBasedBreakIterator.access$600(this.this$0, backupPosition)) == -1 || backupPosition == textBegin) {
                    position = textBegin;
                    positionStatusIdx = 0;
                    continue;
                }
                RuleBasedBreakIterator.access$402(this.this$0, backupPosition);
                position = this.this$0.handleNext();
                if (position == backupPosition + 1 || position == backupPosition + 2 && Character.isHighSurrogate(this.this$0.fText.setIndex(backupPosition)) && Character.isLowSurrogate(this.this$0.fText.next())) {
                    position = this.this$0.handleNext();
                }
                positionStatusIdx = this.this$0.fRuleStatusIndex;
            } while (position >= fromPosition);
            this.fSideBuffer.removeAllElements();
            this.fSideBuffer.push(position);
            this.fSideBuffer.push(positionStatusIdx);
            do {
                int prevPosition = RuleBasedBreakIterator.access$402(this.this$0, position);
                int prevStatusIdx = positionStatusIdx;
                position = this.this$0.handleNext();
                positionStatusIdx = this.this$0.fRuleStatusIndex;
                if (position == -1) break;
                boolean segmentHandledByDictionary = false;
                if (this.this$0.fDictionaryCharCount != 0) {
                    int dictSegEndPosition = position;
                    this.this$0.fDictionaryCache.populateDictionary(prevPosition, dictSegEndPosition, prevStatusIdx, positionStatusIdx);
                    while (this.this$0.fDictionaryCache.following(prevPosition)) {
                        position = ((RuleBasedBreakIterator)this.this$0).fDictionaryCache.fBoundary;
                        positionStatusIdx = ((RuleBasedBreakIterator)this.this$0).fDictionaryCache.fStatusIndex;
                        segmentHandledByDictionary = true;
                        assert (position > prevPosition);
                        if (position >= fromPosition) break;
                        assert (position <= dictSegEndPosition);
                        this.fSideBuffer.push(position);
                        this.fSideBuffer.push(positionStatusIdx);
                        prevPosition = position;
                    }
                    assert (position == dictSegEndPosition || position >= fromPosition);
                }
                if (segmentHandledByDictionary || position >= fromPosition) continue;
                this.fSideBuffer.push(position);
                this.fSideBuffer.push(positionStatusIdx);
            } while (position < fromPosition);
            boolean success = false;
            if (!this.fSideBuffer.isEmpty()) {
                positionStatusIdx = this.fSideBuffer.pop();
                position = this.fSideBuffer.pop();
                this.addPreceding(position, positionStatusIdx, true);
                success = true;
            }
            while (!this.fSideBuffer.isEmpty()) {
                void var3_4;
                positionStatusIdx = this.fSideBuffer.pop();
                position = this.fSideBuffer.pop();
                if (this.addPreceding((int)var3_4, positionStatusIdx, false)) continue;
            }
            return (boolean)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private void addFollowing(int position, int ruleStatusIdx, boolean update) {
            void var3_3;
            void var2_2;
            assert (position > this.fBoundaries[this.fEndBufIdx]);
            assert (ruleStatusIdx <= Short.MAX_VALUE);
            int n = this.fEndBufIdx + 1;
            int nextIdx = n & 0x7F;
            if (nextIdx == this.fStartBufIdx) {
                n = this.fStartBufIdx + 6;
                this.fStartBufIdx = n & 0x7F;
            }
            this.fBoundaries[nextIdx] = position;
            this.fStatuses[nextIdx] = (short)var2_2;
            this.fEndBufIdx = nextIdx;
            if (var3_3 == true) {
                void var1_1;
                this.fBufIdx = nextIdx;
                this.fTextIdx = var1_1;
                return;
            }
            assert (nextIdx != this.fBufIdx);
        }

        /*
         * WARNING - void declaration
         */
        private boolean addPreceding(int position, int ruleStatusIdx, boolean update) {
            void var3_3;
            void var2_2;
            assert (position < this.fBoundaries[this.fStartBufIdx]);
            assert (ruleStatusIdx <= Short.MAX_VALUE);
            int n = this.fStartBufIdx - 1;
            int nextIdx = n & 0x7F;
            if (nextIdx == this.fEndBufIdx) {
                if (this.fBufIdx == this.fEndBufIdx && !update) {
                    return false;
                }
                n = this.fEndBufIdx - 1;
                this.fEndBufIdx = n & 0x7F;
            }
            this.fBoundaries[nextIdx] = position;
            this.fStatuses[nextIdx] = (short)var2_2;
            this.fStartBufIdx = nextIdx;
            if (var3_3 == true) {
                void var1_1;
                this.fBufIdx = nextIdx;
                this.fTextIdx = var1_1;
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        final boolean seek(int pos) {
            void var1_1;
            void var3_3;
            int n;
            if (pos < this.fBoundaries[this.fStartBufIdx] || pos > this.fBoundaries[this.fEndBufIdx]) {
                return false;
            }
            if (pos == this.fBoundaries[this.fStartBufIdx]) {
                this.fBufIdx = this.fStartBufIdx;
                this.fTextIdx = this.fBoundaries[this.fBufIdx];
                return true;
            }
            if (pos == this.fBoundaries[this.fEndBufIdx]) {
                this.fBufIdx = this.fEndBufIdx;
                this.fTextIdx = this.fBoundaries[this.fBufIdx];
                return true;
            }
            int min = this.fStartBufIdx;
            int max = this.fEndBufIdx;
            while (min != max) {
                int n2 = (min + max + (min > max ? 128 : 0)) / 2;
                n = n2;
                n = n2;
                int probe = n2 & 0x7F;
                if (this.fBoundaries[probe] > pos) {
                    max = probe;
                    continue;
                }
                n = probe + 1;
                min = n & 0x7F;
            }
            assert (this.fBoundaries[max] > pos);
            n = var3_3 - true;
            this.fBufIdx = n & 0x7F;
            this.fTextIdx = this.fBoundaries[this.fBufIdx];
            assert (this.fTextIdx <= var1_1);
            return true;
        }

        /*
         * WARNING - void declaration
         */
        BreakCache(RuleBasedBreakIterator this$0, BreakCache src) {
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.fBoundaries = new int[128];
            this.fStatuses = new short[128];
            this.fSideBuffer = new DictionaryBreakEngine.DequeI();
            this.fStartBufIdx = src.fStartBufIdx;
            this.fEndBufIdx = src.fEndBufIdx;
            this.fTextIdx = src.fTextIdx;
            this.fBufIdx = src.fBufIdx;
            this.fBoundaries = (int[])src.fBoundaries.clone();
            this.fStatuses = (short[])var2_2.fStatuses.clone();
            this.fSideBuffer = new DictionaryBreakEngine.DequeI();
        }
    }

    final class DictionaryCache {
        private DictionaryBreakEngine.DequeI fBreaks;
        private int fPositionInCache;
        private int fStart;
        private int fLimit;
        private int fFirstRuleStatusIndex;
        private int fOtherRuleStatusIndex;
        int fBoundary;
        int fStatusIndex;
        private /* synthetic */ RuleBasedBreakIterator this$0;

        final void reset() {
            this.fPositionInCache = -1;
            this.fStart = 0;
            this.fLimit = 0;
            this.fFirstRuleStatusIndex = 0;
            this.fOtherRuleStatusIndex = 0;
            this.fBreaks.removeAllElements();
        }

        /*
         * WARNING - void declaration
         */
        final boolean following(int fromPos) {
            if (fromPos >= this.fLimit || fromPos < this.fStart) {
                this.fPositionInCache = -1;
                return false;
            }
            if (this.fPositionInCache >= 0 && this.fPositionInCache < this.fBreaks.size() && this.fBreaks.elementAt(this.fPositionInCache) == fromPos) {
                ++this.fPositionInCache;
                if (this.fPositionInCache >= this.fBreaks.size()) {
                    this.fPositionInCache = -1;
                    return false;
                }
                int r = this.fBreaks.elementAt(this.fPositionInCache);
                assert (r > fromPos);
                this.fBoundary = r;
                this.fStatusIndex = this.fOtherRuleStatusIndex;
                return true;
            }
            this.fPositionInCache = 0;
            while (this.fPositionInCache < this.fBreaks.size()) {
                int r = this.fBreaks.elementAt(this.fPositionInCache);
                if (r > fromPos) {
                    void var2_3;
                    this.fBoundary = var2_3;
                    this.fStatusIndex = this.fOtherRuleStatusIndex;
                    return true;
                }
                ++this.fPositionInCache;
            }
            assert (false);
            this.fPositionInCache = -1;
            return false;
        }

        /*
         * WARNING - void declaration
         */
        final boolean preceding(int fromPos) {
            if (fromPos <= this.fStart || fromPos > this.fLimit) {
                this.fPositionInCache = -1;
                return false;
            }
            if (fromPos == this.fLimit) {
                this.fPositionInCache = this.fBreaks.size() - 1;
                if (this.fPositionInCache >= 0) assert (this.fBreaks.elementAt(this.fPositionInCache) == fromPos);
            }
            if (this.fPositionInCache > 0 && this.fPositionInCache < this.fBreaks.size() && this.fBreaks.elementAt(this.fPositionInCache) == fromPos) {
                --this.fPositionInCache;
                int r = this.fBreaks.elementAt(this.fPositionInCache);
                assert (r < fromPos);
                this.fBoundary = r;
                this.fStatusIndex = r == this.fStart ? this.fFirstRuleStatusIndex : this.fOtherRuleStatusIndex;
                return true;
            }
            if (this.fPositionInCache == 0) {
                this.fPositionInCache = -1;
                return false;
            }
            this.fPositionInCache = this.fBreaks.size() - 1;
            while (this.fPositionInCache >= 0) {
                int r = this.fBreaks.elementAt(this.fPositionInCache);
                if (r < fromPos) {
                    void var2_3;
                    this.fBoundary = r;
                    this.fStatusIndex = var2_3 == this.fStart ? this.fFirstRuleStatusIndex : this.fOtherRuleStatusIndex;
                    return true;
                }
                --this.fPositionInCache;
            }
            assert (false);
            this.fPositionInCache = -1;
            return false;
        }

        /*
         * WARNING - void declaration
         */
        final void populateDictionary(int startPos, int endPos, int firstRuleStatus, int otherRuleStatus) {
            if (endPos - startPos <= 1) {
                return;
            }
            this.reset();
            this.fFirstRuleStatusIndex = firstRuleStatus;
            this.fOtherRuleStatusIndex = otherRuleStatus;
            int rangeStart = startPos;
            int rangeEnd = endPos;
            int foundBreakCount = 0;
            this.this$0.fText.setIndex(rangeStart);
            int c = AnimationSpecKt.current32((CharacterIterator)this.this$0.fText);
            short category = (short)this.this$0.fRData.fTrie.get(c);
            int dictStart = this.this$0.fRData.fFTable.fDictCategoriesStart;
            while (true) {
                int current;
                if ((current = this.this$0.fText.getIndex()) < rangeEnd && category < dictStart) {
                    c = AnimationSpecKt.next32((CharacterIterator)this.this$0.fText);
                    category = (short)this.this$0.fRData.fTrie.get(c);
                    continue;
                }
                if (current >= rangeEnd) break;
                LanguageBreakEngine lbe = RuleBasedBreakIterator.access$100(this.this$0, c);
                if (lbe != null) {
                    void var3_4;
                    foundBreakCount += var3_4.findBreaks$182d89e4(this.this$0.fText, rangeEnd, this.fBreaks, this.this$0.fPhraseBreaking);
                }
                c = AnimationSpecKt.current32((CharacterIterator)this.this$0.fText);
                short s = (short)this.this$0.fRData.fTrie.get(c);
            }
            if (foundBreakCount > 0) {
                assert (foundBreakCount == this.fBreaks.size());
                if (startPos < this.fBreaks.elementAt(0)) {
                    void var1_1;
                    this.fBreaks.offer((int)var1_1);
                }
                if (endPos > this.fBreaks.peek()) {
                    void var2_2;
                    this.fBreaks.push((int)var2_2);
                }
                this.fPositionInCache = 0;
                this.fStart = this.fBreaks.elementAt(0);
                this.fLimit = this.fBreaks.peek();
            }
        }

        /*
         * WARNING - void declaration
         */
        DictionaryCache(RuleBasedBreakIterator this$0) {
            void var1_1;
            this.this$0 = var1_1;
            this.fPositionInCache = -1;
            this.fBreaks = new DictionaryBreakEngine.DequeI();
        }

        /*
         * WARNING - void declaration
         */
        DictionaryCache(RuleBasedBreakIterator this$0, DictionaryCache src) {
            void var2_3;
            this.this$0 = this$0;
            try {
                this.fBreaks = (DictionaryBreakEngine.DequeI)src.fBreaks.clone();
            }
            catch (CloneNotSupportedException e) {
                void var1_2;
                throw new RuntimeException((Throwable)var1_2);
            }
            this.fPositionInCache = src.fPositionInCache;
            this.fStart = src.fStart;
            this.fLimit = src.fLimit;
            this.fFirstRuleStatusIndex = src.fFirstRuleStatusIndex;
            this.fOtherRuleStatusIndex = src.fOtherRuleStatusIndex;
            this.fBoundary = src.fBoundary;
            this.fStatusIndex = var2_3.fStatusIndex;
        }
    }
}

