/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import androidx.compose.animation.core.AnimationSpecKt;
import androidx.compose.foundation.gestures.DraggableKt;
import com.ibm.icu.impl.BMPSet;
import com.ibm.icu.impl.CaseMapImpl;
import com.ibm.icu.impl.CharacterPropertiesImpl;
import com.ibm.icu.impl.IllegalIcuArgumentException;
import com.ibm.icu.impl.PatternProps;
import com.ibm.icu.impl.RuleCharacterIterator;
import com.ibm.icu.impl.StringRange;
import com.ibm.icu.impl.UCaseProps;
import com.ibm.icu.impl.UCharacterName;
import com.ibm.icu.impl.UCharacterProperty;
import com.ibm.icu.impl.UPropertyAliases;
import com.ibm.icu.impl.UnicodeSetStringSpan;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.lang.CharacterProperties;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.SymbolTable;
import com.ibm.icu.text.UnicodeMatcher;
import com.ibm.icu.util.Freezable;
import com.ibm.icu.util.ICUUncheckedIOException;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.VersionInfo;
import java.io.IOException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.concurrent.TaskQueue;

public class UnicodeSet
extends UnicodeMatcher
implements Freezable<UnicodeSet>,
Comparable<UnicodeSet>,
Iterable<String> {
    private static final SortedSet<String> EMPTY_STRINGS = Collections.unmodifiableSortedSet(new TreeSet());
    private static XSymbolTable XSYMBOL_TABLE;
    private int len;
    private int[] list;
    private int[] rangeList;
    private int[] buffer;
    SortedSet<String> strings = EMPTY_STRINGS;
    private String pat = null;
    private volatile BMPSet bmpSet;
    private volatile UnicodeSetStringSpan stringSpan;
    private static final VersionInfo NO_VERSION;

    public UnicodeSet() {
        this.list = new int[25];
        this.list[0] = 0x110000;
        this.len = 1;
    }

    /*
     * WARNING - void declaration
     */
    public UnicodeSet(UnicodeSet other) {
        void var1_1;
        this.set((UnicodeSet)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public UnicodeSet(int start, int end) {
        this();
        void var2_2;
        void var1_1;
        this.add((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public UnicodeSet(int ... pairs) {
        if ((pairs.length & 1) != 0) {
            throw new IllegalArgumentException("Must have even number of integers");
        }
        this.list = new int[pairs.length + 1];
        this.len = this.list.length;
        int last = -1;
        int i = 0;
        while (i < pairs.length) {
            void var2_2;
            int start = pairs[i];
            if (last >= start) {
                throw new IllegalArgumentException("Must be monotonically increasing.");
            }
            this.list[i++] = start;
            int limit = pairs[i] + 1;
            if (start >= limit) {
                throw new IllegalArgumentException("Must be monotonically increasing.");
            }
            this.list[i++] = var2_2;
        }
        this.list[var3_3] = 0x110000;
    }

    /*
     * WARNING - void declaration
     */
    public UnicodeSet(String pattern) {
        this();
        void var1_1;
        this.applyPattern((String)var1_1, null, null, 1);
    }

    public Object clone() {
        if (this.isFrozen()) {
            return this;
        }
        return new UnicodeSet(this);
    }

    private UnicodeSet set(int start, int end) {
        int n;
        this.checkFrozen();
        this.clear();
        void var3_4 = n;
        n = 0;
        UnicodeSet unicodeSet = this;
        unicodeSet.checkFrozen();
        if (n < 0 || n > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(n, 6));
        }
        if (var3_4 < 0 || var3_4 > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex((long)var3_4, 6));
        }
        if (n <= var3_4) {
            UnicodeSet unicodeSet2 = unicodeSet;
            unicodeSet2.xor(unicodeSet2.range(n, (int)var3_4), 2, 0);
        }
        unicodeSet.pat = null;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private UnicodeSet set(UnicodeSet other) {
        void var1_1;
        this.checkFrozen();
        this.list = Arrays.copyOf(other.list, other.len);
        this.len = other.len;
        this.pat = other.pat;
        this.strings = other.hasStrings() ? new TreeSet<String>(var1_1.strings) : EMPTY_STRINGS;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final UnicodeSet applyPattern(String pattern) {
        void var1_1;
        this.checkFrozen();
        return this.applyPattern((String)var1_1, null, null, 1);
    }

    /*
     * WARNING - void declaration
     */
    private static void appendCodePoint(Appendable app, int c) {
        assert (c >= 0 && c <= 0x10FFFF);
        try {
            if (c > 65535) {
                void var1_2;
                app.append(AnimationSpecKt.getLeadSurrogate((int)c)).append(AnimationSpecKt.getTrailSurrogate((int)var1_2));
                return;
            }
            app.append((char)c);
        }
        catch (IOException e) {
            void var0_1;
            throw new ICUUncheckedIOException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void append(Appendable app, CharSequence s) {
        try {
            void var1_2;
            app.append((CharSequence)var1_2);
            return;
        }
        catch (IOException e) {
            void var0_1;
            throw new ICUUncheckedIOException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static <T extends Appendable> T _appendToPat(T buf, String s, boolean escapeUnprintable) {
        T t;
        void var3_4;
        for (int i = 0; i < s.length(); i += Character.charCount((int)var3_4)) {
            int cp = s.codePointAt(i);
            UnicodeSet._appendToPat(buf, cp, escapeUnprintable);
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    private static <T extends Appendable> T _appendToPat(T buf, int c, boolean escapeUnprintable) {
        try {
            void var1_2;
            if (escapeUnprintable ? Utility.isUnprintable(c) : Utility.shouldAlwaysBeEscaped(c)) {
                return Utility.escape(buf, c);
            }
            switch (c) {
                case 36: 
                case 38: 
                case 45: 
                case 58: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 123: 
                case 125: {
                    buf.append('\\');
                    break;
                }
                default: {
                    if (!PatternProps.isWhiteSpace(c)) break;
                    buf.append('\\');
                }
            }
            UnicodeSet.appendCodePoint(buf, (int)var1_2);
            return buf;
        }
        catch (IOException e) {
            void var0_1;
            throw new ICUUncheckedIOException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static <T extends Appendable> T _appendToPat(T result, int start, int end, boolean escapeUnprintable) {
        T t;
        UnicodeSet._appendToPat(result, start, escapeUnprintable);
        if (start != end) {
            void var3_4;
            void var2_3;
            void var1_2;
            if (start + 1 != end || var1_2 == 56319) {
                try {
                    result.append('-');
                }
                catch (IOException e) {
                    void var0_1;
                    throw new ICUUncheckedIOException((Throwable)var0_1);
                }
            }
            UnicodeSet._appendToPat(t, (int)var2_3, (boolean)var3_4);
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    private <T extends Appendable> T _toPattern(T result, boolean escapeUnprintable) {
        if (this.pat == null) {
            return this.appendNewPattern(result, escapeUnprintable, true);
        }
        try {
            void var1_1;
            if (!escapeUnprintable) {
                result.append(this.pat);
                return result;
            }
            boolean oddNumberOfBackslashes = false;
            int i = 0;
            while (i < this.pat.length()) {
                int c = this.pat.codePointAt(i);
                i += Character.charCount(c);
                if (Utility.isUnprintable(c)) {
                    Utility.escape(result, c);
                    oddNumberOfBackslashes = false;
                    continue;
                }
                if (!oddNumberOfBackslashes && c == 92) {
                    oddNumberOfBackslashes = true;
                    continue;
                }
                if (oddNumberOfBackslashes) {
                    result.append('\\');
                }
                UnicodeSet.appendCodePoint(result, c);
                oddNumberOfBackslashes = false;
            }
            if (oddNumberOfBackslashes) {
                result.append('\\');
            }
            return var1_1;
        }
        catch (IOException e) {
            void var2_3;
            throw new ICUUncheckedIOException((Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private <T extends Appendable> T appendNewPattern(T result, boolean escapeUnprintable, boolean includeStrings) {
        try {
            void var1_1;
            result.append('[');
            int i = 0;
            int limit = this.len & 0xFFFFFFFE;
            if (this.len >= 4 && this.list[0] == 0 && limit == this.len && !this.hasStrings()) {
                result.append('^');
                i = 1;
                --limit;
            }
            while (i < limit) {
                int start = this.list[i];
                int end = this.list[i + 1] - 1;
                if (55296 > end || end > 56319) {
                    UnicodeSet._appendToPat(result, start, end, escapeUnprintable);
                    i += 2;
                    continue;
                }
                int firstLead = i;
                while ((i += 2) < limit && this.list[i] <= 56319) {
                }
                int firstAfterLead = i;
                while (i < limit && (start = this.list[i]) <= 57343) {
                    UnicodeSet._appendToPat(result, start, this.list[i + 1] - 1, escapeUnprintable);
                    i += 2;
                }
                for (int j = firstLead; j < firstAfterLead; j += 2) {
                    UnicodeSet._appendToPat(result, this.list[j], this.list[j + 1] - 1, escapeUnprintable);
                }
            }
            if (this.hasStrings()) {
                for (String s : this.strings) {
                    result.append('{');
                    UnicodeSet._appendToPat(result, s, escapeUnprintable);
                    result.append('}');
                }
            }
            result.append(']');
            return var1_1;
        }
        catch (IOException e) {
            void var3_4;
            throw new ICUUncheckedIOException((Throwable)var3_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    private int size() {
        void var1_1;
        int n = 0;
        UnicodeSet unicodeSet = this;
        int count = unicodeSet.len / 2;
        for (int i = 0; i < count; ++i) {
            n += this.getRangeEnd(i) - this.getRangeStart(i) + 1;
        }
        return (int)(var1_1 + this.strings.size());
    }

    public final boolean hasStrings() {
        return !this.strings.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public final UnicodeSet add(int start, int end) {
        void var2_2;
        void var1_1;
        this.checkFrozen();
        return this.add_unchecked((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private UnicodeSet add_unchecked(int start, int end) {
        void var2_2;
        if (start < 0 || start > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(start, 6));
        }
        if (end < 0 || end > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(end, 6));
        }
        if (start < end) {
            int lastLimit;
            int limit = end + 1;
            if ((this.len & 1) != 0 && (lastLimit = this.len == 1 ? -2 : this.list[this.len - 2]) <= start) {
                this.checkFrozen();
                if (lastLimit == start) {
                    this.list[this.len - 2] = limit;
                    if (limit == 0x110000) {
                        --this.len;
                    }
                } else {
                    this.list[this.len - 1] = start;
                    if (limit < 0x110000) {
                        void var3_3;
                        UnicodeSet unicodeSet = this;
                        unicodeSet.ensureCapacity(unicodeSet.len + 2);
                        this.list[this.len++] = var3_3;
                        this.list[this.len++] = 0x110000;
                    } else {
                        UnicodeSet unicodeSet = this;
                        unicodeSet.ensureCapacity(unicodeSet.len + 1);
                        this.list[this.len++] = 0x110000;
                    }
                }
                this.pat = null;
                return this;
            }
            UnicodeSet unicodeSet = this;
            unicodeSet.add(unicodeSet.range(start, end), 2, 0);
        } else if (start == var2_2) {
            void var1_1;
            this.add((int)var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final UnicodeSet add(int c) {
        void var1_1;
        this.checkFrozen();
        return this.add_unchecked((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final UnicodeSet add_unchecked(int c) {
        if (c < 0 || c > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(c, 6));
        }
        int i = this.findCodePoint(c);
        if ((i & 1) != 0) {
            return this;
        }
        if (c == this.list[i] - 1) {
            this.list[i] = c;
            if (c == 0x10FFFF) {
                UnicodeSet unicodeSet = this;
                unicodeSet.ensureCapacity(unicodeSet.len + 1);
                this.list[this.len++] = 0x110000;
            }
            if (i > 0 && c == this.list[i - 1]) {
                System.arraycopy(this.list, i + 1, this.list, i - 1, this.len - i - 1);
                this.len -= 2;
            }
        } else if (i > 0 && c == this.list[i - 1]) {
            int n = i - 1;
            this.list[n] = this.list[n] + 1;
        } else {
            void var1_1;
            if (this.len + 2 > this.list.length) {
                void var3_3;
                int[] temp = new int[UnicodeSet.nextCapacity(this.len + 2)];
                if (i != 0) {
                    System.arraycopy(this.list, 0, temp, 0, i);
                }
                System.arraycopy(this.list, i, temp, i + 2, this.len - i);
                this.list = var3_3;
            } else {
                System.arraycopy(this.list, i, this.list, i + 2, this.len - i);
            }
            this.list[i] = c;
            this.list[var2_2 + true] = var1_1 + true;
            this.len += 2;
        }
        this.pat = null;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final UnicodeSet add(CharSequence s) {
        this.checkFrozen();
        int cp2 = UnicodeSet.getSingleCP(s);
        if (cp2 < 0) {
            String str = s.toString();
            if (!this.strings.contains(str)) {
                UnicodeSet unicodeSet;
                void cp2 = unicodeSet;
                unicodeSet = this;
                if (unicodeSet.strings == EMPTY_STRINGS) {
                    unicodeSet.strings = new TreeSet<String>();
                }
                unicodeSet.strings.add(cp2.toString());
                this.pat = null;
            }
        } else {
            void var2_2;
            void v0 = var2_2;
            this.add_unchecked((int)v0, (int)v0);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private static int getSingleCP(CharSequence s) {
        int cp;
        if (s.length() == 1) {
            return s.charAt(0);
        }
        if (s.length() == 2 && (cp = Character.codePointAt(s, 0)) > 65535) {
            void var0_1;
            return (int)var0_1;
        }
        return -1;
    }

    private UnicodeSet removeAllStrings() {
        this.checkFrozen();
        if (this.hasStrings()) {
            this.strings.clear();
            this.pat = null;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final UnicodeSet remove(int start, int end) {
        this.checkFrozen();
        if (start < 0 || start > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(start, 6));
        }
        if (end < 0 || end > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(end, 6));
        }
        if (start <= end) {
            void var2_2;
            void var1_1;
            UnicodeSet unicodeSet = this;
            unicodeSet.retain(unicodeSet.range((int)var1_1, (int)var2_2), 2, 2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final UnicodeSet remove(int c) {
        void var1_1;
        void v0 = var1_1;
        return this.remove((int)v0, (int)v0);
    }

    /*
     * WARNING - void declaration
     */
    private UnicodeSet remove(CharSequence s) {
        int cp = UnicodeSet.getSingleCP(s);
        if (cp < 0) {
            this.checkFrozen();
            String str = s.toString();
            if (this.strings.contains(str)) {
                void var1_1;
                this.strings.remove(var1_1);
                this.pat = null;
            }
        } else {
            void var2_2;
            void v0 = var2_2;
            this.remove((int)v0, (int)v0);
        }
        return this;
    }

    private UnicodeSet complement() {
        this.checkFrozen();
        if (this.list[0] == 0) {
            System.arraycopy(this.list, 1, this.list, 0, this.len - 1);
            --this.len;
        } else {
            UnicodeSet unicodeSet = this;
            unicodeSet.ensureCapacity(unicodeSet.len + 1);
            System.arraycopy(this.list, 0, this.list, 1, this.len);
            this.list[0] = 0;
            ++this.len;
        }
        this.pat = null;
        return this;
    }

    public final boolean contains(int c) {
        int n;
        if (c < 0 || c > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(c, 6));
        }
        if (this.bmpSet != null) {
            return this.bmpSet.contains(c);
        }
        if (this.stringSpan != null) {
            return this.stringSpan.contains(c);
        }
        return ((n = this.findCodePoint(n)) & 1) != 0;
    }

    private final int findCodePoint(int c) {
        if (c < this.list[0]) {
            return 0;
        }
        if (this.len >= 2 && c >= this.list[this.len - 2]) {
            return this.len - 1;
        }
        int lo = 0;
        int hi = this.len - 1;
        int i;
        while ((i = lo + hi >>> 1) != lo) {
            if (c < this.list[i]) {
                hi = i;
                continue;
            }
            lo = i;
        }
        return hi;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsAll(String s) {
        void var2_3;
        for (int i = 0; i < s.length(); i += AnimationSpecKt.getCharCount((int)var2_3)) {
            int cp = AnimationSpecKt.charAt((String)s, (int)i);
            if (this.contains(cp)) continue;
            if (!this.hasStrings()) {
                return false;
            }
            return this.containsAll(s, 0);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean containsAll(String s, int i) {
        void var3_3;
        if (i >= s.length()) {
            return true;
        }
        int cp = AnimationSpecKt.charAt((String)s, (int)i);
        if (this.contains(cp) && this.containsAll(s, i + AnimationSpecKt.getCharCount((int)var3_3))) {
            return true;
        }
        for (String setStr : this.strings) {
            if (setStr.isEmpty() || !s.startsWith(setStr, i) || !this.containsAll(s, i + setStr.length())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final UnicodeSet addAll(UnicodeSet c) {
        this.checkFrozen();
        this.add(c.list, c.len, 0);
        if (c.hasStrings()) {
            if (this.strings == EMPTY_STRINGS) {
                this.strings = new TreeSet<String>(c.strings);
            } else {
                void var1_1;
                this.strings.addAll(var1_1.strings);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final UnicodeSet retainAll(UnicodeSet c) {
        this.checkFrozen();
        this.retain(c.list, c.len, 0);
        if (this.hasStrings()) {
            if (!c.hasStrings()) {
                this.strings.clear();
            } else {
                void var1_1;
                this.strings.retainAll(var1_1.strings);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private UnicodeSet removeAll(UnicodeSet c) {
        this.checkFrozen();
        this.retain(c.list, c.len, 2);
        if (this.hasStrings() && c.hasStrings()) {
            void var1_1;
            this.strings.removeAll(var1_1.strings);
        }
        return this;
    }

    private UnicodeSet clear() {
        this.checkFrozen();
        this.list[0] = 0x110000;
        this.len = 1;
        this.pat = null;
        if (this.hasStrings()) {
            this.strings.clear();
        }
        return this;
    }

    public final int getRangeCount() {
        return this.len / 2;
    }

    /*
     * WARNING - void declaration
     */
    public final int getRangeStart(int index) {
        void var1_1;
        return this.list[var1_1 << 1];
    }

    /*
     * WARNING - void declaration
     */
    public final int getRangeEnd(int index) {
        void var1_1;
        return this.list[(var1_1 << 1) + true] - 1;
    }

    public final UnicodeSet compact() {
        this.checkFrozen();
        if (this.len + 7 < this.list.length) {
            this.list = Arrays.copyOf(this.list, this.len);
        }
        this.rangeList = null;
        this.buffer = null;
        if (this.strings != EMPTY_STRINGS && this.strings.isEmpty()) {
            this.strings = EMPTY_STRINGS;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        try {
            void var1_1;
            UnicodeSet that = (UnicodeSet)o;
            if (this.len != that.len) {
                return false;
            }
            for (int i = 0; i < this.len; ++i) {
                if (this.list[i] == that.list[i]) continue;
                return false;
            }
            if (!this.strings.equals(var1_1.strings)) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int result = this.len;
        for (int i = 0; i < this.len; ++i) {
            result *= 1000003;
            result += this.list[i];
        }
        return (int)var1_1;
    }

    public String toString() {
        boolean bl = true;
        UnicodeSet unicodeSet = this;
        StringBuilder stringBuilder = new StringBuilder();
        return unicodeSet._toPattern(stringBuilder, true).toString();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    private UnicodeSet applyPattern(String pattern, ParsePosition pos, SymbolTable symbols, int options) {
        void var3_4;
        boolean parsePositionWasNull = pos == null;
        if (parsePositionWasNull) {
            pos = new ParsePosition(0);
        }
        StringBuilder rebuiltPat = new StringBuilder();
        RuleCharacterIterator chars = new RuleCharacterIterator(pattern, symbols, pos);
        this.applyPattern(chars, (SymbolTable)var3_4, rebuiltPat, 1, 0);
        if (chars.inVariable()) {
            UnicodeSet.syntaxError(chars, "Extra chars in variable value");
        }
        this.pat = rebuiltPat.toString();
        if (parsePositionWasNull) {
            int i = pos.getIndex();
            if ((i = PatternProps.skipWhiteSpace(pattern, i)) != pattern.length()) {
                void var2_3;
                void var1_1;
                throw new IllegalArgumentException("Parse of \"" + (String)var1_1 + "\" failed at " + (int)var2_3);
            }
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    private void applyPattern(RuleCharacterIterator chars, SymbolTable symbols, Appendable rebuiltPat, int options, int depth) {
        if (depth > 100) {
            UnicodeSet.syntaxError(chars, "Pattern nested too deeply");
        }
        opts = 3;
        if ((options & 1) != 0) {
            opts = 7;
        }
        patBuf = new StringBuilder();
        buf = null;
        usePat = false;
        scratch = null;
        backup = null;
        lastItem = 0;
        lastChar = 0;
        mode = 0;
        op = '\u0000';
        invert = false;
        this.clear();
        lastString = null;
        block33: while (mode != 2 && !chars.atEnd()) {
            block94: {
                block93: {
                    block92: {
                        c = 0;
                        literal = false;
                        nested = null;
                        setMode = 0;
                        var23_34 = opts;
                        var22_29 = chars;
                        var24_37 = false;
                        var25_39 = var22_29.getPos(null);
                        var26_41 = var22_29.next(var23_34 &= -3);
                        if (var26_41 == 91 || var26_41 == 92) {
                            var27_43 = var22_29.next(var23_34 & -5);
                            var24_37 = var26_41 == 91 ? var27_43 == 58 : var27_43 == 78 || var27_43 == 112 || var27_43 == 80;
                        }
                        var22_29.setPos((RuleCharacterIterator.Position)var25_39);
                        if (!var24_37) break block92;
                        setMode = 2;
                        break block93;
                    }
                    backup = chars.getPos(backup);
                    c = chars.next(opts);
                    literal = chars.isEscaped();
                    if (c != 91 || literal) ** GOTO lbl64
                    if (mode == 1) {
                        chars.setPos(backup);
                        setMode = 1;
                    } else {
                        mode = 1;
                        patBuf.append('[');
                        backup = chars.getPos(backup);
                        c = chars.next(opts);
                        literal = chars.isEscaped();
                        if (c == 94 && !literal) {
                            invert = true;
                            patBuf.append('^');
                            backup = chars.getPos(backup);
                            c = chars.next(opts);
                            chars.isEscaped();
                        }
                        if (c == 45) {
                            literal = true;
                        } else {
                            chars.setPos(backup);
                            continue;
lbl64:
                            // 1 sources

                            if (symbols != null && (m = symbols.lookupMatcher$52778465()) != null) {
                                try {
                                    nested = (UnicodeSet)m;
                                    setMode = 3;
                                }
                                catch (ClassCastException v0) {
                                    UnicodeSet.syntaxError(chars, "Syntax error");
                                }
                            }
                        }
                    }
                }
                if (setMode == 0) break block94;
                if (lastItem == 1) {
                    if (op != '\u0000') {
                        UnicodeSet.syntaxError(chars, "Char expected after operator");
                    }
                    v1 = lastChar;
                    this.add_unchecked(v1, v1);
                    UnicodeSet._appendToPat(patBuf, lastChar, false);
                    op = '\u0000';
                }
                if (op == '-' || op == '&') {
                    patBuf.append(op);
                }
                if (nested == null) {
                    if (scratch == null) {
                        scratch = new UnicodeSet();
                    }
                    nested = scratch;
                }
                switch (setMode) {
                    case 1: {
                        nested.applyPattern(chars, symbols, patBuf, options, depth + 1);
                        break;
                    }
                    case 2: {
                        chars.skipIgnored(opts);
                        var25_39 = symbols;
                        var24_38 = patBuf;
                        var23_35 = chars;
                        m = nested;
                        var26_42 = var23_35.getCurrentBuffer();
                        var27_43 = var23_35.getCurrentBufferPos();
                        usePat = new ParsePosition(var27_43);
                        var21_28 = var25_39;
                        literal = usePat;
                        c = var26_42;
                        lastItem = m;
                        m = literal.getIndex();
                        if (m + 5 <= c.length()) ** GOTO lbl110
                        v2 = null;
                        ** GOTO lbl149
lbl110:
                        // 1 sources

                        var25_40 = false;
                        var28_44 = false;
                        var29_45 = false;
                        if (!c.regionMatches(m, "[:", 0, 2)) ** GOTO lbl119
                        var25_40 = true;
                        if ((m = PatternProps.skipWhiteSpace(c, m + 2)) < c.length() && c.charAt(m) == '^') {
                            ++m;
                            var29_45 = true;
                        }
                        ** GOTO lbl129
lbl119:
                        // 1 sources

                        if (!c.regionMatches(true, m, "\\p", 0, 2) && !c.regionMatches(m, "\\N", 0, 2)) ** GOTO lbl127
                        var30_46 = c.charAt(m + 1);
                        var29_45 = var30_46 == 80;
                        var28_44 = var30_46 == 78;
                        m = PatternProps.skipWhiteSpace(c, m + 2);
                        if (m != c.length() && c.charAt(m++) == '{') ** GOTO lbl129
                        v2 = null;
                        ** GOTO lbl149
lbl127:
                        // 1 sources

                        v2 = null;
                        ** GOTO lbl149
lbl129:
                        // 2 sources

                        if ((var30_46 = c.indexOf(var25_40 != false ? ":]" : "}", m)) < 0) {
                            v2 = null;
                        } else {
                            var31_47 = c.indexOf(61, m);
                            if (var31_47 >= 0 && var31_47 < var30_46 && !var28_44) {
                                m = c.substring(m, var31_47);
                                c = c.substring(var31_47 + 1, var30_46);
                            } else {
                                m = c.substring(m, var30_46);
                                c = "";
                                if (var28_44) {
                                    c = m;
                                    m = "na";
                                }
                            }
                            lastItem.applyPropertyAlias(m, c, (SymbolTable)var21_28);
                            if (var29_45) {
                                lastItem.complement().removeAllStrings();
                            }
                            literal.setIndex(var30_46 + (var25_40 != false ? 2 : 1));
                            v2 = lastItem;
                        }
lbl149:
                        // 5 sources

                        lastItem = usePat.getIndex() - var27_43;
                        if (lastItem == 0) {
                            UnicodeSet.syntaxError(var23_35, "Invalid property pattern");
                        }
                        var23_35.jumpahead(lastItem);
                        UnicodeSet.append(var24_38, var26_42.substring(var27_43, usePat.getIndex()));
                        break;
                    }
                    case 3: {
                        nested._toPattern(patBuf, false);
                    }
                }
                usePat = true;
                if (mode == 0) {
                    this.set(nested);
                    mode = 2;
                    break;
                }
                switch (op) {
                    case '-': {
                        this.removeAll(nested);
                        break;
                    }
                    case '&': {
                        this.retainAll(nested);
                        break;
                    }
                    case '\u0000': {
                        this.addAll(nested);
                    }
                }
                op = '\u0000';
                lastItem = 2;
                continue;
            }
            if (mode == 0) {
                UnicodeSet.syntaxError(chars, "Missing '['");
            }
            if (!literal) {
                switch (c) {
                    case 93: {
                        if (lastItem == 1) {
                            v3 = lastChar;
                            this.add_unchecked(v3, v3);
                            UnicodeSet._appendToPat(patBuf, lastChar, false);
                        }
                        if (op == '-') {
                            v4 = op;
                            this.add_unchecked(v4, v4);
                            patBuf.append(op);
                        } else if (op == '&') {
                            UnicodeSet.syntaxError(chars, "Trailing '&'");
                        }
                        patBuf.append(']');
                        mode = 2;
                        continue block33;
                    }
                    case 45: {
                        if (op == '\u0000') {
                            if (lastItem != 0) {
                                op = (char)c;
                                continue block33;
                            }
                            if (lastString != null) {
                                op = (char)c;
                                continue block33;
                            }
                            v5 = c;
                            this.add_unchecked(v5, v5);
                            c = chars.next(opts);
                            literal = chars.isEscaped();
                            if (c == 93 && !literal) {
                                patBuf.append("-]");
                                mode = 2;
                                continue block33;
                            }
                        }
                        UnicodeSet.syntaxError(chars, "'-' not after char, string, or set");
                        break;
                    }
                    case 38: {
                        if (lastItem == 2 && op == '\u0000') {
                            op = (char)c;
                            continue block33;
                        }
                        UnicodeSet.syntaxError(chars, "'&' not after set");
                        break;
                    }
                    case 94: {
                        UnicodeSet.syntaxError(chars, "'^' not after '['");
                        break;
                    }
                    case 123: {
                        if (op != '\u0000' && op != '-') {
                            UnicodeSet.syntaxError(chars, "Missing operand after operator");
                        }
                        if (lastItem == 1) {
                            v6 = lastChar;
                            this.add_unchecked(v6, v6);
                            UnicodeSet._appendToPat(patBuf, lastChar, false);
                        }
                        lastItem = 0;
                        if (buf == null) {
                            buf = new StringBuilder();
                        } else {
                            buf.setLength(0);
                        }
                        ok = false;
                        while (!chars.atEnd()) {
                            c = chars.next(opts);
                            literal = chars.isEscaped();
                            if (c == 125 && !literal) {
                                ok = true;
                                break;
                            }
                            UnicodeSet.appendCodePoint(buf, c);
                        }
                        if (!ok) {
                            UnicodeSet.syntaxError(chars, "Invalid multicharacter string");
                        }
                        curString = buf.toString();
                        if (op == '-') {
                            lastSingle = AnimationSpecKt.getSingleCodePoint((CharSequence)(lastString == null ? "" : lastString));
                            curSingle = AnimationSpecKt.getSingleCodePoint((CharSequence)curString);
                            if (lastSingle != 0x7FFFFFFF && curSingle != 0x7FFFFFFF) {
                                this.add(lastSingle, curSingle);
                            } else {
                                if (this.strings == UnicodeSet.EMPTY_STRINGS) {
                                    this.strings = new TreeSet<String>();
                                }
                                try {
                                    StringRange.expand(lastString, curString, true, this.strings);
                                }
                                catch (Exception e) {
                                    UnicodeSet.syntaxError(chars, e.getMessage());
                                }
                            }
                            lastString = null;
                            var15_17 = 0;
                        } else {
                            this.add(curString);
                            lastString = curString;
                        }
                        patBuf.append('{');
                        UnicodeSet._appendToPat(patBuf, curString, false);
                        patBuf.append('}');
                        continue block33;
                    }
                    case 36: {
                        backup = chars.getPos(backup);
                        var18_21 = chars.next(opts);
                        lastSingle = chars.isEscaped();
                        v7 = anchor = var18_21 == 93 && lastSingle == 0;
                        if (symbols == null && !anchor) {
                            var18_21 = 36;
                            chars.setPos(backup);
                            break;
                        }
                        if (anchor && !var15_17) {
                            if (lastItem == 1) {
                                v8 = lastChar;
                                this.add_unchecked(v8, v8);
                                UnicodeSet._appendToPat(patBuf, lastChar, false);
                            }
                            this.add_unchecked(65535);
                            usePat = true;
                            patBuf.append('$').append(']');
                            mode = 2;
                            continue block33;
                        }
                        UnicodeSet.syntaxError(chars, "Unquoted '$'");
                    }
                }
            }
            switch (lastItem) {
                case 0: {
                    if (var15_17 == 45 && lastString != null) {
                        UnicodeSet.syntaxError(chars, "Invalid range");
                    }
                    lastItem = 1;
                    lastChar = var18_21;
                    lastString = null;
                    break;
                }
                case 1: {
                    if (var15_17 == 45) {
                        if (lastString != null) {
                            UnicodeSet.syntaxError(chars, "Invalid range");
                        }
                        if (lastChar >= var18_21) {
                            UnicodeSet.syntaxError(chars, "Invalid range");
                        }
                        this.add_unchecked(lastChar, var18_21);
                        UnicodeSet._appendToPat(patBuf, lastChar, false);
                        patBuf.append((char)var15_17);
                        UnicodeSet._appendToPat(patBuf, var18_21, false);
                        lastItem = 0;
                        var15_17 = 0;
                        break;
                    }
                    v9 = lastChar;
                    this.add_unchecked(v9, v9);
                    UnicodeSet._appendToPat(patBuf, lastChar, false);
                    lastChar = var18_21;
                    break;
                }
                case 2: {
                    if (var15_17) {
                        UnicodeSet.syntaxError(chars, "Set expected after operator");
                    }
                    lastChar = var18_21;
                    lastItem = 1;
                }
            }
        }
        if (mode != 2) {
            UnicodeSet.syntaxError(chars, "Missing ']'");
        }
        var1_1.skipIgnored(opts);
        if ((options & 6) != 0) {
            var23_36 = options;
            var22_33 = this;
            var22_33.checkFrozen();
            switch (var23_36 & 6) {
                case 0: {
                    break;
                }
                case 2: {
                    var22_33.closeOverCaseInsensitive(false);
                    break;
                }
                case 4: {
                    var22_33.closeOverAddCaseMappings();
                    break;
                }
                case 6: {
                    var22_33.closeOverCaseInsensitive(true);
                }
            }
        }
        if (invert) {
            this.complement().removeAllStrings();
        }
        if (usePat) {
            UnicodeSet.append(rebuiltPat, patBuf.toString());
            return;
        }
        this.appendNewPattern(var3_3, false, true);
    }

    /*
     * WARNING - void declaration
     */
    private static void syntaxError(RuleCharacterIterator chars, String msg) {
        RuleCharacterIterator ruleCharacterIterator;
        void var1_1;
        throw new IllegalArgumentException("Error: " + (String)var1_1 + " at \"" + Utility.escape(ruleCharacterIterator.toString()) + '\"');
    }

    private static int nextCapacity(int minCapacity) {
        int n;
        if (minCapacity < 25) {
            return minCapacity + 25;
        }
        if (minCapacity <= 2500) {
            return 5 * minCapacity;
        }
        int newCapacity = 2 * minCapacity;
        if (newCapacity > 0x110001) {
            newCapacity = 0x110001;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private void ensureCapacity(int newLen) {
        void var1_2;
        if (newLen > 0x110001) {
            newLen = 0x110001;
        }
        if (newLen <= this.list.length) {
            return;
        }
        newLen = UnicodeSet.nextCapacity(newLen);
        int[] temp = new int[newLen];
        System.arraycopy(this.list, 0, temp, 0, this.len);
        this.list = var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private void ensureBufferCapacity(int newLen) {
        void var1_1;
        if (newLen > 0x110001) {
            newLen = 0x110001;
        }
        if (this.buffer != null && newLen <= this.buffer.length) {
            return;
        }
        int newCapacity = UnicodeSet.nextCapacity(newLen);
        this.buffer = new int[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    private int[] range(int start, int end) {
        if (this.rangeList == null) {
            this.rangeList = new int[]{start, end + 1, 0x110000};
        } else {
            void var2_2;
            void var1_1;
            this.rangeList[0] = var1_1;
            this.rangeList[1] = var2_2 + true;
        }
        return this.rangeList;
    }

    /*
     * WARNING - void declaration
     */
    private UnicodeSet xor(int[] other, int otherLen, int polarity) {
        void var1_1;
        UnicodeSet unicodeSet = this;
        unicodeSet.ensureBufferCapacity(unicodeSet.len + 2);
        int i = 0;
        int j = 0;
        int k = 0;
        ++i;
        int a = this.list[0];
        ++j;
        int b = other[0];
        while (true) {
            if (a < b) {
                this.buffer[k++] = a;
                a = this.list[i++];
                continue;
            }
            if (b < a) {
                this.buffer[k++] = b;
                b = other[j++];
                continue;
            }
            if (a == 0x110000) break;
            a = this.list[i++];
            b = other[j++];
        }
        this.buffer[k++] = 0x110000;
        this.len = k;
        int[] temp = this.list;
        this.list = this.buffer;
        this.buffer = var1_1;
        this.pat = null;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private UnicodeSet add(int[] other, int otherLen, int polarity) {
        void var1_1;
        UnicodeSet unicodeSet = this;
        unicodeSet.ensureBufferCapacity(unicodeSet.len + otherLen);
        int i = 0;
        int j = 0;
        int k = 0;
        ++i;
        int a = this.list[0];
        ++j;
        int b = other[0];
        block6: while (true) {
            switch (polarity) {
                case 0: {
                    if (a < b) {
                        if (k > 0 && a <= this.buffer[k - 1]) {
                            a = UnicodeSet.max(this.list[i], this.buffer[--k]);
                        } else {
                            this.buffer[k++] = a;
                            a = this.list[i];
                        }
                        ++i;
                        polarity ^= 1;
                        continue block6;
                    }
                    if (b < a) {
                        if (k > 0 && b <= this.buffer[k - 1]) {
                            b = UnicodeSet.max(other[j], this.buffer[--k]);
                        } else {
                            this.buffer[k++] = b;
                            b = other[j];
                        }
                        ++j;
                        polarity ^= 2;
                        continue block6;
                    }
                    if (a == 0x110000) break block6;
                    if (k > 0 && a <= this.buffer[k - 1]) {
                        a = UnicodeSet.max(this.list[i], this.buffer[--k]);
                    } else {
                        this.buffer[k++] = a;
                        a = this.list[i];
                    }
                    ++i;
                    polarity ^= 1;
                    b = other[j++];
                    polarity ^= 2;
                    continue block6;
                }
                case 3: {
                    if (b <= a) {
                        if (a == 0x110000) break block6;
                        this.buffer[k++] = a;
                    } else {
                        if (b == 0x110000) break block6;
                        this.buffer[k++] = b;
                    }
                    a = this.list[i++];
                    polarity ^= 1;
                    b = other[j++];
                    polarity ^= 2;
                    continue block6;
                }
                case 1: {
                    if (a < b) {
                        this.buffer[k++] = a;
                        a = this.list[i++];
                        polarity ^= 1;
                        continue block6;
                    }
                    if (b < a) {
                        b = other[j++];
                        polarity ^= 2;
                        continue block6;
                    }
                    if (a == 0x110000) break block6;
                    a = this.list[i++];
                    polarity ^= 1;
                    b = other[j++];
                    polarity ^= 2;
                    continue block6;
                }
                case 2: {
                    if (b < a) {
                        this.buffer[k++] = b;
                        b = other[j++];
                        polarity ^= 2;
                        continue block6;
                    }
                    if (a < b) {
                        a = this.list[i++];
                        polarity ^= 1;
                        continue block6;
                    }
                    if (a == 0x110000) break block6;
                    a = this.list[i++];
                    polarity ^= 1;
                    b = other[j++];
                    polarity ^= 2;
                }
                default: {
                    continue block6;
                }
            }
            break;
        }
        this.buffer[k++] = 0x110000;
        this.len = k;
        int[] temp = this.list;
        this.list = this.buffer;
        this.buffer = var1_1;
        this.pat = null;
        return this;
    }

    /*
     * Unable to fully structure code
     */
    private UnicodeSet retain(int[] other, int otherLen, int polarity) {
        v0 = this;
        v0.ensureBufferCapacity(v0.len + otherLen);
        i = 0;
        j = 0;
        k = 0;
        ++i;
        a = this.list[0];
        ++j;
        b = other[0];
        block6: while (true) {
            switch (polarity) {
                case 0: {
                    if (a < b) {
                        a = this.list[i++];
                        polarity ^= 1;
                        break;
                    }
                    if (b < a) {
                        b = other[j++];
                        polarity ^= 2;
                        break;
                    }
                    if (a == 0x110000) break block6;
                    this.buffer[k++] = a;
                    ** GOTO lbl65
                }
                case 3: {
                    if (a < b) {
                        this.buffer[k++] = a;
                        a = this.list[i++];
                        polarity ^= 1;
                        break;
                    }
                    if (b < a) {
                        this.buffer[k++] = b;
                        b = other[j++];
                        polarity ^= 2;
                        break;
                    }
                    if (a == 0x110000) break block6;
                    this.buffer[k++] = a;
                    ** GOTO lbl65
                }
                case 1: {
                    if (a < b) {
                        a = this.list[i++];
                        polarity ^= 1;
                        break;
                    }
                    if (b < a) {
                        this.buffer[k++] = b;
                        b = other[j++];
                        polarity ^= 2;
                        break;
                    }
                    if (a == 0x110000) break block6;
                    a = this.list[i++];
                    polarity ^= 1;
                    b = other[j++];
                    polarity ^= 2;
                    break;
                }
                case 2: {
                    if (b < a) {
                        b = other[j++];
                        polarity ^= 2;
                        break;
                    }
                    if (a < b) {
                        this.buffer[k++] = a;
                        a = this.list[i++];
                        polarity ^= 1;
                        break;
                    }
                    if (a == 0x110000) break block6;
lbl65:
                    // 3 sources

                    a = this.list[i++];
                    polarity ^= 1;
                    b = other[j++];
                    polarity ^= 2;
                }
            }
        }
        this.buffer[k++] = 0x110000;
        this.len = k;
        temp = this.list;
        this.list = this.buffer;
        this.buffer = var1_1;
        this.pat = null;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private static final int max(int a, int b) {
        void var1_1;
        if (a > b) {
            int n;
            return n;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void applyFilter(Filter filter, UnicodeSet inclusions) {
        this.clear();
        int startHasProperty = -1;
        UnicodeSet unicodeSet = inclusions;
        int limitRange = unicodeSet.len / 2;
        for (int j = 0; j < limitRange; ++j) {
            int start = inclusions.getRangeStart(j);
            int end = inclusions.getRangeEnd(j);
            for (int ch = start; ch <= end; ++ch) {
                if (filter.contains(ch)) {
                    if (startHasProperty >= 0) continue;
                    startHasProperty = ch;
                    continue;
                }
                if (startHasProperty < 0) continue;
                this.add_unchecked(startHasProperty, ch - 1);
                startHasProperty = -1;
            }
        }
        if (startHasProperty >= 0) {
            void var3_3;
            this.add_unchecked((int)var3_3, 0x10FFFF);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String mungeCharName(String source) {
        void var1_1;
        source = PatternProps.trimWhiteSpace(source);
        StringBuilder buf = null;
        for (int i = 0; i < source.length(); ++i) {
            void var3_3;
            int ch = source.charAt(i);
            if (PatternProps.isWhiteSpace(ch)) {
                if (buf == null) {
                    buf = new StringBuilder().append(source, 0, i);
                } else {
                    StringBuilder stringBuilder = buf;
                    if (stringBuilder.charAt(stringBuilder.length() - 1) == ' ') continue;
                }
                ch = 32;
            }
            if (buf == null) continue;
            buf.append((char)var3_3);
        }
        if (buf == null) {
            String string;
            return string;
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final UnicodeSet applyIntPropertyValue(int prop, int value) {
        if (prop == 8192) {
            UnicodeSet inclusions = CharacterPropertiesImpl.getInclusionsForProperty(prop);
            this.applyFilter(new GeneralCategoryMaskFilter(value), inclusions);
        } else if (prop == 28672) {
            UnicodeSet inclusions = CharacterPropertiesImpl.getInclusionsForProperty(prop);
            this.applyFilter(new ScriptExtensionsFilter(value), inclusions);
        } else if (prop >= 0 && prop < 72) {
            if (value == 0 || value == 1) {
                this.set(CharacterProperties.getBinaryPropertySet(prop));
                if (value == 0) {
                    this.complement().removeAllStrings();
                }
            } else {
                this.clear();
            }
        } else if (4096 <= prop && prop < 4121) {
            void var3_5;
            void var2_2;
            UnicodeSet inclusions = CharacterPropertiesImpl.getInclusionsForProperty(prop);
            this.applyFilter(new IntPropertyFilter(prop, (int)var2_2), (UnicodeSet)var3_5);
        } else {
            void var1_1;
            throw new IllegalArgumentException("unsupported property " + (int)var1_1);
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    private UnicodeSet applyPropertyAlias(String propertyAlias, String valueAlias, SymbolTable symbols) {
        block21: {
            block22: {
                block19: {
                    block20: {
                        this.checkFrozen();
                        invert = false;
                        if (valueAlias.length() <= 0) break block19;
                        symbols = UPropertyAliases.INSTANCE.getPropertyEnum(propertyAlias);
                        if (symbols == -1) {
                            throw new IllegalIcuArgumentException("Invalid name: " + propertyAlias);
                        }
                        p = symbols;
                        if (p == 4101) {
                            p = 8192;
                        }
                        if (!(p >= 0 && p < 72 || p >= 4096 && p < 4121) && (p < 8192 || p >= 8193)) break block20;
                        try {
                            v = AnimationSpecKt.getPropertyValueEnum((int)p, (CharSequence)valueAlias);
                        }
                        catch (IllegalArgumentException e) {
                            if (p == 4098 || p == 4112 || p == 4113) {
                                v = Integer.parseInt(PatternProps.trimWhiteSpace(valueAlias));
                                if (v >= 0 && v <= 255) ** GOTO lbl78
                                throw e;
                            }
                            throw e;
                        }
                    }
                    switch (p) {
                        case 12288: {
                            value = Double.parseDouble(PatternProps.trimWhiteSpace(valueAlias));
                            this.applyFilter(new NumericValueFilter(value), CharacterPropertiesImpl.getInclusionsForProperty(p));
                            return this;
                        }
                        case 16389: {
                            propertyAlias = value = UnicodeSet.mungeCharName(valueAlias);
                            ch = UCharacterName.INSTANCE.getCharFromName(2, propertyAlias);
                            if (ch == -1) {
                                throw new IllegalArgumentException("Invalid character name");
                            }
                            this.clear();
                            this.add_unchecked(ch);
                            return this;
                        }
                        case 16395: {
                            throw new IllegalArgumentException("Unicode_1_Name (na1) not supported");
                        }
                        case 16384: {
                            version = VersionInfo.getInstance(UnicodeSet.mungeCharName(valueAlias));
                            this.applyFilter(new VersionFilter(version), CharacterPropertiesImpl.getInclusionsForProperty(p));
                            return this;
                        }
                        case 28672: {
                            v = AnimationSpecKt.getPropertyValueEnum((int)4106, (CharSequence)valueAlias);
                            break block21;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported property");
                        }
                    }
                }
                pnames = UPropertyAliases.INSTANCE;
                p = 8192;
                v = pnames.getPropertyValueEnum(8192, propertyAlias);
                if (v != -1) break block21;
                p = 4106;
                v = pnames.getPropertyValueEnum(4106, propertyAlias);
                if (v != -1) break block21;
                p = pnames.getPropertyEnum(propertyAlias);
                if (p == -1) {
                    p = -1;
                }
                if (p < 0 || p >= 72) break block22;
                v = 1;
                break block21;
            }
            if (p != -1) ** GOTO lbl77
            if (0 == UPropertyAliases.compare("ANY", propertyAlias)) {
                this.set(0, 0x10FFFF);
                return this;
            }
            if (0 == UPropertyAliases.compare("ASCII", propertyAlias)) {
                this.set(0, 127);
                return this;
            }
            if (0 == UPropertyAliases.compare("Assigned", propertyAlias)) {
                p = 8192;
                v = 1;
                invert = true;
            } else {
                throw new IllegalArgumentException("Invalid property alias: " + (String)var1_1 + "=" + (String)var2_2);
lbl77:
                // 1 sources

                throw new IllegalArgumentException("Missing property value");
            }
        }
        this.applyIntPropertyValue((int)var3_4, v);
        if (invert) {
            this.complement().removeAllStrings();
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private static final void addCaseMapping(UnicodeSet set, int result, StringBuilder full) {
        if (result >= 0) {
            void var2_2;
            UnicodeSet unicodeSet;
            if (result > 31) {
                void var1_1;
                set.add((int)var1_1);
                return;
            }
            unicodeSet.add(full.toString());
            var2_2.setLength(0);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static UnicodeSet maybeOnlyCaseSensitive(UnicodeSet src) {
        void var1_1;
        UnicodeSet unicodeSet;
        block5: {
            UnicodeSet sensitive;
            block4: {
                if (src.size() < 30) {
                    return src;
                }
                sensitive = CharacterProperties.getBinaryPropertySet(34);
                if (src.hasStrings()) break block4;
                UnicodeSet unicodeSet2 = src;
                UnicodeSet unicodeSet3 = unicodeSet2;
                unicodeSet3 = sensitive;
                if (unicodeSet2.len / 2 <= unicodeSet3.len / 2) break block5;
            }
            return sensitive.cloneAsThawed().retainAll(src);
        }
        return ((UnicodeSet)unicodeSet.clone()).retainAll((UnicodeSet)var1_1);
    }

    private static final boolean scfString(CharSequence s, StringBuilder scf) {
        int c;
        int length = s.length();
        for (int i = 0; i < length; i += Character.charCount(c)) {
            c = Character.codePointAt(s, i);
            int scfChar = AnimationSpecKt.foldCase((int)c, (int)0);
            if (scfChar == c) continue;
            scf.setLength(0);
            scf.append(s, 0, i);
            while (true) {
                scf.appendCodePoint(scfChar);
                if ((i += Character.charCount(c)) == length) {
                    return true;
                }
                c = Character.codePointAt(s, i);
                scfChar = AnimationSpecKt.foldCase((int)c, (int)0);
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void closeOverCaseInsensitive(boolean simple) {
        void var3_3;
        UnicodeSet codePoints;
        UCaseProps csp = UCaseProps.INSTANCE;
        UnicodeSet foldSet = new UnicodeSet(this);
        if (!simple && foldSet.hasStrings()) {
            foldSet.strings.clear();
        }
        UnicodeSet unicodeSet = codePoints = UnicodeSet.maybeOnlyCaseSensitive(this);
        int n = codePoints.len / 2;
        for (int i = 0; i < n; ++i) {
            int cp;
            int start = codePoints.getRangeStart(i);
            int end = codePoints.getRangeEnd(i);
            if (simple) {
                for (cp = start; cp <= end; ++cp) {
                    csp.addSimpleCaseClosure(cp, foldSet);
                }
                continue;
            }
            for (cp = start; cp <= end; ++cp) {
                csp.addCaseClosure(cp, foldSet);
            }
        }
        if (this.hasStrings()) {
            StringBuilder sb = simple ? new StringBuilder() : null;
            for (String s : this.strings) {
                if (simple) {
                    if (!UnicodeSet.scfString(s, sb)) continue;
                    foldSet.remove(s).add(sb);
                    continue;
                }
                int n2 = 0;
                String string = s;
                String str = CaseMapImpl.fold(n2, string);
                if (csp.addStringCaseClosure(str, foldSet)) continue;
                foldSet.add(str);
            }
        }
        this.set((UnicodeSet)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void closeOverAddCaseMappings() {
        void var2_3;
        UnicodeSet codePoints;
        UCaseProps csp = UCaseProps.INSTANCE;
        UnicodeSet foldSet = new UnicodeSet(this);
        UnicodeSet unicodeSet = codePoints = UnicodeSet.maybeOnlyCaseSensitive(this);
        int n = codePoints.len / 2;
        StringBuilder full = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            int start = codePoints.getRangeStart(i);
            int end = codePoints.getRangeEnd(i);
            for (int cp = start; cp <= end; ++cp) {
                int result = csp.toFullLower(cp, null, full, 1);
                UnicodeSet.addCaseMapping(foldSet, result, full);
                result = csp.toFullTitle(cp, null, full, 1);
                UnicodeSet.addCaseMapping(foldSet, result, full);
                result = csp.toFullUpper(cp, null, full, 1);
                UnicodeSet.addCaseMapping(foldSet, result, full);
                result = csp.toFullFolding(cp, full, 0);
                UnicodeSet.addCaseMapping(foldSet, result, full);
            }
        }
        if (this.hasStrings()) {
            ULocale root = ULocale.ROOT;
            BreakIterator bi = BreakIterator.getWordInstance(root);
            for (String str : this.strings) {
                foldSet.add(AnimationSpecKt.toLowerCase((ULocale)root, (String)str));
                foldSet.add(AnimationSpecKt.toTitleCase((ULocale)root, (String)str, (BreakIterator)bi));
                foldSet.add(AnimationSpecKt.toUpperCase((ULocale)root, (String)str));
                int n2 = 0;
                String string = str;
                foldSet.add(CaseMapImpl.fold(n2, string));
            }
        }
        this.set((UnicodeSet)var2_3);
    }

    private boolean isFrozen() {
        return this.bmpSet != null || this.stringSpan != null;
    }

    public final UnicodeSet freeze() {
        if (!this.isFrozen()) {
            this.compact();
            if (this.hasStrings()) {
                this.stringSpan = new UnicodeSetStringSpan(this, new ArrayList<String>(this.strings), 127);
            }
            if (this.stringSpan == null || !this.stringSpan.needsStringSpanUTF16()) {
                this.bmpSet = new BMPSet(this.list, this.len);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final int span(CharSequence s, SpanCondition spanCondition) {
        void var2_2;
        void var1_1;
        return this.span((CharSequence)var1_1, 0, (SpanCondition)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final int span(CharSequence s, int start, SpanCondition spanCondition) {
        void var3_3;
        void var2_2;
        void var1_1;
        int which;
        UnicodeSetStringSpan strSpan;
        int end = s.length();
        if (start < 0) {
            start = 0;
        } else if (start >= end) {
            return end;
        }
        if (this.bmpSet != null) {
            return this.bmpSet.span$3279c9dc(s, start, spanCondition, null);
        }
        if (this.stringSpan != null) {
            return this.stringSpan.span(s, start, spanCondition);
        }
        if (this.hasStrings() && (strSpan = new UnicodeSetStringSpan(this, new ArrayList<String>(this.strings), which = spanCondition == SpanCondition.NOT_CONTAINED ? 33 : 34)).needsStringSpanUTF16()) {
            return strSpan.span(s, start, spanCondition);
        }
        return this.spanCodePointsAndCount$3279c9dc((CharSequence)var1_1, (int)var2_2, (SpanCondition)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public final int spanAndCount$3279c9dc(CharSequence s, int start, SpanCondition spanCondition, DraggableKt outCount) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (outCount == null) {
            throw new IllegalArgumentException("outCount must not be null");
        }
        int end = s.length();
        if (start < 0) {
            start = 0;
        } else if (start >= end) {
            return end;
        }
        if (this.stringSpan != null) {
            return this.stringSpan.spanAndCount$3279c9dc(s, start, spanCondition, outCount);
        }
        if (this.bmpSet != null) {
            return this.bmpSet.span$3279c9dc(s, start, spanCondition, outCount);
        }
        if (this.hasStrings()) {
            end = spanCondition == SpanCondition.NOT_CONTAINED ? 33 : 34;
            int which = end | 0x40;
            UnicodeSetStringSpan unicodeSetStringSpan = new UnicodeSetStringSpan(this, new ArrayList<String>(this.strings), which);
            return unicodeSetStringSpan.spanAndCount$3279c9dc(s, start, spanCondition, outCount);
        }
        return this.spanCodePointsAndCount$3279c9dc((CharSequence)var1_1, (int)var2_2, (SpanCondition)var3_3, outCount);
    }

    /*
     * WARNING - void declaration
     */
    private int spanCodePointsAndCount$3279c9dc(CharSequence s, int start, SpanCondition spanCondition, DraggableKt outCount) {
        int c;
        boolean spanContained = spanCondition != SpanCondition.NOT_CONTAINED;
        int next = start;
        int length = s.length();
        int count = 0;
        while (spanContained == this.contains(c = Character.codePointAt(s, next))) {
            void var2_2;
            ++count;
            if ((next += Character.charCount((int)var2_2)) < length) continue;
        }
        if (outCount != null) {
            DraggableKt draggableKt = outCount;
            int n = count;
            throw null;
        }
        return next;
    }

    /*
     * WARNING - void declaration
     */
    public final int spanBack(CharSequence s, int fromIndex, SpanCondition spanCondition) {
        void var2_2;
        void prev;
        int c;
        void var3_3;
        boolean spanContained;
        int which;
        UnicodeSetStringSpan strSpan;
        if (fromIndex <= 0) {
            return 0;
        }
        if (fromIndex > s.length()) {
            fromIndex = s.length();
        }
        if (this.bmpSet != null) {
            return this.bmpSet.spanBack(s, fromIndex, spanCondition);
        }
        if (this.stringSpan != null) {
            return this.stringSpan.spanBack(s, fromIndex, spanCondition);
        }
        if (this.hasStrings() && (strSpan = new UnicodeSetStringSpan(this, new ArrayList<String>(this.strings), which = spanCondition == SpanCondition.NOT_CONTAINED ? 17 : 18)).needsStringSpanUTF16()) {
            return strSpan.spanBack(s, fromIndex, spanCondition);
        }
        boolean bl = spanContained = var3_3 != SpanCondition.NOT_CONTAINED;
        while (spanContained == this.contains(c = Character.codePointBefore(s, (int)prev)) && (prev -= Character.charCount(c)) > 0) {
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final UnicodeSet cloneAsThawed() {
        void var1_1;
        UnicodeSet result = new UnicodeSet(this);
        assert (!result.isFrozen());
        return var1_1;
    }

    private void checkFrozen() {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify frozen object");
        }
    }

    @Override
    public Iterator<String> iterator() {
        return new UnicodeSetIterator2(this);
    }

    static {
        new UnicodeSet().freeze();
        new UnicodeSet(0, 0x10FFFF).freeze();
        XSYMBOL_TABLE = null;
        NO_VERSION = VersionInfo.getInstance(0, 0, 0, 0);
    }

    public static final class SpanCondition
    extends Enum<SpanCondition> {
        public static final /* enum */ SpanCondition NOT_CONTAINED = new SpanCondition();
        public static final /* enum */ SpanCondition CONTAINED = new SpanCondition();
        public static final /* enum */ SpanCondition SIMPLE = new SpanCondition();
        private static /* enum */ SpanCondition CONDITION_COUNT = new SpanCondition();

        static {
            SpanCondition[] spanConditionArray = new SpanCondition[]{NOT_CONTAINED, CONTAINED, SIMPLE, CONDITION_COUNT};
        }
    }

    public static final class ComparisonStyle
    extends Enum<ComparisonStyle> {
        public static final /* enum */ ComparisonStyle SHORTER_FIRST = new ComparisonStyle();
        public static final /* enum */ ComparisonStyle LEXICOGRAPHIC = new ComparisonStyle();
        private static /* enum */ ComparisonStyle LONGER_FIRST = new ComparisonStyle();

        static {
            ComparisonStyle[] comparisonStyleArray = new ComparisonStyle[]{SHORTER_FIRST, LEXICOGRAPHIC, LONGER_FIRST};
        }
    }

    static final class UnicodeSetIterator2
    implements Iterator<String> {
        private int[] sourceList;
        private int len;
        private int item;
        private int current;
        private int limit;
        private SortedSet<String> sourceStrings;
        private Iterator<String> stringIterator;
        private char[] buffer;

        /*
         * WARNING - void declaration
         */
        UnicodeSetIterator2(UnicodeSet source) {
            void var1_1;
            this.len = source.len - 1;
            if (this.len > 0) {
                this.sourceStrings = source.strings;
                this.sourceList = source.list;
                this.current = this.sourceList[this.item++];
                this.limit = this.sourceList[this.item++];
                return;
            }
            this.stringIterator = var1_1.strings.iterator();
            this.sourceList = null;
        }

        @Override
        public final boolean hasNext() {
            return this.sourceList != null || this.stringIterator.hasNext();
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0019J\b\u0010\u001a\u001a\u00020\fH&J\b\u0010\u001b\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001c"}, d2={"Lokhttp3/internal/concurrent/Task;", "", "name", "", "cancelable", "", "(Ljava/lang/String;Z)V", "getCancelable", "()Z", "getName", "()Ljava/lang/String;", "nextExecuteNanoTime", "", "getNextExecuteNanoTime$okhttp", "()J", "setNextExecuteNanoTime$okhttp", "(J)V", "queue", "Lokhttp3/internal/concurrent/TaskQueue;", "getQueue$okhttp", "()Lokhttp3/internal/concurrent/TaskQueue;", "setQueue$okhttp", "(Lokhttp3/internal/concurrent/TaskQueue;)V", "initQueue", "", "initQueue$okhttp", "runOnce", "toString", "okhttp"})
    public static abstract class XSymbolTable
    implements SymbolTable {
        private final String name;
        private final boolean cancelable;
        private TaskQueue queue;
        private long nextExecuteNanoTime;

        public XSymbolTable() {
        }

        /*
         * WARNING - void declaration
         */
        public XSymbolTable(String name, boolean cancelable) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = var1_1;
            this.cancelable = var2_2;
            this.nextExecuteNanoTime = -1L;
        }

        public /* synthetic */ XSymbolTable(String string, boolean bl, int n) {
            this(string, true);
        }

        public String getName() {
            return this.name;
        }

        public boolean getCancelable() {
            return this.cancelable;
        }

        public TaskQueue getQueue$okhttp() {
            return this.queue;
        }

        public long getNextExecuteNanoTime$okhttp() {
            return this.nextExecuteNanoTime;
        }

        /*
         * WARNING - void declaration
         */
        public void setNextExecuteNanoTime$okhttp(long l) {
            void var1_1;
            this.nextExecuteNanoTime = var1_1;
        }

        public abstract long runOnce();

        /*
         * WARNING - void declaration
         */
        public void initQueue$okhttp(TaskQueue queue) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
            if (this.queue == queue) {
                return;
            }
            if (!(this.queue == null)) {
                queue = "task is in multiple queues";
                throw new IllegalStateException(queue.toString());
            }
            this.queue = var1_1;
        }

        public String toString() {
            return this.name;
        }
    }

    static final class VersionFilter
    implements Filter {
        private VersionInfo version;

        /*
         * WARNING - void declaration
         */
        VersionFilter(VersionInfo version) {
            void var1_1;
            this.version = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(int ch222) {
            void var1_4;
            if (ch222 < 0 || ch222 > 0x10FFFF) {
                throw new IllegalArgumentException("Codepoint out of bounds");
            }
            UCharacterProperty ch222 = UCharacterProperty.INSTANCE;
            int n = ch222;
            int ch222 = ch222.getAdditional(n, 0) >> 24;
            VersionInfo v = VersionInfo.getInstance(ch222 >> 4 & 0xF, ch222 & 0xF, 0, 0);
            return !Utility.sameObjects(v, NO_VERSION) && var1_4.compareTo(this.version) <= 0;
        }
    }

    static final class ScriptExtensionsFilter
    implements Filter {
        private int script;

        /*
         * WARNING - void declaration
         */
        ScriptExtensionsFilter(int script) {
            void var1_1;
            this.script = var1_1;
        }

        @Override
        public final boolean contains(int c) {
            return UScript.hasScript(c, this.script);
        }
    }

    static final class IntPropertyFilter
    implements Filter {
        private int prop;
        private int value;

        /*
         * WARNING - void declaration
         */
        IntPropertyFilter(int prop, int value) {
            void var2_2;
            void var1_1;
            this.prop = var1_1;
            this.value = var2_2;
        }

        @Override
        public final boolean contains(int ch) {
            return AnimationSpecKt.getIntPropertyValue((int)ch, (int)this.prop) == this.value;
        }
    }

    static final class GeneralCategoryMaskFilter
    implements Filter {
        private int mask;

        /*
         * WARNING - void declaration
         */
        GeneralCategoryMaskFilter(int mask) {
            void var1_1;
            this.mask = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(int ch) {
            void var1_1;
            return (1 << UCharacterProperty.INSTANCE.getType((int)var1_1) & this.mask) != 0;
        }
    }

    static final class NumericValueFilter
    implements Filter {
        private double value;

        /*
         * WARNING - void declaration
         */
        NumericValueFilter(double value) {
            void var1_1;
            this.value = var1_1;
        }

        @Override
        public final boolean contains(int ch) {
            int n = ch;
            return UCharacterProperty.INSTANCE.getUnicodeNumericValue(n) == this.value;
        }
    }

    static interface Filter {
        public boolean contains(int var1);
    }
}

