/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import java.util.ArrayList;

public final class BytesTrie
implements Cloneable,
Iterable<Entry> {
    private static Result[] valueResults_ = new Result[]{Result.INTERMEDIATE_VALUE, Result.FINAL_VALUE};
    private byte[] bytes_;
    private int root_;
    private int pos_;
    private int remainingMatchLength_;

    /*
     * WARNING - void declaration
     */
    public BytesTrie(byte[] trieBytes, int offset) {
        void var2_2;
        void var1_1;
        this.bytes_ = var1_1;
        BytesTrie bytesTrie = this;
        bytesTrie.pos_ = bytesTrie.root_ = var2_2;
        this.remainingMatchLength_ = -1;
    }

    /*
     * WARNING - void declaration
     */
    public final Result first(int inByte) {
        void var1_1;
        this.remainingMatchLength_ = -1;
        if (inByte < 0) {
            inByte += 256;
        }
        BytesTrie bytesTrie = this;
        return bytesTrie.nextImpl(bytesTrie.root_, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final Result next(int inByte) {
        void var2_3;
        void var1_1;
        int length;
        int pos = this.pos_;
        if (pos < 0) {
            return Result.NO_MATCH;
        }
        if (inByte < 0) {
            inByte += 256;
        }
        if ((length = this.remainingMatchLength_) >= 0) {
            if (inByte == (this.bytes_[pos++] & 0xFF)) {
                int node;
                void var3_4;
                this.remainingMatchLength_ = --length;
                this.pos_ = pos;
                if (var3_4 < 0 && (node = this.bytes_[pos] & 0xFF) >= 32) {
                    return valueResults_[var1_1 & 1];
                }
                return Result.NO_VALUE;
            }
            BytesTrie bytesTrie = this;
            this.pos_ = -1;
            return Result.NO_MATCH;
        }
        return this.nextImpl((int)var2_3, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final int getValue() {
        void var2_2;
        void var1_1;
        int pos = this.pos_;
        int leadByte = this.bytes_[pos++] & 0xFF;
        assert (leadByte >= 32);
        return BytesTrie.readValue(this.bytes_, (int)var1_1, (int)(var2_2 >> 1));
    }

    /*
     * WARNING - void declaration
     */
    private static int readValue(byte[] bytes, int pos, int leadByte) {
        void var0_1;
        void var1_2;
        void var2_3;
        byte[] value22;
        int value22 = leadByte < 81 ? leadByte - 16 : (leadByte < 108 ? leadByte - 81 << 8 | value22[pos] & 0xFF : (leadByte < 126 ? leadByte - 108 << 16 | (value22[pos] & 0xFF) << 8 | value22[pos + 1] & 0xFF : (var2_3 == 126 ? (value22[pos] & 0xFF) << 16 | (value22[pos + 1] & 0xFF) << 8 | value22[pos + 2] & 0xFF : value22[pos] << 24 | (value22[pos + 1] & 0xFF) << 16 | (value22[pos + 2] & 0xFF) << 8 | value22[var1_2 + 3] & 0xFF)));
        return (int)var0_1;
    }

    /*
     * WARNING - void declaration
     */
    private static int skipValue(int pos, int leadByte) {
        int n;
        assert (leadByte >= 32);
        if (leadByte >= 162) {
            void var1_1;
            pos = leadByte < 216 ? ++pos : (leadByte < 252 ? (pos += 2) : (pos += 3 + (var1_1 >> 1 & 1)));
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static int jumpByDelta(byte[] bytes, int pos) {
        void var2_2;
        void var1_1;
        int delta;
        if ((delta = bytes[pos++] & 0xFF) >= 192) {
            if (delta < 240) {
                delta = delta - 192 << 8 | bytes[pos++] & 0xFF;
            } else if (delta < 254) {
                delta = delta - 240 << 16 | (bytes[pos] & 0xFF) << 8 | bytes[pos + 1] & 0xFF;
                pos += 2;
            } else if (delta == 254) {
                delta = (bytes[pos] & 0xFF) << 16 | (bytes[pos + 1] & 0xFF) << 8 | bytes[pos + 2] & 0xFF;
                pos += 3;
            } else {
                byte[] byArray;
                delta = bytes[pos] << 24 | (bytes[pos + 1] & 0xFF) << 16 | (bytes[pos + 2] & 0xFF) << 8 | byArray[pos + 3] & 0xFF;
                pos += 4;
            }
        }
        return (int)(var1_1 + var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static int skipDelta(byte[] bytes, int pos) {
        void var1_2;
        int delta;
        if ((delta = bytes[pos++] & 0xFF) >= 192) {
            void var0_1;
            pos = delta < 240 ? ++pos : (delta < 254 ? (pos += 2) : (pos += 3 + (var0_1 & 1)));
        }
        return (int)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private Result branchNext(int pos222, int length, int inByte) {
        void var3_6;
        int pos222;
        int node;
        void result3;
        if (length == 0) {
            length = this.bytes_[pos222++] & 0xFF;
        }
        ++length;
        while (length > 5) {
            if (inByte < (this.bytes_[pos222++] & 0xFF)) {
                length >>= 1;
                pos222 = BytesTrie.jumpByDelta(this.bytes_, pos222);
                continue;
            }
            int n = length;
            length = n - (n >> 1);
            pos222 = BytesTrie.skipDelta(this.bytes_, pos222);
        }
        do {
            if (inByte == (this.bytes_[pos222++] & 0xFF)) {
                Result result2;
                node = this.bytes_[pos222] & 0xFF;
                assert (node >= 32);
                if ((node & 1) != 0) {
                    result2 = Result.FINAL_VALUE;
                } else {
                    int delta;
                    ++pos222;
                    if ((node >>= 1) < 81) {
                        delta = node - 16;
                    } else if (delta < 108) {
                        delta = delta - 81 << 8 | this.bytes_[pos222++] & 0xFF;
                    } else if (delta < 126) {
                        delta = delta - 108 << 16 | (this.bytes_[pos222] & 0xFF) << 8 | this.bytes_[pos222 + 1] & 0xFF;
                        pos222 += 2;
                    } else if (delta == 126) {
                        delta = (this.bytes_[pos222] & 0xFF) << 16 | (this.bytes_[pos222 + 1] & 0xFF) << 8 | this.bytes_[pos222 + 2] & 0xFF;
                        pos222 += 3;
                    } else {
                        delta = this.bytes_[pos222] << 24 | (this.bytes_[pos222 + 1] & 0xFF) << 16 | (this.bytes_[pos222 + 2] & 0xFF) << 8 | this.bytes_[pos222 + 3] & 0xFF;
                        pos222 += 4;
                    }
                    pos222 += delta;
                    delta = this.bytes_[pos222] & 0xFF;
                    result2 = delta >= 32 ? valueResults_[delta & 1] : Result.NO_VALUE;
                }
                Result result3 = result2;
                this.pos_ = pos222;
                return result3;
            }
            int n = pos222;
            byte[] pos222 = this.bytes_;
            pos222 = this.bytes_[n++] & 0xFF;
            pos222 = BytesTrie.skipValue(n, pos222);
        } while (--result3 > true);
        if (var3_6 == (this.bytes_[pos222++] & 0xFF)) {
            void var1_1;
            this.pos_ = pos222;
            node = this.bytes_[var1_1] & 0xFF;
            if (node >= 32) {
                void var2_4;
                return valueResults_[var2_4 & 1];
            }
            return Result.NO_VALUE;
        }
        BytesTrie bytesTrie = this;
        this.pos_ = -1;
        return Result.NO_MATCH;
    }

    private Result nextImpl(int pos, int inByte) {
        block5: {
            while (true) {
                int n;
                int node;
                if ((node = this.bytes_[pos++] & 0xFF) < 16) {
                    return this.branchNext(pos, node, inByte);
                }
                if (node < 32) {
                    int length = node - 16;
                    if (inByte == (this.bytes_[pos++] & 0xFF)) {
                        this.remainingMatchLength_ = --length;
                        this.pos_ = pos;
                        if (n < 0 && (n = this.bytes_[pos] & 0xFF) >= 32) {
                            return valueResults_[n & 1];
                        }
                        return Result.NO_VALUE;
                    }
                    break block5;
                }
                if ((n & 1) != 0) break block5;
                pos = BytesTrie.skipValue(pos, n);
                assert ((this.bytes_[pos] & 0xFF) < 32);
            }
        }
        BytesTrie bytesTrie = this;
        this.pos_ = -1;
        return Result.NO_MATCH;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$900(byte[] x0, int x1, int x2) {
        void var2_2;
        void var1_1;
        return BytesTrie.readValue(x0, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$1100(int x0, int x1) {
        void var1_1;
        return BytesTrie.skipValue(x0, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$1200(byte[] x0, int x1) {
        void var1_1;
        return BytesTrie.skipDelta(x0, (int)var1_1);
    }

    public static final class Iterator
    implements java.util.Iterator<Entry> {
        private byte[] bytes_;
        private int pos_;
        private int remainingMatchLength_;
        private int maxLength_;
        private Entry entry_;
        private ArrayList<Long> stack_ = new ArrayList();

        /*
         * WARNING - void declaration
         */
        private Iterator(byte[] trieBytes, int offset, int remainingMatchLength, int maxStringLength) {
            void var3_4;
            void var2_3;
            this.bytes_ = trieBytes;
            this.pos_ = var2_3;
            this.remainingMatchLength_ = var3_4;
            this.maxLength_ = maxStringLength;
            this.entry_ = new Entry(this.maxLength_ != 0 ? this.maxLength_ : 32, 0);
            int length = this.remainingMatchLength_;
            if (length >= 0) {
                void var1_2;
                if (this.maxLength_ > 0 && ++length > this.maxLength_) {
                    length = this.maxLength_;
                }
                Entry.access$600(this.entry_, this.bytes_, this.pos_, length);
                this.pos_ += length;
                this.remainingMatchLength_ -= var1_2;
            }
        }

        @Override
        public final boolean hasNext() {
            return this.pos_ >= 0 || !this.stack_.isEmpty();
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        private Entry truncateAndStop() {
            this.pos_ = -1;
            return this.entry_;
        }

        /*
         * WARNING - void declaration
         */
        private int branchNext(int pos, int length) {
            void var1_1;
            void var3_3;
            void var2_2;
            int node;
            while (length > 5) {
                int n = length;
                this.stack_.add((long)BytesTrie.access$1200(this.bytes_, ++pos) << 32 | (long)(n - (n >> 1) << 16) | (long)this.entry_.length);
                length >>= 1;
                pos = BytesTrie.jumpByDelta(this.bytes_, pos);
            }
            byte trieByte = this.bytes_[pos++];
            boolean isFinal = ((node = this.bytes_[pos++] & 0xFF) & 1) != 0;
            int value = BytesTrie.access$900(this.bytes_, pos, node >> 1);
            pos = BytesTrie.access$1100(pos, node);
            this.stack_.add((long)pos << 32 | (long)(var2_2 - true << 16) | (long)this.entry_.length);
            Entry.access$800(this.entry_, (byte)var3_3);
            if (isFinal) {
                this.pos_ = -1;
                return -1;
            }
            return (int)(var1_1 + value);
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ Iterator(byte[] x0, int x1, int x2, int x3, byte by) {
            this((byte[])var1_1, (int)var2_2, (int)var3_3, 0);
            void var3_3;
            void var2_2;
            void var1_1;
        }
    }

    public static final class Entry {
        private byte[] bytes;
        private int length;

        /*
         * WARNING - void declaration
         */
        private Entry(int capacity) {
            void var1_1;
            this.bytes = new byte[var1_1];
        }

        /*
         * WARNING - void declaration
         */
        private void ensureCapacity(int len) {
            if (this.bytes.length < len) {
                void var1_2;
                byte[] newBytes = new byte[Math.min(2 * this.bytes.length, 2 * len)];
                System.arraycopy(this.bytes, 0, newBytes, 0, this.length);
                this.bytes = var1_2;
            }
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ Entry(int x0, byte by) {
            this((int)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$600(Entry x0, byte[] x1, int x2, int x3) {
            void var2_2;
            void var1_1;
            void var3_3;
            Entry entry = x0;
            entry.ensureCapacity(entry.length + var3_3);
            System.arraycopy(var1_1, (int)var2_2, entry.bytes, entry.length, (int)var3_3);
            entry.length += var3_3;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$700(Entry x0, int x1) {
            void var1_1;
            Entry entry = x0;
            x0.length = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$800(Entry x0, byte x1) {
            void var1_1;
            Entry entry = x0;
            entry.ensureCapacity(entry.length + 1);
            entry.bytes[entry.length++] = var1_1;
        }
    }

    public static final class Result
    extends Enum<Result> {
        public static final /* enum */ Result NO_MATCH = new Result();
        public static final /* enum */ Result NO_VALUE = new Result();
        public static final /* enum */ Result FINAL_VALUE = new Result();
        public static final /* enum */ Result INTERMEDIATE_VALUE = new Result();

        public final boolean hasValue() {
            return this.ordinal() >= 2;
        }

        public final boolean hasNext() {
            return (this.ordinal() & 1) != 0;
        }

        static {
            Result[] resultArray = new Result[]{NO_MATCH, NO_VALUE, FINAL_VALUE, INTERMEDIATE_VALUE};
        }
    }
}

