/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import androidx.compose.animation.core.AnimationSpecKt;
import com.ibm.icu.util.BytesTrie;
import java.util.ArrayList;

public final class CharsTrie
implements Cloneable,
Iterable<Entry> {
    private static BytesTrie.Result[] valueResults_ = new BytesTrie.Result[]{BytesTrie.Result.INTERMEDIATE_VALUE, BytesTrie.Result.FINAL_VALUE};
    private CharSequence chars_;
    private int root_;
    private int pos_;
    private int remainingMatchLength_;

    /*
     * WARNING - void declaration
     */
    public CharsTrie(CharSequence trieChars, int offset) {
        void var1_1;
        this.chars_ = var1_1;
        CharsTrie charsTrie = this;
        charsTrie.root_ = 0;
        charsTrie.pos_ = 0;
        this.remainingMatchLength_ = -1;
    }

    public final CharsTrie clone() throws CloneNotSupportedException {
        return (CharsTrie)super.clone();
    }

    public final CharsTrie reset() {
        this.pos_ = this.root_;
        this.remainingMatchLength_ = -1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final BytesTrie.Result first(int inUnit) {
        void var1_1;
        this.remainingMatchLength_ = -1;
        CharsTrie charsTrie = this;
        return charsTrie.nextImpl(charsTrie.root_, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final BytesTrie.Result next(int inUnit) {
        void var2_3;
        void var1_1;
        int pos = this.pos_;
        if (pos < 0) {
            return BytesTrie.Result.NO_MATCH;
        }
        int length = this.remainingMatchLength_;
        if (length >= 0) {
            if (inUnit == this.chars_.charAt(pos++)) {
                char node;
                void var3_4;
                this.remainingMatchLength_ = --length;
                this.pos_ = pos;
                if (var3_4 < 0 && (node = this.chars_.charAt(pos)) >= '@') {
                    return valueResults_[var1_1 >> 15];
                }
                return BytesTrie.Result.NO_VALUE;
            }
            CharsTrie charsTrie = this;
            this.pos_ = -1;
            return BytesTrie.Result.NO_MATCH;
        }
        return this.nextImpl((int)var2_3, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final BytesTrie.Result nextForCodePoint(int cp) {
        if (cp <= 65535) {
            return this.next(cp);
        }
        if (this.next(AnimationSpecKt.getLeadSurrogate((int)cp)).hasNext()) {
            void var1_1;
            return this.next(AnimationSpecKt.getTrailSurrogate((int)var1_1));
        }
        return BytesTrie.Result.NO_MATCH;
    }

    /*
     * WARNING - void declaration
     */
    public final int getValue() {
        void var2_2;
        void var1_1;
        int pos = this.pos_;
        char leadUnit = this.chars_.charAt(pos++);
        assert (leadUnit >= '@');
        if ((leadUnit & 0x8000) != 0) {
            return CharsTrie.readValue(this.chars_, pos, leadUnit & Short.MAX_VALUE);
        }
        return CharsTrie.readNodeValue(this.chars_, (int)var1_1, (int)var2_2);
    }

    public final Iterator iterator() {
        return new Iterator(this.chars_, this.pos_, this.remainingMatchLength_, 0, 0);
    }

    /*
     * WARNING - void declaration
     */
    private static int readValue(CharSequence chars, int pos, int leadUnit) {
        void var0_1;
        void var1_2;
        CharSequence value;
        void var2_3;
        int value2 = leadUnit < 16384 ? leadUnit : (leadUnit < Short.MAX_VALUE ? var2_3 - 16384 << 16 | value.charAt(pos) : value.charAt(pos) << 16 | value.charAt((int)(var1_2 + true)));
        return (int)var0_1;
    }

    /*
     * WARNING - void declaration
     */
    private static int skipValue(int pos, int leadUnit) {
        int n;
        if (leadUnit >= 16384) {
            void var1_1;
            pos = var1_1 < Short.MAX_VALUE ? ++pos : (pos += 2);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private static int readNodeValue(CharSequence chars, int pos, int leadUnit) {
        void var0_1;
        void var1_2;
        CharSequence value;
        void var2_3;
        assert (64 <= leadUnit && leadUnit < 32768);
        int value2 = leadUnit < 16448 ? (leadUnit >> 6) - 1 : (leadUnit < 32704 ? (var2_3 & 0x7FC0) - 16448 << 10 | value.charAt(pos) : value.charAt(pos) << 16 | value.charAt((int)(var1_2 + true)));
        return (int)var0_1;
    }

    /*
     * WARNING - void declaration
     */
    private static int skipNodeValue(int pos, int leadUnit) {
        int n;
        assert (64 <= leadUnit && leadUnit < 32768);
        if (leadUnit >= 16448) {
            void var1_1;
            pos = var1_1 < 32704 ? ++pos : (pos += 2);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private static int jumpByDelta(CharSequence chars, int pos) {
        void var2_2;
        void var1_1;
        int delta;
        if ((delta = chars.charAt(pos++)) >= 64512) {
            if (delta == 65535) {
                delta = chars.charAt(pos) << 16 | chars.charAt(pos + 1);
                pos += 2;
            } else {
                CharSequence charSequence;
                delta = delta - 64512 << 16 | charSequence.charAt(pos++);
            }
        }
        return (int)(var1_1 + var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static int skipDelta(CharSequence chars, int pos) {
        void var1_2;
        char delta;
        if ((delta = chars.charAt(pos++)) >= '\ufc00') {
            void var0_1;
            pos = var0_1 == 65535 ? (pos += 2) : ++pos;
        }
        return (int)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private BytesTrie.Result branchNext(int pos222, int length, int inUnit) {
        void var3_6;
        int pos222;
        char node;
        void result3;
        if (length == 0) {
            length = this.chars_.charAt(pos222++);
        }
        ++length;
        while (length > 5) {
            if (inUnit < this.chars_.charAt(pos222++)) {
                length >>= 1;
                pos222 = CharsTrie.jumpByDelta(this.chars_, pos222);
                continue;
            }
            int n = length;
            length = n - (n >> 1);
            pos222 = CharsTrie.skipDelta(this.chars_, pos222);
        }
        do {
            if (inUnit == this.chars_.charAt(pos222++)) {
                BytesTrie.Result result2;
                node = this.chars_.charAt(pos222);
                if ((node & 0x8000) != 0) {
                    result2 = BytesTrie.Result.FINAL_VALUE;
                } else {
                    int delta;
                    ++pos222;
                    if (node >= '\u4000') {
                        if (delta < Short.MAX_VALUE) {
                            delta = delta - 16384 << 16 | this.chars_.charAt(pos222++);
                        } else {
                            delta = this.chars_.charAt(pos222) << 16 | this.chars_.charAt(pos222 + 1);
                            pos222 += 2;
                        }
                    }
                    result2 = (delta = this.chars_.charAt(pos222 += delta)) >= 64 ? valueResults_[delta >> 15] : BytesTrie.Result.NO_VALUE;
                }
                BytesTrie.Result result3 = result2;
                this.pos_ = pos222;
                return result3;
            }
            int n = pos222;
            CharSequence pos222 = this.chars_;
            pos222 = pos222.charAt(n++);
            pos222 = CharsTrie.skipValue(n, pos222 & Short.MAX_VALUE);
        } while (--result3 > true);
        if (var3_6 == this.chars_.charAt(pos222++)) {
            void var1_1;
            this.pos_ = pos222;
            node = this.chars_.charAt((int)var1_1);
            if (node >= '@') {
                void var2_4;
                return valueResults_[var2_4 >> 15];
            }
            return BytesTrie.Result.NO_VALUE;
        }
        CharsTrie charsTrie = this;
        this.pos_ = -1;
        return BytesTrie.Result.NO_MATCH;
    }

    private BytesTrie.Result nextImpl(int pos, int inUnit) {
        char node = this.chars_.charAt(pos++);
        while (true) {
            int n;
            if (node < '0') {
                return this.branchNext(pos, node, inUnit);
            }
            if (node < '@') {
                int length = node - 48;
                if (inUnit != this.chars_.charAt(pos++)) break;
                this.remainingMatchLength_ = --length;
                this.pos_ = pos;
                if (n < 0) {
                    char c = this.chars_.charAt(pos);
                    n = c;
                    if (c >= '@') {
                        return valueResults_[n >> 15];
                    }
                }
                return BytesTrie.Result.NO_VALUE;
            }
            if ((n & 0x8000) != 0) break;
            pos = CharsTrie.skipNodeValue(pos, n);
            n &= 0x3F;
        }
        CharsTrie charsTrie = this;
        this.pos_ = -1;
        return BytesTrie.Result.NO_MATCH;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$500(int x0, int x1) {
        void var1_1;
        return CharsTrie.skipNodeValue(x0, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$600(CharSequence x0, int x1, int x2) {
        void var2_2;
        void var1_1;
        return CharsTrie.readValue(x0, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$700(CharSequence x0, int x1, int x2) {
        void var2_2;
        void var1_1;
        return CharsTrie.readNodeValue(x0, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$800(CharSequence x0, int x1) {
        void var1_1;
        return CharsTrie.skipDelta(x0, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$900(CharSequence x0, int x1) {
        void var1_1;
        return CharsTrie.jumpByDelta(x0, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$1000(int x0, int x1) {
        void var1_1;
        return CharsTrie.skipValue(x0, (int)var1_1);
    }

    public static final class Iterator
    implements java.util.Iterator<Entry> {
        private CharSequence chars_;
        private int pos_;
        private int remainingMatchLength_;
        private boolean skipValue_;
        private StringBuilder str_ = new StringBuilder();
        private int maxLength_;
        private Entry entry_ = new Entry(0);
        private ArrayList<Long> stack_ = new ArrayList();

        /*
         * WARNING - void declaration
         */
        private Iterator(CharSequence trieChars, int offset, int remainingMatchLength, int maxStringLength) {
            void var3_4;
            void var2_3;
            this.chars_ = trieChars;
            this.pos_ = var2_3;
            this.remainingMatchLength_ = var3_4;
            this.maxLength_ = maxStringLength;
            int length = this.remainingMatchLength_;
            if (length >= 0) {
                void var1_2;
                if (this.maxLength_ > 0 && ++length > this.maxLength_) {
                    length = this.maxLength_;
                }
                this.str_.append(this.chars_, this.pos_, this.pos_ + length);
                this.pos_ += length;
                this.remainingMatchLength_ -= var1_2;
            }
        }

        @Override
        public final boolean hasNext() {
            return this.pos_ >= 0 || !this.stack_.isEmpty();
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        private Entry truncateAndStop() {
            this.pos_ = -1;
            this.entry_.chars = this.str_;
            return this.entry_;
        }

        /*
         * WARNING - void declaration
         */
        private int branchNext(int pos, int length) {
            void var1_1;
            void var3_3;
            void var2_2;
            int node;
            while (length > 5) {
                int n = length;
                this.stack_.add((long)CharsTrie.access$800(this.chars_, ++pos) << 32 | (long)(n - (n >> 1) << 16) | (long)this.str_.length());
                length >>= 1;
                pos = CharsTrie.access$900(this.chars_, pos);
            }
            char trieUnit = this.chars_.charAt(pos++);
            boolean isFinal = ((node = this.chars_.charAt(pos++)) & 0x8000) != 0;
            int value = CharsTrie.access$600(this.chars_, pos, node &= Short.MAX_VALUE);
            pos = CharsTrie.access$1000(pos, node);
            this.stack_.add((long)pos << 32 | (long)(var2_2 - true << 16) | (long)this.str_.length());
            this.str_.append((char)var3_3);
            if (isFinal) {
                this.pos_ = -1;
                this.entry_.chars = this.str_;
                return -1;
            }
            return (int)(var1_1 + value);
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ Iterator(CharSequence x0, int x1, int x2, int x3, byte by) {
            this((CharSequence)var1_1, (int)var2_2, (int)var3_3, 0);
            void var3_3;
            void var2_2;
            void var1_1;
        }
    }

    public static final class Entry {
        public CharSequence chars;

        private Entry() {
        }

        /* synthetic */ Entry(byte by) {
            this();
        }
    }
}

