/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import com.ibm.icu.util.CodePointMap;
import com.ibm.icu.util.CodePointTrie;
import java.util.Arrays;

public final class MutableCodePointTrie
extends CodePointMap
implements Cloneable {
    private int[] index;
    private int index3NullOffset = -1;
    private int[] data;
    private int dataLength;
    private int dataNullOffset = -1;
    private int origInitialValue = 0;
    private int initialValue = 0;
    private int errorValue = 0;
    private int highStart;
    private int highValue = 0;
    private char[] index16;
    private byte[] flags = new byte[69632];

    public MutableCodePointTrie(int initialValue, int errorValue) {
        this.index = new int[4096];
        this.data = new int[16384];
    }

    /*
     * WARNING - void declaration
     */
    private MutableCodePointTrie clone() {
        try {
            void var1_1;
            MutableCodePointTrie builder = (MutableCodePointTrie)super.clone();
            int iCapacity = this.highStart <= 65536 ? 4096 : 69632;
            builder.index = new int[iCapacity];
            builder.flags = new byte[69632];
            int iLimit = this.highStart >> 4;
            for (int i = 0; i < iLimit; ++i) {
                builder.index[i] = this.index[i];
                builder.flags[i] = this.flags[i];
            }
            builder.index3NullOffset = this.index3NullOffset;
            builder.data = (int[])this.data.clone();
            builder.dataLength = this.dataLength;
            builder.dataNullOffset = this.dataNullOffset;
            builder.origInitialValue = this.origInitialValue;
            builder.initialValue = this.initialValue;
            builder.errorValue = this.errorValue;
            builder.highStart = this.highStart;
            builder.highValue = this.highValue;
            assert (this.index16 == null);
            return var1_1;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    private void clear() {
        MutableCodePointTrie mutableCodePointTrie = this;
        mutableCodePointTrie.dataNullOffset = -1;
        mutableCodePointTrie.index3NullOffset = -1;
        this.dataLength = 0;
        MutableCodePointTrie mutableCodePointTrie2 = this;
        mutableCodePointTrie2.highValue = mutableCodePointTrie2.initialValue = this.origInitialValue;
        this.highStart = 0;
        this.index16 = null;
    }

    /*
     * WARNING - void declaration
     */
    public final int get(int c) {
        void var1_1;
        void var2_2;
        if (c < 0 || 0x10FFFF < c) {
            return this.errorValue;
        }
        if (c >= this.highStart) {
            return this.highValue;
        }
        int i = c >> 4;
        if (this.flags[i] == 0) {
            return this.index[i];
        }
        return this.data[this.index[var2_2] + (var1_1 & 0xF)];
    }

    /*
     * WARNING - void declaration
     */
    private static final int maybeFilterValue(int value, int initialValue, int nullValue, CodePointMap.ValueFilter filter) {
        int n;
        void var1_1;
        if (value == var1_1) {
            void var2_2;
            value = var2_2;
        } else if (filter != null) {
            void var3_3;
            value = var3_3.apply(value);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean getRange(int start, CodePointMap.ValueFilter filter, CodePointMap.Range range) {
        void var2_2;
        if (start < 0 || 0x10FFFF < start) {
            return false;
        }
        if (start >= this.highStart) {
            int value = this.highValue;
            if (filter != null) {
                value = filter.apply(value);
            }
            range.set(start, 0x10FFFF, value);
            return true;
        }
        int nullValue = this.initialValue;
        if (filter != null) {
            nullValue = filter.apply(nullValue);
        }
        int c = start;
        int trieValue = 0;
        int value = 0;
        boolean haveValue = false;
        int i = c >> 4;
        do {
            if (this.flags[i] == 0) {
                int trieValue2 = this.index[i];
                if (haveValue) {
                    if (trieValue2 != trieValue) {
                        if (filter == null || MutableCodePointTrie.maybeFilterValue(trieValue2, this.initialValue, nullValue, filter) != value) {
                            range.set(start, c - 1, value);
                            return true;
                        }
                        trieValue = trieValue2;
                    }
                } else {
                    trieValue = trieValue2;
                    value = MutableCodePointTrie.maybeFilterValue(trieValue2, this.initialValue, nullValue, filter);
                    haveValue = true;
                }
                c = c + 16 & 0xFFFFFFF0;
            } else {
                int di = this.index[i] + (c & 0xF);
                int trieValue2 = this.data[di];
                if (haveValue) {
                    if (trieValue2 != trieValue) {
                        if (filter == null || MutableCodePointTrie.maybeFilterValue(trieValue2, this.initialValue, nullValue, filter) != value) {
                            range.set(start, c - 1, value);
                            return true;
                        }
                        trieValue = trieValue2;
                    }
                } else {
                    trieValue = trieValue2;
                    value = MutableCodePointTrie.maybeFilterValue(trieValue2, this.initialValue, nullValue, filter);
                    haveValue = true;
                }
                while ((++c & 0xF) != 0) {
                    if ((trieValue2 = this.data[++di]) == trieValue) continue;
                    if (filter == null || MutableCodePointTrie.maybeFilterValue(trieValue2, this.initialValue, nullValue, filter) != value) {
                        range.set(start, c - 1, value);
                        return true;
                    }
                    trieValue = trieValue2;
                }
            }
            ++i;
        } while (c < this.highStart);
        assert (haveValue);
        if (MutableCodePointTrie.maybeFilterValue(this.highValue, this.initialValue, nullValue, (CodePointMap.ValueFilter)var2_2) != value) {
            range.set(start, c - 1, value);
        } else {
            void var1_1;
            void var3_3;
            var3_3.set((int)var1_1, 0x10FFFF, value);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void writeBlock(int block, int value) {
        void var2_2;
        void var3_3;
        void var1_1;
        int limit = block + 16;
        Arrays.fill(this.data, (int)var1_1, (int)var3_3, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void set(int c, int value) {
        void var2_2;
        if (c < 0 || 0x10FFFF < c) {
            throw new IllegalArgumentException("invalid code point");
        }
        this.ensureHighStart(c);
        int block = this.getDataBlock(c >> 4);
        this.data[var3_3 + (var1_1 & 0xF)] = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final CodePointTrie buildImmutable(CodePointTrie.Type type, CodePointTrie.ValueWidth valueWidth) {
        if (type == null || valueWidth == null) {
            throw new IllegalArgumentException("The type and valueWidth must be specified.");
        }
        try {
            void var2_3;
            CodePointTrie codePointTrie;
            codePointTrie = this.build((CodePointTrie.Type)((Object)codePointTrie), (CodePointTrie.ValueWidth)var2_3);
            return codePointTrie;
        }
        finally {
            this.clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void ensureHighStart(int c) {
        if (c >= this.highStart) {
            void var1_1;
            c = c + 512 & 0xFFFFFE00;
            int i = this.highStart >> 4;
            int iLimit = c >> 4;
            if (iLimit > this.index.length) {
                int[] newIndex = new int[69632];
                for (int j = 0; j < i; ++j) {
                    newIndex[j] = this.index[j];
                }
                this.index = newIndex;
            }
            do {
                this.flags[i] = 0;
                this.index[i] = this.initialValue;
            } while (++i < iLimit);
            this.highStart = var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    private int allocDataBlock(int blockLength) {
        void var2_2;
        void var1_1;
        int newBlock = this.dataLength;
        int newTop = newBlock + blockLength;
        if (newTop > this.data.length) {
            void var3_4;
            int capacity;
            if (this.data.length < 131072) {
                capacity = 131072;
            } else if (this.data.length < 0x110000) {
                capacity = 0x110000;
            } else {
                throw new AssertionError();
            }
            int[] newData = new int[capacity];
            for (int j = 0; j < this.dataLength; ++j) {
                newData[j] = this.data[j];
            }
            this.data = var3_4;
        }
        this.dataLength = var1_1;
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private int getDataBlock(int i) {
        void var2_3;
        if (this.flags[i] == 1) {
            return this.index[i];
        }
        if (i < 4096) {
            int newBlock = this.allocDataBlock(64);
            int iStart = i & 0xFFFFFFFC;
            int iLimit = iStart + 4;
            do {
                assert (this.flags[iStart] == 0);
                this.writeBlock(newBlock, this.index[iStart]);
                this.flags[iStart] = 1;
                this.index[iStart++] = newBlock;
                newBlock += 16;
            } while (iStart < iLimit);
            return this.index[i];
        }
        int newBlock = this.allocDataBlock(16);
        if (newBlock < 0) {
            return newBlock;
        }
        this.writeBlock(newBlock, this.index[i]);
        this.flags[i] = 1;
        this.index[var1_1] = newBlock;
        return (int)var2_3;
    }

    private void maskValues(int mask) {
        int i;
        this.initialValue &= mask;
        this.errorValue &= mask;
        this.highValue &= mask;
        int iLimit = this.highStart >> 4;
        for (i = 0; i < iLimit; ++i) {
            if (this.flags[i] != 0) continue;
            int n = i;
            this.index[n] = this.index[n] & mask;
        }
        i = 0;
        while (i < this.dataLength) {
            int n = i++;
            this.data[n] = this.data[n] & mask;
        }
    }

    private static boolean equalBlocks(int[] s, int si, int[] t, int ti, int length) {
        while (length > 0 && s[si] == t[ti]) {
            ++si;
            ++ti;
            --length;
        }
        return length == 0;
    }

    private static boolean equalBlocks(char[] s, int si, int[] t, int ti, int length) {
        while (length > 0 && s[si] == t[ti]) {
            ++si;
            ++ti;
            --length;
        }
        return length == 0;
    }

    private static boolean equalBlocks(char[] s, int si, char[] t, int ti, int length) {
        while (length > 0 && s[si] == t[ti]) {
            ++si;
            ++ti;
            --length;
        }
        return length == 0;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean allValuesSameAs(int[] p, int pi, int length, int value) {
        void var2_2;
        void var1_1;
        int pLimit = pi + length;
        while (pi < pLimit && p[pi] == value) {
            ++pi;
        }
        return var1_1 == var2_2;
    }

    private static int findSameBlock(char[] p, int pStart, int length, char[] q, int qStart, int blockLength) {
        length -= blockLength;
        while (pStart <= length) {
            if (MutableCodePointTrie.equalBlocks(p, pStart, q, qStart, blockLength)) {
                return pStart;
            }
            ++pStart;
        }
        return -1;
    }

    private static int getOverlap(char[] p, int length, char[] q, int qStart, int blockLength) {
        int overlap;
        assert (overlap <= length);
        for (overlap = blockLength - 1; overlap > 0 && !MutableCodePointTrie.equalBlocks(p, length - overlap, q, qStart, overlap); --overlap) {
        }
        return overlap;
    }

    /*
     * WARNING - void declaration
     */
    private int findHighStart() {
        int i = this.highStart >> 4;
        while (i > 0) {
            void var2_2;
            int match;
            if (this.flags[--i] == 0) {
                match = this.index[i] == this.highValue ? 1 : 0;
            } else {
                int p = this.index[i];
                int j = 0;
                while (true) {
                    if (j == 16) {
                        match = 1;
                        break;
                    }
                    if (this.data[match + j] != this.highValue) {
                        match = 0;
                        break;
                    }
                    ++j;
                }
            }
            if (var2_2 != false) continue;
            return i + 1 << 4;
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    private int compactWholeDataBlocks(int fastILimit, AllSameBlocks allSameBlocks) {
        newDataCapacity = 128;
        newDataCapacity += 16;
        newDataCapacity += 4;
        iLimit = this.highStart >> 4;
        blockLength = 64;
        inc = 4;
        for (i = 0; i < iLimit; i += inc) {
            if (i == fastILimit) {
                blockLength = 16;
                inc = 1;
            }
            value = this.index[i];
            if (this.flags[i] != 1) ** GOTO lbl20
            p = value;
            if (MutableCodePointTrie.allValuesSameAs(this.data, p + 1, blockLength - 1, value = this.data[p])) {
                this.flags[i] = 0;
                this.index[i] = value;
            } else {
                newDataCapacity += blockLength;
                continue;
lbl20:
                // 1 sources

                if (!MutableCodePointTrie.$assertionsDisabled && this.flags[i] != 0) {
                    throw new AssertionError();
                }
                if (inc > 1) {
                    allSame = true;
                    next_i = i + inc;
                    for (j = i + 1; j < next_i; ++j) {
                        if (!MutableCodePointTrie.$assertionsDisabled && this.flags[j] != 0) {
                            throw new AssertionError();
                        }
                        if (this.index[j] == value) continue;
                        allSame = false;
                        break;
                    }
                    if (!allSame) {
                        if (this.getDataBlock(i) < 0) {
                            return -1;
                        }
                        newDataCapacity += blockLength;
                        continue;
                    }
                }
            }
            other = allSameBlocks.findOrAdd(i, inc, value);
            if (other == -2) {
                jInc = 4;
                j = 0;
                while (true) {
                    if (j == i) {
                        allSameBlocks.add(i, inc, value);
                        break;
                    }
                    if (j == fastILimit) {
                        jInc = 1;
                    }
                    if (this.flags[j] == 0 && this.index[j] == value) {
                        allSameBlocks.add(j, jInc + inc, value);
                        other = j;
                        break;
                    }
                    j += jInc;
                }
            }
            if (other >= 0) {
                this.flags[i] = 2;
                this.index[i] = other;
                continue;
            }
            newDataCapacity += blockLength;
        }
        return (int)var3_3;
    }

    private int compactData(int fastILimit, int[] newData, int dataNullIndex, MixedBlocks mixedBlocks) {
        int newDataLength = 0;
        int i = 0;
        while (newDataLength < 128) {
            this.index[i] = newDataLength;
            newDataLength += 64;
            i += 4;
        }
        int blockLength = 64;
        mixedBlocks.init(newData.length, 64);
        mixedBlocks.extend(newData, 0, 0, 128);
        int iLimit = this.highStart >> 4;
        int inc = 4;
        int fastLength = 0;
        for (int i2 = 8; i2 < iLimit; i2 += inc) {
            int prevDataLength22;
            int n;
            int n2;
            int n3;
            if (i2 == fastILimit) {
                blockLength = 16;
                inc = 1;
                fastLength = newDataLength;
                mixedBlocks.init(newData.length, 16);
                mixedBlocks.extend(newData, 0, 0, newDataLength);
            }
            if (this.flags[i2] == 0) {
                int n4;
                int value = this.index[i2];
                n3 = mixedBlocks.findAllSameBlock(newData, value);
                while (n3 >= 0 && i2 == dataNullIndex && i2 >= fastILimit && n3 < fastLength) {
                    int n5;
                    block19: {
                        boolean bl;
                        block18: {
                            n4 = fastILimit;
                            int[] nArray = this.index;
                            int n6 = n3;
                            for (n2 = 0; n2 < n4; n2 += 4) {
                                if (nArray[n2] != n6) continue;
                                bl = true;
                                break block18;
                            }
                            bl = false;
                        }
                        if (!bl) break;
                        int n7 = n3 + 1;
                        n3 = blockLength;
                        n2 = value;
                        n4 = newDataLength;
                        int n8 = n7;
                        int[] nArray = newData;
                        n4 -= n3;
                        block4: for (n = n8; n <= n4; ++n) {
                            if (nArray[n] != n2) continue;
                            n8 = 1;
                            while (true) {
                                if (n8 == n3) {
                                    n5 = n;
                                    break block19;
                                }
                                if (nArray[n + n8] != n2) {
                                    n += n8;
                                    continue block4;
                                }
                                ++n8;
                            }
                        }
                        n5 = -1;
                    }
                    n3 = n5;
                }
                if (n3 >= 0) {
                    this.index[i2] = n3;
                    continue;
                }
                n2 = blockLength;
                n4 = value;
                int n9 = newDataLength;
                int[] nArray = newData;
                n3 = n9 - (n2 - 1);
                for (n = n9; n3 < n && nArray[n - 1] == n4; --n) {
                }
                this.index[i2] = newDataLength - n3;
                prevDataLength22 = newDataLength;
                for (n3 = n9 - n; n3 < blockLength; ++n3) {
                    newData[newDataLength++] = value;
                }
                mixedBlocks.extend(newData, 0, prevDataLength22, newDataLength);
                continue;
            }
            if (this.flags[i2] == 1) {
                int block = this.index[i2];
                n3 = mixedBlocks.findBlock(newData, this.data, block);
                if (n3 >= 0) {
                    this.index[i2] = n3;
                    continue;
                }
                n3 = blockLength;
                n2 = block;
                int[] nArray = this.data;
                int n10 = newDataLength;
                int[] prevDataLength22 = newData;
                assert (n <= n10);
                for (n = n3 - 1; n > 0 && !MutableCodePointTrie.equalBlocks(prevDataLength22, n10 - n, nArray, n2, n); --n) {
                }
                n3 = n;
                this.index[i2] = newDataLength - n3;
                prevDataLength22 = newDataLength;
                while (n3 < blockLength) {
                    newData[newDataLength++] = this.data[block + n3++];
                }
                mixedBlocks.extend(newData, 0, prevDataLength22, newDataLength);
                continue;
            }
            int j = this.index[i2];
            this.index[i2] = this.index[j];
        }
        return newDataLength;
    }

    /*
     * WARNING - void declaration
     */
    private int compactIndex(int fastILimit, MixedBlocks mixedBlocks) {
        void var3_3;
        void var1_1;
        int n22;
        int index3Start;
        int fastIndexLength = fastILimit >> 2;
        if (this.highStart >> 6 <= fastIndexLength) {
            this.index3NullOffset = Short.MAX_VALUE;
            return fastIndexLength;
        }
        char[] fastIndex = new char[fastIndexLength];
        int i3FirstNull = -1;
        int i = 0;
        int j = 0;
        while (i < fastILimit) {
            int i3 = this.index[i];
            fastIndex[j] = (char)i3;
            if (i3 == this.dataNullOffset) {
                if (i3FirstNull < 0) {
                    i3FirstNull = j;
                } else if (this.index3NullOffset < 0 && j - i3FirstNull + 1 == 32) {
                    this.index3NullOffset = i3FirstNull;
                }
            } else {
                i3FirstNull = -1;
            }
            int iNext = i + 4;
            while (++i < iNext) {
                this.index[i] = i3 += 16;
            }
            ++j;
        }
        mixedBlocks.init(fastIndexLength, 32);
        mixedBlocks.extend(fastIndex, 0, 0, fastIndexLength);
        int index3Capacity = 0;
        i3FirstNull = this.index3NullOffset;
        boolean hasLongI3Blocks = false;
        int iStart = fastILimit < 4096 ? 0 : 4096;
        int iLimit = this.highStart >> 4;
        int i2 = iStart;
        while (i2 < iLimit) {
            int j2 = i2;
            int jLimit = i2 + 32;
            int oredI3 = 0;
            boolean isNull = true;
            do {
                int i3 = this.index[j2];
                oredI3 |= i3;
                if (i3 == this.dataNullOffset) continue;
                isNull = false;
            } while (++j2 < jLimit);
            if (isNull) {
                this.flags[i2] = 0;
                if (i3FirstNull < 0) {
                    if (oredI3 <= 65535) {
                        index3Capacity += 32;
                    } else {
                        index3Capacity += 36;
                        hasLongI3Blocks = true;
                    }
                    i3FirstNull = 0;
                }
            } else if (oredI3 <= 65535) {
                int n = mixedBlocks.findBlock(fastIndex, this.index, i2);
                if (n >= 0) {
                    this.flags[i2] = 1;
                    this.index[i2] = n;
                } else {
                    this.flags[i2] = 2;
                    index3Capacity += 32;
                }
            } else {
                this.flags[i2] = 3;
                index3Capacity += 36;
                hasLongI3Blocks = true;
            }
            i2 = j2;
        }
        int index2Capacity = iLimit - iStart >> 5;
        int index1Length = index2Capacity + 31 >> 5;
        int index16Capacity = fastIndexLength + index1Length + index3Capacity + index2Capacity + 1;
        this.index16 = Arrays.copyOf(fastIndex, index16Capacity);
        mixedBlocks.init(index16Capacity, 32);
        MixedBlocks longI3Blocks = null;
        if (hasLongI3Blocks) {
            longI3Blocks = new MixedBlocks(0);
            longI3Blocks.init(index16Capacity, 36);
        }
        char[] index2 = new char[index2Capacity];
        int i2Length = 0;
        i3FirstNull = this.index3NullOffset;
        int indexLength = index3Start = fastIndexLength + index1Length;
        for (int i3 = iStart; i3 < iLimit; i3 += 32) {
            int i32;
            int f = this.flags[i3];
            if (f == 0 && i3FirstNull < 0) {
                f = this.dataNullOffset <= 65535 ? 2 : 3;
                i3FirstNull = 0;
            }
            if (f == 0) {
                i32 = this.index3NullOffset;
            } else if (f == 1) {
                i32 = this.index[i3];
            } else if (f == 2) {
                n22 = mixedBlocks.findBlock(this.index16, this.index, i3);
                if (n22 >= 0) {
                    i32 = n22;
                } else {
                    if (indexLength == index3Start) {
                        n22 = 0;
                    } else {
                        int n;
                        i32 = 32;
                        int n3 = i3;
                        int[] n22 = this.index;
                        f = indexLength;
                        char[] i4 = this.index16;
                        assert (31 <= f);
                        for (n = 31; n > 0 && !MutableCodePointTrie.equalBlocks(i4, f - n, n22, n3, n); --n) {
                        }
                        n22 = n;
                    }
                    i32 = indexLength - n22;
                    int prevIndexLength = indexLength;
                    while (n22 < 32) {
                        this.index16[indexLength++] = (char)this.index[i3 + n22++];
                    }
                    mixedBlocks.extend(this.index16, index3Start, prevIndexLength, indexLength);
                    if (hasLongI3Blocks) {
                        longI3Blocks.extend(this.index16, index3Start, prevIndexLength, indexLength);
                    }
                }
            } else {
                assert (f == 3);
                assert (hasLongI3Blocks);
                int j3 = i3;
                int jLimit = i3 + 32;
                int k = indexLength;
                do {
                    int v = this.index[j3++];
                    int upperBits = (v & 0x30000) >> 2;
                    int n = ++k;
                    this.index16[n] = (char)v;
                    v = this.index[j3++];
                    upperBits |= (v & 0x30000) >> 4;
                    int n4 = ++k;
                    this.index16[n4] = (char)v;
                    v = this.index[j3++];
                    upperBits |= (v & 0x30000) >> 6;
                    int n5 = ++k;
                    this.index16[n5] = (char)v;
                    v = this.index[j3++];
                    upperBits |= (v & 0x30000) >> 8;
                    int n6 = ++k;
                    this.index16[n6] = (char)v;
                    v = this.index[j3++];
                    upperBits |= (v & 0x30000) >> 10;
                    int n7 = ++k;
                    this.index16[n7] = (char)v;
                    v = this.index[j3++];
                    upperBits |= (v & 0x30000) >> 12;
                    int n8 = ++k;
                    this.index16[n8] = (char)v;
                    v = this.index[j3++];
                    upperBits |= (v & 0x30000) >> 14;
                    int n9 = ++k;
                    this.index16[n9] = (char)v;
                    v = this.index[j3++];
                    int n10 = ++k;
                    this.index16[n10] = (char)v;
                    this.index16[++k - 9] = (char)(upperBits |= (v & 0x30000) >> 16);
                } while (j3 < jLimit);
                int n = longI3Blocks.findBlock(this.index16, this.index16, indexLength);
                if (n >= 0) {
                    i32 = n | 0x8000;
                } else {
                    n = indexLength == index3Start ? 0 : MutableCodePointTrie.getOverlap(this.index16, indexLength, this.index16, indexLength, 36);
                    i32 = indexLength - n | 0x8000;
                    int prevIndexLength = indexLength;
                    if (n > 0) {
                        int start = indexLength;
                        while (n < 36) {
                            this.index16[indexLength++] = this.index16[start + n++];
                        }
                    } else {
                        indexLength += 36;
                    }
                    mixedBlocks.extend(this.index16, index3Start, prevIndexLength, indexLength);
                    if (hasLongI3Blocks) {
                        longI3Blocks.extend(this.index16, index3Start, prevIndexLength, indexLength);
                    }
                }
            }
            if (this.index3NullOffset < 0 && i3FirstNull >= 0) {
                this.index3NullOffset = i32;
            }
            index2[i2Length++] = (char)i32;
        }
        assert (i2Length == var1_1);
        assert (indexLength <= index3Start + index3Capacity);
        if (this.index3NullOffset < 0) {
            this.index3NullOffset = Short.MAX_VALUE;
        }
        if (indexLength >= 32799) {
            throw new IndexOutOfBoundsException("The trie data exceeds limitations of the data structure.");
        }
        int blockLength = 32;
        void i1 = var3_3;
        for (int i4 = 0; i4 < i2Length; i4 += blockLength) {
            int i22;
            if (i2Length - i4 >= blockLength) {
                assert (blockLength == 32);
                n22 = mixedBlocks.findBlock(this.index16, index2, i4);
            } else {
                blockLength = i2Length - i4;
                n22 = MutableCodePointTrie.findSameBlock(this.index16, index3Start, indexLength, index2, i4, blockLength);
            }
            if (n22 >= 0) {
                i22 = n22;
            } else {
                n22 = indexLength == index3Start ? 0 : MutableCodePointTrie.getOverlap(this.index16, indexLength, index2, i4, blockLength);
                i22 = indexLength - n22;
                int prevIndexLength = indexLength;
                while (n22 < blockLength) {
                    this.index16[indexLength++] = index2[i4 + n22++];
                }
                mixedBlocks.extend(this.index16, index3Start, prevIndexLength, indexLength);
            }
            this.index16[i1++] = (char)i22;
        }
        assert (i1 == index3Start);
        assert (indexLength <= index16Capacity);
        return indexLength;
    }

    /*
     * WARNING - void declaration
     */
    private int compactTrie(int fastILimit) {
        void var1_1;
        int fastLimit;
        assert ((this.highStart & 0x1FF) == 0);
        this.highValue = this.get(0x10FFFF);
        int n = this.findHighStart();
        int realHighStart = n + 511 & 0xFFFFFE00;
        if (realHighStart == 0x110000) {
            this.highValue = this.initialValue;
        }
        if (realHighStart < (fastLimit = fastILimit << 4)) {
            for (int i = realHighStart >> 4; i < fastILimit; ++i) {
                this.flags[i] = 0;
                this.index[i] = this.highValue;
            }
            this.highStart = fastLimit;
        } else {
            this.highStart = realHighStart;
        }
        int[] asciiData = new int[128];
        for (int i = 0; i < 128; ++i) {
            asciiData[i] = this.get(i);
        }
        AllSameBlocks allSameBlocks = new AllSameBlocks();
        int newDataCapacity = this.compactWholeDataBlocks(fastILimit, allSameBlocks);
        int[] newData = Arrays.copyOf(asciiData, newDataCapacity);
        int dataNullIndex = allSameBlocks.findMostUsed();
        MixedBlocks mixedBlocks = new MixedBlocks(0);
        int newDataLength = this.compactData(fastILimit, newData, dataNullIndex, mixedBlocks);
        assert (newDataLength <= newDataCapacity);
        this.data = newData;
        this.dataLength = newDataLength;
        if (this.dataLength > 262159) {
            throw new IndexOutOfBoundsException("The trie data exceeds limitations of the data structure.");
        }
        if (dataNullIndex >= 0) {
            void var3_5;
            this.dataNullOffset = this.index[var3_5];
            this.initialValue = this.data[this.dataNullOffset];
        } else {
            this.dataNullOffset = 1048575;
        }
        int indexLength = this.compactIndex(fastILimit, mixedBlocks);
        this.highStart = n;
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private CodePointTrie build(CodePointTrie.Type type, CodePointTrie.ValueWidth valueWidth) {
        void var2_2;
        char[] trieIndex;
        switch (valueWidth) {
            case BITS_32: {
                break;
            }
            case BITS_16: {
                this.maskValues(65535);
                break;
            }
            case BITS_8: {
                this.maskValues(255);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        int fastLimit = type == CodePointTrie.Type.FAST ? 65536 : 4096;
        int indexLength = this.compactTrie(fastLimit >> 4);
        if (valueWidth == CodePointTrie.ValueWidth.BITS_32 && (indexLength & 1) != 0) {
            this.index16[indexLength++] = 65518;
        }
        int length = indexLength << 1;
        if (valueWidth == CodePointTrie.ValueWidth.BITS_16) {
            if (((indexLength ^ this.dataLength) & 1) != 0) {
                this.data[this.dataLength++] = this.errorValue;
            }
            if (this.data[this.dataLength - 1] != this.errorValue || this.data[this.dataLength - 2] != this.highValue) {
                this.data[this.dataLength++] = this.highValue;
                this.data[this.dataLength++] = this.errorValue;
            }
            length += this.dataLength << 1;
        } else if (valueWidth == CodePointTrie.ValueWidth.BITS_32) {
            if (this.data[this.dataLength - 1] != this.errorValue || this.data[this.dataLength - 2] != this.highValue) {
                if (this.data[this.dataLength - 1] != this.highValue) {
                    this.data[this.dataLength++] = this.highValue;
                }
                this.data[this.dataLength++] = this.errorValue;
            }
            length += this.dataLength << 2;
        } else {
            int and3 = length + this.dataLength & 3;
            if (and3 != 0 || this.data[this.dataLength - 1] != this.errorValue || this.data[this.dataLength - 2] != this.highValue) {
                if (and3 == 3 && this.data[this.dataLength - 1] == this.highValue) {
                    this.data[this.dataLength++] = this.errorValue;
                } else {
                    while (and3 != 2) {
                        this.data[this.dataLength++] = this.highValue;
                        and3 = and3 + 1 & 3;
                    }
                    this.data[this.dataLength++] = this.highValue;
                    this.data[this.dataLength++] = this.errorValue;
                }
            }
            length += this.dataLength;
        }
        assert ((length & 3) == 0);
        if (this.highStart <= fastLimit) {
            trieIndex = new char[indexLength];
            int i = 0;
            for (int j = 0; j < indexLength; ++j) {
                trieIndex[j] = (char)this.index[i];
                i += 4;
            }
        } else if (indexLength == this.index16.length) {
            trieIndex = this.index16;
            this.index16 = null;
        } else {
            trieIndex = Arrays.copyOf(this.index16, indexLength);
        }
        switch (1.$SwitchMap$com$ibm$icu$util$CodePointTrie$ValueWidth[var2_2.ordinal()]) {
            case 2: {
                int i;
                char[] data16 = new char[this.dataLength];
                for (i = 0; i < this.dataLength; ++i) {
                    data16[i] = (char)this.data[i];
                }
                if (type == CodePointTrie.Type.FAST) {
                    return new CodePointTrie.Fast16(trieIndex, data16, this.highStart, this.index3NullOffset, this.dataNullOffset);
                }
                return new CodePointTrie.Small16(trieIndex, data16, this.highStart, this.index3NullOffset, this.dataNullOffset);
            }
            case 1: {
                int[] data32 = Arrays.copyOf(this.data, this.dataLength);
                if (type == CodePointTrie.Type.FAST) {
                    return new CodePointTrie.Fast32(trieIndex, data32, this.highStart, this.index3NullOffset, this.dataNullOffset);
                }
                return new CodePointTrie.Small32(trieIndex, data32, this.highStart, this.index3NullOffset, this.dataNullOffset);
            }
            case 3: {
                void var3_6;
                void var1_1;
                int i;
                byte[] data8 = new byte[this.dataLength];
                for (i = 0; i < this.dataLength; ++i) {
                    data8[i] = (byte)this.data[i];
                }
                if (var1_1 == CodePointTrie.Type.FAST) {
                    return new CodePointTrie.Fast8(trieIndex, data8, this.highStart, this.index3NullOffset, this.dataNullOffset);
                }
                return new CodePointTrie.Small8(trieIndex, (byte[])var3_6, this.highStart, this.index3NullOffset, this.dataNullOffset);
            }
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$000(int[] x0, int x1, int[] x2, int x3, int x4) {
        void var3_3;
        void var2_2;
        void var1_1;
        return MutableCodePointTrie.equalBlocks(x0, (int)var1_1, (int[])var2_2, (int)var3_3, x4);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$100(char[] x0, int x1, int[] x2, int x3, int x4) {
        void var3_3;
        void var2_2;
        void var1_1;
        return MutableCodePointTrie.equalBlocks(x0, (int)var1_1, (int[])var2_2, (int)var3_3, x4);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$200(char[] x0, int x1, char[] x2, int x3, int x4) {
        void var3_3;
        void var2_2;
        void var1_1;
        return MutableCodePointTrie.equalBlocks(x0, (int)var1_1, (char[])var2_2, (int)var3_3, x4);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$300(int[] x0, int x1, int x2, int x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        return MutableCodePointTrie.allValuesSameAs(x0, (int)var1_1, (int)var2_2, (int)var3_3);
    }

    static final class MixedBlocks {
        private int[] table;
        private int length;
        private int shift;
        private int mask;
        private int blockLength;

        private MixedBlocks() {
        }

        /*
         * WARNING - void declaration
         */
        final void init(int maxLength, int newBlockLength) {
            void var2_2;
            void var1_1;
            int newLength;
            int maxDataIndex = maxLength - newBlockLength + 1;
            if (maxDataIndex <= 4095) {
                newLength = 6007;
                this.shift = 12;
                this.mask = 4095;
            } else if (newLength <= Short.MAX_VALUE) {
                newLength = 50021;
                this.shift = 15;
                this.mask = Short.MAX_VALUE;
            } else if (newLength <= 131071) {
                newLength = 200003;
                this.shift = 17;
                this.mask = 131071;
            } else {
                newLength = 1500007;
                this.shift = 21;
                this.mask = 0x1FFFFF;
            }
            if (this.table == null || newLength > this.table.length) {
                this.table = new int[newLength];
            } else {
                Arrays.fill(this.table, 0, newLength, 0);
            }
            this.length = var1_1;
            this.blockLength = var2_2;
        }

        final void extend(int[] data, int minStart, int prevDataLength, int newDataLength) {
            int start = prevDataLength - this.blockLength;
            start = start >= 0 ? ++start : 0;
            int end = newDataLength - this.blockLength;
            while (start <= end) {
                int hashCode = this.makeHashCode(data, start);
                this.addEntry(data, null, start, hashCode, start);
                ++start;
            }
        }

        final void extend(char[] data, int minStart, int prevDataLength, int newDataLength) {
            int start = prevDataLength - this.blockLength;
            start = start >= minStart ? ++start : minStart;
            int end = newDataLength - this.blockLength;
            while (start <= end) {
                int hashCode = this.makeHashCode(data, start);
                this.addEntry(null, data, start, hashCode, start);
                ++start;
            }
        }

        /*
         * WARNING - void declaration
         */
        final int findBlock(int[] data, int[] blockData, int blockStart) {
            void var3_4;
            void var2_3;
            int hashCode = this.makeHashCode(blockData, blockStart);
            int entryIndex = this.findEntry(data, null, (int[])var2_3, null, (int)var3_4, hashCode);
            if (entryIndex >= 0) {
                void var1_2;
                return (this.table[var1_2] & this.mask) - 1;
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        final int findBlock(char[] data, int[] blockData, int blockStart) {
            void var3_4;
            void var2_3;
            int hashCode = this.makeHashCode(blockData, blockStart);
            int entryIndex = this.findEntry(null, data, (int[])var2_3, null, (int)var3_4, hashCode);
            if (entryIndex >= 0) {
                void var1_2;
                return (this.table[var1_2] & this.mask) - 1;
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        final int findBlock(char[] data, char[] blockData, int blockStart) {
            void var3_4;
            void var2_3;
            int hashCode = this.makeHashCode(blockData, blockStart);
            int entryIndex = this.findEntry(null, data, null, (char[])var2_3, (int)var3_4, hashCode);
            if (entryIndex >= 0) {
                void var1_2;
                return (this.table[var1_2] & this.mask) - 1;
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        final int findAllSameBlock(int[] data2, int blockValue) {
            int n;
            int n2;
            void var3_7;
            int n3;
            int n4 = blockValue;
            MixedBlocks mixedBlocks = this;
            int n5 = n4;
            for (n3 = 1; n3 < mixedBlocks.blockLength; ++n3) {
                n5 = n5 * 37 + n4;
            }
            int hashCode = n5;
            n3 = var3_7;
            n5 = n2;
            int[] nArray = data2;
            MixedBlocks mixedBlocks2 = this;
            int data2 = n3 << mixedBlocks2.shift;
            n3 = n2 = MixedBlocks.modulo(n3, mixedBlocks2.length - 1) + 1;
            while (true) {
                int n6;
                if ((n6 = mixedBlocks2.table[n3]) == 0) {
                    n = ~n3;
                    break;
                }
                if ((n6 & ~mixedBlocks2.mask) == data2 && MutableCodePointTrie.access$300(nArray, n6 = (n6 & mixedBlocks2.mask) - 1, mixedBlocks2.blockLength, n5)) {
                    n = n3;
                    break;
                }
                n3 = mixedBlocks2.nextIndex(n2, n3);
            }
            int entryIndex = n;
            if (n >= 0) {
                void var1_2;
                return (this.table[var1_2] & this.mask) - 1;
            }
            return -1;
        }

        private int makeHashCode(int[] blockData, int blockStart) {
            int blockLimit = blockStart + this.blockLength;
            int hashCode = blockData[blockStart++];
            do {
                hashCode = hashCode * 37 + blockData[blockStart++];
            } while (blockStart < blockLimit);
            return hashCode;
        }

        private int makeHashCode(char[] blockData, int blockStart) {
            int blockLimit = blockStart + this.blockLength;
            int hashCode = blockData[blockStart++];
            do {
                hashCode = hashCode * 37 + blockData[blockStart++];
            } while (blockStart < blockLimit);
            return hashCode;
        }

        /*
         * WARNING - void declaration
         */
        private void addEntry(int[] data32, char[] data16, int blockStart, int hashCode, int dataIndex) {
            void var3_4;
            void var2_3;
            assert (dataIndex >= 0 && dataIndex < this.mask);
            int entryIndex = this.findEntry(data32, data16, data32, (char[])var2_3, (int)var3_4, hashCode);
            if (entryIndex < 0) {
                this.table[var1_2 ^ 0xFFFFFFFF] = hashCode << this.shift | dataIndex + 1;
            }
        }

        private int findEntry(int[] data32, char[] data16, int[] blockData32, char[] blockData16, int blockStart, int hashCode) {
            int initialEntryIndex;
            int shiftedHashCode = hashCode << this.shift;
            int entryIndex = initialEntryIndex = MixedBlocks.modulo(hashCode, this.length - 1) + 1;
            int entry;
            while ((entry = this.table[entryIndex]) != 0) {
                if ((entry & ~this.mask) == shiftedHashCode) {
                    int dataIndex = (entry & this.mask) - 1;
                    if (data32 != null ? MutableCodePointTrie.access$000(data32, dataIndex, blockData32, blockStart, this.blockLength) : (blockData32 != null ? MutableCodePointTrie.access$100(data16, dataIndex, blockData32, blockStart, this.blockLength) : MutableCodePointTrie.access$200(data16, dataIndex, blockData16, blockStart, this.blockLength))) {
                        return entryIndex;
                    }
                }
                entryIndex = this.nextIndex(initialEntryIndex, entryIndex);
            }
            return ~entryIndex;
        }

        /*
         * WARNING - void declaration
         */
        private int nextIndex(int initialEntryIndex, int entryIndex) {
            void var1_1;
            return (entryIndex + var1_1) % this.length;
        }

        /*
         * WARNING - void declaration
         */
        private static int modulo(int n, int m) {
            int n2;
            int i = n % m;
            if (i < 0) {
                void var1_1;
                i += var1_1;
            }
            return n2;
        }

        /* synthetic */ MixedBlocks(byte by) {
            this();
        }
    }

    static final class AllSameBlocks {
        private int length;
        private int mostRecent = -1;
        private int[] indexes = new int[32];
        private int[] values = new int[32];
        private int[] refCounts = new int[32];

        AllSameBlocks() {
        }

        /*
         * WARNING - void declaration
         */
        final int findOrAdd(int index, int count, int value) {
            void var2_2;
            void var3_3;
            void var1_1;
            if (this.mostRecent >= 0 && this.values[this.mostRecent] == value) {
                int n = this.mostRecent;
                this.refCounts[n] = this.refCounts[n] + count;
                return this.indexes[this.mostRecent];
            }
            for (int i = 0; i < this.length; ++i) {
                if (this.values[i] != value) continue;
                this.mostRecent = i;
                int n = i;
                this.refCounts[n] = this.refCounts[n] + count;
                return this.indexes[i];
            }
            if (this.length == 32) {
                return -2;
            }
            this.mostRecent = this.length;
            this.indexes[this.length] = var1_1;
            this.values[this.length] = var3_3;
            this.refCounts[this.length++] = var2_2;
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        final void add(int index, int count, int value) {
            void var2_2;
            void var3_3;
            void var1_1;
            assert (this.length == 32);
            int least = -1;
            int leastCount = 69632;
            for (int i = 0; i < this.length; ++i) {
                assert (this.values[i] != value);
                if (this.refCounts[i] >= leastCount) continue;
                least = i;
                leastCount = this.refCounts[i];
            }
            assert (least >= 0);
            this.mostRecent = least;
            this.indexes[least] = var1_1;
            this.values[least] = var3_3;
            this.refCounts[least] = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        final int findMostUsed() {
            void var1_1;
            if (this.length == 0) {
                return -1;
            }
            int max = -1;
            int maxCount = 0;
            for (int i = 0; i < this.length; ++i) {
                if (this.refCounts[i] <= maxCount) continue;
                max = i;
                maxCount = this.refCounts[i];
            }
            return this.indexes[var1_1];
        }
    }
}

